/**************************** test2.c ***********************************/
/* Copyright 2003/12/29 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple echo and timer test program.					*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test9.c 16-Jun-2004,15:46:18,`RADSETT' First archived version.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include "lpc2119.h"
#include "dev_cntrl.h"
#include "lpc_sys.h"

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */


/********************* main *********************************************/
/*  main -- program start point.  Simple toggle program.		*/
int main( void)
 {
 unsigned int count, output;

 (void)SetNativeSpeed( 10000uL);

 PINSEL0 = 0;		/*  Set pin P0.0 - P0.16 to I/O.		*/
 PINSEL1 = 0;		/*  Set pin P0.16 - P0.32 to I/O.		*/
 PINSEL2 = 0x30;	/*  Set pins P1.16 - P1.31 to I/O 	        */
 IODIR = ~0;		/*  Set pin P0.0  - P0.32 to output.		*/
 IO1DIR = ~0;		/*  Set pin P1.0  - P1.32 to output.		*/

	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

	/*  Start timer.						*/
 (void)StartClock();

 count = 0;
 while( 1) {  /*lint !e716*/
    output = count | (count << 16);
    IOSET = output;
    IOCLR = ~output;
    IO1SET = output;
    IO1CLR = ~output;
    count ++;
    count &= 0xFFFF;
    }
 return( 0);			/*lint !e527 unreachable		*/
 }
