/**************************** test7.c ***********************************/
/* Copyright 2004/01/21 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple timer test program. Use to compare alternate count conversion*/
/* routines.								*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test7.c 28-Jan-2004,09:44:36,`RADSETT' First archived version
*   2 test7.c 13-Jul-2004,10:47:48,`RADSETT' Remove unused _impure_ptr arguments.
*        Some lint cleanup.
*        Bring in header file support for second timer conversion.
*        lpc_sys.h now included implicitly.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include "lpc210x.h"
#include "dev_cntrl.h"
#include "lpc_ioctl.h"
#include "testdiv.h"


	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */


/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 struct serial_param sp;
 unsigned int i;


 (void)SetNativeSpeed( 10000uL);

	/* Desired serial line characteristics 9600,n82			*/
 sp.baud = 9600uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop = UART_STOP_BITS_2;

 PINSEL0 &= 0xFFFCFFFFu;	/*  Set pin P0.8 to I/O.		*/
 IODIR |= 0x100;		/*  Set pin P0.8 to output.		*/

 IOCLR = 0x100u;

	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();

 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\r\n");		/*  It's alive !!		*/



 SetTSF( 10000000uL);	/*  Set to same scaling factor expected in the	*/
 			/* timer internals.				*/
 (void)iprintf( "eq,tdiv,tshiftadd\r\n");
 IOSET = 0x100u;
 IOCLR = 0x100u;
 for( i = 0; i < 50; i++) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < 100; i += 5) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }

 for( ;i < 200; i += 10) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }

 for( ;i < 1000; i += 100) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < 100000; i += 500) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < 1000000; i += 10000) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < 10000000; i += 100000) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < 100000000; i += 1000000) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 for( ;i < (UINT_MAX/10); i += 1000000) {
    unsigned int stop, start, start1, stop1, res1, res2;
    IOSET = 0x100u;
    start = T0TC;
    res1 = UsToCounts(i);
    stop = T0TC;
    IOCLR = 0x100u;
    IOSET = 0x100u;			
    start1 = T0TC;
    res2 = UsToCounts2( i);
    stop1 = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u,%u,%u\r\n", i,res1-res2,stop - start, stop1-start1);
    }
 (void)iprintf("done\r\n");

 for(i = 0; i < UINT_MAX; i++) {
    unsigned int res1, res2;

    if( (i % 100000) == 0) {
         (void)iprintf("%u\r\n", i);
	 }

    res1 = UsToCounts(i);
    res2 = UsToCounts2( i);
    if( res1 != res2) {
         (void)iprintf( "\r\n%u,%u,%u\r\n", i, res1, res2);
	 }
    }
 (void)iprintf("done\r\n");

 while(1) {			/*lint !e716 while(1)			*/
    IOSET = 0x100u;
    IOCLR = 0x100u;
    }
 return( 0);			/*lint !e527 unreachable		*/
 }
