/**************************** test2.c ***********************************/
/* Copyright 2003/12/29 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple echo and timer test program.					*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test2.c 30-Dec-2003,10:34:14,`RADSETT' First archival version.
*   2 test2.c 18-Jan-2004,11:10:58,`RADSETT' Update to new form of call to WaitUs
*        (argument change).
*   3 test2.c 13-Jul-2004,10:45:38,`RADSETT' Remove unused _impure_ptr arguments
*        lpc_sys.h now included implicitly.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include <errno.h>
#include "lpc210x.h"
#include "dev_cntrl.h"
#include "lpc_ioctl.h"

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */


/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 struct serial_param sp;


 (void)SetNativeSpeed( 10000uL);

	/* Desired serial line characteristics 9600,n82			*/
 sp.baud = 9600uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop = UART_STOP_BITS_2;

 PINSEL0 &= 0xFFFCFFFFu;	/*  Set pin P0.8 to I/O.		*/
 IODIR |= 0x100;		/*  Set pin P0.8 to output.		*/

	/*  Quick toggles to show we got started.			*/
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 1 */
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 2 */
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 3 */
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 4 */
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 5 */
 IOCLR = 0x100u;
 IOSET = 0x100u;	/* 6 */
 IOCLR = 0x100u;


	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();

 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\r\n");		/*  It's alive !!		*/


	/*  Another sequence of toggles.  This time high and low should	*/
	/* be 1 second each for a 20sec total delay.  Should be easily 	*/
	/* measureable to confirm timer operation.			*/
 puts( "Starting wait\r\n");

 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;
 WaitUs( 1000000u);
 IOSET = 0x100u;
 WaitUs( 1000000u);
 IOCLR = 0x100u;

 puts( "End wait\r\n");

	/*  Two possible ways to end, either sit toggling a pin or run	*/
	/* a simple character echo.					*/
#if 0
 PINSEL0 = 0u;
 IODIR |= 0x100;

 while( 1) {  /*lint !e716*/
    IOSET = 0x100u;
    IOCLR = 0x100u;
    }
#endif

#if 1
 while( 1) {			/*lint !e716				*/
    fputc('>', stdout);
    fputc( getchar(), stdout);
    }
#endif
 return( 0);			/*lint !e527 unreachable		*/
 }
