mdl = ARM

# GCC ARM
#cfgl are link/load parameters passed to ld
#-s means strip all symbols
#-v means verbose output
#-o $@ means use $@ as output filename
#$+ copies dependancies to link line

# Figure out where the libraries are
SYS_LDFLAGS = ${shell arm-elf-gcc -print-search-dirs | grep ^libraries | sed -e "s/^libraries:.*=/:/g" -e "s/ /\\\\ /g" -e "s/:/ -L /g"}
cfgl_arm = -v -o$@ -L. ${SYS_LDFLAGS} crt0.o $+
# Compile command.
cfg_arm_gc = -c -Os -o $@ 
# Alternate form of the compile command.  Use if previous form does not work.  Adapt to your own directory structure.
#cfg_arm_gc = -c -Os -nostdinc -isystem /home/radsett/install/arm-elf/include/ -isystem /home/radsett/install/lib/gcc-lib/arm-elf/3.3.2/include/ -o $@ 

# 
# GNU Compiler ARM
#
ifeq ($(mdl),ARM) 
  submdl = LPC210X
endif

ifeq ($(submdl),LPC210X)
  ar = arm-elf-ar
  cc = arm-elf-gcc
  cl = arm-elf-ld $(cfgl_arm)
  chex = arm-elf-objcopy -O ihex $< $@

        #  Providing a named linkfile option here allows programs for
        # multiple variants to be built using the same makefile.
  linkfile_LPC210X = -Tlpc210x.ld
  linkfile_LPC2119 = -Tlpc2119.ld

    ### Rules for building ###

        #  Build a dependancy file from a C file.  Uses the C compiler to
        # determine what files are included and filters the result to
        # produce a makefile target: dependancy list
%.d: %.c
	@set -e; rm -f $@; \
	$(cc) -M $(clags) $< > $@.$$$$; \
	sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
	rm -f $@.$$$$

        #  How to add an object file to a library.
(%):
	$(ar) cr $@ $%

        #  How to build an object file from a C file.
%.o: %.c
	$(cc) $(cfg_arm_gc) $<

        #  How to build an object file from an assembly file
%.o: %.s
	$(cc) $(cfg_arm_gc) $<

        #  How to create a hex file from the result produced by the 
        # linker.
%.hex: %.prg
	$(chex)

endif


    #  The list of targets.  We want to end up building all of these.  
    # Includes the startup code, all the test programs and a library 
    # containing all the support code.
all: dep lib crt0.o test2.hex test3.hex test6.hex test7.hex test8.hex test9.hex \
	test10.hex

    # A set of lists of all the sources.
testsource = test2.c test3.c test6.c test7.c test8.c test9.c test10.c testdiv.c
sources = _close_r.c _fstat_r.c _ioctl_r.c _lseek_r.c _open_r.c \
	_read_r.c _sbrk_r.c sys_dev.c sys_mam.c sys_pll.c sys_time.c sys_vic.c sys_vpb.c \
	uart0_poll.c uart0_int.c _write_r.c
asm_source = interrupt_sup.s uart0_ishell.s
startup_source = crt0.s
headers = dev_cntrl.h errno_lpc.h lpc_sys.h lpc210x.h lpc2119.h testdiv.h
asm_headers = interrupt.inc

    # Build dependencies for the link phase for all the test programs.
test2.prg: test2.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

test3.prg: test3.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

test6.prg: test6.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

test7.prg: test7.o testdiv.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

test8.prg: test8.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

test9.prg: test9.o $(sources:.c=.o)  $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC2119)

test10.prg: test10.o $(sources:.c=.o) $(asm_source:.s=.o)
	$(cl) $(linkfile_LPC210X)

lib: libnewlib-lpc.a($(sources:.c=.o) $(asm_source:.s=.o))

    # For building the library (AKA archive)
libnewlib-lpc.a($(sources:.c=.o) $(asm_source:.s=.o)): $(sources:.c=.o) $(asm_source:.s=.o)

    # Placeholder for source code archive support.  Does nothing.
archive: $(sources:%=$(ARCPATH)/%) $(ARCPATH)/makefile $(ARCPATH)/setupnew.mak \
	$(testsource:%=$(ARCPATH)/%) $(headers:%=$(ARCPATH)/%) \
	$(asm_source:%=$(ARCPATH)/%) $(asm_headers:%=$(ARCPATH)/%) $(ARCPATH)/crt0.s

dep : $(sources:.c=.d) $(testsource:.c=.d) testdiv.d
	@touch .depend

clean:
	rm -f *.o 
	rm -f *.a 
	rm -f *.hex 
	rm -f *.prg
	rm -f *.d
	rm -f *.d.[0-9]*
	rm -f .depend

    # Include dependancies for all the the C source.
ifneq ($(wildward .depend),) 
include $(sources:.c=.d) $(testsource:.c=.d) testdiv.d
endif


