/*****************************************************************************

 - UART in simple polled-mode
 - UART-Test with reduced printf (rprintf)
 - Test for vector remapping
 
 by Martin Thomas 

******************************************************************************/

#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "irq.h"
#include "swi.h"
#include "timer.h"
#include "serial.h"
#include "rprintf.h"


static const char Hello[]="\nHello from WinARM.\nHave Fun,\nMartin Thomas\n\n";
static const char Hello_rprintf[]="Hello from rprintf\n";


static void dump_mem(unsigned long startaddress, int n)
{
	volatile unsigned long *p;
	
	p = (unsigned long*)startaddress;
	int i;
	
	for (i=0; i<n; i++) {
		rprintf("Addr:0x%08lx = 0x%08lx (0x%04x:0x%04x)\n", 
			p, *p, (*p)>>16, (*p)&0xffff);
		p++;
	}
}


static void dump_interrupt_state(void)
{
	unsigned long cpsr; 
	
	cpsr = IntGetCPSR();
	
	rprintf("State : stat-reg 0x%08x -> ", cpsr);
	
	if ( cpsr & I_Bit ) {
		rprintf("IRQ disabled, ");
	}
	else {
		rprintf("IRQ enabled, ");
	}
	
	if ( cpsr & F_Bit ) {
		rprintf("FIQ disabled\n");
	}
	else {
		rprintf("FIQ enabled\n");
	}
}
	

int main (void)
{
	int flip = 0;

	volatile unsigned long c, is;

    init_VIC();
    init_serial0(115200);	/* baud rate setting */

	putstring_serial0(Hello); /* write welcome thru putstring */
	
	rprintf_devopen( putc_serial0 ); /* init rprintf */
	rprintf("rprintf: %s", Hello_rprintf);
	
#if 1
	MEMMAP = 1; // Vectors in FLASH
	rprintf("Dump for MEMMAP = 1 / Flash\n");
	dump_mem(0x00000000, 16);
	dump_mem(0x40000000, 16);
	
	MEMMAP = 2; // Vectors in RAM
	rprintf("Dump for MEMMAP = 2 / RAM\n");
	dump_mem(0x00000000, 16);
	dump_mem(0x40000000, 16);
	rprintf("dump done\n");
#endif

		
	c = IntGetCPSR();
	is = c;
	rprintf("\nCPSR from startup: 0x%08lx\n", c);
	dump_interrupt_state();

	rprintf("Disable IRQ:\n");	
	c = IntDisable();
	rprintf("returned prev. state :0x%08lx\n", c);
	dump_interrupt_state();
	
#if 0
	rprintf("Enable:\n");	
	c = IntEnable();
	rprintf("retval:0x%08lx\n", c);
	dump_interrupt_state();
#endif
	
	rprintf("Restore startup-condition:\n");	
	IntRestore(is);
	dump_interrupt_state();
	
    rprintf("\nTesting Timer-Interrupt\n");
	
	IODIR1 = 0x00FF0000;		/* P1.16..23 defined as Outputs */
	IOCLR1 = 0x00550000;
	IOSET1 = 0x00AA0000;		
	init_timer();
	enable_timer( 0 );

	while (1) {
		if ( timer_counter > 0x80 ) {
			timer_counter = 0;
			flip = !flip;
			if (flip) {
				IOSET1 = 0x000F0000;	/* turn off P1.20~23 */	
				IOCLR1 = 0x00F00000;	/* turn on P1.16~19 */
			}
			else {
				IOSET1 = 0x00F00000;	/* turn on P1.20~23 */
				IOCLR1 = 0x000F0000;	/* turn off P1.16~19 */
				rprintf(".");
			}
		}
	}
	return 0; /* never reached */
}
