/***********************************************************************/
/*                                                                     */
/*  RAM.ld:  Linker Script File                                        */
/*                                                                     */
/***********************************************************************/

ENTRY(_start)
STACK_SIZE = 0x400;

/* Memory Definitions */
/* lpc2129 mt */
MEMORY
{
  ROM (rx) : ORIGIN = 0x00000000, LENGTH = 0x0003E000
  RAM (rw) : ORIGIN = 0x40000000, LENGTH = 0x00004000
}

/* Section Definitions */
SECTIONS
{
  /* first section is .text which is used for code */
  .text :
  {
    *crt0.o (.text)            /* Startup code */
    *(.text .text.*)           /* remaining code */
	*(.gnu.linkonce.t.*)
	*(.glue_7)
    *(.glue_7t)
	*(.gcc_except_table)
    *(.rodata)                 /* read-only data (constants) */
    *(.rodata*)
    *(.gnu.linkonce.r.*)
  } > RAM

  . = ALIGN(4);
  
	/* .ctors .dtors are used for c++ constructors/destructors */
	/* added by Martin Thomas 4/2005 based on Anglia Design example */
	.ctors :
	{
		PROVIDE(__ctors_start__ = .);
		KEEP(*(SORT(.ctors.*)))
		KEEP(*(.ctors))
		PROVIDE(__ctors_end__ = .);
	} >RAM
	
	.dtors :
	{
		PROVIDE(__dtors_start__ = .); 
		KEEP(*(SORT(.dtors.*)))
		KEEP(*(.dtors))
		PROVIDE(__dtors_end__ = .);
	} >RAM
  
    . = ALIGN(4);
	/* mthomas - end */
	
  _etext = . ;
  PROVIDE (etext = .);

  /* .data section which is used for initialized data */
  .data :
  {
    _data = .;
    *(.data)
	*(.data.*)
	*(.gnu.linkonce.d*)
	SORT(CONSTRUCTORS)
  } > RAM

  . = ALIGN(4);
  _edata = . ;
  PROVIDE (edata = .);

  /* .bss section which is used for uninitialized data */
  .bss (NOLOAD) :
  {
    __bss_start = . ;
    __bss_start__ = . ;
    *(.bss)
	*(.gnu.linkonce.b*)
    *(COMMON)
    . = ALIGN(4);
  } > RAM

  . = ALIGN(4);
  __bss_end__ = . ;
  PROVIDE (__bss_end = .);

  .stack ALIGN(256) :
  {
    . += STACK_SIZE;
    PROVIDE (_stack = .);
  } > RAM

  _end = . ;
  PROVIDE (end = .);

  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
}

	/*  Provide address definitions for any peripheral registers	*/
	/* used.							*/

/* WD */

PROVIDE( WDMOD = 0xE0000000);
PROVIDE( WDTC = 0xE0000004);
PROVIDE( WDFEED = 0xE0000008);
PROVIDE( WDTV = 0xE000000C);

/* TIMER 0 */

PROVIDE( T0IR = 0xE0004000);
PROVIDE( T0TCR = 0xE0004004);
PROVIDE( T0TC = 0xE0004008);
PROVIDE( T0PR = 0xE000400C);
PROVIDE( T0PC = 0xE0004010);
PROVIDE( T0MCR = 0xE0004014);
PROVIDE( T0MR0 = 0xE0004018);
PROVIDE( T0MR1 = 0xE000401C);
PROVIDE( T0MR2 = 0xE0004020);
PROVIDE( T0MR3 = 0xE0004024);
PROVIDE( T0CCR = 0xE0004028);
PROVIDE( T0CR0 = 0xE000402C);
PROVIDE( T0CR1 = 0xE0004030);
PROVIDE( T0CR2 = 0xE0004034);
PROVIDE( T0EMR = 0xE000403C);

/* TIMER 1 */

PROVIDE( T1IR = 0xE0008000);
PROVIDE( T1TCR = 0xE0008004);
PROVIDE( T1TC = 0xE0008008);
PROVIDE( T1PR = 0xE000800C);
PROVIDE( T1PC = 0xE0008010);
PROVIDE( T1MCR = 0xE0008014);
PROVIDE( T1MR0 = 0xE0008018);
PROVIDE( T1MR1 = 0xE000801C);
PROVIDE( T1MR2 = 0xE0008020);
PROVIDE( T1MR3 = 0xE0008024);
PROVIDE( T1CCR = 0xE0008028);
PROVIDE( T1CR0 = 0xE000802C);
PROVIDE( T1CR1 = 0xE0008030);
PROVIDE( T1CR2 = 0xE0008034);
PROVIDE( T1CR3 = 0xE0008038);
PROVIDE( T1EMR = 0xE000803C);

/* UART 0 */

PROVIDE( U0RBR = 0xE000C000);
PROVIDE( U0THR = 0xE000C000);
PROVIDE( U0DLL = 0xE000C000);
PROVIDE( U0IER = 0xE000C004);
PROVIDE( U0DLM = 0xE000C004);
PROVIDE( U0IIR = 0xE000C008);
PROVIDE( U0FCR = 0xE000C008);
PROVIDE( U0LCR = 0xE000C00C);
PROVIDE( U0LSR = 0xE000C014);
PROVIDE( U0SCR = 0xE000C01C);

/* UART 1 */

PROVIDE( U1RBR = 0xE0010000);
PROVIDE( U1THR = 0xE0010000);
PROVIDE( U1DLL = 0xE0010000);
PROVIDE( U1IER = 0xE0010004);
PROVIDE( U1DLM = 0xE0010004);
PROVIDE( U1IIR = 0xE0010008);
PROVIDE( U1FCR = 0xE0010008);
PROVIDE( U1LCR = 0xE001000C);
PROVIDE( U1MCR = 0xE0010010);
PROVIDE( U1LSR = 0xE0010014);
PROVIDE( U1MSR = 0xE0010018);
PROVIDE( U1SCR = 0xE001001C);

/* PWM */

PROVIDE( PWMIR = 0xE0014000);
PROVIDE( PWMTCR = 0xE0014004);
PROVIDE( PWMTC = 0xE0014008);
PROVIDE( PWMPR = 0xE001400C);
PROVIDE( PWMPC = 0xE0014010);
PROVIDE( PWMMCR = 0xE0014014);
PROVIDE( PWMMR0 = 0xE0014018);
PROVIDE( PWMMR1 = 0xE001401C);
PROVIDE( PWMMR2 = 0xE0014020);
PROVIDE( PWMMR3 = 0xE0014024);
PROVIDE( PWMMR4 = 0xE0014040);
PROVIDE( PWMMR5 = 0xE0014044);
PROVIDE( PWMMR6 = 0xE0014048);
PROVIDE( PWMPCR = 0xE001404C);
PROVIDE( PWMLER = 0xE0014050);

/* IIC */

PROVIDE( I2CONSET = 0xE001C000);
PROVIDE( I2STAT = 0xE001C004);
PROVIDE( I2DAT = 0xE001C008);
PROVIDE( I2ADR = 0xE001C00C);
PROVIDE( I2SCLH = 0xE001C010);
PROVIDE( I2SCLL = 0xE001C014);
PROVIDE( I2CONCLR = 0xE001C018);

/* SPI/SPI0 */

PROVIDE( S0PCR = 0xE0020000);
PROVIDE( S0PSR = 0xE0020004);
PROVIDE( S0PPR = 0xE0020008);
PROVIDE( S0PCCR = 0xE002000C);
PROVIDE( S0PINT = 0xE002001C);

	/* Synonyms for compatibility with the 210x series.	*/
PROVIDE( SPCR = 0xE0020000);
PROVIDE( SPSR = 0xE0020004);
PROVIDE( SPPR = 0xE0020008);
PROVIDE( SPCCR = 0xE002000C);
PROVIDE( SPINT = 0xE002001C);

/* RTC */

PROVIDE( ILR = 0xE0024000);
PROVIDE( CTC = 0xE0024004);
PROVIDE( CCR = 0xE0024008);
PROVIDE( CIIR = 0xE002400C);
PROVIDE( AMR = 0xE0024010);
PROVIDE( CTIME0 = 0xE0024014);
PROVIDE( CTIME1 = 0xE0024018);
PROVIDE( CTIME2 = 0xE002401C);
PROVIDE( SEC = 0xE0024020);
PROVIDE( MINUTE = 0xE0024024);
PROVIDE( HOUR = 0xE0024028);
PROVIDE( DOM = 0xE002402C);
PROVIDE( DOW = 0xE0024030);
PROVIDE( DOY = 0xE0024034);
PROVIDE( MONTH = 0xE0024038);
PROVIDE( YEAR = 0xE002403C);
PROVIDE( ALSEC = 0xE0024060);
PROVIDE( ALMIN = 0xE0024064);
PROVIDE( ALHOUR = 0xE0024068);
PROVIDE( ALDOM = 0xE002406C);
PROVIDE( ALDOW = 0xE0024070);
PROVIDE( ALDOY = 0xE0024074);
PROVIDE( ALMON = 0xE0024078);
PROVIDE( ALYEAR = 0xE002407C);
PROVIDE( PREINT = 0xE0024080);
PROVIDE( PREFRAC = 0xE0024084);

/* GPIO PORT0 */

PROVIDE( IO0PIN = 0xE0028000);
PROVIDE( IO0SET = 0xE0028004);
PROVIDE( IO0DIR = 0xE0028008);
PROVIDE( IO0CLR = 0xE002800C);

	/* Synonyms for compatibility with the 210x series.	*/
PROVIDE( IOPIN = 0xE0028000);
PROVIDE( IOSET = 0xE0028004);
PROVIDE( IODIR = 0xE0028008);
PROVIDE( IOCLR = 0xE002800C);

/* GPIO PORT1 */

PROVIDE( IO1PIN = 0xE0028010);
PROVIDE( IO1SET = 0xE0028014);
PROVIDE( IO1DIR = 0xE0028018);
PROVIDE( IO1CLR = 0xE002800C);

/* GPIO PORT2 */

PROVIDE( IO2PIN = 0xE0028020);
PROVIDE( IO2SET = 0xE0028024);
PROVIDE( IO2DIR = 0xE0028028);
PROVIDE( IO2CLR = 0xE002802C);

/* GPIO PORT3 */

PROVIDE( IO3PIN = 0xE0028030);
PROVIDE( IO3SET = 0xE0028034);
PROVIDE( IO3DIR = 0xE0028038);
PROVIDE( IO3CLR = 0xE002803C);

/* PIN CONNECT BLOCK */

PROVIDE( PINSEL0 = 0xE002C000);
PROVIDE( PINSEL1 = 0xE002C004);
PROVIDE( PINSEL2 = 0xE002C014);

/* SPI1 */

PROVIDE( S1PCR = 0xE0030000);
PROVIDE( S1PSR = 0xE0030004);
PROVIDE( S1PPR = 0xE0030008);
PROVIDE( S1PCCR = 0xE003000C);
PROVIDE( S1PINT = 0xE003001C);

/* ADC */

	/* Renamed from AD... to prevent ld conflict. */
PROVIDE( A2DCR = 0xE0034000);
PROVIDE( A2DDR = 0xE0034004);

/* CAN */

PROVIDE( CAN_RECV = 0xE0038000);
PROVIDE( AFMR = 0xE003C000);
PROVIDE( SFF_sa = 0xE003C004);
PROVIDE( SFF_GRP_sa = 0xE003C008);
PROVIDE( EFF_sa = 0xE003C00C);
PROVIDE( EFF_GRP_sa = 0xE003C010);
PROVIDE( ENDofTable = 0xE003C014);
PROVIDE( LUTerrAd = 0xE003C018);
PROVIDE( LUTerr = 0xE003C01C);
PROVIDE( CANTxSR = 0xE0040000);
PROVIDE( CANRxSR = 0xE0040004);
PROVIDE( CANMSR = 0xE0040008);

/* CAN1 Interface */

PROVIDE( C1MOD = 0xE0044000);
PROVIDE( C1CMR = 0xE0044004);
PROVIDE( C1GSR = 0xE0044008);
PROVIDE( C1ICR = 0xE004400C);
PROVIDE( C1IER = 0xE0044010);
PROVIDE( C1BTR = 0xE0044014);
PROVIDE( C1EWL = 0xE0044018);
PROVIDE( C1SR = 0xE004401C);
PROVIDE( C1RFS = 0xE0044020);
PROVIDE( C1RID = 0xE0044024);
PROVIDE( C1RDA = 0xE0044028);
PROVIDE( C1RDB = 0xE004402C);
PROVIDE( C1TFI1 = 0xE0044030);
PROVIDE( C1TID1 = 0xE0044034);
PROVIDE( C1TDA1 = 0xE0044038);
PROVIDE( C1TDB1 = 0xE004403C);
PROVIDE( C1TFI2 = 0xE0044040);
PROVIDE( C1TID2 = 0xE0044044);
PROVIDE( C1TDA2 = 0xE0044048);
PROVIDE( C1TDB2 = 0xE004404C);
PROVIDE( C1TFI3 = 0xE0044050);
PROVIDE( C1TID3 = 0xE0044054);
PROVIDE( C1TDA3 = 0xE0044058);
PROVIDE( C1TDB3 = 0xE004405C);

/* CAN2 Interface */

PROVIDE( C2MOD = 0xE0048000);
PROVIDE( C2CMR = 0xE0048004);
PROVIDE( C2GSR = 0xE0048008);
PROVIDE( C2ICR = 0xE004800C);
PROVIDE( C2IER = 0xE0048010);
PROVIDE( C2BTR = 0xE0048014);
PROVIDE( C2EWL = 0xE0048018);
PROVIDE( C2SR = 0xE004801C);
PROVIDE( C2RFS = 0xE0048020);
PROVIDE( C2RID = 0xE0048024);
PROVIDE( C2RDA = 0xE0048028);
PROVIDE( C2RDB = 0xE004802C);
PROVIDE( C2TFI1 = 0xE0048030);
PROVIDE( C2TID1 = 0xE0048034);
PROVIDE( C2TDA1 = 0xE0048038);
PROVIDE( C2TDB1 = 0xE004803C);
PROVIDE( C2TFI2 = 0xE0048040);
PROVIDE( C2TID2 = 0xE0048044);
PROVIDE( C2TDA2 = 0xE0048048);
PROVIDE( C2TDB2 = 0xE004804C);
PROVIDE( C2TFI3 = 0xE0048050);
PROVIDE( C2TID3 = 0xE0048054);
PROVIDE( C2TDA3 = 0xE0048058);
PROVIDE( C2TDB3 = 0xE004805C);

/* CAN3 Interface */

PROVIDE( C3MOD = 0xE004C000);
PROVIDE( C3CMR = 0xE004C004);
PROVIDE( C3GSR = 0xE004C008);
PROVIDE( C3ICR = 0xE004C00C);
PROVIDE( C3IER = 0xE004C010);
PROVIDE( C3BTR = 0xE004C014);
PROVIDE( C3EWL = 0xE004C018);
PROVIDE( C3SR = 0xE004C01C);
PROVIDE( C3RFS = 0xE004C020);
PROVIDE( C3RID = 0xE004C024);
PROVIDE( C3RDA = 0xE004C028);
PROVIDE( C3RDB = 0xE004C02C);
PROVIDE( C3TFI1 = 0xE004C030);
PROVIDE( C3TID1 = 0xE004C034);
PROVIDE( C3TDA1 = 0xE004C038);
PROVIDE( C3TDB1 = 0xE004C03C);
PROVIDE( C3TFI2 = 0xE004C040);
PROVIDE( C3TID2 = 0xE004C044);
PROVIDE( C3TDA2 = 0xE004C048);
PROVIDE( C3TDB2 = 0xE004C04C);
PROVIDE( C3TFI3 = 0xE004C050);
PROVIDE( C3TID3 = 0xE004C054);
PROVIDE( C3TDA3 = 0xE004C058);
PROVIDE( C3TDB3 = 0xE004C05C);

/* CAN4 Interface */

PROVIDE( C4MOD = 0xE0050000);
PROVIDE( C4CMR = 0xE0050004);
PROVIDE( C4GSR = 0xE0050008);
PROVIDE( C4ICR = 0xE005000C);
PROVIDE( C4IER = 0xE0050010);
PROVIDE( C4BTR = 0xE0050014);
PROVIDE( C4EWL = 0xE0050018);
PROVIDE( C4SR = 0xE005001C);
PROVIDE( C4RFS = 0xE0050020);
PROVIDE( C4RID = 0xE0050024);
PROVIDE( C4RDA = 0xE0050028);
PROVIDE( C4RDB = 0xE005002C);
PROVIDE( C4TFI1 = 0xE0050030);
PROVIDE( C4TID1 = 0xE0050034);
PROVIDE( C4TDA1 = 0xE0050038);
PROVIDE( C4TDB1 = 0xE005003C);
PROVIDE( C4TFI2 = 0xE0050040);
PROVIDE( C4TID2 = 0xE0050044);
PROVIDE( C4TDA2 = 0xE0050048);
PROVIDE( C4TDB2 = 0xE005004C);
PROVIDE( C4TFI3 = 0xE0050050);
PROVIDE( C4TID3 = 0xE0050054);
PROVIDE( C4TDA3 = 0xE0050058);
PROVIDE( C4TDB3 = 0xE005005C);

/* SYSTEM CONTROL BLOCK */
	/* MAM */

PROVIDE( MAMCR = 0xE01FC000);
PROVIDE( MAMTIM = 0xE01FC004);


PROVIDE( MEMAP = 0xE01FC040);

	/* PLL */

PROVIDE( PLLCON = 0xE01FC080);
PROVIDE( PLLCFG = 0xE01FC084);
PROVIDE( PLLSTAT = 0xE01FC088);
PROVIDE( PLLFEED = 0xE01FC08C);

	/* POWER CONTROL */

PROVIDE( PCON = 0xE01FC0C0);
PROVIDE( PCONP = 0xE01FC0C4);

	/* VPB */

PROVIDE( VPBDIV = 0xE01FC100);

	/* EXTERNAL INTERUPT/WAKE */

PROVIDE( EXTINT = 0xE01FC140);
PROVIDE( EXTWAKE = 0xE01FC144);
PROVIDE( EXTMODE = 0xE01FC148);
PROVIDE( EXTPOLAR = 0xE01FC14C);

/* External Memory Controller- EMC */

PROVIDE( BCFG0 = 0xFFE00000);
PROVIDE( BCFG1 = 0xFFE00004);
PROVIDE( BCFG2 = 0xFFE00008);
PROVIDE( BCFG3 = 0xFFE0000C);

/* Vector Interrupt Controller (VIC) */

PROVIDE( VICIRQStatus = 0xFFFFF000);
PROVIDE( VICFIQStatus = 0xFFFFF004);
PROVIDE( VICRawIntr = 0xFFFFF008);
PROVIDE( VICIntSelect = 0xFFFFF00C);
PROVIDE( VICIntEnable = 0xFFFFF010);
PROVIDE( VICIntEnClr = 0xFFFFF014);
PROVIDE( VICSoftInt = 0xFFFFF018);
PROVIDE( VICSoftIntClear = 0xFFFFF01C);
PROVIDE( VICProtection = 0xFFFFF020);
PROVIDE( VICVectAddrRead = 0xFFFFF030);
PROVIDE( VICDefVectAddr = 0xFFFFF034);
PROVIDE( VICVectAddr = 0xFFFFF100);
PROVIDE( VICVectCntl = 0xFFFFF200);

