/******************************************************************************
 *****************************************************************************/

#include "lpc210x_gnuarm.h"
#include "config.h"
#include "uart.h"

#define BAUD 115200

// olimex LPC-P2106: one led on P0.7 (active low)
#define LEDPIN  7

void systemInit(void)
{
	// --- enable and connect the PLL (Phase Locked Loop) ---
	// a. set multiplier and divider
	SCB_PLLCFG = MSEL | (1<<PSEL1) | (0<<PSEL0);
	// b. enable PLL
	SCB_PLLCON = (1<<PLLE);
	// c. feed sequence
	SCB_PLLFEED = PLL_FEED1;
	SCB_PLLFEED = PLL_FEED2;
	// d. wait for PLL lock (PLOCK bit is set if locked)
	while (!(SCB_PLLSTAT & (1<<PLOCK)));
	// e. connect (and enable) PLL
	SCB_PLLCON = (1<<PLLE) | (1<<PLLC);
	// f. feed sequence
	SCB_PLLFEED = PLL_FEED1;
	SCB_PLLFEED = PLL_FEED2;
	
	// --- setup and enable the MAM (Memory Accelerator Module) ---
	// a. start change by turning of the MAM (redundant)
	MAM_MAMCR = 0;	
	// b. set MAM-Fetch cycle to 3 cclk as recommended for >40MHz
	MAM_MAMTIM = MAM_FETCH;
	// c. enable MAM 
	MAM_MAMCR = MAM_MODE;
	
	// --- set VPB speed ---
	SCB_VPBDIV = VPBDIV_VAL;
	
	// --- map INT-vector ---
	#if defined(RAM_RUN)
	  SCB_MEMMAP = MEMMAP_USER_RAM_MODE;
	#elif defined(ROM_RUN)
	  SCB_MEMMAP = MEMMAP_USER_FLASH_MODE;
	#else
	#error RUN_MODE not defined!
	#endif
}

void gpioInit(void)
{
	GPIO_IOSET  = (1<<LEDPIN);	// set Bit = LED off (active low)
	GPIO_IODIR |= (1<<LEDPIN);	// define LED-Pin as output
}

void ledToggle(void)
{
	static unsigned char state=0;
	
	state = !state;
	if (state) GPIO_IOCLR = (1<<LEDPIN);	// set Bit = LED on
	else GPIO_IOSET = (1<<LEDPIN);	// set Bit = LED off (active low)
}

int main(void)
{
	int ch;
	
	systemInit();
	gpioInit();
	
	uart0Init(UART_BAUD(BAUD), UART_8N1, UART_FIFO_8); // setup the UART
	
	uart0Putch('M');
	
	uart0Puts("\r\nHello from WinARM!\r\n");
	uart0Puts("Demo based on code from R O Software\r\n");
	
	ledToggle();
	
	while(1) {
		if ((ch = uart0Getch()) >= 0) {
			uart0Puts("You pressed : ");
			uart0Putch(ch);
			uart0Puts("\r\n");
			ledToggle();
		}
	}
	
	return 0;
}
