//////////////////////////////////////////////////////////////////////////////
//
//             Philips LPC210X LED/Switch Example
//               for the Olimex LPC-P2106 board
//
// This example demonstrates writing to and reading from 
// the GPIO port.
// (1) flash the LED 10 times
// (2) wait for key-press, turn off LED of key is pressed
//
// by Martin THOMAS, Kaiserslautern, Germany
// (eversmith@heizung-thomas.de)
//
// based on an example by Rowley Associates Limited found somewhere
// in the "net"
//
// (all compiler optimizations should be disabled - see makefile)
//////////////////////////////////////////////////////////////////////////////

#include "lpc210x_gnuarm.h"

// olimex LPC-P2106: one led on P0.7 (active low)
#define LEDPIN  7
// olimex LPC-P2106: one switch on P0.31 (active low)
#define SWPIN 	31

static void ledInit(void)
{
	GPIO_IODIR |= (1<<LEDPIN);	// define LED-Pin as output
	GPIO_IODIR &= ~(1<<SWPIN);	// define Switch-Pin as input
	GPIO_IOSET = (1<<LEDPIN);	// set Bit = LED off (active low)
}

static void delay(void)
{
	volatile int i,j;

	for (i=0;i<100;i++)
		for (j=0;j<1000;j++);
}
 
int main(void)
{
	int i;
	
	MAM_MAMCR = 2;	// MAM functions fully enabled (?)
	
	ledInit();
	
	i=0;
	while (i<10)	
	{
		GPIO_IOCLR=(1<<LEDPIN);	// set all outputs in mask to 0 -> LED on
		delay();
		GPIO_IOSET=(1<<LEDPIN);	// set all outputs in mask to 1 -> LED off
		delay();
		i++;
	}
	
	while (1)	
	{
		if (GPIO_IOPIN & (1<<SWPIN))	// true if button released (active low)
			GPIO_IOCLR=(1<<LEDPIN);		// clear I/O bit -> LED on (active low)
		else
			GPIO_IOSET=(1<<LEDPIN);		// set I/O bit -> LED off
	}
	
	return 0;
}
