//*----------------------------------------------------------------------------
//*      ATMEL Microcontroller Software Support  -  ROUSSET  -
//*----------------------------------------------------------------------------
//* The software is delivered "AS IS" without warranty or condition of any
//* kind, either express, implied or statutory. This includes without
//* limitation any warranty or condition with respect to merchantability or
//* fitness for any particular purpose, or against the infringements of
//* intellectual property rights of others.
//*----------------------------------------------------------------------------
//* File Name           : mips.c
//* Object              : Mips calculation
//* Creation            : JPP   13/Jan/2003
//*
//*----------------------------------------------------------------------------

#ifndef mips_h
#define mips_h

//* --------------------------- Constant definition ---------------------------

#define NB_LOSE_CYCLE		 3 	/* 1 for break pipe and 2 for "LDR"*/
#define NB_ASM_INSTRUCTION	(40 + NB_LOSE_CYCLE)


/* Clock Selection */
/*-----------------*/
#define TC_CLKS                  0x7
#define TC_CLKS_MCK2             0x0
#define TC_CLKS_MCK8             0x1
#define TC_CLKS_MCK32            0x2
#define TC_CLKS_MCK128           0x3
#define TC_CLKS_MCK1024          0x4

#define TIMER_INTERRUPT_LEVEL	7

//* --------------------------- Structure definition --------------------------

typedef struct _AT91S_MIPS_TIMER {
unsigned int 	Id ;
unsigned short	Peroid;
unsigned char	Div;
} AT91S_MIPS_TIMER, *AT91PS_MIPS_TIMER;

//* ----------------------- External Function Prototype -----------------------

void Init_Mips_Timer (void);
//mtA
// void Start_Mips_Timer (void);
__ramfunc void Start_Mips_Timer (void);
//mtE

unsigned int  Mips_Result_loop(void);
unsigned int  Mips_Result_all(void);

extern void ARM_mips (void);
extern void THUMB_mips (void);
extern void Ram_ARM_mips (void);
extern void Ram_THUMB_mips (void);

#endif /* SAM7Board */
