//*----------------------------------------------------------------------------
//*      ATMEL Microcontroller Software Support  -  ROUSSET  -
//*----------------------------------------------------------------------------
//* The software is delivered "AS IS" without warranty or condition of any
//* kind, either express, implied or statutory. This includes without
//* limitation any warranty or condition with respect to merchantability or
//* fitness for any particular purpose, or against the infringements of
//* intellectual property rights of others.
//*----------------------------------------------------------------------------
//* File Name           : mips.c
//* Object              : Mips calculation
//* Creation            : JPP   13/Jan/2003
//* 1.1 29/Aug/05 JPP   : Update AIC definion
//*----------------------------------------------------------------------------

// Include Standard LIB  files

// Include Standard files
#include "Board.h"
#include "mips.h"

//* ------------------------------ Global variable ----------------------------

const AT91PS_TC	MipsTimerBase =AT91C_BASE_TC0;
const AT91S_MIPS_TIMER MipsTimer = { AT91C_ID_TC0,((MCK)/1024),TC_CLKS_MCK1024};

volatile unsigned int  cmpt_loop[2];

//*----------------------------------------------------------------------------
//* Function Name       : timer0_c_irq_handler
//* Object              : C handler interrupt function called by the interrupts
//*                       assembling routine
//* Output Parameters   : increment count_timer0_interrupt
//*----------------------------------------------------------------------------
void timer0_irq_handler(void)
{
    unsigned int dummy;
    //* Acknowledge interrupt status
    dummy = MipsTimerBase->TC_SR;
    MipsTimerBase->TC_CCR=AT91C_TC_CLKDIS;
    //* Stop internal loop
    cmpt_loop[0]=1;
    //* Suppress warning variable "dummy" was set but never used
    dummy = dummy;
}

//*----------------------------------------------------------------------------
//* Function Name       : Init_Mips_Timer
//* Object              : Init Timer management
//* Input Parameters    : none
//* Output Parameters   : none
//*----------------------------------------------------------------------------
void Init_Mips_Timer (void)
{
    int dummy;
	//* Init timer interrupt
	AT91F_PMC_EnablePeriphClock(AT91C_BASE_PMC,1 << MipsTimer.Id);

	 //* Disable the clock and the interrupts
	MipsTimerBase->TC_CCR = AT91C_TC_CLKDIS ;
	MipsTimerBase->TC_IDR = 0xFFFFFFFF ;
	dummy = MipsTimerBase->TC_SR ;
	//* Suppress warning
	dummy=dummy;
	//* Set the Mode of the Timer Counter
	MipsTimerBase->TC_CMR = AT91C_TC_WAVE |AT91C_TC_CPCTRG | MipsTimer.Div ;

	//* open Timer 0 interrupt
	AT91F_AIC_ConfigureIt ( AT91C_BASE_AIC, MipsTimer.Id, TIMER_INTERRUPT_LEVEL,AT91C_AIC_SRCTYPE_INT_HIGH_LEVEL, timer0_irq_handler);

	MipsTimerBase->TC_IER = AT91C_TC_CPCS;  	//* Enable the RC Compare interrupt
	AT91F_AIC_EnableIt (AT91C_BASE_AIC, MipsTimer.Id);

}
//*----------------------------------------------------------------------------
//* Function Name       : Start_Mips_Timer
//* Object              : Start Timer
//* Input Parameters    : none
//* Output Parameters   : none
//*----------------------------------------------------------------------------
__ramfunc void Start_Mips_Timer (void)
{
	cmpt_loop[0]=0;
	//* Enable the clock and Start timer
	MipsTimerBase->TC_CCR = AT91C_TC_CLKEN ;
	MipsTimerBase->TC_RA = 0;
	MipsTimerBase->TC_RB = MipsTimerBase->TC_RC = MipsTimer.Peroid;
	MipsTimerBase->TC_CCR = AT91C_TC_SWTRG ;
}

//*----------------------------------------------------------------------------
//* Function Name       : Mips_Result_loop
//* Object              : Return the number of loop can be executed under the time
//* Input Parameters    : none
//* Output Parameters   : the counter  value
//*----------------------------------------------------------------------------
unsigned int  Mips_Result_loop(void)
{
 return (cmpt_loop[1]);
}
//*----------------------------------------------------------------------------
//* Function Name       : Mips_Result_all
//* Object              : Return the number of loop can be executed under the time
//* Input Parameters    : none
//* Output Parameters   : miliMPIS
//*----------------------------------------------------------------------------
unsigned int  Mips_Result_all(void)
{
 return ((cmpt_loop[1]*NB_ASM_INSTRUCTION) / 1000);
}

