//*----------------------------------------------------------------------------
//*         ATMEL Microcontroller Software Support  -  ROUSSET  -
//*----------------------------------------------------------------------------
//* The software is delivered "AS IS" without warranty or condition of any
//* kind, either express, implied or statutory. This includes without
//* limitation any warranty or condition with respect to merchantability or
//* fitness for any particular purpose, or against the infringements of
//* intellectual property rights of others.
//*----------------------------------------------------------------------------
//* File Name           : main.c
//* Object              : main application written in C
//* Creation            : JPP   02/Jul/2004
//* 1.1 29/Aug/05 JPP   : Update AIC definion
//*----------------------------------------------------------------------------

/* 
   modified by Martin Thomas (not Atmel) for the GNU-toolchain
*/

// Include Standard files
#include "Board.h"
#include "dbgu.h"
#include "mips.h"
#define   NB_LOOP   1000000
//* --------------------------- Constant definition ---------------------------
#define SOFT_INTERRUPT_LEVEL	5

unsigned int WaitSate;
//*----------------------------------------------------------------------------
//* Function Name       : aic_software_interrupt
//* Object              : Software interrupt function
//*----------------------------------------------------------------------------
void aic_software_interrupt(void)
{//* Begin
  int i;
    //* measure application
    AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED3) ;
        for (i=0;i<NB_LOOP;i++)
        {
        //* Read the output state
            if ( (AT91F_PIO_GetInput(AT91C_BASE_PIOA) & LED4 ) == LED4 ) {
                AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED4 );
            }
            else {
               AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED4 );
           }// End if then else
       }// End For
   AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED3) ;
}

//*----------------------------------------------------------------------------
//* Function Name       : main
//* Object              : Main interrupt function
//*----------------------------------------------------------------------------

//mtA
//void main( void )
int main(void)
//mtE
{//* Begin


    // Load System pAic Base address
    AT91PS_AIC     pAic= AT91C_BASE_AIC;
    // Set the PIO
    // First, enable the clock of the PIO and set the LEDs in output
        AT91F_PMC_EnablePeriphClock ( AT91C_BASE_PMC, 1 << AT91C_ID_PIOA ) ;

 //* mthomas: Enable User Reset and set its minimal assertion to 960 us
        AT91C_BASE_RSTC->RSTC_RMR = AT91C_RSTC_URSTEN | (0x4<<8) | (unsigned int)(0xA5<<24);


    // then, we configure the PIO Lines corresponding to LED1 to LED4
    // to be outputs. No need to set these pins to be driven by the PIO because it is GPIO pins only.
       AT91F_PIO_CfgOutput( AT91C_BASE_PIOA, LED_MASK ) ;

    // Clear the LED's. On the SAM7S64 we must apply a "1" to turn off LEDs
       AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED_MASK ) ;

    //* define switch SW1 at PIO input
       AT91F_PIO_CfgInput(AT91C_BASE_PIOA,SW1_MASK);

    //* Software interrupt
    //* Open the software interrupt on the AIC
        AT91F_AIC_ConfigureIt ( pAic, AT91C_ID_SYS, SOFT_INTERRUPT_LEVEL, AT91C_AIC_SRCTYPE_INT_POSITIVE_EDGE,  aic_software_interrupt);
        AT91F_AIC_EnableIt (pAic, AT91C_ID_SYS);

    //* Timer initialization
        Init_Mips_Timer();

    //* Usart
       AT91F_DBGU_Init();
	   AT91F_DBGU_Printk("\r\nAtmel SAM7 MIPS-Demo (GNU-Port by Martin Thomas)\r\n");
       siprintf(message,"\r\nMCK clock frequency: %d Hz \r\n",MCK );
       AT91F_DBGU_Printk(message);


       AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED1) ;
       while( 1==1 ) {
              siprintf(message,"\r\nMC_FMR Value: 0x%X", AT91C_BASE_MC->MC_FMR);
              AT91F_DBGU_Printk(message);
#if 1
              siprintf(message,"\r\nEnter number of flash wait state to set: ");
              AT91F_DBGU_Printk(message);
              AT91F_DBGU_scanf("%d",&WaitSate);
              siprintf(message,"\r\nInput was %d\r\n", WaitSate);
              AT91F_DBGU_Printk(message);
#else
              WaitSate = 1;
#endif
              AT91C_BASE_MC->MC_FMR = (AT91C_BASE_MC->MC_FMR & ~AT91C_MC_FWS) | (WaitSate <<8);
              siprintf(message,"\r\n\r\nNumber of flash wait state is %d \r\n", (AT91C_BASE_MC->MC_FMR & AT91C_MC_FWS)>>8);
              AT91F_DBGU_Printk(message);

	      Init_Mips_Timer();
	      // Set LED2
	      AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED2) ;

#if 1
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      //* Background measurement
	      ARM_mips();
	      //* print result
	      siprintf(message,"\r\nFLASH_ARM     %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);

	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      AT91F_AIC_Trig (pAic,AT91C_ID_SYS);
	      //* Background measurement
	      ARM_mips();
	      //* print result
	      siprintf(message,"Measure %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
#endif

#if 1
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
              //* Background measurement
//	      AT91F_DBGU_Printk("-->");
	      THUMB_mips();
//        AT91F_DBGU_Printk("<--");
	      //* print result
	      siprintf(message,"FLASH_THUMB   %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      AT91F_AIC_Trig (pAic,AT91C_ID_SYS);
	      //* Background measurement
	      THUMB_mips();
	      //* print result
	      siprintf(message,"Measure %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
#endif

#if 1
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      //* Background measurement
	      Ram_ARM_mips();
	      //* print result
	      siprintf(message,"RAM_ARM %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      AT91F_AIC_Trig (pAic,AT91C_ID_SYS);
	      //* Background measurement
	      Ram_ARM_mips();
	      //* print result
	      siprintf(message,"Measure %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
#endif

#if 1
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      //* Background measurement
	      Ram_THUMB_mips();
	      //* print result
	      siprintf(message,"RAM_THUMB   %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
	      //* Enable the clock and Start timer
	      Start_Mips_Timer();
	      //* Start the target application
	      AT91F_AIC_Trig (pAic,AT91C_ID_SYS);
	      //* Background measurement
	      Ram_THUMB_mips();
	      //* print result
	      siprintf(message,"Measure %d, %d mMIPS\r\n", Mips_Result_loop(), Mips_Result_all() );
	      AT91F_DBGU_Printk(message);
#endif 
	
	      // Clear LED2
	      AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED2 ) ;
	} /* while */
	
	return 0; /* mt - never reached */

}//* End
