#ifndef mac71xx_h
#define mac71xx_h
/*******************************************************************************
mac71xx.h - Register defs for Motorola MAC 7101 / 7111 / 7121 / 7131 / 7141


THE SOFTWARE IS DELIVERED "AS IS" WITHOUT WARRANTY OR CONDITION OF ANY KIND, 
EITHER EXPRESS, IMPLIED OR STATUTORY. THIS INCLUDES WITHOUT LIMITATION ANY 
WARRANTY OR CONDITION WITH RESPECT TO MERCHANTABILITY OR FITNESS FOR ANY 
PARTICULAR PURPOSE, OR AGAINST THE INFRINGEMENTS OF INTELLECTUAL PROPERTY RIGHTS 
OF OTHERS.
           
This file may be freely used for commercial and non-commercial applications, 
including being redistributed with any tools.

If you find a problem with the file, please report it so that it can be fixed.

Created by Sten Larsson (sten_larsson at yahoo com)
*******************************************************************************/


#define REG8  (volatile unsigned char*)
#define REG16 (volatile unsigned short*)
#define REG32 (volatile unsigned int*)

/*##############################################################################
## REGISTERS
##############################################################################*/

#define AIPS_MPR         (*(REG32 (0xFC000000)))
#define AIPS_PACRA       (*(REG32 (0xFC000020)))
#define AIPS_PACRB       (*(REG32 (0xFC000028)))
#define AIPS_OPACRA      (*(REG32 (0xFC000040)))
#define AIPS_OPACRB      (*(REG32 (0xFC000044)))
#define AIPS_OPACRC      (*(REG32 (0xFC000048)))
#define AIPS_OPACRD      (*(REG32 (0xFC00004C)))
#define AIPS_OPACRE      (*(REG32 (0xFC000050)))


#define AXBS_PR_EIM      (*(REG32 (0xFC004100)))
#define AXBS_CR_EIM      (*(REG32 (0xFC004110)))
#define AXBS_PR_SRAM     (*(REG32 (0xFC004300)))
#define AXBS_CR_SRAM     (*(REG32 (0xFC004310)))
#define AXBS_PR_PC       (*(REG32 (0xFC004700)))
#define AXBS_CR_PC       (*(REG32 (0xFC004710)))


#define AEIM0_AR         (*(REG16 (0xFC008000)))
#define AEIM0_MR         (*(REG16 (0xFC008004)))
#define AEIM0_CR         (*(REG16 (0xFC008008)))
#define AEIM1_AR         (*(REG16 (0xFC00800C)))
#define AEIM1_MR         (*(REG16 (0xFC008010)))
#define AEIM1_CR         (*(REG16 (0xFC008014)))
#define AEIM2_AR         (*(REG16 (0xFC008018)))
#define AEIM2_MR         (*(REG16 (0xFC00801C)))
#define AEIM2_CR         (*(REG16 (0xFC008020)))


#define MCM_PCT          (*(REG16 (0xFC040000)))
#define MCM_REV          (*(REG16 (0xFC040002)))
#define MCM_AMC          (*(REG16 (0xFC040004)))
#define MCM_ASC          (*(REG16 (0xFC040006)))
#define MCM_IMC          (*(REG32 (0xFC040008)))
#define MCM_MRSR         (*(REG8  (0xFC04000F)))
#define MCM_MWCR         (*(REG8  (0xFC040013)))
#define MCM_MSWTCR       (*(REG16 (0xFC040016)))
#define MCM_MSWTSR       (*(REG8  (0xFC04001B)))
#define MCM_MSWTIR       (*(REG8  (0xFC04001F)))
#define MCM_AAMR         (*(REG32 (0xFC040020)))
#define MCM_CFADR        (*(REG32 (0xFC040070)))
#define MCM_CFLOC        (*(REG8  (0xFC040076)))
#define MCM_CFATR        (*(REG8  (0xFC040077)))
#define MCM_CFDTR        (*(REG32 (0xFC04007C)))


#define EDMAC_CR         (*(REG32 (0xFC044000)))
#define EDMAC_ES         (*(REG32 (0xFC044004)))
#define EDMAC_ERQ        (*(REG16 (0xFC04400E)))
#define EDMAC_EEI        (*(REG16 (0xFC044016)))
#define EDMAC_SERQ       (*(REG8  (0xFC044018)))
#define EDMAC_CERQ       (*(REG8  (0xFC044019)))
#define EDMAC_SEEI       (*(REG8  (0xFC04401A)))
#define EDMAC_CEEI       (*(REG8  (0xFC04401B)))
#define EDMAC_CINT       (*(REG8  (0xFC04401C)))
#define EDMAC_CERR       (*(REG8  (0xFC04401D)))
#define EDMAC_SSRT       (*(REG8  (0xFC04401E)))
#define EDMAC_CDNE       (*(REG8  (0xFC04401F)))
#define EDMAC_INT        (*(REG16 (0xFC044026)))
#define EDMAC_ERR        (*(REG16 (0xFC04402E)))
#define EDMAC_CH0        (*(REG8  (0xFC044100)))
#define EDMAC_CH1        (*(REG8  (0xFC044101)))
#define EDMAC_CH2        (*(REG8  (0xFC044102)))
#define EDMAC_CH3        (*(REG8  (0xFC044103)))
#define EDMAC_CH4        (*(REG8  (0xFC044104)))
#define EDMAC_CH5        (*(REG8  (0xFC044105)))
#define EDMAC_CH6        (*(REG8  (0xFC044106)))
#define EDMAC_CH7        (*(REG8  (0xFC044107)))
#define EDMAC_CH8        (*(REG8  (0xFC044108)))
#define EDMAC_CH9        (*(REG8  (0xFC044109)))
#define EDMAC_CHA        (*(REG8  (0xFC04410A)))
#define EDMAC_CHB        (*(REG8  (0xFC04410B)))
#define EDMAC_CHC        (*(REG8  (0xFC04410C)))
#define EDMAC_CHD        (*(REG8  (0xFC04410D)))
#define EDMAC_CHE        (*(REG8  (0xFC04410E)))
#define EDMAC_CHF        (*(REG8  (0xFC04410F)))
#define EDMAC_TCD0       (*(REG32 (0xFC044100)))
#define EDMAC_TCD1       (*(REG32 (0xFC044101)))
#define EDMAC_TCD2       (*(REG32 (0xFC044104)))
#define EDMAC_TCD3       (*(REG32 (0xFC044108)))
#define EDMAC_TCD4       (*(REG32 (0xFC04410C)))
#define EDMAC_TCD5       (*(REG32 (0xFC044120)))
#define EDMAC_TCD6       (*(REG32 (0xFC044121)))
#define EDMAC_TCD7       (*(REG32 (0xFC044124)))
#define EDMAC_TCD8       (*(REG32 (0xFC044128)))
#define EDMAC_TCD9       (*(REG32 (0xFC04412C)))
#define EDMAC_TCDA       (*(REG32 (0xFC044130)))
#define EDMAC_TCDB       (*(REG32 (0xFC044131)))
#define EDMAC_TCDC       (*(REG32 (0xFC044134)))
#define EDMAC_TCDD       (*(REG32 (0xFC044138)))
#define EDMAC_TCDE       (*(REG32 (0xFC04413C)))
#define EDMAC_TCDF       (*(REG32 (0xFC044140)))


#define INTC_IPRH        (*(REG32 (0xFC048000)))
#define INTC_IPRL        (*(REG32 (0xFC048004)))
#define INTC_IMRH        (*(REG32 (0xFC048008)))
#define INTC_IMRL        (*(REG32 (0xFC04800C)))
#define INTC_IFRCH       (*(REG32 (0xFC048010)))
#define INTC_IFRCL       (*(REG32 (0xFC048014)))
#define INTC_ICONFIG     (*(REG8  (0xFC04801B)))
#define INTC_SIMR        (*(REG8  (0xFC04801C)))
#define INTC_CIMR        (*(REG8  (0xFC04801D)))
#define INTC_CLMASK      (*(REG8  (0xFC04801E)))
#define INTC_SLMASK      (*(REG8  (0xFC04801F)))
#define INTC_ICR0        (*(REG8  (0xFC048040)))
#define INTC_ICR1        (*(REG8  (0xFC048041)))
#define INTC_ICR2        (*(REG8  (0xFC048042)))
#define INTC_ICR3        (*(REG8  (0xFC048043)))
#define INTC_ICR4        (*(REG8  (0xFC048044)))
#define INTC_ICR5        (*(REG8  (0xFC048045)))
#define INTC_ICR6        (*(REG8  (0xFC048046)))
#define INTC_ICR7        (*(REG8  (0xFC048047)))
#define INTC_ICR8        (*(REG8  (0xFC048048)))
#define INTC_ICR9        (*(REG8  (0xFC048049)))
#define INTC_ICRA        (*(REG8  (0xFC04804A)))
#define INTC_ICRB        (*(REG8  (0xFC04804B)))
#define INTC_ICRC        (*(REG8  (0xFC04804C)))
#define INTC_ICRD        (*(REG8  (0xFC04804D)))
#define INTC_ICRE        (*(REG8  (0xFC04804E)))
#define INTC_ICRF        (*(REG8  (0xFC04804F)))
#define INTC_ICR10       (*(REG8  (0xFC048050)))
#define INTC_ICR11       (*(REG8  (0xFC048051)))
#define INTC_ICR12       (*(REG8  (0xFC048052)))
#define INTC_ICR13       (*(REG8  (0xFC048053)))
#define INTC_ICR14       (*(REG8  (0xFC048054)))
#define INTC_ICR15       (*(REG8  (0xFC048055)))
#define INTC_ICR16       (*(REG8  (0xFC048056)))
#define INTC_ICR17       (*(REG8  (0xFC048057)))
#define INTC_ICR18       (*(REG8  (0xFC048058)))
#define INTC_ICR19       (*(REG8  (0xFC048059)))
#define INTC_ICR1A       (*(REG8  (0xFC04805A)))
#define INTC_ICR1B       (*(REG8  (0xFC04805B)))
#define INTC_ICR1C       (*(REG8  (0xFC04805C)))
#define INTC_ICR1D       (*(REG8  (0xFC04805D)))
#define INTC_ICR1E       (*(REG8  (0xFC04805E)))
#define INTC_ICR1F       (*(REG8  (0xFC04805F)))
#define INTC_ICR20       (*(REG8  (0xFC048060)))
#define INTC_ICR21       (*(REG8  (0xFC048061)))
#define INTC_ICR22       (*(REG8  (0xFC048062)))
#define INTC_ICR23       (*(REG8  (0xFC048063)))
#define INTC_ICR24       (*(REG8  (0xFC048064)))
#define INTC_ICR25       (*(REG8  (0xFC048065)))
#define INTC_ICR26       (*(REG8  (0xFC048066)))
#define INTC_ICR27       (*(REG8  (0xFC048067)))
#define INTC_ICR28       (*(REG8  (0xFC048068)))
#define INTC_ICR29       (*(REG8  (0xFC048069)))
#define INTC_ICR2A       (*(REG8  (0xFC04806A)))
#define INTC_ICR2B       (*(REG8  (0xFC04806B)))
#define INTC_ICR2C       (*(REG8  (0xFC04806C)))
#define INTC_ICR2D       (*(REG8  (0xFC04806D)))
#define INTC_ICR2E       (*(REG8  (0xFC04806E)))
#define INTC_ICR2F       (*(REG8  (0xFC04806F)))
#define INTC_ICR30       (*(REG8  (0xFC048070)))
#define INTC_ICR31       (*(REG8  (0xFC048071)))
#define INTC_ICR32       (*(REG8  (0xFC048072)))
#define INTC_ICR33       (*(REG8  (0xFC048073)))
#define INTC_ICR34       (*(REG8  (0xFC048074)))
#define INTC_ICR35       (*(REG8  (0xFC048075)))
#define INTC_ICR36       (*(REG8  (0xFC048076)))
#define INTC_ICR37       (*(REG8  (0xFC048077)))
#define INTC_ICR38       (*(REG8  (0xFC048078)))
#define INTC_ICR39       (*(REG8  (0xFC048079)))
#define INTC_ICR3A       (*(REG8  (0xFC04807A)))
#define INTC_ICR3B       (*(REG8  (0xFC04807B)))
#define INTC_ICR3C       (*(REG8  (0xFC04807C)))
#define INTC_ICR3D       (*(REG8  (0xFC04807D)))
#define INTC_ICR3E       (*(REG8  (0xFC04807E)))
#define INTC_ICR3F       (*(REG8  (0xFC04807F)))
#define INTC_IRQIACK     (*(REG8  (0xFC0480EC)))
#define INTC_FIQIACK     (*(REG8  (0xFC0480F0)))


#define SSM_STATUS       (*(REG16 (0xFC080002)))
#define SSM_MEMCONFIG    (*(REG16 (0xFC080004)))
#define SSM_WAKEUP       (*(REG32 (0xFC080008)))
#define SSM_PORTSEL      (*(REG16 (0xFC08000C)))


#define DMA_CHCONFIG1    (*(REG8  (0xFC084000)))
#define DMA_CHCONFIG2    (*(REG8  (0xFC084001)))
#define DMA_CHCONFIG3    (*(REG8  (0xFC084002)))
#define DMA_CHCONFIG4    (*(REG8  (0xFC084003)))
#define DMA_CHCONFIG5    (*(REG8  (0xFC084004)))
#define DMA_CHCONFIG6    (*(REG8  (0xFC084005)))
#define DMA_CHCONFIG7    (*(REG8  (0xFC084006)))
#define DMA_CHCONFIG8    (*(REG8  (0xFC084007)))
#define DMA_CHCONFIG9    (*(REG8  (0xFC084008)))
#define DMA_CHCONFIG10   (*(REG8  (0xFC084009)))
#define DMA_CHCONFIG11   (*(REG8  (0xFC08400A)))
#define DMA_CHCONFIG12   (*(REG8  (0xFC08400B)))
#define DMA_CHCONFIG13   (*(REG8  (0xFC08400C)))
#define DMA_CHCONFIG14   (*(REG8  (0xFC08400D)))
#define DMA_CHCONFIG15   (*(REG8  (0xFC08400E)))
#define DMA_CHCONFIG16   (*(REG8  (0xFC08400F)))


#define CRG_SYNR         (*(REG8  (0xFC088000)))
#define CRG_REFDV        (*(REG8  (0xFC088001)))
#define CRG_CTFLG        (*(REG8  (0xFC088002)))
#define CRG_FLG          (*(REG8  (0xFC088003)))
#define CRG_INT          (*(REG8  (0xFC088004)))
#define CRG_CLKSEL       (*(REG8  (0xFC088005)))
#define CRG_PLLCTL       (*(REG8  (0xFC088006)))
#define CRG_SDMCTL       (*(REG8  (0xFC088007)))
#define CRG_BDMCTL       (*(REG8  (0xFC088008)))
#define CRG_FORBYP       (*(REG8  (0xFC088009)))
#define CRG_CTCTL        (*(REG8  (0xFC08800A)))


#define PIT_FLG          (*(REG32 (0xFC08C100)))
#define PIT_INTEN        (*(REG32 (0xFC08C104)))
#define PIT_INTSEL       (*(REG32 (0xFC08C108)))
#define PIT_EN           (*(REG32 (0xFC08C10C)))
#define PIT_CTRL         (*(REG32 (0xFC08C110)))


#define VREG_CTRL        (*(REG8  (0xFC090000)))


#define CANA_MCR         (*(REG32 (0xFC094000)))
#define CANA_CTRL        (*(REG32 (0xFC094004)))
#define CANA_TIMER       (*(REG32 (0xFC094008)))
#define CANA_RXGMASK     (*(REG32 (0xFC094010)))
#define CANA_RX14MASK    (*(REG32 (0xFC094014)))
#define CANA_RX15MASK    (*(REG32 (0xFC094018)))
#define CANA_ECR         (*(REG32 (0xFC09401C)))
#define CANA_ESR         (*(REG32 (0xFC094020)))
#define CANA_IMASK2      (*(REG32 (0xFC094024)))
#define CANA_IMASK1      (*(REG32 (0xFC094028)))
#define CANA_IFLAG2      (*(REG32 (0xFC09402C)))
#define CANA_IFLAG1      (*(REG32 (0xFC094030)))
#define CANA_BUF0        (*(REG32 (0xFC094080)))
#define CANA_BUF1        (*(REG32 (0xFC094081)))
#define CANA_BUF2        (*(REG32 (0xFC094082)))
#define CANA_BUF3        (*(REG32 (0xFC094083)))
#define CANA_BUF4        (*(REG32 (0xFC094084)))
#define CANA_BUF5        (*(REG32 (0xFC094085)))
#define CANA_BUF6        (*(REG32 (0xFC094086)))
#define CANA_BUF7        (*(REG32 (0xFC094087)))
#define CANA_BUF8        (*(REG32 (0xFC094088)))
#define CANA_BUF9        (*(REG32 (0xFC094089)))
#define CANA_BUFA        (*(REG32 (0xFC09408A)))
#define CANA_BUFB        (*(REG32 (0xFC09408B)))
#define CANA_BUFC        (*(REG32 (0xFC09408C)))
#define CANA_BUFD        (*(REG32 (0xFC09408D)))
#define CANA_BUFE        (*(REG32 (0xFC09408E)))
#define CANA_BUFF        (*(REG32 (0xFC09408F)))
#define CANA_BUF10       (*(REG32 (0xFC094090)))
#define CANA_BUF11       (*(REG32 (0xFC094091)))
#define CANA_BUF12       (*(REG32 (0xFC094092)))
#define CANA_BUF13       (*(REG32 (0xFC094093)))
#define CANA_BUF14       (*(REG32 (0xFC094094)))
#define CANA_BUF15       (*(REG32 (0xFC094095)))
#define CANA_BUF16       (*(REG32 (0xFC094096)))
#define CANA_BUF17       (*(REG32 (0xFC094097)))
#define CANA_BUF18       (*(REG32 (0xFC094098)))
#define CANA_BUF19       (*(REG32 (0xFC094099)))
#define CANA_BUF1A       (*(REG32 (0xFC09409A)))
#define CANA_BUF1B       (*(REG32 (0xFC09409B)))
#define CANA_BUF1C       (*(REG32 (0xFC09409C)))
#define CANA_BUF1D       (*(REG32 (0xFC09409D)))
#define CANA_BUF1E       (*(REG32 (0xFC09409E)))
#define CANA_BUF1F       (*(REG32 (0xFC09409F)))

#define CANB_MCR         (*(REG32 (0xFC098000)))
#define CANB_CTRL        (*(REG32 (0xFC098004)))
#define CANB_TIMER       (*(REG32 (0xFC098008)))
#define CANB_RXGMASK     (*(REG32 (0xFC098010)))
#define CANB_RX14MASK    (*(REG32 (0xFC098014)))
#define CANB_RX15MASK    (*(REG32 (0xFC098018)))
#define CANB_ECR         (*(REG32 (0xFC09801C)))
#define CANB_ESR         (*(REG32 (0xFC098020)))
#define CANB_IMASK2      (*(REG32 (0xFC098024)))
#define CANB_IMASK1      (*(REG32 (0xFC098028)))
#define CANB_IFLAG2      (*(REG32 (0xFC09802C)))
#define CANB_IFLAG1      (*(REG32 (0xFC098030)))
#define CANB_BUF0        (*(REG32 (0xFC098080)))
#define CANB_BUF1        (*(REG32 (0xFC098081)))
#define CANB_BUF2        (*(REG32 (0xFC098082)))
#define CANB_BUF3        (*(REG32 (0xFC098083)))
#define CANB_BUF4        (*(REG32 (0xFC098084)))
#define CANB_BUF5        (*(REG32 (0xFC098085)))
#define CANB_BUF6        (*(REG32 (0xFC098086)))
#define CANB_BUF7        (*(REG32 (0xFC098087)))
#define CANB_BUF8        (*(REG32 (0xFC098088)))
#define CANB_BUF9        (*(REG32 (0xFC098089)))
#define CANB_BUFA        (*(REG32 (0xFC09808A)))
#define CANB_BUFB        (*(REG32 (0xFC09808B)))
#define CANB_BUFC        (*(REG32 (0xFC09808C)))
#define CANB_BUFD        (*(REG32 (0xFC09808D)))
#define CANB_BUFE        (*(REG32 (0xFC09808E)))
#define CANB_BUFF        (*(REG32 (0xFC09808F)))
#define CANB_BUF10       (*(REG32 (0xFC098090)))
#define CANB_BUF11       (*(REG32 (0xFC098091)))
#define CANB_BUF12       (*(REG32 (0xFC098092)))
#define CANB_BUF13       (*(REG32 (0xFC098093)))
#define CANB_BUF14      (*(REG32 (0xFC098094)))
#define CANB_BUF15      (*(REG32 (0xFC098095)))
#define CANB_BUF16      (*(REG32 (0xFC098096)))
#define CANB_BUF17      (*(REG32 (0xFC098097)))
#define CANB_BUF18      (*(REG32 (0xFC098098)))
#define CANB_BUF19      (*(REG32 (0xFC098099)))
#define CANB_BUF1A      (*(REG32 (0xFC09809A)))
#define CANB_BUF1B      (*(REG32 (0xFC09809B)))
#define CANB_BUF1C      (*(REG32 (0xFC09809C)))
#define CANB_BUF1D      (*(REG32 (0xFC09809D)))
#define CANB_BUF1E      (*(REG32 (0xFC09809E)))
#define CANB_BUF1F      (*(REG32 (0xFC09809F)))


#define CANC_MCR        (*(REG32 (0xFC09C000)))
#define CANC_CTRL       (*(REG32 (0xFC09C004)))
#define CANC_TIMER      (*(REG32 (0xFC09C008)))
#define CANC_RXGMASK    (*(REG32 (0xFC09C010)))
#define CANC_RX14MASK   (*(REG32 (0xFC09C014)))
#define CANC_RX15MASK   (*(REG32 (0xFC09C018)))
#define CANC_ECR        (*(REG32 (0xFC09C01C)))
#define CANC_ESR        (*(REG32 (0xFC09C020)))
#define CANC_IMASK2     (*(REG32 (0xFC09C024)))
#define CANC_IMASK1     (*(REG32 (0xFC09C028)))
#define CANC_IFLAG2     (*(REG32 (0xFC09C02C)))
#define CANC_IFLAG1     (*(REG32 (0xFC09C030)))
#define CANC_BUF0       (*(REG32 (0xFC09C080)))
#define CANC_BUF1       (*(REG32 (0xFC09C081)))
#define CANC_BUF2       (*(REG32 (0xFC09C082)))
#define CANC_BUF3       (*(REG32 (0xFC09C083)))
#define CANC_BUF4       (*(REG32 (0xFC09C084)))
#define CANC_BUF5       (*(REG32 (0xFC09C085)))
#define CANC_BUF6       (*(REG32 (0xFC09C086)))
#define CANC_BUF7       (*(REG32 (0xFC09C087)))
#define CANC_BUF8       (*(REG32 (0xFC09C088)))
#define CANC_BUF9       (*(REG32 (0xFC09C089)))
#define CANC_BUFA       (*(REG32 (0xFC09C08A)))
#define CANC_BUFB       (*(REG32 (0xFC09C08B)))
#define CANC_BUFC       (*(REG32 (0xFC09C08C)))
#define CANC_BUFD       (*(REG32 (0xFC09C08D)))
#define CANC_BUFE       (*(REG32 (0xFC09C08E)))
#define CANC_BUFF       (*(REG32 (0xFC09C08F)))
#define CANC_BUF10      (*(REG32 (0xFC09C090)))
#define CANC_BUF11      (*(REG32 (0xFC09C091)))
#define CANC_BUF12      (*(REG32 (0xFC09C092)))
#define CANC_BUF13      (*(REG32 (0xFC09C093)))
#define CANC_BUF14      (*(REG32 (0xFC09C094)))
#define CANC_BUF15      (*(REG32 (0xFC09C095)))
#define CANC_BUF16      (*(REG32 (0xFC09C096)))
#define CANC_BUF17      (*(REG32 (0xFC09C097)))
#define CANC_BUF18      (*(REG32 (0xFC09C098)))
#define CANC_BUF19      (*(REG32 (0xFC09C099)))
#define CANC_BUF1A      (*(REG32 (0xFC09C09A)))
#define CANC_BUF1B      (*(REG32 (0xFC09C09B)))
#define CANC_BUF1C      (*(REG32 (0xFC09C09C)))
#define CANC_BUF1D      (*(REG32 (0xFC09C09D)))
#define CANC_BUF1E      (*(REG32 (0xFC09C09E)))
#define CANC_BUF1F      (*(REG32 (0xFC09C09F)))

#define CAND_MCR        (*(REG32 (0xFC0A0000)))
#define CAND_CTRL       (*(REG32 (0xFC0A0004)))
#define CAND_TIMER      (*(REG32 (0xFC0A0008)))
#define CAND_RXGMASK    (*(REG32 (0xFC0A0010)))
#define CAND_RX14MASK   (*(REG32 (0xFC0A0014)))
#define CAND_RX15MASK   (*(REG32 (0xFC0A0018)))
#define CAND_ECR        (*(REG32 (0xFC0A001C)))
#define CAND_ESR        (*(REG32 (0xFC0A0020)))
#define CAND_IMASK2     (*(REG32 (0xFC0A0024)))
#define CAND_IMASK1     (*(REG32 (0xFC0A0028)))
#define CAND_IFLAG2     (*(REG32 (0xFC0A002C)))
#define CAND_IFLAG1     (*(REG32 (0xFC0A0030)))
#define CAND_BUF0       (*(REG32 (0xFC0A0080)))
#define CAND_BUF1       (*(REG32 (0xFC0A0081)))
#define CAND_BUF2       (*(REG32 (0xFC0A0082)))
#define CAND_BUF3       (*(REG32 (0xFC0A0083)))
#define CAND_BUF4       (*(REG32 (0xFC0A0084)))
#define CAND_BUF5       (*(REG32 (0xFC0A0085)))
#define CAND_BUF6       (*(REG32 (0xFC0A0086)))
#define CAND_BUF7       (*(REG32 (0xFC0A0087)))
#define CAND_BUF8       (*(REG32 (0xFC0A0088)))
#define CAND_BUF9       (*(REG32 (0xFC0A0089)))
#define CAND_BUFA       (*(REG32 (0xFC0A008A)))
#define CAND_BUFB       (*(REG32 (0xFC0A008B)))
#define CAND_BUFC       (*(REG32 (0xFC0A008C)))
#define CAND_BUFD       (*(REG32 (0xFC0A008D)))
#define CAND_BUFE       (*(REG32 (0xFC0A008E)))
#define CAND_BUFF       (*(REG32 (0xFC0A008F)))
#define CAND_BUF10      (*(REG32 (0xFC0A0090)))
#define CAND_BUF11      (*(REG32 (0xFC0A0091)))
#define CAND_BUF12      (*(REG32 (0xFC0A0092)))
#define CAND_BUF13      (*(REG32 (0xFC0A0093)))
#define CAND_BUF14      (*(REG32 (0xFC0A0094)))
#define CAND_BUF15      (*(REG32 (0xFC0A0095)))
#define CAND_BUF16      (*(REG32 (0xFC0A0096)))
#define CAND_BUF17      (*(REG32 (0xFC0A0097)))
#define CAND_BUF18      (*(REG32 (0xFC0A0098)))
#define CAND_BUF19      (*(REG32 (0xFC0A0099)))
#define CAND_BUF1A      (*(REG32 (0xFC0A009A)))
#define CAND_BUF1B      (*(REG32 (0xFC0A009B)))
#define CAND_BUF1C      (*(REG32 (0xFC0A009C)))
#define CAND_BUF1D      (*(REG32 (0xFC0A009D)))
#define CAND_BUF1E      (*(REG32 (0xFC0A009E)))
#define CAND_BUF1F      (*(REG32 (0xFC0A009F)))


#define IIC_IBAD        (*(REG8  (0xFC0AC000)))
#define IIC_IBFD        (*(REG8  (0xFC0AC001)))
#define IIC_IBCR        (*(REG8  (0xFC0AC002)))
#define IIC_IBSR        (*(REG8  (0xFC0AC003)))
#define IIC_IBDR        (*(REG8  (0xFC0AC004)))


#define DSPIA_MCR       (*(REG32 (0xFC0B4000)))
#define DSPIA_TCR       (*(REG32 (0xFC0B4008)))
#define DSPIA_SR        (*(REG32 (0xFC0B402C)))
#define DSPIA_RSER      (*(REG32 (0xFC0B4030)))
#define DSPIA_PUSHR     (*(REG32 (0xFC0B4034)))
#define DSPIA_POPR      (*(REG32 (0xFC0B4038)))
#define DSPIA_TXFR0     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR1     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR2     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR3     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR4     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR5     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR6     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR7     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR8     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFR9     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRA     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRB     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRC     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRD     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRE     (*(REG32 (0xFC0B403C)))
#define DSPIA_TXFRF     (*(REG32 (0xFC0B403C)))
#define DSPIA_RXFR0     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR1     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR2     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR3     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR4     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR5     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR6     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR7     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR8     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFR9     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRA     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRB     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRC     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRD     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRE     (*(REG32 (0xFC0B407C)))
#define DSPIA_RXFRF     (*(REG32 (0xFC0B407C)))

#define DSPIB_MCR       (*(REG32 (0xFC0B8000)))
#define DSPIB_TCR       (*(REG32 (0xFC0B8008)))
#define DSPIB_SR        (*(REG32 (0xFC0B802C)))
#define DSPIB_RSER      (*(REG32 (0xFC0B8030)))
#define DSPIB_PUSHR     (*(REG32 (0xFC0B8034)))
#define DSPIB_POPR      (*(REG32 (0xFC0B8038)))
#define DSPIB_TXFR0     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR1     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR2     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR3     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR4     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR5     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR6     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR7     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR8     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFR9     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRA     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRB     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRC     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRD     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRE     (*(REG32 (0xFC0B803C)))
#define DSPIB_TXFRF     (*(REG32 (0xFC0B803C)))
#define DSPIB_RXFR0     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR1     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR2     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR3     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR4     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR5     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR6     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR7     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR8     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFR9     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRA     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRB     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRC     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRD     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRE     (*(REG32 (0xFC0B807C)))
#define DSPIB_RXFRF     (*(REG32 (0xFC0B807C)))


#define ESCIA_BD        (*(REG8  (0xFC0C4000)))
#define ESCIA_CR1       (*(REG8  (0xFC0C4002)))
#define ESCIA_CR2       (*(REG8  (0xFC0C4003)))
#define ESCIA_CR3       (*(REG8  (0xFC0C4004)))
#define ESCIA_DRH       (*(REG8  (0xFC0C4006)))
#define ESCIA_DRL       (*(REG8  (0xFC0C4007)))
#define ESCIA_SR1       (*(REG8  (0xFC0C4008)))
#define ESCIA_SR2       (*(REG8  (0xFC0C4009)))
#define ESCIA_LINSTAT1  (*(REG8  (0xFC0C400A)))
#define ESCIA_LINSTAT2  (*(REG8  (0xFC0C400B)))
#define ESCIA_LINCTRL1  (*(REG8  (0xFC0C400C)))
#define ESCIA_LINCTRL2  (*(REG8  (0xFC0C400D)))
#define ESCIA_LINCTRL3  (*(REG8  (0xFC0C400E)))
#define ESCIA_LINTX     (*(REG8  (0xFC0C4010)))
#define ESCIA_LINRX     (*(REG8  (0xFC0C4014)))
#define ESCIA_LINCRCP1  (*(REG8  (0xFC0C4018)))
#define ESCIA_LINCRCP2  (*(REG8  (0xFC0C4019)))

/*
#define ESCIA_BD        (*(REG8  (0xFC0C8000)))
#define ESCIA_CR1       (*(REG8  (0xFC0C8002)))
#define ESCIA_CR2       (*(REG8  (0xFC0C8003)))
#define ESCIA_CR3       (*(REG8  (0xFC0C8004)))
#define ESCIA_DRH       (*(REG8  (0xFC0C8006)))
#define ESCIA_DRL       (*(REG8  (0xFC0C8007)))
#define ESCIA_SR1       (*(REG8  (0xFC0C8008)))
#define ESCIA_SR2       (*(REG8  (0xFC0C8009)))
#define ESCIA_LINSTAT1  (*(REG8  (0xFC0C800A)))
#define ESCIA_LINSTAT2  (*(REG8  (0xFC0C800B)))
#define ESCIA_LINCTRL1  (*(REG8  (0xFC0C800C)))
#define ESCIA_LINCTRL2  (*(REG8  (0xFC0C800D)))
#define ESCIA_LINCTRL3  (*(REG8  (0xFC0C800E)))
#define ESCIA_LINTX     (*(REG8  (0xFC0C8010)))
#define ESCIA_LINRX     (*(REG8  (0xFC0C8014)))
#define ESCIA_LINCRCP1  (*(REG8  (0xFC0C8018)))
#define ESCIA_LINCRCP2  (*(REG8  (0xFC0C8019)))
*/

#define ESCIB_BD        (*(REG8  (0xFC0CC000)))
#define ESCIB_CR1       (*(REG8  (0xFC0CC002)))
#define ESCIB_CR2       (*(REG8  (0xFC0CC003)))
#define ESCIB_CR3       (*(REG8  (0xFC0CC004)))
#define ESCIB_DRH       (*(REG8  (0xFC0CC006)))
#define ESCIB_DRL       (*(REG8  (0xFC0CC007)))
#define ESCIB_SR1       (*(REG8  (0xFC0CC008)))
#define ESCIB_SR2       (*(REG8  (0xFC0CC009)))
#define ESCIB_LINSTAT1  (*(REG8  (0xFC0CC00A)))
#define ESCIB_LINSTAT2  (*(REG8  (0xFC0CC00B)))
#define ESCIB_LINCTRL1  (*(REG8  (0xFC0CC00C)))
#define ESCIB_LINCTRL2  (*(REG8  (0xFC0CC00D)))
#define ESCIB_LINCTRL3  (*(REG8  (0xFC0CC00E)))
#define ESCIB_LINTX     (*(REG8  (0xFC0CC010)))
#define ESCIB_LINRX     (*(REG8  (0xFC0CC014)))
#define ESCIB_LINCRCP1  (*(REG8  (0xFC0CC018)))
#define ESCIB_LINCRCP2  (*(REG8  (0xFC0CC019)))


#define ESCIC_BD        (*(REG8  (0xFC0D0000)))
#define ESCIC_CR1       (*(REG8  (0xFC0D0002)))
#define ESCIC_CR2       (*(REG8  (0xFC0D0003)))
#define ESCIC_CR3       (*(REG8  (0xFC0D0004)))
#define ESCIC_DRH       (*(REG8  (0xFC0D0006)))
#define ESCIC_DRL       (*(REG8  (0xFC0D0007)))
#define ESCIC_SR1       (*(REG8  (0xFC0D0008)))
#define ESCIC_SR2       (*(REG8  (0xFC0D0009)))
#define ESCIC_LINSTAT1  (*(REG8  (0xFC0D000A)))
#define ESCIC_LINSTAT2  (*(REG8  (0xFC0D000B)))
#define ESCIC_LINCTRL1  (*(REG8  (0xFC0D000C)))
#define ESCIC_LINCTRL2  (*(REG8  (0xFC0D000D)))
#define ESCIC_LINCTRL3  (*(REG8  (0xFC0D000E)))
#define ESCIC_LINTX     (*(REG8  (0xFC0D0010)))
#define ESCIC_LINRX     (*(REG8  (0xFC0D0014)))
#define ESCIC_LINCRCP1  (*(REG8  (0xFC0D0018)))
#define ESCIC_LINCRCP2  (*(REG8  (0xFC0D0019)))


#define EMIOS_MCR       (*(REG32 (0xFC0DC000)))
#define EMIOS_GFLAG     (*(REG32 (0xFC0DC004)))
#define EMIOS_OUDIS     (*(REG32 (0xFC0DC008)))
#define EMIOS_UCDIS     (*(REG32 (0xFC0DC00C)))
#define EMIOS_CH0       (*(REG32 (0xFC0DC020)))
#define EMIOS_CH1       (*(REG32 (0xFC0DC020)))
#define EMIOS_CH2       (*(REG32 (0xFC0DC020)))
#define EMIOS_CH3       (*(REG32 (0xFC0DC020)))


#define ATDA_TRIGCTL    (*(REG8  (0xFC0E0000)))
#define ATDA_ETRIGCH    (*(REG8  (0xFC0E0001)))
#define ATDA_PRE        (*(REG8  (0xFC0E0002)))
#define ATDA_MODE       (*(REG8  (0xFC0E0003)))
#define ATDA_INT        (*(REG8  (0xFC0E000E)))
#define ATDA_FLAG       (*(REG8  (0xFC0E000F)))
#define ATDA_CW         (*(REG32 (0xFC0E0010)))
#define ATDA_RR         (*(REG32 (0xFC0E0014)))


#define ATDB_TRIGCTL    (*(REG8  (0xFC0E4000)))
#define ATDB_ETRIGCH    (*(REG8  (0xFC0E4001)))
#define ATDB_PRE        (*(REG8  (0xFC0E4002)))
#define ATDB_MODE       (*(REG8  (0xFC0E4003)))
#define ATDB_INT        (*(REG8  (0xFC0E400E)))
#define ATDB_FLAG       (*(REG8  (0xFC0E400F)))
#define ATDB_CW         (*(REG32 (0xFC0E4010)))
#define ATDB_RR         (*(REG32 (0xFC0E4014)))


#define PIMA_CONFIG0    (*(REG16 (0xFC0E8000)))
#define PIMA_CONFIG1    (*(REG16 (0xFC0E8002)))
#define PIMA_CONFIG2    (*(REG16 (0xFC0E8004)))
#define PIMA_CONFIG3    (*(REG16 (0xFC0E8006)))
#define PIMA_CONFIG4    (*(REG16 (0xFC0E8008)))
#define PIMA_CONFIG5    (*(REG16 (0xFC0E800A)))
#define PIMA_CONFIG6    (*(REG16 (0xFC0E800C)))
#define PIMA_CONFIG7    (*(REG16 (0xFC0E800E)))
#define PIMA_CONFIG8    (*(REG16 (0xFC0E8010)))
#define PIMA_CONFIG9    (*(REG16 (0xFC0E8012)))
#define PIMA_CONFIGA    (*(REG16 (0xFC0E8014)))
#define PIMA_CONFIGB    (*(REG16 (0xFC0E8016)))
#define PIMA_CONFIGC    (*(REG16 (0xFC0E8018)))
#define PIMA_CONFIGD    (*(REG16 (0xFC0E801A)))
#define PIMA_CONFIGE    (*(REG16 (0xFC0E801C)))
#define PIMA_CONFIGF    (*(REG16 (0xFC0E801E)))
#define PIMA_PORTIFR    (*(REG16 (0xFC0E8020)))
#define PIMA_PORTDATA   (*(REG16 (0xFC0E8024)))
#define PIMA_PORTIR     (*(REG16 (0xFC0E8026)))
#define PIMA_PINDATA0   (*(REG8  (0xFC0E8028)))
#define PIMA_PINDATA1   (*(REG8  (0xFC0E8029)))
#define PIMA_PINDATA2   (*(REG8  (0xFC0E802A)))
#define PIMA_PINDATA3   (*(REG8  (0xFC0E802B)))
#define PIMA_PINDATA4   (*(REG8  (0xFC0E802C)))
#define PIMA_PINDATA5   (*(REG8  (0xFC0E802D)))
#define PIMA_PINDATA6   (*(REG8  (0xFC0E802E)))
#define PIMA_PINDATA7   (*(REG8  (0xFC0E802F)))
#define PIMA_PINDATA8   (*(REG8  (0xFC0E8030)))
#define PIMA_PINDATA9   (*(REG8  (0xFC0E8031)))
#define PIMA_PINDATAA   (*(REG8  (0xFC0E8032)))
#define PIMA_PINDATAB   (*(REG8  (0xFC0E8033)))
#define PIMA_PINDATAC   (*(REG8  (0xFC0E8034)))
#define PIMA_PINDATAD   (*(REG8  (0xFC0E8035)))
#define PIMA_PINDATAE   (*(REG8  (0xFC0E8036)))
#define PIMA_PINDATAF   (*(REG8  (0xFC0E8037)))

#define PIMB_CONFIG0    (*(REG16 (0xFC0E8040)))
#define PIMB_CONFIG1    (*(REG16 (0xFC0E8042)))
#define PIMB_CONFIG2    (*(REG16 (0xFC0E8044)))
#define PIMB_CONFIG3    (*(REG16 (0xFC0E8046)))
#define PIMB_CONFIG4    (*(REG16 (0xFC0E8048)))
#define PIMB_CONFIG5    (*(REG16 (0xFC0E804A)))
#define PIMB_CONFIG6    (*(REG16 (0xFC0E804C)))
#define PIMB_CONFIG7    (*(REG16 (0xFC0E804E)))
#define PIMB_CONFIG8    (*(REG16 (0xFC0E8050)))
#define PIMB_CONFIG9    (*(REG16 (0xFC0E8052)))
#define PIMB_CONFIGA    (*(REG16 (0xFC0E8054)))
#define PIMB_CONFIGB    (*(REG16 (0xFC0E8056)))
#define PIMB_CONFIGC    (*(REG16 (0xFC0E8058)))
#define PIMB_CONFIGD    (*(REG16 (0xFC0E805A)))
#define PIMB_CONFIGE    (*(REG16 (0xFC0E805C)))
#define PIMB_CONFIGF    (*(REG16 (0xFC0E805E)))
#define PIMB_PORTIFR    (*(REG16 (0xFC0E8060)))
#define PIMB_PORTDATA   (*(REG16 (0xFC0E8064)))
#define PIMB_PORTIR     (*(REG16 (0xFC0E8066)))
#define PIMB_PINDATA0   (*(REG8  (0xFC0E8068)))
#define PIMB_PINDATA1   (*(REG8  (0xFC0E8069)))
#define PIMB_PINDATA2   (*(REG8  (0xFC0E806A)))
#define PIMB_PINDATA3   (*(REG8  (0xFC0E806B)))
#define PIMB_PINDATA4   (*(REG8  (0xFC0E806C)))
#define PIMB_PINDATA5   (*(REG8  (0xFC0E806D)))
#define PIMB_PINDATA6   (*(REG8  (0xFC0E806E)))
#define PIMB_PINDATA7   (*(REG8  (0xFC0E806F)))
#define PIMB_PINDATA8   (*(REG8  (0xFC0E8070)))
#define PIMB_PINDATA9   (*(REG8  (0xFC0E8071)))
#define PIMB_PINDATAA   (*(REG8  (0xFC0E8072)))
#define PIMB_PINDATAB   (*(REG8  (0xFC0E8073)))
#define PIMB_PINDATAC   (*(REG8  (0xFC0E8074)))
#define PIMB_PINDATAD   (*(REG8  (0xFC0E8075)))
#define PIMB_PINDATAE   (*(REG8  (0xFC0E8076)))
#define PIMB_PINDATAF   (*(REG8  (0xFC0E8077)))

#define PIMC_CONFIG0    (*(REG16 (0xFC0E8080)))
#define PIMC_CONFIG1    (*(REG16 (0xFC0E8082)))
#define PIMC_CONFIG2    (*(REG16 (0xFC0E8084)))
#define PIMC_CONFIG3    (*(REG16 (0xFC0E8086)))
#define PIMC_CONFIG4    (*(REG16 (0xFC0E8088)))
#define PIMC_CONFIG5    (*(REG16 (0xFC0E808A)))
#define PIMC_CONFIG6    (*(REG16 (0xFC0E808C)))
#define PIMC_CONFIG7    (*(REG16 (0xFC0E808E)))
#define PIMC_CONFIG8    (*(REG16 (0xFC0E8090)))
#define PIMC_CONFIG9    (*(REG16 (0xFC0E8092)))
#define PIMC_CONFIGA    (*(REG16 (0xFC0E8094)))
#define PIMC_CONFIGB    (*(REG16 (0xFC0E8096)))
#define PIMC_CONFIGC    (*(REG16 (0xFC0E8098)))
#define PIMC_CONFIGD    (*(REG16 (0xFC0E809A)))
#define PIMC_CONFIGE    (*(REG16 (0xFC0E809C)))
#define PIMC_CONFIGF    (*(REG16 (0xFC0E809E)))
#define PIMC_PORTIFR    (*(REG16 (0xFC0E80A0)))
#define PIMC_PORTDATA   (*(REG16 (0xFC0E80A4)))
#define PIMC_PORTIR     (*(REG16 (0xFC0E80A6)))
#define PIMC_PINDATA0   (*(REG8  (0xFC0E80A8)))
#define PIMC_PINDATA1   (*(REG8  (0xFC0E80A9)))
#define PIMC_PINDATA2   (*(REG8  (0xFC0E80AA)))
#define PIMC_PINDATA3   (*(REG8  (0xFC0E80AB)))
#define PIMC_PINDATA4   (*(REG8  (0xFC0E80AC)))
#define PIMC_PINDATA5   (*(REG8  (0xFC0E80AD)))
#define PIMC_PINDATA6   (*(REG8  (0xFC0E80AE)))
#define PIMC_PINDATA7   (*(REG8  (0xFC0E80AF)))
#define PIMC_PINDATA8   (*(REG8  (0xFC0E80B0)))
#define PIMC_PINDATA9   (*(REG8  (0xFC0E80B1)))
#define PIMC_PINDATAA   (*(REG8  (0xFC0E80B2)))
#define PIMC_PINDATAB   (*(REG8  (0xFC0E80B3)))
#define PIMC_PINDATAC   (*(REG8  (0xFC0E80B4)))
#define PIMC_PINDATAD   (*(REG8  (0xFC0E80B5)))
#define PIMC_PINDATAE   (*(REG8  (0xFC0E80B6)))
#define PIMC_PINDATAF   (*(REG8  (0xFC0E80B7)))

#define PIMD_CONFIG0    (*(REG16 (0xFC0E80C0)))
#define PIMD_CONFIG1    (*(REG16 (0xFC0E80C2)))
#define PIMD_CONFIG2    (*(REG16 (0xFC0E80C4)))
#define PIMD_CONFIG3    (*(REG16 (0xFC0E80C6)))
#define PIMD_CONFIG4    (*(REG16 (0xFC0E80C8)))
#define PIMD_CONFIG5    (*(REG16 (0xFC0E80CA)))
#define PIMD_CONFIG6    (*(REG16 (0xFC0E80CC)))
#define PIMD_CONFIG7    (*(REG16 (0xFC0E80CE)))
#define PIMD_CONFIG8    (*(REG16 (0xFC0E80D0)))
#define PIMD_CONFIG9    (*(REG16 (0xFC0E80D2)))
#define PIMD_CONFIGA    (*(REG16 (0xFC0E80D4)))
#define PIMD_CONFIGB    (*(REG16 (0xFC0E80D6)))
#define PIMD_CONFIGC    (*(REG16 (0xFC0E80D8)))
#define PIMD_CONFIGD    (*(REG16 (0xFC0E80DA)))
#define PIMD_CONFIGE    (*(REG16 (0xFC0E80DC)))
#define PIMD_CONFIGF    (*(REG16 (0xFC0E80DE)))
#define PIMD_PORTIFR    (*(REG16 (0xFC0E80E0)))
#define PIMD_PORTDATA   (*(REG16 (0xFC0E80E4)))
#define PIMD_PORTIR     (*(REG16 (0xFC0E80E6)))
#define PIMD_PINDATA0   (*(REG8  (0xFC0E80E8)))
#define PIMD_PINDATA1   (*(REG8  (0xFC0E80E9)))
#define PIMD_PINDATA2   (*(REG8  (0xFC0E80EA)))
#define PIMD_PINDATA3   (*(REG8  (0xFC0E80EB)))
#define PIMD_PINDATA4   (*(REG8  (0xFC0E80EC)))
#define PIMD_PINDATA5   (*(REG8  (0xFC0E80ED)))
#define PIMD_PINDATA6   (*(REG8  (0xFC0E80EE)))
#define PIMD_PINDATA7   (*(REG8  (0xFC0E80EF)))
#define PIMD_PINDATA8   (*(REG8  (0xFC0E80F0)))
#define PIMD_PINDATA9   (*(REG8  (0xFC0E80F1)))
#define PIMD_PINDATAA   (*(REG8  (0xFC0E80F2)))
#define PIMD_PINDATAB   (*(REG8  (0xFC0E80F3)))
#define PIMD_PINDATAC   (*(REG8  (0xFC0E80F4)))
#define PIMD_PINDATAD   (*(REG8  (0xFC0E80F5)))
#define PIMD_PINDATAE   (*(REG8  (0xFC0E80F6)))
#define PIMD_PINDATAF   (*(REG8  (0xFC0E80F7)))

#define PIME_CONFIG0    (*(REG16 (0xFC0E8110)))
#define PIME_CONFIG1    (*(REG16 (0xFC0E8112)))
#define PIME_CONFIG2    (*(REG16 (0xFC0E8114)))
#define PIME_CONFIG3    (*(REG16 (0xFC0E8116)))
#define PIME_CONFIG4    (*(REG16 (0xFC0E8118)))
#define PIME_CONFIG5    (*(REG16 (0xFC0E811A)))
#define PIME_CONFIG6    (*(REG16 (0xFC0E811C)))
#define PIME_CONFIG7    (*(REG16 (0xFC0E811E)))
#define PIME_CONFIG8    (*(REG16 (0xFC0E8120)))
#define PIME_CONFIG9    (*(REG16 (0xFC0E8122)))
#define PIME_CONFIGA    (*(REG16 (0xFC0E8124)))
#define PIME_CONFIGB    (*(REG16 (0xFC0E8126)))
#define PIME_CONFIGC    (*(REG16 (0xFC0E8128)))
#define PIME_CONFIGD    (*(REG16 (0xFC0E812A)))
#define PIME_CONFIGE    (*(REG16 (0xFC0E812C)))
#define PIME_CONFIGF    (*(REG16 (0xFC0E812E)))
#define PIME_PORTIFR    (*(REG16 (0xFC0E8130)))
#define PIME_PORTDATA   (*(REG16 (0xFC0E8134)))
#define PIME_PORTIR     (*(REG16 (0xFC0E8136)))
#define PIME_PINDATA0   (*(REG8  (0xFC0E8138)))
#define PIME_PINDATA1   (*(REG8  (0xFC0E8139)))
#define PIME_PINDATA2   (*(REG8  (0xFC0E813A)))
#define PIME_PINDATA3   (*(REG8  (0xFC0E813B)))
#define PIME_PINDATA4   (*(REG8  (0xFC0E813C)))
#define PIME_PINDATA5   (*(REG8  (0xFC0E813D)))
#define PIME_PINDATA6   (*(REG8  (0xFC0E813E)))
#define PIME_PINDATA7   (*(REG8  (0xFC0E813F)))
#define PIME_PINDATA8   (*(REG8  (0xFC0E8140)))
#define PIME_PINDATA9   (*(REG8  (0xFC0E8141)))
#define PIME_PINDATAA   (*(REG8  (0xFC0E8142)))
#define PIME_PINDATAB   (*(REG8  (0xFC0E8143)))
#define PIME_PINDATAC   (*(REG8  (0xFC0E8144)))
#define PIME_PINDATAD   (*(REG8  (0xFC0E8145)))
#define PIME_PINDATAE   (*(REG8  (0xFC0E8146)))
#define PIME_PINDATAF   (*(REG8  (0xFC0E8147)))

#define PIMF_CONFIG0    (*(REG16 (0xFC0E8150)))
#define PIMF_CONFIG1    (*(REG16 (0xFC0E8152)))
#define PIMF_CONFIG2    (*(REG16 (0xFC0E8154)))
#define PIMF_CONFIG3    (*(REG16 (0xFC0E8156)))
#define PIMF_CONFIG4    (*(REG16 (0xFC0E8158)))
#define PIMF_CONFIG5    (*(REG16 (0xFC0E815A)))
#define PIMF_CONFIG6    (*(REG16 (0xFC0E815C)))
#define PIMF_CONFIG7    (*(REG16 (0xFC0E815E)))
#define PIMF_CONFIG8    (*(REG16 (0xFC0E8160)))
#define PIMF_CONFIG9    (*(REG16 (0xFC0E8162)))
#define PIMF_CONFIGA    (*(REG16 (0xFC0E8164)))
#define PIMF_CONFIGB    (*(REG16 (0xFC0E8166)))
#define PIMF_CONFIGC    (*(REG16 (0xFC0E8168)))
#define PIMF_CONFIGD    (*(REG16 (0xFC0E816A)))
#define PIMF_CONFIGE    (*(REG16 (0xFC0E816C)))
#define PIMF_CONFIGF    (*(REG16 (0xFC0E816E)))
#define PIMF_PORTIFR    (*(REG16 (0xFC0E8170)))
#define PIMF_PORTDATA   (*(REG16 (0xFC0E8174)))
#define PIMF_PORTIR     (*(REG16 (0xFC0E8176)))
#define PIMF_PINDATA0   (*(REG8  (0xFC0E8178)))
#define PIMF_PINDATA1   (*(REG8  (0xFC0E8179)))
#define PIMF_PINDATA2   (*(REG8  (0xFC0E817A)))
#define PIMF_PINDATA3   (*(REG8  (0xFC0E817B)))
#define PIMF_PINDATA4   (*(REG8  (0xFC0E817C)))
#define PIMF_PINDATA5   (*(REG8  (0xFC0E818D)))
#define PIMF_PINDATA6   (*(REG8  (0xFC0E818E)))
#define PIMF_PINDATA7   (*(REG8  (0xFC0E818F)))
#define PIMF_PINDATA8   (*(REG8  (0xFC0E8180)))
#define PIMF_PINDATA9   (*(REG8  (0xFC0E8181)))
#define PIMF_PINDATAA   (*(REG8  (0xFC0E8182)))
#define PIMF_PINDATAB   (*(REG8  (0xFC0E8183)))
#define PIMF_PINDATAC   (*(REG8  (0xFC0E8184)))
#define PIMF_PINDATAD   (*(REG8  (0xFC0E8185)))
#define PIMF_PINDATAE   (*(REG8  (0xFC0E8186)))
#define PIMF_PINDATAF   (*(REG8  (0xFC0E8187)))

#define PIMG_CONFIG0    (*(REG16 (0xFC0E8190)))
#define PIMG_CONFIG1    (*(REG16 (0xFC0E8192)))
#define PIMG_CONFIG2    (*(REG16 (0xFC0E8194)))
#define PIMG_CONFIG3    (*(REG16 (0xFC0E8196)))
#define PIMG_CONFIG4    (*(REG16 (0xFC0E8198)))
#define PIMG_CONFIG5    (*(REG16 (0xFC0E819A)))
#define PIMG_CONFIG6    (*(REG16 (0xFC0E819C)))
#define PIMG_CONFIG7    (*(REG16 (0xFC0E819E)))
#define PIMG_CONFIG8    (*(REG16 (0xFC0E81A0)))
#define PIMG_CONFIG9    (*(REG16 (0xFC0E81A2)))
#define PIMG_CONFIGA    (*(REG16 (0xFC0E81A4)))
#define PIMG_CONFIGB    (*(REG16 (0xFC0E81A6)))
#define PIMG_CONFIGC    (*(REG16 (0xFC0E81A8)))
#define PIMG_CONFIGD    (*(REG16 (0xFC0E81AA)))
#define PIMG_CONFIGE    (*(REG16 (0xFC0E81AC)))
#define PIMG_CONFIGF    (*(REG16 (0xFC0E81AE)))
#define PIMG_PORTIFR    (*(REG16 (0xFC0E81B0)))
#define PIMG_PORTDATA   (*(REG16 (0xFC0E81B4)))
#define PIMG_PORTIR     (*(REG16 (0xFC0E81B6)))
#define PIMG_PINDATA0   (*(REG8  (0xFC0E81B8)))
#define PIMG_PINDATA1   (*(REG8  (0xFC0E81B9)))
#define PIMG_PINDATA2   (*(REG8  (0xFC0E81BA)))
#define PIMG_PINDATA3   (*(REG8  (0xFC0E81BB)))
#define PIMG_PINDATA4   (*(REG8  (0xFC0E81BC)))
#define PIMG_PINDATA5   (*(REG8  (0xFC0E81BD)))
#define PIMG_PINDATA6   (*(REG8  (0xFC0E81BE)))
#define PIMG_PINDATA7   (*(REG8  (0xFC0E81BF)))
#define PIMG_PINDATA8   (*(REG8  (0xFC0E81C0)))
#define PIMG_PINDATA9   (*(REG8  (0xFC0E81C1)))
#define PIMG_PINDATAA   (*(REG8  (0xFC0E81C2)))
#define PIMG_PINDATAB   (*(REG8  (0xFC0E81C3)))
#define PIMG_PINDATAC   (*(REG8  (0xFC0E81C4)))
#define PIMG_PINDATAD   (*(REG8  (0xFC0E81C5)))
#define PIMG_PINDATAE   (*(REG8  (0xFC0E81C6)))
#define PIMG_PINDATAF   (*(REG8  (0xFC0E81C7)))

#define PIMH_CONFIG0    (*(REG16 (0xFC0E81D0)))
#define PIMH_CONFIG1    (*(REG16 (0xFC0E81D2)))
#define PIMH_CONFIG2    (*(REG16 (0xFC0E81D4)))
#define PIMH_CONFIG3    (*(REG16 (0xFC0E81D6)))
#define PIMH_CONFIG4    (*(REG16 (0xFC0E81D8)))
#define PIMH_CONFIG5    (*(REG16 (0xFC0E81DA)))
#define PIMH_CONFIG6    (*(REG16 (0xFC0E81DC)))
#define PIMH_CONFIG7    (*(REG16 (0xFC0E81DE)))
#define PIMH_CONFIG8    (*(REG16 (0xFC0E81E0)))
#define PIMH_CONFIG9    (*(REG16 (0xFC0E81E2)))
#define PIMH_CONFIGA    (*(REG16 (0xFC0E81E4)))
#define PIMH_CONFIGB    (*(REG16 (0xFC0E81E6)))
#define PIMH_CONFIGC    (*(REG16 (0xFC0E81E8)))
#define PIMH_CONFIGD    (*(REG16 (0xFC0E81EA)))
#define PIMH_CONFIGE    (*(REG16 (0xFC0E81EC)))
#define PIMH_CONFIGF    (*(REG16 (0xFC0E81EE)))
#define PIMH_PORTIFR    (*(REG16 (0xFC0E81F0)))
#define PIMH_PORTDATA   (*(REG16 (0xFC0E81F4)))
#define PIMH_PORTIR     (*(REG16 (0xFC0E81F6)))
#define PIMH_PINDATA0   (*(REG8  (0xFC0E81F8)))
#define PIMH_PINDATA1   (*(REG8  (0xFC0E81F9)))
#define PIMH_PINDATA2   (*(REG8  (0xFC0E81FA)))
#define PIMH_PINDATA3   (*(REG8  (0xFC0E81FB)))
#define PIMH_PINDATA4   (*(REG8  (0xFC0E81FC)))
#define PIMH_PINDATA5   (*(REG8  (0xFC0E81FD)))
#define PIMH_PINDATA6   (*(REG8  (0xFC0E81FE)))
#define PIMH_PINDATA7   (*(REG8  (0xFC0E81FF)))
#define PIMH_PINDATA8   (*(REG8  (0xFC0E8200)))
#define PIMH_PINDATA9   (*(REG8  (0xFC0E8201)))
#define PIMH_PINDATAA   (*(REG8  (0xFC0E8202)))
#define PIMH_PINDATAB   (*(REG8  (0xFC0E8203)))
#define PIMH_PINDATAC   (*(REG8  (0xFC0E8204)))
#define PIMH_PINDATAD   (*(REG8  (0xFC0E8205)))
#define PIMH_PINDATAE   (*(REG8  (0xFC0E8206)))
#define PIMH_PINDATAF   (*(REG8  (0xFC0E8207)))


#define CFM_MCR         (*(REG16 (0xFC0FC000)))
#define CFM_CLKD        (*(REG8  (0xFC0FC002)))
#define CFM_SEC         (*(REG32 (0xFC0FC008)))
#define CFM_PROT        (*(REG32 (0xFC0FC010)))
#define CFM_SACC        (*(REG32 (0xFC0FC014)))
#define CFM_DACC        (*(REG32 (0xFC0FC018)))
#define CFM_USTAT       (*(REG8  (0xFC0FC020)))
#define CFM_CMD         (*(REG8  (0xFC0FC024)))
#define CFM_DFPROT      (*(REG8  (0xFC0FC044)))
#define CFM_DFSACC      (*(REG8  (0xFC0FC045)))
#define CFM_DFDACC      (*(REG8  (0xFC0FC046)))

#endif /* mac71xx_h */
