#ifndef at91rm9200_h
#define at91rm9200_h
/*******************************************************************************
at91rm9200.h - Register defs for Atmel AT91RM9200

           
THE SOFTWARE IS DELIVERED "AS IS" WITHOUT WARRANTY OR CONDITION OF ANY KIND, 
EITHER EXPRESS, IMPLIED OR STATUTORY. THIS INCLUDES WITHOUT LIMITATION ANY 
WARRANTY OR CONDITION WITH RESPECT TO MERCHANTABILITY OR FITNESS FOR ANY 
PARTICULAR PURPOSE, OR AGAINST THE INFRINGEMENTS OF INTELLECTUAL PROPERTY RIGHTS 
OF OTHERS.
           
This file may be freely used for commercial and non-commercial applications, 
including being redistributed with any tools.

If you find a problem with the file, please report it so that it can be fixed.

Created by Sten Larsson (sten_larsson at yahoo com)
*******************************************************************************/

#define REG8  (volatile unsigned char*)
#define REG16 (volatile unsigned short*)
#define REG32 (volatile unsigned int*)


/*##############################################################################
## Memory Controller 
##############################################################################*/
#define MC_RCR                (*(REG32 (0xFFFFFF00)))
#define MC_ASR                (*(REG32 (0xFFFFFF04)))
#define MC_AASR               (*(REG32 (0xFFFFFF08)))
#define MC_MPR                (*(REG32 (0xFFFFFF0C)))

/*##############################################################################
## External Bus Interface 
##############################################################################*/
#define EBI_CSA               (*(REG32 (0xFFFFFF60)))
#define EBI_CFGR              (*(REG32 (0xFFFFFF64)))

/*##############################################################################
## Static Memory Controller 
##############################################################################*/
#define SMC_CSR0              (*(REG32 (0xFFFFFF70)))
#define SMC_CSR1              (*(REG32 (0xFFFFFF74)))
#define SMC_CSR2              (*(REG32 (0xFFFFFF78)))
#define SMC_CSR3              (*(REG32 (0xFFFFFF7C)))
#define SMC_CSR4              (*(REG32 (0xFFFFFF80)))
#define SMC_CSR5              (*(REG32 (0xFFFFFF84)))
#define SMC_CSR6              (*(REG32 (0xFFFFFF88)))
#define SMC_CSR7              (*(REG32 (0xFFFFFF8C)))

/*##############################################################################
## SDRAM Controller 
##############################################################################*/
#define SDRAMC_MR             (*(REG32 (0xFFFFFF90)))
#define SDRAMC_TR             (*(REG32 (0xFFFFFF94)))
#define SDRAMC_CR             (*(REG32 (0xFFFFFF98)))
#define SDRAMC_SRR            (*(REG32 (0xFFFFFF9C)))
#define SDRAMC_LPR            (*(REG32 (0xFFFFFFA0)))
#define SDRAMC_IER            (*(REG32 (0xFFFFFFA4)))
#define SDRAMC_IDR            (*(REG32 (0xFFFFFFA8)))
#define SDRAMC_IMR            (*(REG32 (0xFFFFFFAC)))
#define SDRAMC_ISR            (*(REG32 (0xFFFFFFB0)))

/*##############################################################################
## Burst Flash Controller 
##############################################################################*/
#define BFC_MR                (*(REG32 (0xFFFFFFC0)))

/*##############################################################################
## Advanced Interrupt Controller 
##############################################################################*/
#define AIC_SMR0              (*(REG32 (0xFFFFF000)))
#define AIC_SMR1              (*(REG32 (0xFFFFF004)))
#define AIC_SMR31             (*(REG32 (0xFFFFF07C)))
#define AIC_SVR0              (*(REG32 (0xFFFFF080)))
#define AIC_SVR1              (*(REG32 (0xFFFFF084)))
#define AIC_SVR31             (*(REG32 (0xFFFFF0FC)))
#define AIC_IVR               (*(REG32 (0xFFFFF100)))
#define AIC_FVR               (*(REG32 (0xFFFFF104)))
#define AIC_ISR               (*(REG32 (0xFFFFF108)))
#define AIC_IPR               (*(REG32 (0xFFFFF10C)))
#define AIC_IMR               (*(REG32 (0xFFFFF110)))
#define AIC_CISR              (*(REG32 (0xFFFFF114)))
#define AIC_IECR              (*(REG32 (0xFFFFF120)))
#define AIC_IDCR              (*(REG32 (0xFFFFF124)))
#define AIC_ICCR              (*(REG32 (0xFFFFF128)))
#define AIC_ISCR              (*(REG32 (0xFFFFF12C)))
#define AIC_EOICR             (*(REG32 (0xFFFFF130)))
#define AIC_SPU               (*(REG32 (0xFFFFF134)))
#define AIC_DCR               (*(REG32 (0xFFFFF138)))
#define AIC_FFER              (*(REG32 (0xFFFFF140)))
#define AIC_FFDR              (*(REG32 (0xFFFFF144)))
#define AIC_FFSR              (*(REG32 (0xFFFFF148)))

/*##############################################################################
## Power Management Controller 
##############################################################################*/
#define PMC_SCER              (*(REG32 (0xFFFFFC00)))
#define PMC_SCDR              (*(REG32 (0xFFFFFC04)))
#define PMC_SCSR              (*(REG32 (0xFFFFFC08)))
#define PMC_PCER              (*(REG32 (0xFFFFFC10)))
#define PMC_PCDR              (*(REG32 (0xFFFFFC14)))
#define PMC_PCSR              (*(REG32 (0xFFFFFC18)))
#define PMC_MOR               (*(REG32 (0xFFFFFC20)))
#define PMC_MCFR              (*(REG32 (0xFFFFFC24)))
#define PMC_PLLAR             (*(REG32 (0xFFFFFC28)))
#define PMC_PLLBR             (*(REG32 (0xFFFFFC2C)))
#define PMC_MCKR              (*(REG32 (0xFFFFFC30)))
#define PMC_PCK0              (*(REG32 (0xFFFFFC40)))
#define PMC_PCK1              (*(REG32 (0xFFFFFC44)))
#define PMC_PCK2              (*(REG32 (0xFFFFFC48)))
#define PMC_PCK3              (*(REG32 (0xFFFFFC4C)))
#define PMC_PCK4              (*(REG32 (0xFFFFFC50)))
#define PMC_PCK5              (*(REG32 (0xFFFFFC54)))
#define PMC_PCK6              (*(REG32 (0xFFFFFC58)))
#define PMC_PCK7              (*(REG32 (0xFFFFFC5C)))
#define PMC_IER               (*(REG32 (0xFFFFFC60)))
#define PMC_IDR               (*(REG32 (0xFFFFFC64)))
#define PMC_SR                (*(REG32 (0xFFFFFC68)))
#define PMC_IMR               (*(REG32 (0xFFFFFC6C)))

/*##############################################################################
## System Timer 
##############################################################################*/
#define ST_CR                 (*(REG32 (0xFFFFFD00)))
#define ST_PIMR               (*(REG32 (0xFFFFFD04)))
#define ST_WDMR               (*(REG32 (0xFFFFFD08)))
#define ST_RTMR               (*(REG32 (0xFFFFFD0C)))
#define ST_SR                 (*(REG32 (0xFFFFFD10)))
#define SR_IER                (*(REG32 (0xFFFFFD14)))
#define SR_IDR                (*(REG32 (0xFFFFFD18)))
#define SR_IMR                (*(REG32 (0xFFFFFD1C)))
#define SR_RTAR               (*(REG32 (0xFFFFFD20)))
#define SR_CRTR               (*(REG32 (0xFFFFFD24)))

/*##############################################################################
## Real Time Controller 
##############################################################################*/
#define RTC_CR                (*(REG32 (0xFFFFFE00)))
#define RTC_MR                (*(REG32 (0xFFFFFE04)))
#define RTC_TIMR              (*(REG32 (0xFFFFFE08)))
#define RTC_CALR              (*(REG32 (0xFFFFFE0C)))
#define RTC_TIMALR            (*(REG32 (0xFFFFFE10)))
#define RTC_CALALR            (*(REG32 (0xFFFFFE14)))
#define RTC_SR                (*(REG32 (0xFFFFFE18)))
#define RTC_SCCR              (*(REG32 (0xFFFFFE1C)))
#define RTC_IER               (*(REG32 (0xFFFFFE20)))
#define RTC_IDR               (*(REG32 (0xFFFFFE24)))
#define RTC_IMR               (*(REG32 (0xFFFFFE28)))
#define RTC_VER               (*(REG32 (0xFFFFFE2C)))

/*##############################################################################
## Debug Unit 
##############################################################################*/
#define DBGU_CR               (*(REG32 (0xFFFFF200)))
#define DBGU_MR               (*(REG32 (0xFFFFF204)))
#define DBGU_IER              (*(REG32 (0xFFFFF208)))
#define DBGU_IDR              (*(REG32 (0xFFFFF20C)))
#define DBGU_IMR              (*(REG32 (0xFFFFF210)))
#define DBGU_SR               (*(REG32 (0xFFFFF214)))
#define DBGU_RHR              (*(REG32 (0xFFFFF218)))
#define DBGU_THR              (*(REG32 (0xFFFFF21C)))
#define DBGU_BRGR             (*(REG32 (0xFFFFF220)))
#define DBGU_CIDR             (*(REG32 (0xFFFFF240)))
#define DBGU_EXID             (*(REG32 (0xFFFFF244)))
#define DBGU_FNR              (*(REG32 (0xFFFFF248)))
#define DBGU_RPR              (*(REG32 (0xFFFFF300)))
#define DBGU_RCR              (*(REG32 (0xFFFFF304)))
#define DBGU_TPR              (*(REG32 (0xFFFFF308)))
#define DBGU_TCR              (*(REG32 (0xFFFFF30C)))
#define DBGU_RNP              (*(REG32 (0xFFFFF310)))
#define DBGU_RNC              (*(REG32 (0xFFFFF314)))
#define DBGU_TNP              (*(REG32 (0xFFFFF318)))
#define DBGU_TNC              (*(REG32 (0xFFFFF31C)))
#define DBGU_PTC              (*(REG32 (0xFFFFF320)))
#define DBGU_PTS              (*(REG32 (0xFFFFF324)))

/*##############################################################################
## Parallel Input/Output Controller A 
##############################################################################*/
#define PIOA_PER              (*(REG32 (0xFFFFF400)))
#define PIOA_PDR              (*(REG32 (0xFFFFF404)))
#define PIOA_PSR              (*(REG32 (0xFFFFF408)))
#define PIOA_OER              (*(REG32 (0xFFFFF410)))
#define PIOA_ODR              (*(REG32 (0xFFFFF414)))
#define PIOA_OSR              (*(REG32 (0xFFFFF418)))
#define PIOA_IFER             (*(REG32 (0xFFFFF420)))
#define PIOA_IFDR             (*(REG32 (0xFFFFF424)))
#define PIOA_IFSR             (*(REG32 (0xFFFFF428)))
#define PIOA_SODR             (*(REG32 (0xFFFFF430)))
#define PIOA_CODR             (*(REG32 (0xFFFFF434)))
#define PIOA_ODSR             (*(REG32 (0xFFFFF438)))
#define PIOA_PDSR             (*(REG32 (0xFFFFF43C)))
#define PIOA_IER              (*(REG32 (0xFFFFF440)))
#define PIOA_IDR              (*(REG32 (0xFFFFF444)))
#define PIOA_IMR              (*(REG32 (0xFFFFF448)))
#define PIOA_ISR              (*(REG32 (0xFFFFF44C)))
#define PIOA_MDER             (*(REG32 (0xFFFFF450)))
#define PIOA_MDDR             (*(REG32 (0xFFFFF454)))
#define PIOA_MDSR             (*(REG32 (0xFFFFF458)))
#define PIOA_PUDR             (*(REG32 (0xFFFFF460)))
#define PIOA_PUER             (*(REG32 (0xFFFFF464)))
#define PIOA_PUSR             (*(REG32 (0xFFFFF468)))
#define PIOA_ASR              (*(REG32 (0xFFFFF470)))
#define PIOA_BSR              (*(REG32 (0xFFFFF474)))
#define PIOA_ABSR             (*(REG32 (0xFFFFF478)))
#define PIOA_OWER             (*(REG32 (0xFFFFF4A0)))
#define PIOA_OWDR             (*(REG32 (0xFFFFF4A4)))
#define PIOA_OWSR             (*(REG32 (0xFFFFF4A8)))

/*##############################################################################
## Parallel Input/Output Controller B 
##############################################################################*/
#define PIOB_PER              (*(REG32 (0xFFFFF600)))
#define PIOB_PDR              (*(REG32 (0xFFFFF604)))
#define PIOB_PSR              (*(REG32 (0xFFFFF608)))
#define PIOB_OER              (*(REG32 (0xFFFFF610)))
#define PIOB_ODR              (*(REG32 (0xFFFFF614)))
#define PIOB_OSR              (*(REG32 (0xFFFFF618)))
#define PIOB_IFER             (*(REG32 (0xFFFFF620)))
#define PIOB_IFDR             (*(REG32 (0xFFFFF624)))
#define PIOB_IFSR             (*(REG32 (0xFFFFF628)))
#define PIOB_SODR             (*(REG32 (0xFFFFF630)))
#define PIOB_CODR             (*(REG32 (0xFFFFF634)))
#define PIOB_ODSR             (*(REG32 (0xFFFFF638)))
#define PIOB_PDSR             (*(REG32 (0xFFFFF63C)))
#define PIOB_IER              (*(REG32 (0xFFFFF640)))
#define PIOB_IDR              (*(REG32 (0xFFFFF644)))
#define PIOB_IMR              (*(REG32 (0xFFFFF648)))
#define PIOB_ISR              (*(REG32 (0xFFFFF64C)))
#define PIOB_MDER             (*(REG32 (0xFFFFF650)))
#define PIOB_MDDR             (*(REG32 (0xFFFFF654)))
#define PIOB_MDSR             (*(REG32 (0xFFFFF658)))
#define PIOB_PUDR             (*(REG32 (0xFFFFF660)))
#define PIOB_PUER             (*(REG32 (0xFFFFF664)))
#define PIOB_PUSR             (*(REG32 (0xFFFFF668)))
#define PIOB_ASR              (*(REG32 (0xFFFFF670)))
#define PIOB_BSR              (*(REG32 (0xFFFFF674)))
#define PIOB_ABSR             (*(REG32 (0xFFFFF678)))
#define PIOB_OWER             (*(REG32 (0xFFFFF6A0)))
#define PIOB_OWDR             (*(REG32 (0xFFFFF6A4)))
#define PIOB_OWSR             (*(REG32 (0xFFFFF6A8)))

/*##############################################################################
## Parallel Input/Output Controller C 
##############################################################################*/
#define PIOC_PER              (*(REG32 (0xFFFFF800)))
#define PIOC_PDR              (*(REG32 (0xFFFFF804)))
#define PIOC_PSR              (*(REG32 (0xFFFFF808)))
#define PIOC_OER              (*(REG32 (0xFFFFF810)))
#define PIOC_ODR              (*(REG32 (0xFFFFF814)))
#define PIOC_OSR              (*(REG32 (0xFFFFF818)))
#define PIOC_IFER             (*(REG32 (0xFFFFF820)))
#define PIOC_IFDR             (*(REG32 (0xFFFFF824)))
#define PIOC_IFSR             (*(REG32 (0xFFFFF828)))
#define PIOC_SODR             (*(REG32 (0xFFFFF830)))
#define PIOC_CODR             (*(REG32 (0xFFFFF834)))
#define PIOC_ODSR             (*(REG32 (0xFFFFF838)))
#define PIOC_PDSR             (*(REG32 (0xFFFFF83C)))
#define PIOC_IER              (*(REG32 (0xFFFFF840)))
#define PIOC_IDR              (*(REG32 (0xFFFFF844)))
#define PIOC_IMR              (*(REG32 (0xFFFFF848)))
#define PIOC_ISR              (*(REG32 (0xFFFFF84C)))
#define PIOC_MDER             (*(REG32 (0xFFFFF850)))
#define PIOC_MDDR             (*(REG32 (0xFFFFF854)))
#define PIOC_MDSR             (*(REG32 (0xFFFFF858)))
#define PIOC_PUDR             (*(REG32 (0xFFFFF860)))
#define PIOC_PUER             (*(REG32 (0xFFFFF864)))
#define PIOC_PUSR             (*(REG32 (0xFFFFF868)))
#define PIOC_ASR              (*(REG32 (0xFFFFF870)))
#define PIOC_BSR              (*(REG32 (0xFFFFF874)))
#define PIOC_ABSR             (*(REG32 (0xFFFFF878)))
#define PIOC_OWER             (*(REG32 (0xFFFFF8A0)))
#define PIOC_OWDR             (*(REG32 (0xFFFFF8A4)))
#define PIOC_OWSR             (*(REG32 (0xFFFFF8A8)))

/*##############################################################################
## Parallel Input/Output Controller D 
##############################################################################*/
#define PIOD_PER              (*(REG32 (0xFFFFFA00)))
#define PIOD_PDR              (*(REG32 (0xFFFFFA04)))
#define PIOD_PSR              (*(REG32 (0xFFFFFA08)))
#define PIOD_OER              (*(REG32 (0xFFFFFA10)))
#define PIOD_ODR              (*(REG32 (0xFFFFFA14)))
#define PIOD_OSR              (*(REG32 (0xFFFFFA18)))
#define PIOD_IFER             (*(REG32 (0xFFFFFA20)))
#define PIOD_IFDR             (*(REG32 (0xFFFFFA24)))
#define PIOD_IFSR             (*(REG32 (0xFFFFFA28)))
#define PIOD_SODR             (*(REG32 (0xFFFFFA30)))
#define PIOD_CODR             (*(REG32 (0xFFFFFA34)))
#define PIOD_ODSR             (*(REG32 (0xFFFFFA38)))
#define PIOD_PDSR             (*(REG32 (0xFFFFFA3C)))
#define PIOD_IER              (*(REG32 (0xFFFFFA40)))
#define PIOD_IDR              (*(REG32 (0xFFFFFA44)))
#define PIOD_IMR              (*(REG32 (0xFFFFFA48)))
#define PIOD_ISR              (*(REG32 (0xFFFFFA4C)))
#define PIOD_MDER             (*(REG32 (0xFFFFFA50)))
#define PIOD_MDDR             (*(REG32 (0xFFFFFA54)))
#define PIOD_MDSR             (*(REG32 (0xFFFFFA58)))
#define PIOD_PUDR             (*(REG32 (0xFFFFFA60)))
#define PIOD_PUER             (*(REG32 (0xFFFFFA64)))
#define PIOD_PUSR             (*(REG32 (0xFFFFFA68)))
#define PIOD_ASR              (*(REG32 (0xFFFFFA70)))
#define PIOD_BSR              (*(REG32 (0xFFFFFA74)))
#define PIOD_ABSR             (*(REG32 (0xFFFFFA78)))
#define PIOD_OWER             (*(REG32 (0xFFFFFAA0)))
#define PIOD_OWDR             (*(REG32 (0xFFFFFAA4)))
#define PIOD_OWSR             (*(REG32 (0xFFFFFAA8)))

/*##############################################################################
## Serial Peripheral Interface 
##############################################################################*/
#define SPI_CR                (*(REG32 (0xFFFE0000)))
#define SPI_MR                (*(REG32 (0xFFFE0004)))
#define SPI_RDR               (*(REG32 (0xFFFE0008)))
#define SPI_TDR               (*(REG32 (0xFFFE000C)))
#define SPI_SR                (*(REG32 (0xFFFE0010)))
#define SPI_IER               (*(REG32 (0xFFFE0014)))
#define SPI_IDR               (*(REG32 (0xFFFE0018)))
#define SPI_IMR               (*(REG32 (0xFFFE001C)))
#define SPI_CSR0              (*(REG32 (0xFFFE0030)))
#define SPI_CSR1              (*(REG32 (0xFFFE0034)))
#define SPI_CSR2              (*(REG32 (0xFFFE0038)))
#define SPI_CSR3              (*(REG32 (0xFFFE003C)))
#define SPI_RPR               (*(REG32 (0xFFFE0100)))
#define SPI_RCR               (*(REG32 (0xFFFE0104)))
#define SPI_TPR               (*(REG32 (0xFFFE0108)))
#define SPI_TCR               (*(REG32 (0xFFFE010C)))
#define SPI_RNP               (*(REG32 (0xFFFE0110)))
#define SPI_RNC               (*(REG32 (0xFFFE0114)))
#define SPI_TNP               (*(REG32 (0xFFFE0118)))
#define SPI_TNC               (*(REG32 (0xFFFE011C)))
#define SPI_PTC               (*(REG32 (0xFFFE0120)))
#define SPI_PTS               (*(REG32 (0xFFFE0124)))

/*##############################################################################
## Two-wire Interface 
##############################################################################*/
#define TWI_CR                (*(REG32 (0xFFFB8000)))
#define TWI_MMR               (*(REG32 (0xFFFB8004)))
#define TWI_IADR              (*(REG32 (0xFFFB800C)))
#define TWI_CWGR              (*(REG32 (0xFFFB8010)))
#define TWI_SR                (*(REG32 (0xFFFB8020)))
#define TWI_IER               (*(REG32 (0xFFFB8024)))
#define TWI_IDR               (*(REG32 (0xFFFB8028)))
#define TWI_IMR               (*(REG32 (0xFFFB802C)))
#define TWI_RHR               (*(REG32 (0xFFFB8030)))
#define TWI_THR               (*(REG32 (0xFFFB8034)))

/*##############################################################################
## Universal Sync/Async Rec/Trans 0 
##############################################################################*/
#define US0_CR                (*(REG32 (0xFFFC0000)))
#define US0_MR                (*(REG32 (0xFFFC0004)))
#define US0_IER               (*(REG32 (0xFFFC0008)))
#define US0_IDR               (*(REG32 (0xFFFC000C)))
#define US0_IMR               (*(REG32 (0xFFFC0010)))
#define US0_CSR               (*(REG32 (0xFFFC0014)))
#define US0_RHR               (*(REG32 (0xFFFC0018)))
#define US0_THR               (*(REG32 (0xFFFC001C)))
#define US0_BRGR              (*(REG32 (0xFFFC0020)))
#define US0_RTOR              (*(REG32 (0xFFFC0024)))
#define US0_TTGR              (*(REG32 (0xFFFC0028)))
#define US0_FIDI              (*(REG32 (0xFFFC0040)))
#define US0_NER               (*(REG32 (0xFFFC0044)))
#define US0_IF                (*(REG32 (0xFFFC004C)))
#define US0_RPR               (*(REG32 (0xFFFC0100)))
#define US0_RCR               (*(REG32 (0xFFFC0104)))
#define US0_TPR               (*(REG32 (0xFFFC0108)))
#define US0_TCR               (*(REG32 (0xFFFC010C)))
#define US0_RNP               (*(REG32 (0xFFFC0110)))
#define US0_RNC               (*(REG32 (0xFFFC0114)))
#define US0_TNP               (*(REG32 (0xFFFC0118)))
#define US0_TNC               (*(REG32 (0xFFFC011C)))
#define US0_PTC               (*(REG32 (0xFFFC0120)))
#define US0_PTS               (*(REG32 (0xFFFC0124)))

/*##############################################################################
## Universal Sync/Async Rec/Trans 1 
##############################################################################*/
#define US1_CR1               (*(REG32 (0xFFFC4000)))
#define US1_MR1               (*(REG32 (0xFFFC4004)))
#define US1_IER1              (*(REG32 (0xFFFC4008)))
#define US1_IDR1              (*(REG32 (0xFFFC400C)))
#define US1_IMR1              (*(REG32 (0xFFFC4010)))
#define US1_CSR1              (*(REG32 (0xFFFC4014)))
#define US1_RHR1              (*(REG32 (0xFFFC4018)))
#define US1_THR1              (*(REG32 (0xFFFC401C)))
#define US1_BRGR1             (*(REG32 (0xFFFC4020)))
#define US1_RTOR1             (*(REG32 (0xFFFC4024)))
#define US1_TTGR1             (*(REG32 (0xFFFC4028)))
#define US1_FIDI1             (*(REG32 (0xFFFC4040)))
#define US1_NER1              (*(REG32 (0xFFFC4044)))
#define US1_IF1               (*(REG32 (0xFFFC404C)))
#define US1_RPR               (*(REG32 (0xFFFC4100)))
#define US1_RCR               (*(REG32 (0xFFFC4104)))
#define US1_TPR               (*(REG32 (0xFFFC4108)))
#define US1_TCR               (*(REG32 (0xFFFC410C)))
#define US1_RNP               (*(REG32 (0xFFFC4110)))
#define US1_RNC               (*(REG32 (0xFFFC4114)))
#define US1_TNP               (*(REG32 (0xFFFC4118)))
#define US1_TNC               (*(REG32 (0xFFFC411C)))
#define US1_PTC               (*(REG32 (0xFFFC4120)))
#define US1_PTS               (*(REG32 (0xFFFC4124)))

/*##############################################################################
## Universal Sync/Async Rec/Trans 2 
##############################################################################*/
#define US2_CR                (*(REG32 (0xFFFC8000)))
#define US2_MR                (*(REG32 (0xFFFC8004)))
#define US2_IER               (*(REG32 (0xFFFC8008)))
#define US2_IDR               (*(REG32 (0xFFFC800C)))
#define US2_IMR               (*(REG32 (0xFFFC8010)))
#define US2_CSR               (*(REG32 (0xFFFC8014)))
#define US2_RHR               (*(REG32 (0xFFFC8018)))
#define US2_THR               (*(REG32 (0xFFFC801C)))
#define US2_BRGR              (*(REG32 (0xFFFC8020)))
#define US2_RTOR              (*(REG32 (0xFFFC8024)))
#define US2_TTGR              (*(REG32 (0xFFFC8028)))
#define US2_FIDI              (*(REG32 (0xFFFC8040)))
#define US2_NER               (*(REG32 (0xFFFC8044)))
#define US2_IF                (*(REG32 (0xFFFC804C)))
#define US2_RPR               (*(REG32 (0xFFFC8100)))
#define US2_RCR               (*(REG32 (0xFFFC8104)))
#define US2_TPR               (*(REG32 (0xFFFC8108)))
#define US2_TCR               (*(REG32 (0xFFFC810C)))
#define US2_RNP               (*(REG32 (0xFFFC8110)))
#define US2_RNC               (*(REG32 (0xFFFC8114)))
#define US2_TNP               (*(REG32 (0xFFFC8118)))
#define US2_TNC               (*(REG32 (0xFFFC811C)))
#define US2_PTC               (*(REG32 (0xFFFC8120)))
#define US2_PTS               (*(REG32 (0xFFFC8124)))

/*##############################################################################
## Universal Sync/Async Rec/Trans 3 
##############################################################################*/
#define US3_CR                (*(REG32 (0xFFFCC000)))
#define US3_MR                (*(REG32 (0xFFFCC004)))
#define US3_IER               (*(REG32 (0xFFFCC008)))
#define US3_IDR               (*(REG32 (0xFFFCC00C)))
#define US3_IMR               (*(REG32 (0xFFFCC010)))
#define US3_CSR               (*(REG32 (0xFFFCC014)))
#define US3_RHR               (*(REG32 (0xFFFCC018)))
#define US3_THR               (*(REG32 (0xFFFCC01C)))
#define US3_BRGR              (*(REG32 (0xFFFCC020)))
#define US3_RTOR              (*(REG32 (0xFFFCC024)))
#define US3_TTGR              (*(REG32 (0xFFFCC028)))
#define US3_FIDI              (*(REG32 (0xFFFCC040)))
#define US3_NER               (*(REG32 (0xFFFCC044)))
#define US3_IF                (*(REG32 (0xFFFCC04C)))
#define US3_RPR               (*(REG32 (0xFFFCC100)))
#define US3_RCR               (*(REG32 (0xFFFCC104)))
#define US3_TPR               (*(REG32 (0xFFFCC108)))
#define US3_TCR               (*(REG32 (0xFFFCC10C)))
#define US3_RNP               (*(REG32 (0xFFFCC110)))
#define US3_RNC               (*(REG32 (0xFFFCC114)))
#define US3_TNP               (*(REG32 (0xFFFCC118)))
#define US3_TNC               (*(REG32 (0xFFFCC11C)))
#define US3_PTC               (*(REG32 (0xFFFCC120)))
#define US3_PTS               (*(REG32 (0xFFFCC124)))

/*##############################################################################
## Serial Synchronous Controller 0 
##############################################################################*/
#define SSC0_CR               (*(REG32 (0xFFFD0000)))
#define SSC0_CMR              (*(REG32 (0xFFFD0004)))
#define SSC0_RCMR             (*(REG32 (0xFFFD0010)))
#define SSC0_RFMR             (*(REG32 (0xFFFD0014)))
#define SSC0_TCMR             (*(REG32 (0xFFFD0018)))
#define SSC0_TFMR             (*(REG32 (0xFFFD001C)))
#define SSC0_RHR              (*(REG32 (0xFFFD0020)))
#define SSC0_THR              (*(REG32 (0xFFFD0024)))
#define SSC0_RSHR             (*(REG32 (0xFFFD0030)))
#define SSC0_TSHR             (*(REG32 (0xFFFD0034)))
#define SSC0_SR               (*(REG32 (0xFFFD0040)))
#define SSC0_IER              (*(REG32 (0xFFFD0044)))
#define SSC0_IDR              (*(REG32 (0xFFFD0048)))
#define SSC0_IMR              (*(REG32 (0xFFFD004C)))
#define SSC0_RPR              (*(REG32 (0xFFFD0100)))
#define SSC0_RCR              (*(REG32 (0xFFFD0104)))
#define SSC0_TPR              (*(REG32 (0xFFFD0108)))
#define SSC0_TCR              (*(REG32 (0xFFFD010C)))
#define SSC0_RNP              (*(REG32 (0xFFFD0110)))
#define SSC0_RNC              (*(REG32 (0xFFFD0114)))
#define SSC0_TNP              (*(REG32 (0xFFFD0118)))
#define SSC0_TNC              (*(REG32 (0xFFFD011C)))
#define SSC0_PTC              (*(REG32 (0xFFFD0120)))
#define SSC0_PTS              (*(REG32 (0xFFFD0124)))

/*##############################################################################
## Serial Synchronous Controller 1 
##############################################################################*/
#define SSC1_CR               (*(REG32 (0xFFFD4000)))
#define SSC1_CMR              (*(REG32 (0xFFFD4004)))
#define SSC1_RCMR             (*(REG32 (0xFFFD4010)))
#define SSC1_RFMR             (*(REG32 (0xFFFD4014)))
#define SSC1_TCMR             (*(REG32 (0xFFFD4018)))
#define SSC1_TFMR             (*(REG32 (0xFFFD401C)))
#define SSC1_RHR              (*(REG32 (0xFFFD4020)))
#define SSC1_THR              (*(REG32 (0xFFFD4024)))
#define SSC1_RSHR             (*(REG32 (0xFFFD4030)))
#define SSC1_TSHR             (*(REG32 (0xFFFD4034)))
#define SSC1_SR               (*(REG32 (0xFFFD4040)))
#define SSC1_IER              (*(REG32 (0xFFFD4044)))
#define SSC1_IDR              (*(REG32 (0xFFFD4048)))
#define SSC1_IMR              (*(REG32 (0xFFFD404C)))
#define SSC1_RPR              (*(REG32 (0xFFFD4100)))
#define SSC1_RCR              (*(REG32 (0xFFFD4104)))
#define SSC1_TPR              (*(REG32 (0xFFFD4108)))
#define SSC1_TCR              (*(REG32 (0xFFFD410C)))
#define SSC1_RNP              (*(REG32 (0xFFFD4110)))
#define SSC1_RNC              (*(REG32 (0xFFFD4114)))
#define SSC1_TNP              (*(REG32 (0xFFFD4118)))
#define SSC1_TNC              (*(REG32 (0xFFFD411C)))
#define SSC1_PTC              (*(REG32 (0xFFFD4120)))
#define SSC1_PTS              (*(REG32 (0xFFFD4124)))

/*##############################################################################
## Serial Synchronous Controller 2 
##############################################################################*/
#define SSC2_CR               (*(REG32 (0xFFFD8000)))
#define SSC2_CMR              (*(REG32 (0xFFFD8004)))
#define SSC2_RCMR             (*(REG32 (0xFFFD8010)))
#define SSC2_RFMR             (*(REG32 (0xFFFD8014)))
#define SSC2_TCMR             (*(REG32 (0xFFFD8018)))
#define SSC2_TFMR             (*(REG32 (0xFFFD801C)))
#define SSC2_RHR              (*(REG32 (0xFFFD8020)))
#define SSC2_THR              (*(REG32 (0xFFFD8024)))
#define SSC2_RSHR             (*(REG32 (0xFFFD8030)))
#define SSC2_TSHR             (*(REG32 (0xFFFD8034)))
#define SSC2_SR               (*(REG32 (0xFFFD8040)))
#define SSC2_IER              (*(REG32 (0xFFFD8044)))
#define SSC2_IDR              (*(REG32 (0xFFFD8048)))
#define SSC2_IMR              (*(REG32 (0xFFFD804C)))
#define SSC2_RPR              (*(REG32 (0xFFFD8100)))
#define SSC2_RCR              (*(REG32 (0xFFFD8104)))
#define SSC2_TPR              (*(REG32 (0xFFFD8108)))
#define SSC2_TCR              (*(REG32 (0xFFFD810C)))
#define SSC2_RNP              (*(REG32 (0xFFFD8110)))
#define SSC2_RNC              (*(REG32 (0xFFFD8114)))
#define SSC2_TNP              (*(REG32 (0xFFFD8118)))
#define SSC2_TNC              (*(REG32 (0xFFFD811C)))
#define SSC2_PTC              (*(REG32 (0xFFFD8120)))
#define SSC2_PTS              (*(REG32 (0xFFFD8124)))

/*##############################################################################
## Timer Counter 0,1,2 
##############################################################################*/
#define TC0_CCR               (*(REG32 (0xFFFA0000)))
#define TC0_CMR               (*(REG32 (0xFFFA0004)))
#define TC0_CV                (*(REG32 (0xFFFA0010)))
#define TC0_RA                (*(REG32 (0xFFFA0014)))
#define TC0_RB                (*(REG32 (0xFFFA0018)))
#define TC0_RC                (*(REG32 (0xFFFA001C)))
#define TC0_SR                (*(REG32 (0xFFFA0020)))
#define TC0_IER               (*(REG32 (0xFFFA0024)))
#define TC0_IDR               (*(REG32 (0xFFFA0028)))
#define TC0_IMR               (*(REG32 (0xFFFA002C)))
#define TC1_CCR               (*(REG32 (0xFFFA0040)))
#define TC1_CMR               (*(REG32 (0xFFFA0044)))
#define TC1_CV                (*(REG32 (0xFFFA0050)))
#define TC1_RA                (*(REG32 (0xFFFA0054)))
#define TC1_RB                (*(REG32 (0xFFFA0058)))
#define TC1_RC                (*(REG32 (0xFFFA005C)))
#define TC1_SR                (*(REG32 (0xFFFA0060)))
#define TC1_IER               (*(REG32 (0xFFFA0064)))
#define TC1_IDR               (*(REG32 (0xFFFA0068)))
#define TC1_IMR               (*(REG32 (0xFFFA006C)))
#define TC2_CCR               (*(REG32 (0xFFFA0080)))
#define TC2_CMR               (*(REG32 (0xFFFA0084)))
#define TC2_CV                (*(REG32 (0xFFFA0090)))
#define TC2_RA                (*(REG32 (0xFFFA0094)))
#define TC2_RB                (*(REG32 (0xFFFA0098)))
#define TC2_RC                (*(REG32 (0xFFFA009C)))
#define TC2_SR                (*(REG32 (0xFFFA00A0)))
#define TC2_IER               (*(REG32 (0xFFFA00A4)))
#define TC2_IDR               (*(REG32 (0xFFFA00A8)))
#define TC2_IMR               (*(REG32 (0xFFFA00AC)))
#define TC012_BCR             (*(REG32 (0xFFFA00C0)))
#define TC012_BMR             (*(REG32 (0xFFFA00C4)))

/*##############################################################################
## Timer Counter 3,4,5 
##############################################################################*/
#define TC3_CCR               (*(REG32 (0xFFFA4000)))
#define TC3_CMR               (*(REG32 (0xFFFA4004)))
#define TC3_CV                (*(REG32 (0xFFFA4010)))
#define TC3_RA                (*(REG32 (0xFFFA4014)))
#define TC3_RB                (*(REG32 (0xFFFA4018)))
#define TC3_RC                (*(REG32 (0xFFFA401C)))
#define TC3_SR                (*(REG32 (0xFFFA4020)))
#define TC3_IER               (*(REG32 (0xFFFA4024)))
#define TC3_IDR               (*(REG32 (0xFFFA4028)))
#define TC3_IMR               (*(REG32 (0xFFFA402C)))
#define TC4_CCR               (*(REG32 (0xFFFA4040)))
#define TC4_CMR               (*(REG32 (0xFFFA4044)))
#define TC4_CV                (*(REG32 (0xFFFA4050)))
#define TC4_RA                (*(REG32 (0xFFFA4054)))
#define TC4_RB                (*(REG32 (0xFFFA4058)))
#define TC4_RC                (*(REG32 (0xFFFA405C)))
#define TC4_SR                (*(REG32 (0xFFFA4060)))
#define TC4_IER               (*(REG32 (0xFFFA4064)))
#define TC4_IDR               (*(REG32 (0xFFFA4068)))
#define TC4_IMR               (*(REG32 (0xFFFA406C)))
#define TC5_CCR               (*(REG32 (0xFFFA4080)))
#define TC5_CMR               (*(REG32 (0xFFFA4084)))
#define TC5_CV                (*(REG32 (0xFFFA4090)))
#define TC5_RA                (*(REG32 (0xFFFA4094)))
#define TC5_RB                (*(REG32 (0xFFFA4098)))
#define TC5_RC                (*(REG32 (0xFFFA409C)))
#define TC5_SR                (*(REG32 (0xFFFA40A0)))
#define TC5_IER               (*(REG32 (0xFFFA40A4)))
#define TC5_IDR               (*(REG32 (0xFFFA40A8)))
#define TC5_IMR               (*(REG32 (0xFFFA40AC)))
#define TC345_BCR             (*(REG32 (0xFFFA40C0)))
#define TC345_BMR             (*(REG32 (0xFFFA40C4)))

/*##############################################################################
## MultiMedia Card Interface 
##############################################################################*/
#define MCI_CR                (*(REG32 (0xFFFB4000)))
#define MCI_MR                (*(REG32 (0xFFFB4004)))
#define MCI_DTOR              (*(REG32 (0xFFFB4008)))
#define MCI_SDCR              (*(REG32 (0xFFFB400C)))
#define MCI_ARGR              (*(REG32 (0xFFFB4010)))
#define MCI_CMDR              (*(REG32 (0xFFFB4014)))
#define MCI_RSPR1             (*(REG32 (0xFFFB4020)))
#define MCI_RSPR2             (*(REG32 (0xFFFB4024)))
#define MCI_RSPR3             (*(REG32 (0xFFFB4028)))
#define MCI_RSPR4             (*(REG32 (0xFFFB402C)))
#define MCI_RDR               (*(REG32 (0xFFFB4030)))
#define MCI_TDR               (*(REG32 (0xFFFB4034)))
#define MCI_SR                (*(REG32 (0xFFFB4040)))
#define MCI_IER               (*(REG32 (0xFFFB4044)))
#define MCI_IDR               (*(REG32 (0xFFFB4048)))
#define MCI_IMR               (*(REG32 (0xFFFB404C)))
#define MCI_RPR               (*(REG32 (0xFFFB4100)))
#define MCI_RCR               (*(REG32 (0xFFFB4104)))
#define MCI_TPR               (*(REG32 (0xFFFB4108)))
#define MCI_TCR               (*(REG32 (0xFFFB410C)))
#define MCI_RNPR              (*(REG32 (0xFFFB4110)))
#define MCI_RNCR              (*(REG32 (0xFFFB4114)))
#define MCI_TNPR              (*(REG32 (0xFFFB4118)))
#define MCI_TNCR              (*(REG32 (0xFFFB411C)))
#define MCI_PTCR              (*(REG32 (0xFFFB4120)))
#define MCI_PTSR              (*(REG32 (0xFFFB4124)))

/*##############################################################################
## USB Device Port 
##############################################################################*/
#define UDP_FRM_NUM           (*(REG32 (0xFFFB0000)))
#define UDP_GLB_STAT          (*(REG32 (0xFFFB0004)))
#define UDP_FADDR             (*(REG32 (0xFFFB0008)))
#define UDP_IER               (*(REG32 (0xFFFB0010)))
#define UDP_IDR               (*(REG32 (0xFFFB0014)))
#define UDP_IMR               (*(REG32 (0xFFFB0018)))
#define UDP_ISR               (*(REG32 (0xFFFB001C)))
#define UDP_ICR               (*(REG32 (0xFFFB0020)))
#define UDP_RST_EP            (*(REG32 (0xFFFB0028)))
#define UDP_CSR0              (*(REG32 (0xFFFB0030)))
#define UDP_CSR1              (*(REG32 (0xFFFB0034)))
#define UDP_CSR2              (*(REG32 (0xFFFB0038)))
#define UDP_CSR3              (*(REG32 (0xFFFB003C)))
#define UDP_CSR4              (*(REG32 (0xFFFB0040)))
#define UDP_CSR5              (*(REG32 (0xFFFB0044)))
#define UDP_CSR6              (*(REG32 (0xFFFB0048)))
#define UDP_CSR7              (*(REG32 (0xFFFB004C)))
#define UDP_FDR0              (*(REG32 (0xFFFB0050)))
#define UDP_FDR1              (*(REG32 (0xFFFB0054)))
#define UDP_FDR2              (*(REG32 (0xFFFB0058)))
#define UDP_FDR3              (*(REG32 (0xFFFB005C)))
#define UDP_FDR4              (*(REG32 (0xFFFB0060)))
#define UDP_FDR5              (*(REG32 (0xFFFB0064)))
#define UDP_FDR6              (*(REG32 (0xFFFB0068)))
#define UDP_FDR7              (*(REG32 (0xFFFB006C)))

/*##############################################################################
## Ethernet MAC 
##############################################################################*/
#define ETH_CTL               (*(REG32 (0xFFFBC000)))
#define ETH_CFG               (*(REG32 (0xFFFBC004)))
#define ETH_SR                (*(REG32 (0xFFFBC008)))
#define ETH_TAR               (*(REG32 (0xFFFBC00C)))
#define ETH_TCR               (*(REG32 (0xFFFBC010)))
#define ETH_TSR               (*(REG32 (0xFFFBC014)))
#define ETH_RBPQP             (*(REG32 (0xFFFBC018)))
#define ETH_RSR               (*(REG32 (0xFFFBC020)))
#define ETH_ISR               (*(REG32 (0xFFFBC024)))
#define ETH_IER               (*(REG32 (0xFFFBC028)))
#define ETH_IDR               (*(REG32 (0xFFFBC02C)))
#define ETH_IMR               (*(REG32 (0xFFFBC030)))
#define ETH_MAN               (*(REG32 (0xFFFBC034)))
#define ETH_FRA               (*(REG32 (0xFFFBC040)))
#define ETH_SCOL              (*(REG32 (0xFFFBC044)))
#define ETH_MCOL              (*(REG32 (0xFFFBC048)))
#define ETH_OK                (*(REG32 (0xFFFBC04C)))
#define ETH_SEQE              (*(REG32 (0xFFFBC050)))
#define ETH_ALE               (*(REG32 (0xFFFBC054)))
#define ETH_DTE               (*(REG32 (0xFFFBC058)))
#define ETH_LCOL              (*(REG32 (0xFFFBC05C)))
#define ETH_ECOL              (*(REG32 (0xFFFBC060)))
#define ETH_CSE               (*(REG32 (0xFFFBC064)))
#define ETH_TUE               (*(REG32 (0xFFFBC068)))
#define ETH_CDE               (*(REG32 (0xFFFBC06C)))
#define ETH_ELR               (*(REG32 (0xFFFBC070)))
#define ETH_RJB               (*(REG32 (0xFFFBC074)))
#define ETH_USF               (*(REG32 (0xFFFBC078)))
#define ETH_SQEE              (*(REG32 (0xFFFBC07C)))
#define ETH_DRFC              (*(REG32 (0xFFFBC080)))
#define ETH_HSH               (*(REG32 (0xFFFBC090)))
#define ETH_HSL               (*(REG32 (0xFFFBC094)))
#define ETH_SA1L              (*(REG32 (0xFFFBC098)))
#define ETH_SA1H              (*(REG32 (0xFFFBC09C)))
#define ETH_SA2L              (*(REG32 (0xFFFBC0A0)))
#define ETH_SA2H              (*(REG32 (0xFFFBC0A4)))
#define ETH_SA3L              (*(REG32 (0xFFFBC0A8)))
#define ETH_SA3H              (*(REG32 (0xFFFBC0AC)))
#define ETH_SA4L              (*(REG32 (0xFFFBC0B0)))
#define ETH_SA4H              (*(REG32 (0xFFFBC0B4)))


#endif  /* at91rm9200_h */
