<?php
// functions for links

function draw_links_categories()
{
	global $config, $lang;
	$ret = db_query("select cod, name, descr from {$config["prefix"]}_linkscat where parent_id = 0 order by name" );
	if( !$ret ) return;
	theme_draw_centerbox_open( $lang["LINKS_TITLE"] );
?>
<table width="100%" border="0" cellspacing="0" cellpadding="2">
<?php
	while( $row = db_fetch_array($ret) ) {
?>
<tr><td class="rowblank">&nbsp;</td></tr>
<tr><td class="row1"><a href="links.php?cat=<?php print $row["cod"]; ?>"><?php print $row["name"]; ?></a></td></tr>
<tr><td class="row2"><?php print $row["descr"]; ?></td></tr>
<?php
	}
	db_free_result($ret);
?>
</table>
<?php
	theme_draw_centerbox_close();
}

function draw_links_subcategories( $parent_id )
{
	global $config, $lang;
	$parent_id = intval($parent_id);
	if( $parent_id <= 0 ) return;
	$ret = db_query("select cod, name from {$config["prefix"]}_linkscat where parent_id = $parent_id and cod != $parent_id order by name" );
	if( !$ret )
	{
		echo "<div class=\"error\">{$lang["ERROR_04"]}:<br>".db_error()."</div>";
		return;
	}
	if( db_num_rows($ret) == 0 ) return;
?>
<table width="100%" border="0" cellspacing="0" cellpadding="2">
<tr><td class="row0"><?php echo $lang["LINKS_SUBCAT_TITLE"]; ?></td></tr>
<?php
	$i=0;
	while( $row = db_fetch_array($ret) ) {
		$crow = "row".((($i++)%2)+1);
?>
<tr><td class="<?php echo $crow; ?>"><a href="links.php?cat=<?php print $row["cod"]; ?>"><?php print $row["name"]; ?></a></td></tr>
<?php
	}
	db_free_result($ret);
?>
</table><br>
<?php
}

function draw_links_list()
{
	global $config, $lang, $cfg;
	if( !isset($_GET["cat"]) ) return;
	$cat = intval($_GET["cat"]);
    if( isset($_GET["page"]) ) $page = intval($_GET["page"]);
    else $page = 0;

	// get category name
	$ret = db_query("select name, parent_id from {$config["prefix"]}_linkscat where cod=$cat");
	if( !$ret )
	{
		echo "<div class=\"error\">{$lang["ERROR_04"]}:<br>".db_error()."</div>";
		return;
	}
	if( db_num_rows($ret) != 1 ) {
		db_free_result( $ret );
		print $lang["LINKS_ERROR01"];
		return;
	}
	$cat_name = db_result( $ret, 0, 0 );
	$cat_parent_id = db_result( $ret, 0, 1 );
	db_free_result( $ret );

	$stmt2 = "select count(*) from {$config["prefix"]}_links where category=$cat and active='Y'";
    $ret = db_query($stmt2);
    $totlinks = db_result( $ret, 0, 0 );
	db_free_result( $ret );

	$stmt = "select id, name, count, descr from {$config["prefix"]}_links where category=$cat and active='Y' order by name";
	switch( $config["dbtype"] )
	{
		case "mysql":
			$stmt .= " limit ".($cfg["links"]["max_per_page"]*$page).", ".$cfg["links"]["max_per_page"];
			break;
		case "pgsql":
			$stmt .= " LIMIT ".$cfg["links"]["max_per_page"]." OFFSET ".($cfg["links"]["max_per_page"]*$page);
	}
	$ret = db_query( $stmt );
	if( !$ret )
	{
		echo "<div class=\"error\">{$lang["ERROR_04"]}:<br>".db_error()."</div>";
		return;
	}
	theme_draw_centerbox_open( $cat_name );
	draw_links_subcategories( $cat );
?>
<table width="100%" border="0" cellspacing="0" cellpadding="1">
<tr>
	<td class="row0"><?php print $lang["LINKS_HEADER_1"]; ?></td>
	<td class="row0" align="right" width=60><?php print $lang["LINKS_HEADER_4"]; ?></td>
</tr>
<?php
	while( $row = db_fetch_array($ret) ) {
		print "<tr><td class=\"row1\"><b><a href=\"links.php?link={$row["id"]}\" target=\"_blank\">{$row["name"]}</a></b></td><td class=\"row1\" align=\"right\" width=60>{$row["count"]}</td></tr>";
		print "<tr><td class=\"row2\">{$row["descr"]}</td><td align=\"center\" class=\"row2\"><a href=\"links.php?link={$row["id"]}\" target=\"_blank\"><img src=\"modules/links/link.png\" width=32 height=32 alt=\"{$lang["LINKS_VISIT"]}\" border=0></a></td></tr>";
		print "<tr><td class=\"rowblank\" colspan=2><hr></td></tr>";
	}
	db_free_result($ret);
?>
</table>
<table width="100" border=0 cellpadding=2 cellspacing=0 align="center">
	<tr>
		<td width="25" align="center">
<?php
	if( $page > 0 ) echo "<a href=\"links.php?cat={$cat}&page=0\">|&lt;</a>";
	else echo "|&lt;";
?></td>
		<td width="25" align="center">
<?php
	if( $page > 0 ) echo "<a href=\"links.php?cat={$cat}&page=".($page-1)."\">&lt;&lt;</a>";
	else echo "&lt;&lt;";
?></td>
		<td width="25" align="center">
<?php
	if( ($page+1)*$cfg["links"]["max_per_page"] < $totlinks )
		echo "<a href=\"links.php?cat={$cat}&page=".($page+1)."\">&gt;&gt;</a>";
	else echo "&gt;&gt;";
?></td>
		<td width="25" align="center">
<?php
	if( ($page+1)*$cfg["links"]["max_per_page"] < $totlinks )
		echo "<a href=\"links.php?cat={$cat}&page="
			.intval(($totlinks-1)/$cfg["links"]["max_per_page"])."\">&gt;|</a>";
	else echo "&gt;|";
?></td>
	</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="2">
<tr>
	<td width="50%">
<?php
	if( $cat_parent_id != 0 ) $lnk="?cat=$cat_parent_id";
	else $lnk="";
	echo "<a href=\"links.php{$lnk}\">{$lang["LINKS_GOUP"]}</a>";
?></td>
	<td width="50%" align="right">
<?php
	if( $cfg["links"]["useradd"] ) echo "<a href=\"add_link.php?cat=$cat\">{$lang["LINKS_ADD"]}</a>";
	else echo "&nbsp;";
?></td>
</tr>
</table>
<?php
	theme_draw_centerbox_close();
}
?>
