<?php
if (strstr($_SERVER["PHP_SELF"], "/core/"))  die ("You can't access this file directly...");
session_start();

function getmicrotime()
{ 
    list($usec, $sec) = explode(" ",microtime()); 
    return ((float)$usec + (float)$sec); 
}
$time_start = getmicrotime();

$modules = array();
$headcode = "";
$config = array();
$config["menu"] = array();
require("wt_config.php");
if ( ($config["dbtype"] === "mysql") || ($config["dbtype"] === "pgsql") ) {
    require("core/{$config["dbtype"]}.lib.php");
} else {
    require("core/mysql.lib.php");
}
include_once("core/login.php");

function check_lang( $lang )
{
    // up to only 4 letters
    $ret = substr( $lang, 0, 4 );
    if( ereg("^[a-z]{2,4}$", $ret) ) return $ret;
    else
    {
        echo "Invalid lang file";
        return "enus";
    }
}

$conn = db_connect($config["host"],$config["database"],$config["user"],$config["password"]) or die( db_error() );
// Load configuration
$cfg = array();

$ret = db_query( "select * from {$config["prefix"]}_config" );
if( !$ret ) {
    print "<div class=\"error\">An error has ocurred while loading configuration.</div>";
} else {
    while( $rowcfg = db_fetch_array($ret) ) {
        $cfg[$rowcfg["id"]] = unserialize(stripslashes($rowcfg["config"]));
    }
}
db_free_result($ret);

include_once( "lang/msg_".check_lang($cfg["core"]["lang"]).".php" );
require_once("core/theme.php");

//if( !isset($config["show_map"]) ) $config["show_map"] = true;

//if( $config["show_map"] )
//{
//    $sitemap = array();
//    $sitemap[] = array(HOME_TITLE, 'index.php');
//}
//

//
// Links at main box
$config["menu"][10] = array( "title"=>$lang["HOME_TITLE"], "file"=>"index.php", "type"=>"A", "newwindow"=>"N" );
$config["menu"][110] = array( "title"=>$lang["NEW_USER_LINK"], "file"=>"newuser.php", "type"=>"N", "newwindow"=>"N" );
$config["menu"][120] = array( "title"=>$lang["MYACCT_TITLE"], "file"=>"myaccount.php", "type"=>"L", "newwindow"=>"N" );
$config["menu"][130] = array( "title"=>$lang["STATS_TITLE"], "file"=>"stats.php", "type"=>"A", "newwindow"=>"N" );

// Links at admmenu
$config["admmenu"] = array();
$config["admmenu"]["sidebox"] = array( "title"=>$lang["SIDEBOX_EDIT_TITLE"], "file"=>"adm_sideboxes.php", "class"=>"sideboxes" );
$config["admmenu"]["info"] = array( "title"=>$lang["ADMMNU_INFO"], "file"=>"adm_info.php", "class"=>"admin" );
$config["admmenu"]["webadmin"] = array( "title"=>$lang["ADMMNU_WEBADMIN"], "file"=>"admin.php", "class"=>"admin" );
$config["admmenu"]["sendemail"] = array( "title"=>$lang["ADMMNU_SENDEMAIL"], "file"=>"adm_sendmail.php", "class"=>"admin" );

$config["admmenu"]["users"] = array( "title"=>$lang["ADMMNU_USERS"], "file"=>"adm_users.php", "class"=>"admin" );
$config["admmenu"]["user_access"] = array( "title"=>$lang["ADMMNU_USERACCESS"], "file"=>"adm_access.php", "class"=>"admin" );
$config["admmenu"]["menu"] = array( "title"=>$lang["ADMMNU_MENU"], "file"=>"adm_menu.php", "class"=>"admin" );

// Pending actions
$pending_actions = array();
// sideboxes
$config["sidebox"] = array();
$config["sidebox"][] = array( "title"=>"Menu", "function"=>"draw_menu" );
$config["sidebox"][] = array( "title"=>"Login box", "function"=>"draw_login_box" );
$config["sidebox"][] = array( "title"=>"Users Online", "function"=>"draw_users_online" );
$config["sidebox"][] = array( "title"=>"Admin Box", "function"=>"draw_admin_box" );
$config["sidebox"][] = array( "title"=>"Pending Actions", "function"=>"draw_pending_actions" );

$modules = array();
foreach($cfg["modules"] as $mid=>$enabled) {
    $modules[$mid] = false;
    if ($enabled) include_once("modules/$mid/main.php");
}

if( check_module("fileman") && $cfg["core"]["avatars"] )
	$config["fileman"]["avatars"] = array( "name"=>"Avatars", "folder"=>$cfg["core"]["avatars_folder"] );

// loads the user menu from database
$ret = db_query( "select * from {$config["prefix"]}_menu order by pos" );
if( !$ret ) {
    print "<div class=\"error\">An error has ocurred while loading user menu.</div>";
} else {
    while( $rmenu = db_fetch_array($ret) ) {
		$pos = $rmenu["pos"];
		$c = 0;
		while( isset($config["menu"][$pos]) ) {
			$pos++;
			// if this happens, thre is something very wrong
			if( ++$c > 100 ) {
				print "<div class=\"error\">The menu is full.</div>";
				break;
			}
		}
		$config["menu"][$pos] = array( "title"=>$rmenu["title"], "file"=>$rmenu["url"], "type"=>$rmenu["type"], "newwindow"=>$rmenu["newwindow"] );
    }
}
db_free_result($ret);

//

// todo: passar para login.php
// if the user comes from a site below the same url
// like www.phpdbform.com and www.phpdbform.com/test
// empty the session

if(isset($_SESSION["wt"])) {
    if( $_SESSION["wt"]["url"] != $cfg["core"]["url"] ) {
        clear_login();
    }
} else {
    clear_login();
}

// User trying to login
if(isset($_POST["submit_login"])) {
    do_login();
}
if( !$_SESSION["wt"]["logged"] ) {
    check_autologin();
}

if( isset($_GET["act"]) && $_GET["act"]=="logout") {
    clear_login();
    delete_autologin();
}

function show_date( $date, $showtime=true )
{
    global $cfg;
    switch( $cfg["core"]["date_format"] )
    {
        case "fmtEUR":  $date_str = substr($date,8,2)."/".substr($date,5,2)."/".substr($date,0,4); break;
        case "fmtUSA":  $date_str = substr($date,5,2)."/".substr($date,8,2)."/".substr($date,0,4); break;
        default:        $date_str = substr($date,0,4)."-".substr($date,5,2)."-".substr($date,8,2); break;
    }
    if( $showtime ) $date_str .= " ".substr($date,11,5);
    return $date_str;
}

function crop_string( $text, $maxlen )
{
    if( strlen($text) <= $maxlen ) return $text;
    else return( substr( $text, 0, ($maxlen-3) ) . "..." );
}

function conv_date( $date, $showtime=true )
{
	global $cfg;
	switch( $cfg["core"]["date_format"] )
	{
		case "fmtEUR":  $date_str = substr($date,6,4)."-".substr($date,3,2)."-".substr($date,0,2); break;
		case "fmtUSA":  $date_str = substr($date,6,4)."/".substr($date,0,2)."/".substr($date,3,2); break;
		default:        $date_str = substr($date,0,4)."-".substr($date,5,2)."-".substr($date,8,2); break;
	}
	if( $showtime ) $date_str .= " ".substr($date,11,5);
	return $date_str;
}

//function session_dump()
//{
//  // dumps info about a session - debugging
//  $session_array = explode(";",session_encode());
//  $html = "SESSION VARIABLES DUMP<br><br>";
//  for ($x = 0; $x < count($session_array); $x++) { 
//    $html .= "     $session_array[$x] <br>";
//  }
//  $html .= " <br><br>";
//  return $html;
//}
//
//function magic_encode( $var )
//{
//    if( get_magic_quotes_gpc() ) return $var;
//    else return addslashes($var);
//}
function delmagic( $value )
{
    // this function removes backslashes ig magic_quotes_gpc is on
    if( get_magic_quotes_gpc() ) return stripslashes( $value );
    else return $value;
}

function showavatar( $avatar, $realname )
{
    global $cfg;
    if( $cfg["core"]["avatars"] && $avatar != "" )
        return "<img src=\"{$cfg["core"]["avatars_folder"]}/$avatar\" alt=\"$realname\" width=100 height=100 border=0>";
    else return "&nbsp;";
}

function check_module( $module )
{
    global $modules;
    if( !isset($modules[$module]) ) return false;
    return $modules[$module];
}
?>