<?php
include_once("core/main.php");
include_once("core/parser.php");
// this is forced here for security reasons
if( !check_user_class("admin") ) exit;

$index_page = false;
$page_name = $lang["UMSG_BLK_SENDMESSAGE"];

draw_header();
if( isset($_POST["msg_submit"]) ) process_msg();
else draw_msg_form();
draw_footer();

function draw_msg_form()
{
	global $config, $lang;
	$msg_title="";
	$button = $lang["UMSG_BLK_BUTTON"];
	$title_box = $lang["UMSG_BLK_BOX"];
	theme_draw_centerbox_open( $title_box );
	echo "<table border=0 cellspacing=0 cellpadding=2 align=\"center\"><tr><td class=\"centerboxtext\">";
	echo "<form action=\"adm_sendmessage.php\" method=\"post\">";
	echo "<br>".$lang["UMSG_SEND_TITLE"]."<br>
<input type=\"hidden\" name=\"msg_submit\" value=\"1\">
<input type=\"text\" name=\"msgtitle\" size=60 maxlength=80 class=\"field_textbox\" value=\"$msg_title\"><br>"
.$lang["UMSG_SEND_TEXT"]."<br>
<textarea cols=60 rows=10 name=\"msgtext\" class=\"field_textbox\"></textarea><br>
<input type=\"submit\" name=\"submit_msg\" class=\"button\" value=\"$button\">
</form></td></tr></table>";
	theme_draw_centerbox_close();
}

function process_msg()
{
	global $config, $lang;
	$msgtitle = delmagic( strip_tags(trim($_POST["msgtitle"])) );
	$msgtext = delmagic( trim($_POST["msgtext"]) );
	if( strlen($msgtitle) <= 0 || strlen($msgtext) <= 0 )
	{
		print $lang["UMSG_SEND_ERROR_01"];
		return;
	}
	// parse the text
	$msgtext_ori = $msgtext;
	$err = "";
	parse_tags3( $msgtext, $err );
	if( strlen($err) > 0 )
	{
		echo "<span class=\"error\">{$lang["ERROR_10"]} $err</span>";
		return;
	}
	$now = date( "Y-m-d H:i" );
	// send the message
	$query1="select uid from {$config["prefix"]}_users where active='Y'";
	$req1 = db_query($query1);
	if( db_num_rows($req1)==0 ) return;
	while ($member=db_fetch_array($req1))
	{
		$stmt = "insert into {$config["prefix"]}_user_msgs(userid,folder,date,user_from,title,text) values";
		$stmt .= sprintf( "(%d, '%s', '%s', %d, '%s', '%s')",
			$member["uid"],
			"inbox",
			$now,
			$_SESSION["wt"]["uid"],
			addslashes($msgtitle),
			addslashes($msgtext)
		);
		if( !db_query($stmt) )
		{
			print db_error();
			return;
		}
	}
	echo "<div class=\"info\" align=\"center\">{$lang["UMSG_BLK_SENT"]}<br><br></div>";
}
?>