<?php
include_once("core/main.php");
// this is forced here for security reasons
if( !check_module("links") ) die( "module not enabled" );
if( !$cfg["links"]["useradd"] ) die( "function not allowed" );

require_once("phpdbform/phpdbform_form.php");

$index_page = false;
$page_name = $lang["LINKS_ADD_TITLE"];

draw_header();
if( !$_SESSION["wt"]["logged"] )
{
    theme_draw_centerbox_open( $lang["LINKS_ADD_TITLE"] );
	print "<span class=\"error\">{$lang["NOT_LOGGED"]}</span>";
	theme_draw_centerbox_close();
    draw_footer();
    exit;
}

if( isset($_GET["cat"]) ) $cat = intval($_GET["cat"]);
else $cat = 0;

$catok = false;
$listcat = array();
$ret = db_query("select cod, name from {$config["prefix"]}_linkscat order by name");
while( $row = db_fetch_array($ret) )
{
	if( !$catok ) if( $cat == $row["cod"] ) $catok = true;
	$listcat[] = array( $row["cod"], $row["cod"]." | ".$row["name"] );
}
db_free_result($ret);

if( !$catok )
{
    theme_draw_centerbox_open( $lang["LINKS_ADD_TITLE"] );
	print "<span class=\"error\">{$lang["LINKS_ERROR01"]}</span>";
	theme_draw_centerbox_close();
    draw_footer();
    exit;
}

$form = new phpform( "addlinkform", "add_link.php?cat=$cat" );
$form->add_static_listbox( "category", $lang["LINKS_CAT_TITLE"], $listcat );
$form->fields["category"]->value = $cat;
$form->add_textbox( "name", "*".$lang["LINKS_NAME_TITLE"], 30, 30 );
$form->add_textbox( "url", "*".$lang["LINKS_URL_TITLE"], 30, 255 );
$form->fields["url"]->value = "http://";
$form->add_textarea( "descr", "*".$lang["LINKS_DESCR_TITLE"], 30, 6 );
$form->add_textarea( "obs", $lang["LINKS_OBS_TITLE"], 30, 3 );

theme_draw_centerbox_open( $lang["LINKS_ADD_TITLE"] );
$ok = false;
$errors = array();

if( $form->process() )
{
	if( !isset($_SESSION["wt"]["addlink"]) )
	{
		$form->fields["category"]->value = intval($form->fields["category"]->value);
		$form->fields["name"]->value = trim(strip_tags($form->fields["name"]->value));
		$form->fields["url"]->value = trim(strip_tags($form->fields["url"]->value));
		$form->fields["descr"]->value = trim(strip_tags($form->fields["descr"]->value));
		$form->fields["obs"]->value = trim(strip_tags($form->fields["obs"]->value));

		if( empty($form->fields["name"]->value) ) $errors[] = $lang["LINKS_ADDERR_NAME"];
		if( (substr( $form->fields["url"]->value, 0, 7 ) != "http://")
			&& (substr( $form->fields["url"]->value, 0, 6 ) != "ftp://")
			|| (strlen($form->fields["url"]->value) < 10 ) )
				$errors[] = $lang["LINKS_ADDERR_URL"];
		if( strlen($form->fields["descr"]->value) <= 10 ) $errors[] = $lang["LINKS_ADDERR_DESCR"];

		if( !empty($errors) )
		{
			print "<div class=\"error\">";
			while( $err = each($errors) )
			{
				print "{$err[1]}<br>\n";
			}
			print "</div>\n";
		} else $ok = true;

		if( $ok )
		{
			$stmt = "insert into {$config["prefix"]}_links set"
				." category = {$form->fields["category"]->value},"
				." active = 'N',"
				." name = '".addslashes($form->fields["name"]->value)."',"
				." url = '".addslashes($form->fields["url"]->value)."',"
				." count = 0,"
				." descr = '".addslashes($form->fields["descr"]->value)."',"
				." obs = '".addslashes($form->fields["obs"]->value)."\nIP: ".$_SERVER["REMOTE_ADDR"]."\nDate: ".date("Y-m-d H:i:s")."'";
			$ret = db_query( $stmt );
			if( !$ret )
			{
				$ok = false;
				print "<div class=\"error\">".$lang["ERROR_04"]."<br>".db_error()."</div>";
			} else {
				print "<div class=\"info\">".$lang["LINKS_ADDOK"]."</div>";
				mail($cfg["core"]["mail_admin"], $lang["LINKS_ADDEMAIL_TITLE"], $lang["LINKS_ADDEMAIL_TEXT"]."\n\n".$cfg["core"]["url"],"From: ".$cfg["core"]["mail_admin"]."\n");
				$_SESSION["wt"]["addlink"] = true;
			}
		}
	} else $ok = true;
} else {
	if( isset($_SESSION["wt"]["addlink"]) ) unset($_SESSION["wt"]["addlink"]);
}
if( !$ok ) $form->draw();
theme_draw_centerbox_close();

draw_footer();
?>