#include <limits.h>
#include "testdiv.h"
	/*  Used for converting between counts and uS for time function.*/
	/* An unsigned long long so overflows are not possible during 	*/
	/* the conversion.  Note relationship to CLOCK_SPEED.		*/
#define COUNTS_PER_US	(10uLL)


	/*** Local Variables ***/

	/*  Scales between desired nominal clock frequency and what we	*/
	/* were actually able to achieve.  This ends up being the 	*/
	/* actual clock rate in Hz.					*/
static unsigned long tsf;	


/********************* SetTSF *******************************************/
/*  Set tsf (equiv to internal timing scale factor of timer operations)	*/
/* in test routines.							*/
void SetTSF( unsigned long set_to)
 {
 tsf = set_to;
 }

/********************* divx *********************************************/
/*  Divide by 78125.  Constant time operation.				*/
static unsigned long long divx(unsigned long long x)
{
 unsigned long long res;

	/*  None of these operations overflow only since before this	*/
	/* routine is called the calling routine uses a shift operation	*/
	/* to perform a divide by 128 to provide enough headroom to	*/
	/* allow this to succeed w/o overflow.				*/
 res = (84*x)>> 7;
 res = (73*x - res)>> 7;
 res = (94*x + res) >> 8;
 res = (121*x + res) >> 7;
 res = (106*x + res) >> 9;
 res = (101*x + res) >> 7;
 res = (95*x + res) >> 8;
 res = (107*x + res) >> 23;
 return res;
}


/********************* UsToCounts2 ***************************************/
/*  UsToCounts2 -- Equivalent to timers USToCounts.  Use to test 	*/
/* alternative approaches.					 	*/
unsigned int UsToCounts2( unsigned int us)
{
 unsigned long long tmp;

 tmp = COUNTS_PER_US * us * tsf;
 tmp >>= 7;		/*  First divide by 128.  Doing this first	*/
 			/* ensures 7 bits of overhead for later divide	*/
 			/* operations.					*/

 tmp = divx(tmp);

 if( tmp > ULONG_MAX) {
    return ULONG_MAX;
    }
 return (unsigned int)tmp;
}

