/**************************** test8.c ***********************************/
/* Copyright 2004/01/21 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple timer test program. Tests timer around where HW overflows.	*/
/* Assumes default parameters for timer.       				*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test8.c 03-Feb-2004,17:12:48,`RADSETT' First archived version
*   2 test8.c 13-Jul-2004,10:48:28,`RADSETT' Remove unused _impure_ptr arguments.
*        Some lint cleanup.
*        lpc_sys.h now included implicitly.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include "lpc210x.h"
#include "dev_cntrl.h"
#include "lpc_ioctl.h"

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */

/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 struct serial_param sp;
 unsigned int i;


 (void)SetNativeSpeed( 10000uL);

	/* Desired serial line characteristics 9600,n82			*/
 sp.baud = 9600uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop = UART_STOP_BITS_2;

 PINSEL0 &= 0xFFFCFFFFu;	/*  Set pin P0.8 to I/O.		*/
 IODIR |= 0x100;		/*  Set pin P0.8 to output.		*/

 IOCLR = 0x100u;

	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();

 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\r\n");		/*  It's alive !!		*/


 (void)iprintf( "req, actual\r\n");
 IOSET = 0x100u;
 IOCLR = 0x100u;
 for( i = ((UINT_MAX/10)-50); i < ((UINT_MAX/10)+50); i += 1) {
    unsigned int stop, start;

    IOSET = 0x100u;
    start = T0TC;
    WaitUs( i);
    stop = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("%u,%u\r\n", i,stop - start);
    }
 (void)iprintf("done\r\n");
 while(1) {			/*lint !e716 while(1)			*/
    IOSET = 0x100u;
    IOCLR = 0x100u;
    }
 return( 0);			/*lint !e527 unreachable		*/
 }
