/**************************** test3.c ***********************************/
/* Copyright 2004/01/18 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple timer test program. Use to measure accuracy of WaitUs.	*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test3.c 29-Jan-2004,10:33:22,`RADSETT' First archived version
*   2 test3.c 13-Jul-2004,10:46:20,`RADSETT' Add bell to hello world.
*        Remove unused _impure_ptr arguments
*        lpc_sys.h now included implicitly.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "lpc210x.h"
#include "dev_cntrl.h"
#include "lpc_ioctl.h"

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */


/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 struct serial_param sp;


 (void)SetNativeSpeed( 10000uL);

	/* Desired serial line characteristics 9600,n82			*/
 sp.baud = 9600uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop = UART_STOP_BITS_2;

 PINSEL0 &= 0xFFFCFFFFu;	/*  Set pin P0.8 to I/O.		*/
 IODIR |= 0x100;		/*  Set pin P0.8 to output.		*/

 IOCLR = 0x100u;

	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();

 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\a\r\n");		/*  It's alive !!		*/


 IOSET = 0x100u;
 IOCLR = 0x100u;
 while( 1) {			/*lint !e716				*/
    char buffer[80];
    int value;
    unsigned int start, stop;
    puts("Requested wait?");

    (void)gets( buffer);/*lint !e421*/
    value = atoi(buffer);
    (void)iprintf("wait for %d %u\r\n", value, UsToCounts((unsigned int)value));

    IOSET = 0x100u;
    start = T0TC;
    WaitUs( (unsigned int)value);
    stop = T0TC;
    IOCLR = 0x100u;
    (void)iprintf("waited for %u, %u --> %u\r\n", start, stop, stop - start);
    }

 return( 0);			/*lint !e527 unreachable		*/
 }
