/**************************** test11.c **********************************/
/* Copyright 2005/02/01 Aeolus Development				*/
/*									*/
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*									*/
/*  Simple echo and SPI with FRAM test program.				*/
/************************************************************************/
/*
*   TLIB revision history:
*   1 test11.c 01-Jan-2006,11:21:36,`RADSETT' Original version.
*   2 test11.c 01-Jan-2006,14:21:50,`RADSETT' Add some explanatory comments.
*   TLIB revision history ends.
*/

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/unistd.h>
//#include "lpc210x.h"
#include "lpc_ioctl.h"
#include "fram.h"

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1_int,	/* stdin  */
	&com1_int,	/* stdout */
	&com1_int,	/* stderr */
	&spi,
	0 };		/* end of list */


const char *helwrld = "Hello World\r\n";
FRAM_INSTANCE fram1;
struct device_table_entry fram_table;
SUB_DEVICE_CHAIN sd_inf;

/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 struct serial_param sp;
 struct interrupt_param irq;
 struct spi_param spip;
 FILE *spif;
 int ret;
 char buffer[32];
#if 0
 int i;
 unsigned int wrbytes;
 struct device_select sel;
#endif


 (void)SetNativeSpeed( 10000uL);

	/* Desired serial line characteristics 9600,n82			*/
 sp.baud = 9600uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop = UART_STOP_BITS_2;
 irq.FIQ = 0;
 irq.pri = (INT_PRIORITY)5;


	/*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable);
 (void)VPBControl( VPB_DIV1);
 (void)SetDesiredSpeed( 60000uL);

 (void)ioctl( fileno(stdout), INTERRUPT_SETUP, &irq);
	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();



 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\r\n");		/*  It's alive !!		*/
 
	/* Desired spi line characteristics 1000Hz etc...		*/
 spip.hz = 500000uL;
 spip.cpha = SPI_CPHA_EDGE1;
 spip.cpol = SPI_CPOL_HIGH;
 spip.lsbf = SPI_BIT_DIR_MSBF;
 irq.FIQ = 0;
 irq.pri = (INT_PRIORITY)6;

	/*  Create a sub-device for the FRAM.  The device number of 18	*/
	/* indicates that P0.18 is being used as a chip select.		*/
	/*  fram1 and fram_table are the instance specific information	*/
	/* and device table entry being built up.  sd_inf is the sub	*/
	/* device link that will be used to add the FRAM to the SPI as 	*/
	/* a sub device.						*/
	/*  Note that we call this driver test.				*/
 ret = CreateFRAM(  FM25160, 18u/*device_number*/, "test", &fram1, &fram_table, &sd_inf);
 (void)iprintf( "Create FRAM returns %d\r\n", ret);

	/*  Open up the SPI device to add the FRAM to it.		*/
 spif = fopen( "spi", "r+");
 if( spif == 0) {
    puts( "SPI open error\r\n");	
    }
 else {

    ret = ioctl( fileno(spif), DEVICE_INIT, 0);
    (void)iprintf( "SPI Init on file %d returns %d\r\n", fileno(spif), ret);

	/*  Add the FRAM to the SPI as a sub device.			*/
    ret = ioctl( fileno(spif), DEVICE_ADD, &sd_inf);
    (void)iprintf( "SPI Add device on file %d returns %d\r\n", fileno(spif), ret);

	/* Set up line in case we want to use SPI directly.		*/
    ret = ioctl( fileno(spif), SPI_SETUP, &spip);
    (void)iprintf( "SPI Line Setup on file %d returns %d\r\n", fileno(spif), ret);

	/* Set up interrupt.  Without this the driver won't work.	*/
    ret = ioctl( fileno(spif), INTERRUPT_SETUP, &irq);
    (void)iprintf( "SPI Interrupt Setup returns %d\r\n", ret);
    (void)fflush(stdout);
    (void)setvbuf( spif, 0, _IONBF, 0uL);
    fclose(spif);

	/* OK.  Now we can open the sub-device we just added.  Since it	*/
	/* is a sub-device of spi the name starts off as spi.  spi/test	*/
	/* then refers to the test sub-device of the spi device.	*/
    spif = fopen( "spi/test", "w");
    if( spif == 0) {
         puts( "fram open error\r\n");
         (void)fflush(stdout);
         while( 1) {			/*lint !e716 -e527				*/
              fputc(']', stdout);
              fputc( getchar(), stdout);
              }
	 }
    else {
         puts( "fram open\r\n");
         (void)fflush(stdout);

		/* Initialize the FRAM.  Must be done once per power 	*/
		/* on.							*/
         ret = ioctl( fileno(spif), DEVICE_INIT, 0);
         (void)iprintf( "FRAM Init on file %d returns %d\r\n", fileno(spif), ret);

		/*  Write a simple string to the fram.			*/
         if( fputs(helwrld, spif) == EOF) {
	      puts("could not write fram\r\n");
	      }

	 (void)fflush( spif);
	 fclose( spif);		/*  All done, close the FRAM.		*/
         (void)iprintf( "fram closed\r\n");

		/*  Now re-open the FRAM to read back what was written.	*/
         spif = fopen( "spi/test", "r");
         if( spif == 0) {
              puts( "fram open error\r\n");
              (void)fflush(stdout);
              while( 1) {			/*lint !e716 -e527	*/
                   fputc(']', stdout);
                   fputc( getchar(), stdout);
                   }
	      }
         else {
              puts( "fram open\r\n");
              (void)fflush(stdout);
		/*  Read a buffer full of data.  A few points to 	*/
		/* mention here.					*/
		/*  - Since no terminating 0 was written none will be 	*/
		/*    read back.  This means the read back string may	*/
		/*    contain garbage characters beyond those written 	*/
		/*  - A function like fgets that reads until the EOL	*/
		/*    also appears to read character by character. 	*/
		/*    This will stop reading as soon as the EOL is 	*/
		/*    reached but the overhead of reading a single byte */
		/*    at a time is high.				*/
	      buffer[0] = 0;
	      if( read( fileno(spif), buffer, sizeof(buffer)-(size_t)1) != 0) {
		   buffer[31] = 0;
                   (void)iprintf( "read buffer of %d str len of %d\r\n", sizeof(buffer), strlen(buffer));
                   (void)iprintf( "read from fram [%s]\r\n", buffer);
		   }
	      else {
	           puts("could not read fram\r\n");
		   }
	      fclose( spif);
              (void)iprintf( "fram closed\r\n");
              }
         }
#if 0
    sel.device_number = 8;
    sel.select_action = SELECT_ACTION_INIT;
    ret = ioctl( fileno(spif), DEVICE_SELECT, &sel);
    while( 1) {
         sel.select_action = SELECT_ACTION_SEL;
         ret = ioctl( fileno(spif), DEVICE_SELECT, &sel);
         (void)fputs(helwrld, spif);
	 fflush( spif);
         while( chars_waiting( fileno(spif)) < strlen( helwrld)) {
	      }
         sel.select_action = SELECT_ACTION_DESEL;
         ret = ioctl( fileno(spif), DEVICE_SELECT, &sel);
	 fread( buffer, 1, strlen( helwrld), spif);
         }
#endif
    }

	/*  Two possible ways to end, either sit toggling a pin or run	*/
	/* a simple character echo.					*/
#if 0
 PINSEL0 = 0u;
 IODIR |= 0x100;

 while( 1) {  /*lint !e716*/
    IOSET = 0x100u;
    IOCLR = 0x100u;
    }
#endif

#if 1
 while( 1) {			/*lint !e716				*/
    fputc('>', stdout);
    fputc( getchar(), stdout);
    }
#endif
 return( 0);			/*lint !e527 unreachable		*/
 }
