/*****************************************************************************
 *   uarttest.c:  main C entry file for Philips LPC214x Family Microprocessors
 *
 *   Copyright(C) 2006, Philips Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2005.10.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/

// arm-elf-gcc/WinARM-port by Martin Thomas 
// extern->header, volatiles, startup-gimmik

#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "irq.h"
#include "uart.h"

#include <string.h>

// extern DWORD UART0Count;
// extern BYTE UART0Buffer[BUFSIZE];

static char Hello[]="\r\nHello from the WinARM-Port\r\nHave Fun,\r\nMartin Thomas\r\n";

/*****************************************************************************
**   Main Function  main()
*****************************************************************************/
int main (void)
{
    init_VIC();
    UARTInit(115200);	/* baud rate setting */
	
	U0IER = IER_THRE | IER_RLS;			/* Disable RBR */
	UARTSend( (BYTE*)Hello, strlen(Hello) );
	UART0Count = 0;
	U0IER = IER_THRE | IER_RLS | IER_RBR;	/* Re-enable RBR */
	
    while (1) 
    {				/* Loop forever */
	if ( UART0Count != 0 )
	{
		U0IER = IER_THRE | IER_RLS;			/* Disable RBR */
	    UARTSend( UART0Buffer, UART0Count );
	    UART0Count = 0;
	    U0IER = IER_THRE | IER_RLS | IER_RBR;	/* Re-enable RBR */
	}
    }
    return 0;
}

/*****************************************************************************
**                            End Of File
*****************************************************************************/
