/*****************************************************************************
 *   fiotest.c:  main C entry file for Philips LPC214x Family Microprocessors
 *   
 *   Copyright(C) 2006, Philips Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2005.10.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/

// modified as **** SWI-DEMO **** by Martin Thomas
// to demonstrate SWI-handling:
// interrupts enabled and disabled by SWI-calls


#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "irq.h"
#include "timer.h"
#include "fio.h"

#include "swi.h" /* mthomas */

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
	DWORD counter = 0;
	DWORD loopcounter = 0;
	
	/********* The main Function is an endless loop ***********/	
	init_VIC();
	init_timer();
	
	/* Initialize GPIO pins, default is REGULAR_PORT  */
	GPIOInit( REGULAR_PORT );
	
	/* Initialize timer for GPIO toggling timing */
	enable_timer( 0 );
	
	// startup ends with interrupts disabled
	// the IRQ will be enabled thru a SWI-call:
	IntEnable();
	
	/* From the blink speed of the LED, it won't tell the difference between
	the regular port and fast port unless a scope is applied. This demo is
	show how the regular and fast port should be initialized and the level
	of the port can be changed. */        
	while( 1 ) {
		if ( timer_counter >= 0x20 * counter ) {
			IOSET1 = 1 << (16 + counter);
			counter++;
			if ( counter > 8 ) {
				loopcounter++;
				if ( loopcounter > 2 ) {
					/* stop interrupts after some loop
					-> counter-value will not be updated any longer
					-> no more "blinking"
					*/
					IOCLR1 = 0x00FF0000;
					IOSET1 = 0x00550000;
					IntDisable();  // thru a SWI-call
					loopcounter = 0;
					counter = 0;
					timer_counter = 0;
				}
				else {
					counter = 0;
					timer_counter = 0;
					IOCLR1 = 0x00FF0000;
				}
			} /* if counter > */
		} /* if timer_counter > */
	}

	return 0;

}

/*****************************************************************************
**                            End Of File
*****************************************************************************/

