/*****************************************************************************
 *   rtctest.c:  main C entry file for Philips LPC214x Family Microprocessors
 *
 *   Copyright(C) 2006, Philips Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2005.10.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/

// modified by Martin Thomas

#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "irq.h"
#include "timer.h"
#include "rtc.h"

// extern DWORD alarm_on;

RTCTime local_time, alarm_time, current_time;

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
    init_VIC();

    /* Initialize RTC module */
    RTCInit();

    local_time.RTC_Sec = 0;
    local_time.RTC_Min = 0;
    local_time.RTC_Hour = 0;
    local_time.RTC_Mday = 8;
    local_time.RTC_Wday = 3;
    local_time.RTC_Yday = 8;		/* current date 12/08/2005 00:00:00*/
    local_time.RTC_Mon = 12;
    local_time.RTC_Year = 2005;
    RTCSetTime( local_time );		/* Set local time */

    alarm_time.RTC_Sec = 5;
    alarm_time.RTC_Min = 0;
    alarm_time.RTC_Hour = 0;
    alarm_time.RTC_Mday = 8;
    alarm_time.RTC_Wday = 3;
    alarm_time.RTC_Yday = 8;		/* alarm date 12/08/2005 00:00:05 */
    alarm_time.RTC_Mon = 12;
    alarm_time.RTC_Year = 2005;
    RTCSetAlarm( alarm_time );		/* set alarm time */
   
    /* install RTC timer handler mainly for alarm control */
    if ( install_irq( RTC_INT, (void *)RTCHandler ) == FALSE )
    {
		while ( 1 );		/* very bad happened */
    }

    /* mask off alarm mask, turn on IMYEAR in the counter increment interrupt
    register */
    RTCSetAlarmMask(AMRSEC|AMRMIN|AMRHOUR|AMRDOM|AMRDOW|AMRDOY|AMRMON|AMRYEAR);
    CIIR = IMMIN | IMYEAR;
    /* 12/08/2005 00:00:05 is the alarm on */

	IODIR1 = 0x00FF0000;		/* P1.16..23 defined as Outputs */
    
    RTCStart();

    while (1) 
    {					/* Loop forever */
		if ( alarm_on != 0 )
		{
			alarm_on = 0;
			/* Get current time when alarm is on */
			current_time = RTCGetTime();
			/* light some leds on alarm */
			IOSET1 = 0x00550000;
		}
    }
    return 0;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
