/*****************************************************************************
 *   adctest.c:  main C entry file for Philips LPC214x Family Microprocessors
 *
 *   Copyright(C) 2006, Philips Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2005.10.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/

// modified as a WinARM-example by Martin Thomas:
// Only read one ADC-channel in polled mode and show "led-bar".
// Tested with LPC2138 on MCB2130.

#include "LPC214x.h"                        /* LPC21xx definitions */
#include "type.h"
#include "target.h"
#include "irq.h"
#include "adc.h"


// mthomas:

#include "timer.h"
#include "serial.h"
#include "rprintf.h"

// moved to header-file
// extern DWORD ADC0Value[ADC_NUM], ADC1Value[ADC_NUM];
// extern DWORD ADC0IntDone, ADC1IntDone;

#if ADC_INTERRUPT_FLAG
#error "Interrupt-mode not supported in this gcc-port of the example - TODO"
#endif


const DWORD barpattern[8] = {
	0x00010000,
	0x00030000,
	0x00070000,
	0x000F0000,
	0x001F0000,
	0x003F0000,
	0x007F0000,
	0x00FF0000
};

#define VREF    33/10
#define POTCHAN 1

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
	DWORD i;
	DWORD work, olddispval, mytime;
	
	init_VIC();
	
	/* Initialize ADC  */
	ADCInit( ADC_CLK );
	
	/* Init Timer */
	init_timer();
	enable_timer( 0 );
	mytime = timer_counter;
	
	/* Init UART and rprintf */
	init_serial0(115200);	/* baud rate setting */
	rprintf_devopen( putc_serial0 ); /* init rprintf */
	rprintf("Hello from the ADC Example (gcc-port by Martin Thomas)\n\n");
	
	IODIR1 = 0x00FF0000;		/* P1.16..23 defined as Outputs */

	olddispval = 0xff;
	

	while (1) {

// loops not used here
#if 0

#if ADC_INTERRUPT_FLAG			/* Interrupt driven */

		for ( i = 0; i < ADC_NUM; i++ )
		{
			ADC0Read( i );
			while ( !ADC0IntDone );
			ADC0IntDone = 0;
		}
		for ( i = 0; i < ADC_NUM; i++ )
		{
			ADC1Read( i );
			while ( !ADC1IntDone );
			ADC1IntDone = 0;
		}
	
#else  					/* Polling */
	
		for ( i = 0; i < ADC_NUM; i++ )
		{
			ADC0Value[i] = ADC0Read( i );
		}
		for ( i = 0; i < ADC_NUM; i++ )
		{
			ADC1Value[i] = ADC1Read( i );
		}
#endif

#endif

#if ADC_INTERRUPT_FLAG
		ADC0Read( POTCHAN );
		while ( !ADC0IntDone );
		ADC0IntDone = 0;
#else
		ADC0Value[POTCHAN] = ADC0Read(POTCHAN); // just read AIN1 (Poti MCB2130)
#endif
	
		work = (ADC0Value[POTCHAN] >> 7) & 0x00000007;   // convert to 3-bit value
		if ( work != olddispval ) {
			IOCLR1 = 0x00ff0000;    // clear all LEDs
			IOSET1 = barpattern[work]; // enable LEDs
			olddispval = work;
		}
	
		work = timer_counter;
		if ( (DWORD)(work-mytime) > 0x80 ) {
			mytime = work;
			work = ADC0Value[POTCHAN];
			rprintf("10-bit:% 4lu 3-bit: %lu Voltage: %01u.%04u V\n", 
				work, 
				work>>7,
				(DWORD) (work * VREF) >> 10UL,
				(DWORD) ((work * VREF * 10000UL) >> 10UL) % 10000
			);
		}
	
	} // while

	return 0;
}

/*****************************************************************************
**                            End Of File
*****************************************************************************/

