/**************************** test2.c ***********************************/
/* Copyright 2003/12/29 Aeolus Development                              */ 						
/* Example program.  Feel free to copy and modify as desired.  Please	*/
/* remove Aeolus Development copyright from any modifications (although	*/
/* references to source of the original copy may remain).		*/
/*  Simple echo and timer test program.                                 */
/************************************************************************/
/*
*   TLIB revision history:
*   1 test2.c 30-Dec-2003,10:34:14,`RADSETT' First archival version.
*   2 test2.c 18-Jan-2004,11:10:58,`RADSETT' Update to new form of call to WaitUs
*        (argument change).
*   TLIB revision history ends.
*/

/* Jul04 adopted to WinARM-env. (makefile mainly) and Olimex LPC-P2106: M.Thomas     */
/* Sep04 adopted to newlib-lpc rel3 - mt */


#include <stdio.h>
#include <errno.h>
#include <arch/philips/newlib-lpc/lpc210x.h>
#include <arch/philips/newlib-lpc/dev_cntrl.h>
#include <arch/philips/newlib-lpc/lpc_ioctl.h>
#include <arch/philips/newlib-lpc/lpc_sys.h>

// olimex LPC-P2106: one led on P0.7 (active low)
#define LEDPIN  7

	/**** Device table.  List of device drivers for newlib.	****/
const struct device_table_entry *device_table[] = {
	&com1,	/* stdin  */
	&com1,	/* stdout */
	&com1,	/* stderr */
	0 };	/* end of list */

#if 1
int isatty(int fd)
{
	return 1;
}
#endif

static void ledInit(void)
{
	IODIR |= (1<<LEDPIN);	// define LED-Pin as output
}

static void ledOn(void)
{
	IOCLR=(1<<LEDPIN);
}

static void ledOff(void)
{
	IOSET=(1<<LEDPIN);
}

static void ledOnOff(unsigned char wait)
{
	ledOn();
	if (wait) WaitUs( 1000000u);
	ledOff();
}

/********************* main *********************************************/
/*  main -- program start point.  Simple echo program with some timing	*/
/* tests thrown in.	  						*/
int main( void)
 {
 int i;
 struct serial_param sp;


 (void)SetNativeSpeed( 14746uL );

 /* Desired serial line characteristics 115200,n81			*/
 sp.baud   = 115200uL;
 sp.length = UART_WORD_LEN_8;
 sp.parity = UART_PARITY_NONE;
 sp.stop   = UART_STOP_BITS_1;

 ledInit();

	/*  Quick toggles to show we got started.			*/
 
 for (i=0;i<6;i++) ledOnOff(0);
 
 /*  Set up memory access, CPU and bus speeds.			*/
 (void)SetMAM( 3u, MAM_full_enable );
 (void)VPBControl( VPB_DIV1 );
 (void)SetDesiredSpeed( 60000uL);

	/*  Set up serial port to desired rate.				*/
 (void)ioctl( fileno(stdout), UART_SETUP, &sp);

	/*  Start timer.						*/
 (void)StartClock();

 (void)iprintf( "Minimum Wait %u\r\n", MinimumAchievableWait());

 puts( "Hello World\r\n");		/*  It's alive !!		*/


	/*  Another sequence of toggles.  This time high and low should	*/
	/* be 1 second each for a 20sec total delay.  Should be easily 	*/
	/* measureable to confirm timer operation.			*/
 puts( "Starting wait\r\n");

 for (i=0;i<20;i++) ledOnOff(1);
 
 puts( "End wait\r\n");

	/*  Two possible ways to end, either sit toggling a pin or run	*/
	/* a simple character echo.					*/
#if 0
 PINSEL0 = 0u;
 IODIR |= 0x100;

 while( 1) {  /*lint !e716*/
    IOSET = 0x100u;
    IOCLR = 0x100u;
    }
#endif

#if 1
 while( 1) {			/*lint !e716				*/
    fputc('>', stdout);
    fputc( getchar(), stdout);
    }
#endif
 return( 0);			/*lint !e527 unreachable		*/
 }
