// WinARM RS232 example
// based on the newlib-lpc example "test2"
//
// for WinARM environment and Olimex LPC-2106 test-platform

// M. Thomas <eversmith@heizung-thomas.de>


#include <stdio.h>
#include <errno.h>
/* from newlib-lpc */
#include <arch/philips/newlib-lpc/lpc210x.h>
#include <arch/philips/newlib-lpc/dev_cntrl.h>
#include <arch/philips/newlib-lpc/lpc_ioctl.h>
#include <arch/philips/newlib-lpc/lpc_sys.h>

// olimex LPC-P2106: one led on P0.7 (active low)
#define LEDPIN  7
// olimex LPC-P2106: one switch on P0.31 (active low)
#define SWPIN 	31

/**** Device table.  List of device drivers for newlib.	****/
	const struct device_table_entry *device_table[] = {
		&com1,	/* stdin  */
		&com1,	/* stdout */
		&com1,	/* stderr */
		0 
	};	/* end of list */

#if 1
int isatty(int);

int isatty(int t)
{
	return 1;
}
#endif

static void ledInit(void)
{
	IODIR |= (1<<LEDPIN);	// define LED-Pin as output
	IODIR &= ~(1<<SWPIN);	// define Switch-Pin as input
	IOSET = (1<<LEDPIN);	// set Bit = off (active low)
}

static void delay(void)
{
	volatile int i,j;

	for (i=0;i<100;i++)
		for (j=0;j<1000;j++);
}

static void blink(void)
{
	IOCLR=(1<<LEDPIN);	// set all outputs in mask to 0
	delay();
	IOSET=(1<<LEDPIN);	// set all outputs in mask to 1
	delay();
}

int main(void)
{
	struct serial_param sp;
	// int i;
	char c;
	
	ledInit();

	blink();
	
	SetNativeSpeed(14746uL);
	
	/* Desired serial line characteristics 115200,n81			*/
	sp.baud   = 115200uL;
	sp.length = UART_WORD_LEN_8;
	sp.parity = UART_PARITY_NONE;
	sp.stop   = UART_STOP_BITS_1;

	/*  Set up memory access, CPU and bus speeds.			*/
	SetMAM( 3u, MAM_full_enable);
	VPBControl( VPB_DIV1);
	SetDesiredSpeed( 60000uL);
	
	blink();
	/*  Set up serial port to desired rate.				*/
	(void)ioctl( fileno(stdout), UART_SETUP, &sp);
	blink();
	
	puts("Hello World - WinARM\r\n");
	puts("--------------------\r\n");
	puts("UART0 Echo - type any key\r\n");
	
	while (1) {
		c=getchar();
		blink();
		fprintf(stdout,"Character :%c\r\n",c);
	}

	return 0;
}
