//////////////////////////////////////////////////////////////////////////////
//
// Philips LPC210X ARM7TDMI LED/Switch Example with (a little) C++
//
// This example demonstrates writing to and reading from 
// the GPIO port.
// (1) flash the LED 10 times
// (2) wait for key-press, turn off LED if key is pressed
// (3) simple C++ class
//
// by Martin THOMAS, Kaiserslautern, Germany
// (eversmith@heizung-thomas.de)
//
// based on:
// - GPIO-handling form an example by Rowley Associates Limited
// - C++ handling in startup und linker-script from an example by
//   Anglia Design for ST ARM7 (Spencer Oliver)
//////////////////////////////////////////////////////////////////////////////

#define GLOBALOBJECT
// if definded this demonstrates calling the constructors
// for "global" objects from the startup-code (see crt0.S and *.ld)

#include "lpc210x_gnuarm.h"

// olimex LPC-P2106: one led on P0.7 (active low)
#define LEDPIN  7
// olimex LPC-P2106: one switch on P0.31 (active low)
#define SWPIN 	31

class LedHandler {
private:
	int ledstate;
public:
	LedHandler() { /* constructor */
		GPIO_IODIR |= (1<<LEDPIN);	// define LED-Pin as output
		GPIO_IOSET = (1<<LEDPIN);	// set Bit = LED off (active low)
		ledstate = 1;
	}
	void on() 	{
		GPIO_IOCLR=(1<<LEDPIN);		// clear I/O bit -> LED on (active low)
	}
	void off() 	{
		GPIO_IOSET=(1<<LEDPIN);		// set I/O bit -> LED off
	}
	void showstate() {
		if (ledstate) on();
		else off();
	}
	void setstate(const int newstate) {
		ledstate = newstate;
	}
};

void delay(void )
{
	volatile int i,j;

	for (i=0;i<100;i++)
		for (j=0;j<1000;j++);
}
 
#ifdef GLOBALOBJECT
// #warning "using 'global' LedHandler-Object"
LedHandler lh; 
#endif
 
int main(void)
{
	int i;

	#ifndef GLOBALOBJECT
	// #warning "using 'local' LedHandler-Object"
	LedHandler lh; 
	#endif
		
	MAM_MAMCR = 2;	// MAM functions fully enabled
	
	GPIO_IODIR &= ~(1<<SWPIN);	// define Switch-Pin as input
	
	lh.showstate(); // test state init from contructor
	for (i=0;i<15;i++) delay();
	
	i=0;
	while (i<10)	
	{
		lh.on();
		delay();
		lh.off();
		delay();
		i++;
	}
	
	while (1)	
	{
		if (GPIO_IOPIN & (1<<SWPIN))	{ // true if button released (active low)
			lh.setstate(1);
			lh.showstate();
			// lh.on();   // led on if button is released
		}
		else {
			lh.setstate(0);
			lh.showstate();
			//lh.off();  // led off if button is pressed
		}
	}
	
	return 0; // never reached
}
