/******************************************************************************/
/*  TIMER.C: Time Functions for 10Hz Clock Tick using Timer0                  */
/******************************************************************************/
/*  Inspired by a sample application from Keil Elektronik                     */
/*  A lot of information has been found in a sample from R O Software.        */
/******************************************************************************/
/*  Sample for WinARM by M.Thomas <eversmith@heizung-thomas.de>               */
/******************************************************************************/

#include "lpc210x_gnuarm.h"
#include "config.h"
#include "Timer.h"

#define TxIR_MR0_FLAG        (1<<0)

volatile unsigned long timeval;

/* Timer0 Compare-Match Interrupt Handler (ISR) */
void __attribute__ ((interrupt("IRQ"))) tc0_cmp(void) 
{
	timeval++;
	T0_IR = TxIR_MR0_FLAG; // Clear interrupt flag by writing 1 to Bit 0
	VICVectAddr = 0;       // Acknowledge Interrupt (rough?)
}

