/*---------------------------------------------------------------------------*/
/*-         ATMEL Microcontroller Software Support  -  ROUSSET  -            */
/*---------------------------------------------------------------------------*/
/* The software is delivered "AS IS" without warranty or condition of any    */
/* kind, either express, implied or statutory. This includes without	     */
/* limitation any warranty or condition with respect to merchantability or   */
/* fitness for any particular purpose, or against the infringements of	     */
/* intellectual property rights of others.				     */
/*---------------------------------------------------------------------------*/
/*- File source          : GCC_FLASH.ld                                      */
/*- Object               : Linker Script File for Flash Workspace            */
/*- Compilation flag     : None                                              */
/*-                                                                          */
/*- 1.0 20/Oct/04 JPP    : Creation                                          */
/*---------------------------------------------------------------------------*/

/* 
	modified for the WinARM example - M.Thomas (not Atmel) 
	- ramfunc-section/C++-support and more
*/

/*
//*** <<< Use Configuration Wizard in Context Menu >>> *** 
*/


/*
// <h> Memory Configuration
//   <h> Code (Read Only)
//     <o>  Start <0x0-0xFFFFFFFF>
//     <o1> Size  <0x0-0xFFFFFFFF>
//   </h>
//   <h> Data (Read/Write)
//     <o2> Start <0x0-0xFFFFFFFF>
//     <o3> Size  <0x0-0xFFFFFFFF>
//   </h>
//   <h> Top of Stack (Read/Write)
//     <o4> STACK <0x0-0xFFFFFFFF>
//   </h>
// </h>
*/

/* Memory Definitions */

/* mt change code origin from 0x00000000 */
MEMORY
{
  CODE (rx) : ORIGIN = 0x00100000, LENGTH = 0x00010000
  DATA (rw) : ORIGIN = 0x00200000, LENGTH = 0x00004000
  STACK (rw) : ORIGIN = 0x00204000,LENGTH = 0x00000000
}

__FIRST_IN_RAM = ORIGIN(DATA);

/* Section Definitions */

SECTIONS
{
	/* first section is .text which is used for code */
	. = 0x0000000;
	
	.text :
	{
		KEEP(*(.vectorg))
		. = ALIGN(4);
		KEEP(*(.init))
		*(.text .text.*)                   /* remaining code */
		*(.gnu.linkonce.t.*)
		*(.glue_7)
		*(.glue_7t)
		*(.gcc_except_table)
		*(.rodata)                 /* read-only data (constants) */
		*(.rodata*)
		*(.gnu.linkonce.r.*)
		. = ALIGN(4);
	} >CODE 
	
	. = ALIGN(4);

	/* .ctors section where constructors of global objects are placed */
	.ctors :
	{
		PROVIDE(__ctors_start__ = .);
		KEEP(*(SORT(.ctors.*)))
		KEEP(*(.ctors))
		. = ALIGN(4);
		PROVIDE(__ctors_end__ = .);
		. = ALIGN(4);
	} >CODE
	
	. = ALIGN(4);

	_etext = . ;
	PROVIDE (etext = .);

	/* .data section which is used for initialized data */
	.data : AT (_etext)
	{
	_data = . ;
	KEEP(*(.vectmapped))
	. = ALIGN(4);
	*(.fastrun)
	. = ALIGN(4);
	SORT(CONSTRUCTORS)
	. = ALIGN(4);
	*(.data)
	*(.data.*)
	*(.gnu.linkonce.d*)
	. = ALIGN(4);
	} >DATA
	
	. = ALIGN(4);
	
	_edata = . ;
	PROVIDE (edata = .);
	
	/* .bss section which is used for uninitialized data */
	.bss :
	{
	__bss_start = . ;
	__bss_start__ = . ;
	*(.bss)
	*(.gnu.linkonce.b*)
	*(COMMON)
	. = ALIGN(4);
	} 
	. = ALIGN(4);
	__bss_end__ = . ;
	__bss_end__ = . ;
	_end = .;
	
	. = ALIGN(4);
	
	.int_data :  
	{ 
		*(.internal_ram_top) 
	} > STACK 

	. = ALIGN(4);
	
	PROVIDE (end = .);


  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }

}
