/*
;------------------------------------------------------------------------------
;-         ATMEL Microcontroller Software Support  -  ROUSSET  -
;------------------------------------------------------------------------------
; The software is delivered "AS IS" without warranty or condition of any
; kind, either express, implied or statutory. This includes without
; limitation any warranty or condition with respect to merchantability or
; fitness for any particular purpose, or against the infringements of
; intellectual property rights of others.
;-----------------------------------------------------------------------------
;- File source          : asm_mips.s79
;- Object               : Main loop function can be assembly in ARM or THUMB
;-                        This function read DATA in data area with or without
;-			  Wait state
;-
;- Compilation flag     : None
;-
;- 1.0 02/Jul/04 JPP    : Creation
;
;- 1.0/gcc 9/May/2006 Martin Thomas (not Atmel) : modified for arm-elf-as
;------------------------------------------------------------------------------
*/

#include  "MIPS.mac"

/*
;------------------------------------------------------------------------------
;- Area Definition
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;- Function             : ARM_mips
;- Parameter
;- Treatments           : Infinite loop for measurement in ARM mode
;-                        It is loop of 40 instruction with 3 loss cycle for 
;-			  read external memory (Need know wait state) and one 
;-			  pipeline break
;- Called Functions     : None
;- Called Macros        : MIPS
;------------------------------------------------------------------------------
;- (TC) Counter Clock Disable Command
*/

#if 0
		PROGRAM	?ARM_mips
		RSEG	ICODE:CODE:ROOT(2)
		CODE32	; 
		
		PUBLIC	ARM_mips
ARM_mips:
		MIPS
		ENDMOD
#endif

		.text
		.arm
		.global ARM_mips
		.func   ARM_mips
ARM_mips:
		MIPS
		.endfunc
		
/*
;------------------------------------------------------------------------------
;- Function             : THUMB_mips
;- Parameter
;- Treatments           : Infinite loop for measurement in THUMB mode
;-                        It is loop of 40 instruction with 3 loss cycle for 
;-			  read external memory (Need know wait state) and one 
;-			  pipeline break
;------------------------------------------------------------------------------
*/

#if 0 
        PROGRAM	?THUMB_mips
		RSEG	ICODE:CODE:ROOT(2)
		CODE16	; 		
		PUBLIC	THUMB_mips
THUMB_mips:
                MIPS
		ENDMOD
#endif

		.text
		.thumb
		.global THUMB_mips
		.func THUMB_mips
		.thumb_func
THUMB_mips:
		MIPS
		.endfunc


/*
;------------------------------------------------------------------------------
;- Function             : Ram_ARM_mips
;- Parameter
;- Treatments           : Infinite loop for measurement in ARM mode
;-                        It is loop of 40 instruction with 3 loss cycle for 
;-			  read external memory (Need know wait state) and one 
;-			  pipeline break
;------------------------------------------------------------------------------
*/

#if 0
		PROGRAM	?Ram_ARM_mips
		RSEG	CODE_I:CODE:ROOT(2)
		CODE32	; 
		
		PUBLIC	Ram_ARM_mips
Ram_ARM_mips:
		MIPS
		ENDMOD
#endif

		.section .fastrun,"ax"
//		.section .fastrun,"ax",%progbits
//		.section .fastrun
		.arm
		.global Ram_ARM_mips
		.func Ram_ARM_mips
Ram_ARM_mips:
		MIPS
		.endfunc
		
/*
;------------------------------------------------------------------------------
;- Function             : Ram_THUMB_mips
;- Parameter
;- Treatments           : Infinite loop for measurement in thumb mode
;-                        It is loop of 40 instruction with 3 loss cycle for 
;-			  read external memory (Need know wait state) and one 
;-			  pipeline break
;------------------------------------------------------------------------------	
*/

#if 0
		PROGRAM	?Ram_THUMB_mips
		RSEG	CODE_I:CODE:ROOT(2)
		CODE16	; 		
		PUBLIC	Ram_THUMB_mips
Ram_THUMB_mips:
                MIPS
		ENDMOD
#endif

		.section .fastrun,"ax"
//		.section .fastrun,"ax",%progbits
//		.section .fastrun
		.thumb 
		.global Ram_THUMB_mips
		.func Ram_THUMB_mips
		.thumb_func
Ram_THUMB_mips:
		MIPS
		.endfunc


/*	END */

	.end

