/*********************************************************************

 Author        : ADI - Apps            www.analog.com/MicroConverter

 Date          : Sept. 2005

 File          : blink.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : Blinks LED continuously
		
*********************************************************************/

/* This file has been modified by Martin Thomas,
   see readme.txt. Don't blame ADI if it does not work
   for you. This code has not been tested with the
   hardware. */

#include "aduc7026.h"

// volatile unsigned long dummy = 1UL;  // into .data

static void delay(const unsigned long length)
{
	volatile unsigned long cnt;
	
	cnt = length;
	
	while (cnt > 0) {
    	cnt--;
	}
}

int main(void) 
{	
	GP4DAT = 0x04000000;			// P4.2 configured as an output. LED is turned on	

#if 0
	GP4DAT ^= 0x00040000;		// Complement P4.2
	GP4DAT ^= 0x00040000;		// Complement P4.2
	GP4DAT ^= 0x00040000;		// Complement P4.2
	GP4DAT ^= 0x00040000;		// Complement P4.2
#endif

	while (1) {
		GP4DAT ^= 0x00040000;		// Complement P4.2
		delay(2000000UL);
	}
	
	return 0; /* never reached */
}

