<?
// ------------------------------------------------------------------------
// Based on Wired Community Software's mySQL Code
// (c) Copyright 1999-2000
// Doug Goldstein
// (c) Copyright 2000
// ------------------------------------------------------------------------ 

  include("config.inc.php");

// #########################################################################
// Database class for PostGres functions
// #########################################################################
  class sql {

  // #######################################################################
  // Connect to the database
  // #######################################################################
    function connect() {
      
      global $config;  

      if ($this->dbh == 0) {
   
        $connect = "host=" . $config['dbserver'] . " user= " . $config['dbuser'] . " password=" . $config['dbpass'] . " dbname=" . $config['dbname'];
  
        $this->dbh = pg_connect($connect);
      }
      if (!$this->dbh) {
        $this->not_right("Unable to connect to the database!");
      }
     
    }

  // #######################################################################
  // Grab the error descriptor
  // #######################################################################
    function graberrordesc() {
      $this->error=pg_errormessage($this->dbh);
      return $this->error;
    }

  // #######################################################################
  // Grab the error number
  // #######################################################################
    function graberrornum() {
      
     // PostGres doesn't return a error number as far as I can see (Doug Goldstein)
     
      $this->errornum = 0;
      return $this->errornum;
    }

  // #######################################################################
  // Do the query
  // #######################################################################
    function do_query($query) {
    
      $this->sth = pg_exec($this->dbh,$query);
      if (!$this->sth) {
        $this->not_right("Unable to do_query: $query");
      }

      $this->rownum = 0;

      return $this->sth;
    }

  // #######################################################################
  // Fetch the next row in an array
  // #######################################################################
    function fetch_array($sth) {
      
      $this->row = pg_fetch_array($sth, $this->rownum);

      $this->rownum++;
    
      return $this->row;
    }

  // #######################################################################
  // Finish the statement handler
  // #######################################################################
    function finish_sth($sth) {

      return @pg_freeresult($this->sth);
    }

  // #######################################################################
  // Grab the total rows
  // #######################################################################
    function total_rows($sth) {
      return pg_numrows($this->sth);
    }

  // #######################################################################
  // Die
  // #######################################################################
    function not_right($error) {
      $this->errordesc = pg_errormessage(); 
      echo "Seeya! $this->errordesc";
    }

  }

?>
