<? /* Main functions and classes */
// ------------------------------------------------------------------------
// WWWThreads - PHP
// Wired Community Software
// Rick Baker (rbaker@wcsoft.net)
// (c) Copyright 1999-2000
// ------------------------------------------------------------------------ 

// THIS NEEDS TO BE SET, OTHERWISE ADMIN SCRIPTS WILL NOT WORK
// THIS IS THE ACTUAL PATH TO YOUR PHP INSTALLATION
   $thispath = "/home/httpd/html/wwwthreads.com/php";

  include("$thispath/config.inc.php");
  include("$thispath/$config[dbtype].inc.php");
  include("$thispath/theme.inc.php");

// -------------------------------------
// Strip out all of those pesky slashes
   if ( (is_array($GLOBALS)==1) && (get_magic_quotes_gpc()==1) ){ 
      while( list($key,$value) = each($GLOBALS)) {
         if (is_string($value) == 1) {
            $GLOBALS[$key] = stripslashes($value);
         }
      }
   }

// ---------------------------
// Turn off the magic quoting
   set_magic_quotes_runtime(0);

// ---------------------------------------------------
// If we are using sessions, we start the session here
  if ($config[tracking] == "sessions") {
     session_save_path($config[sessionpath]);
     session_start();
  }

  if (!$w3t_language) {
    $w3t_language = $config[language];
  }
  include("$thispath/languages/$w3t_language/generic.php");

  $dbh = new sql;
  $dbh -> connect();



// ########################################################################
// HTML CLASS
// Define class for sending html
// ######################################################################## 
  class html {
  
  // ###################################################################### 
  // SEND_HEADER FUNCTION
  // Grab the title and send the header
  // ###################################################################### 
    function send_header($inputTitle="",$Cat="",$refresh="",$Username="",$Password="",$bypass="",$user="") {

      global $theme, $config, $lang, $dbh, $thispath, $w3t_myname, $w3t_mypass;  

    // -------------------------------------------------------------------
    // If we don't have a status then they we need to try and authenticate
      if (!$user['U_Status']) {

        $user[U_Username] = $w3t_myname;
        $user[U_Password] = $w3t_mypass;

        $userob = new user;
        $user = $userob -> authenticate($user[U_Username],$user[U_Password],'U_Username, U_Password');
         
      }

    // -----------------------------
    // Grab any personal preferences
      $FrontPage = $user["U_FrontPage"];
      $Privates  = $user["U_Privates"];
      $StyleSheet= $user["U_StyleSheet"];
      $Status    = $user["U_Status"];
      $language  = $user["U_Language"];
      if (!$language) { $language = $config['language']; }
      echo "<HTML><HEAD>";

      if ($refresh) {
        echo "$refresh";
      }

    // -------------------------------------------------------
    // If they don't have a stylesheet pref we use the default
      if (!$StyleSheet) {
        $StyleSheet = $theme['stylesheet'];
      }

    // ----------------------------------------------------
    // For certain languages we need to specify an encoding
      if ($language == "polish") {
        echo "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-2\">";
      }
      elseif ($language == "russian") {
        print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1251\">";
      }
      elseif ($language == "chinese") {
        print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2313\">";
      }
      elseif ($language == "big5") {
        print "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=big5\">";
      }

   // -----------------------
   // include the style sheet
      echo "<link rel=\"stylesheet\" href=\"$config[styledir]/$StyleSheet.css\" type=\"text/css\">";

    // ---------------------------------------------------
    // If we need to include some javascript we do it here
      if ($user["java"]) {
        $javafile = $config['path'] ."/includes/" .$user['java'] .".js";
        readfile("$javafile");
      }

      echo "<TITLE>$inputTitle - $lang[POWERED_BY] WWWThreads PHP</TITLE></HEAD><BODY>";

    // ----------------------------
    // require the header.php file
      echo "<SPAN CLASS=\"onbody\">";
      include "$thispath/includes/header.php";
      echo "</SPAN>";

    // -----------------------------------------------------
    // If the forum is closed the we only let admins proceed
      if ($config['isclosed'] && $user['U_Status'] != "Administrator") {
        $this -> open_table();
        echo "
          <TR CLASS=\"lighttable\">
            <TD>
        ";
        include "$thispath/includes/closedforums.php";
        $this -> close_table();
        exit();
      }
   
      $this->open_table();
      echo "<tr><td align=\"center\" class=\"menubar\">";

    // ----------------------------------------------------
    // If they have private messages we give the PM flasher
      if ($Privates) {
        echo "
          <a href=\"$config[phpurl]/login.php?Cat=$Cat\">
            <img src= \"$config[images]/newpm.gif\" border=0 alt=\"$lang[WEL_PRIV2] $Privates $lang[WEL_PRIV3]\">
          </a>
        "; 
      }

      $spacer = " | ";

    // ----------------------------  
    // Set up the faq file to go to
      $language = "faq_" .$language;

    // ----------------------
    // What is our main page?
      $mainpage = "wwwthreads";
      if ($config['catsonly']) {
        $mainpage = "categories";
      }
      if (!$FrontPage) {
        $FrontPage = $mainpage;
      }

    // ---------------------------------------------------
    // If they aren't logged in they get the standard menu
      $phpurl = $config['phpurl'];
      if ( !$user['U_Username'] || $bypass == 1 ) {
        echo "
          <a href=\"$phpurl/$FrontPage.php?Cat=$Cat\">$lang[FORUM_IND]</a>
          $spacer
          <a href=\"$phpurl/search.php?Cat=$Cat\">$lang[TEXT_SEARCH]</a>
          $spacer
          <a href=\"$phpurl/newuser.php?Cat=$Cat\">$lang[NEW_USER]</a>
          $spacer
          <a href=\"$phpurl/login.php?Cat=$Cat\">$lang[BUTT_LOGIN]</a>
          $spacer
          <a href=\"$phpurl/online.php?Cat=$Cat\">$lang[WHO_ON]</a>
          $spacer
          <a href=\"$phpurl/$language.php?Cat=$Cat\">$lang[FAQ_TEXT]</a>
        ";

      // Since we still want to see non logged in users on the online screen
      // we need to track this by IP
        $IP = getenv ("REMOTE_ADDR");
        $What = getenv ("SCRIPT_NAME");
        $script[0] = "";
        preg_match ("/(.*)\/(.*).php/",$What,$script);
        $What     = $script[2];
        $Last     = time();
        $Username = "-ANON-$IP";
        $What     = addslashes($What);
        $Username = addslashes($Username);

        $query = "
          REPLACE INTO w3t_Online
          (O_Username,O_Last,O_What)
          VALUES ('$Username','$Last','$What')	
        ";
        $dbh -> do_query($query);

      }  

    // Otherwise they are logged in so they get the special menu
      else {

      // ------------------------------
      // Update the who's online screen
        $Username = addslashes($user['U_Username']);
        $What = getenv ("SCRIPT_NAME");
        $script[0] = "";
        preg_match ("/(.*)\/(.*).php/",$What,$script);
        $What     = $script[2];
        $Last     = time();
        $What     = addslashes($What);
        $Username = addslashes($Username);

        $query = "
          REPLACE INTO w3t_Online
          (O_Username,O_Last,O_What)
          VALUES ('$Username','$Last','$What')	
        ";
        $dbh -> do_query($query);

      // ------------------------------------------------------------
      // We need to check for a temporary cookie and if we don't find
      // one then this is their first visit for that browser session
      // so we get rid of the TempRead values in their profile
        if ( !$w3t_visit ) {
          $date = time();
          $query = "
            UPDATE w3t_Users
            SET    U_Laston   = $date,
                   U_TempRead = ''
            WHERE  U_Username = '$Username'
            AND    U_Laston   < ($date - 14300)
          ";
          $dbh -> do_query($query);
        }

        $phpurl = $config['phpurl'];

      // ------------------------------------------------------------------
      // If they are an admin or moderator they get a link to the admin sec
        if ( ($user['U_Status'] == "Administrator") || ($user['U_Status'] == "Moderator") ) {
          echo "
            <a href = \"$phpurl/admin/login.php?Cat=$Cat\">$lang[ADMIN_MENU]</a>
            $spacer
          ";
        }

        echo "
            <a href = \"$phpurl/$FrontPage.php?Cat=$Cat\">$lang[FORUM_IND]</a>
            $spacer
            <a href = \"$phpurl/search.php?Cat=$Cat\">$lang[TEXT_SEARCH]</a>
            $spacer
            <a href = \"$phpurl/editprofile.php?Cat=$Cat\">$lang[EDIT_PROF]</a>
            $spacer
        ";

        if ($config['private']) {
          echo "
            <a href = \"$phpurl/sendprivate.php?Cat=$Cat\">$lang[PRIV_MENU]</a>
            $spacer
          ";
        }

        echo "
            <a href = \"$phpurl/login.php?Cat=$Cat\">$lang[CPRIV_MENU]</a>
            $spacer
            <a href = \"$phpurl/online.php?Cat=$Cat\">$lang[WHO_ON]</a>
            $spacer
            <a href = \"$phpurl/$language.php?Cat=$Cat\">$lang[FAQ_TEXT]</a>
            $spacer
            <a href = \"$phpurl/logout.php?Cat=$Cat\">$lang[LOGOUT_TEXT]</a>
        ";
      }

    // -----------------------------
    // Are we showing the user list?
      if ($config['userlist']) {
        echo "
          $spacer
          <a href=\"$phpurl/showmembers.php?Cat=$Cat&page=1\">$lang[USER_LIST]</a>
        ";
      }

      $this->close_table(); 
      echo "<p>";
    }



  // ####################################################################### 
  // Not right - something went wrong - UHOH!
  // ####################################################################### 
    function not_right($error="",$Cat="",$header="") {

       global $lang,$theme;

       if (!$header) {
          $this -> send_header("$lang[NO_PROCEED]",$Cat,0,0,0,0);
       }
       $this -> table_header($lang[NO_PROCEED]);
       echo "
         <TABLE BORDER=0 WIDTH=\"$theme[tablewidth]\" ALIGN=\"$theme[tablealign]\">
         <TR class=\"cleartable\"><TD>
         <SPAN CLASS=\"onbody\">
         $lang[NO_PROCEED2]:
         </p><p>
         <i>
         $error
         </i>
         </p><p>
         $lang[NO_PROCEED3]
         </p>
         </SPAN>
         </TD></TR></TABLE>
       ";
       $this -> send_footer();
       exit;
    }


  // ####################################################################### 
  // Check_refer 
  // ####################################################################### 
    function check_refer($Cat="") {

      global $config,$lang;

      $valid = 0;       
      $referers = split("\|",$config[referer]);
      for ($i=0; $i <= (sizeof($referers)-1); $i++) {
         if (eregi($referers[$i],getenv('HTTP_REFERER'))) {
           $valid++;
         }
      }
      if (!$valid) {
         $this -> not_right("$lang[NOT_VALID]",$Cat);
      }
    }



  // ####################################################################### 
  // Markup a string 
  // ####################################################################### 
    function do_markup($Body="") {
    
       global $lang,$config;
    // ------------------------
    // Encode bolds and italics
       $Body =eregi_replace("\[b\]","<b>",$Body);
       $Body =eregi_replace("\[i\]","<i>",$Body);
       $Body =eregi_replace("\[\/i\]","</i>",$Body);
       $Body =eregi_replace("\[\/b\]","</b>",$Body);

    // -----------------------
    // Convert the color codes
       $Body =eregi_replace("\[$lang[COLOR_RED]\]","<font color=red>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_RED]\]","</font color=red>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_GREEN]\]","<font color=green>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_GREEN]\]","</font color=green>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_BLUE]\]","<font color=blue>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_BLUE]\]","</font color=blue>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_ORANGE]\]","<font color=orange>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_ORANGE]\]","</font color=orange>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_PURPLE]\]","<font color=purple>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_PURPLE]\]","</font color=purple>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_WHITE]\]","<font color=white>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_WHITE]\]","</font color=white>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_BLACK]\]","<font color=black>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_BLACK]\]","</font color=black>",$Body);
       $Body =eregi_replace("\[$lang[COLOR_YELLOW]\]","<font color=yellow>",$Body);
       $Body =eregi_replace("\[\/$lang[COLOR_YELLOW]\]","</font color=yellow>",$Body);

    // Convert the smileys
       $Body = eregi_replace("\[$lang[ICON_SMILE]\]","<img src=\"$config[images]/icons/smile.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_FROWN]\]","<img src=\"$config[images]/icons/frown.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_BLUSH]\]","<img src=\"$config[images]/icons/blush.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_COOL]\]","<img src=\"$config[images]/icons/cool.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_CRAZY]\]","<img src=\"$config[images]/icons/crazy.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_LAUGH]\]","<img src=\"$config[images]/icons/laugh.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_MAD]\]","<img src=\"$config[images]/icons/mad.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_SHOCKED]\]","<img src=\"$config[images]/icons/shocked.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_TONGUE]\]","<img src=\"$config[images]/icons/tongue.gif\">",$Body); 
       $Body = eregi_replace("\[$lang[ICON_WINK]\]","<img src=\"$config[images]/icons/wink.gif\">",$Body); 

    // -------------
    // Quote markup
       $Body = eregi_replace("\[$lang[TEXT_QUOTE]\]","<blockquote><font class=\"small\">$lang[IN_REPLY]:</font><hr><p>",$Body);
       $Body = eregi_replace("\[/$lang[TEXT_QUOTE]\]","<p><hr></blockquote>",$Body);

    // HTML markup
    // ---------------------------
       $Body = eregi_replace("\[pre\]","<pre>",$Body);
       $Body = eregi_replace("\[/pre\]","</pre>",$Body);

    // ---------------------------
    // Convert url markup -> html
       $Body = preg_replace("/\[url\]http:\/\/([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=http://\\1>http://\\1</a>",$Body);
       $Body = preg_replace("/\[url\]https:\/\/([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=https://\\1>https://\\1</a>",$Body);
       $Body = preg_replace("/\[url\]([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=http://\\1>\\1</a>",$Body);
       $Body = preg_replace("/\[url=http:\/\/(.*?)\]([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=http://\\1>\\2</a>",$Body);
       $Body = preg_replace("/\[url=https:\/\/(.*?)\]([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=https://\\1>\\2</a>",$Body);
       $Body = preg_replace("/\[url=(.*?)\]([^\[]*?)\[\/url\]/","<a target=\"_blank\" href=http://\\1>\\2</a>",$Body);
     

    // ----------------------------
    // Convert email markup -> html
       $Body = eregi_replace("\[$lang[TEXT_EMAIL]\]([^\[]*)\[/$lang[TEXT_EMAIL]\]","<a href=\"mailto:\\1\">\\1</a>",$Body);

    // ---------------------
    // Convert image markup 
       if ($config[allowimages]) {
          $Body = eregi_replace("\[$lang[TEXT_IMAGE]\]http([^\[]*)(.gif|.jpg)\[/$lang[TEXT_IMAGE]\]","<img src=\"http\\1\\2\">",$Body);
       }

       return $Body;

    }


  // ####################################################################### 
  // Remove Markup from a string 
  // ####################################################################### 
    function undo_markup($Body="") {
    
       global $lang,$config;
    // ------------------------
    // Encode bolds and italics
       $Body =eregi_replace("<b>","[b]",$Body);
       $Body =eregi_replace("<i>","[i]",$Body);
       $Body =eregi_replace("</i>","[/i]",$Body);
       $Body =eregi_replace("</b>","[/b]",$Body);

    // -----------------------
    // Convert the color codes
       $Body =eregi_replace("<font color=red>","[$lang[COLOR_RED]]",$Body);
       $Body =eregi_replace("</font color=red>","[/$lang[COLOR_RED]]",$Body);
       $Body =eregi_replace("<font color=green>","[$lang[COLOR_GREEN]]",$Body);
       $Body =eregi_replace("</font color=green>","[/$lang[COLOR_GREEN]]",$Body);
       $Body =eregi_replace("<font color=blue>","[$lang[COLOR_BLUE]]",$Body);
       $Body =eregi_replace("</font color=blue>","[/$lang[COLOR_BLUE]]",$Body);
       $Body =eregi_replace("<font color=orange>","[$lang[COLOR_ORANGE]]",$Body);
       $Body =eregi_replace("</font color=orange>","[/$lang[COLOR_ORANGE]]",$Body);
       $Body =eregi_replace("<font color=purple>","[$lang[COLOR_PURPLE]]",$Body);
       $Body =eregi_replace("</font color=purple>","[/$lang[COLOR_PURPLE]]",$Body);
       $Body =eregi_replace("<font color=white>","[$lang[COLOR_WHITE]]",$Body);
       $Body =eregi_replace("</font color=white>","[/$lang[COLOR_WHITE]]",$Body);
       $Body =eregi_replace("<font color=black>","[$lang[COLOR_BLACK]]",$Body);
       $Body =eregi_replace("</font color=black>","[/$lang[COLOR_BLACK]]",$Body);
       $Body =eregi_replace("<font color=yellow>","[$lang[COLOR_YELLOW]]",$Body);
       $Body =eregi_replace("</font color=yellow>","[/$lang[COLOR_YELLOW]]",$Body);

    // Convert the smileys
       $Body = eregi_replace("<img src=\"$config[images]/icons/smile.gif\">","[$lang[ICON_SMILE]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/frown.gif\">","[$lang[ICON_FROWN]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/blush.gif\">","[$lang[ICON_BLUSH]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/cool.gif\">","[$lang[ICON_COOL]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/crazy.gif\">","[$lang[ICON_CRAZY]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/laugh.gif\">","[$lang[ICON_LAUGH]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/mad.gif\">","[$lang[ICON_MAD]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/shocked.gif\">","[$lang[ICON_SHOCKED]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/tongue.gif\">","[$lang[ICON_TONGUE]]",$Body); 
       $Body = eregi_replace("<img src=\"$config[images]/icons/wink.gif\">","[$lang[ICON_WINK]]",$Body); 

    // -------------
    // Quote markup
       $Body = eregi_replace("<blockquote><font class=\"small\">$lang[IN_REPLY]:</font><hr><p>","[$lang[TEXT_QUOTE]]",$Body);
       $Body = eregi_replace("<p><hr></blockquote>","[/$lang[TEXT_QUOTE]]",$Body);

    // HTML markup
    // ---------------------------
       $Body = eregi_replace("<pre>","[pre]",$Body);
       $Body = eregi_replace("</pre>","[/pre]",$Body);

    // ---------------------------
    // Convert url markup -> html
       $Body = preg_replace("/<a href=\"http:\/\/(.*?)\" target=\"_new\">(.*?)<\/a>/i","[url=\\1]\\2[/url]",$Body);
       $Body = preg_replace("/<a target=\"_blank\" href=(.*?)>(.*?)<\/a>/i","[url=\\1]\\2[/url]",$Body);
     
    // ----------------------------
    // Convert email markup -> html
       $Body = eregi_replace("<a href=\"mailto:([^\[]*)\">","[$lang[TEXT_EMAIL]]\\1[/$lang[TEXT_EMAIL]]",$Body);

    // ---------------------
    // Convert image markup 
       if ($config[allowimages]) {
       //   $Body = eregi_replace("<img src=\"([^\[]*)\">","\[$lang[TEXT_IMAGE]\]\\1\[/$lang[TEXT_IMAGE]\]",$Body);
       }

       return $Body;

    }
   
  // ####################################################################### 
  // Send a table header
  // ####################################################################### 
    function table_header($header="") {

      global $theme;
      $this -> open_table();
      echo "<tr><td class=\"tdheader\">$header";
      $this -> close_table();

    }

  // ####################################################################### 
  // Open a table
  // ####################################################################### 
    function open_table() {
      global $theme;

      echo " 
        <TABLE WIDTH=\"$theme[tablewidth]\" ALIGN=\"$theme[tablealign]\" CELLPADDING=0 CELLSPACING=0 BORDER=0>
          <TR>
            <TD class=\"tableborders\">
              <TABLE CELLPADDING=\"$theme[cellpadding]\" CELLSPACING=\"$theme[cellspacing]\" WIDTH=100% BORDER=0>
      ";
    }

  // ####################################################################### 
  // Close the table
  // ####################################################################### 
    function close_table() {
      echo "
        </TD></TR></TABLE>
        </TD></TR></TABLE>
      ";
    }


  // ####################################################################### 
  // Send the footer
  // ####################################################################### 
    function send_footer() {

      global $config, $theme, $thispath;

      $html = new html;
      echo "<p>";
      $html -> open_table();
      echo "
        <TR class=\"darktable\">
        <TD>
          <TABLE BORDER=0 WIDTH=100% cellpadding=0 cellspacing=0>
          <TR>
            <TD align=left>

              <A HREF=\"$config[homeurl]\">$config[urltitle]</A> |
              <A HREF=\"mailto:$config[emailaddy]\">$config[emailtitle]</a>
            </TD><TD align=right>
              <A HREF=\"http://www.wwwthreads.com\"><FONT class=\"small\">Powered BY WWWThreads 5.1.5<i>php</i></FONT></A>
          </TD></TR></TABLE>
      ";
      $html -> close_table();

      include "$thispath/includes/footer.php";
      echo "
        </BODY>
        </HTML>
      ";
        
    }      

  // ####################################################################### 
  // get_date
  // ####################################################################### 
    function get_date() {
   
      global $config;
      $currtime = time();
      $currtime = $currtime+($config[adjusttime]*3600);
      return $currtime;
    }

  // ####################################################################### 
  // Convert the time
  // ####################################################################### 
    function convert_time($time="",$offset="") {

      global $theme;
      $time = $time+($offset *3600);

      if ($theme['timeformat'] == "short1") {
        $time = date("m/d/y h:i A", $time);
      }
      if ($theme['timeformat'] == "short2") {
        $time = date("d/m/y h:i A", $time);
      }
      if ($theme['timeformat'] == "short3") {
        $time = date("y/m/d h:i A", $time);
      }
      if ($theme['timeformat'] == "short4") {
        $time = date("Y/m/d H:i", $time);
      }


      return $time;

    }

  
  // ####################################################################### 
  // Switch_colors - This will switch colors between the 2 table colors
  // ####################################################################### 
    function switch_colors($color="") {

      if ($color == "lighttable") {
        $color = "darktable";
      }
      else {
        $color = "lighttable";
      }
      return ($color);
    }



  // ####################################################################### 
  // jump box- prints out a jump box to jump to other forums
  // ####################################################################### 
     function jump_box($Cat="",$groupquery="",$Board="") {

       global $dbh, $config, $lang;
       
       if ($Cat) {
         $pattern = ",";
         $replace = " OR Bo_Cat = ";
         $thiscat = ereg_replace($pattern,$replace,$Cat);
         $thiscat = "AND (Bo_Cat = " . $thiscat .")";
       }
       $groupquery = ereg_replace("AND","WHERE",$groupquery);

       $query = "
         SELECT Bo_Number,Bo_Title,Bo_Keyword,Bo_Cat,Bo_CatName,Bo_Sorter
         FROM   w3t_Boards
         $groupquery
         $thiscat
         ORDER BY Bo_Cat,Bo_Sorter
       ";
       $sth = $dbh -> do_query($query);
       echo "
         <FORM METHOD=POST ACTION=\"$config[phpurl]/jumper.php\">
         <INPUT TYPE=HIDDEN NAME=Cat value=\"$Cat\">
         <SPAN CLASS=\"onbody\">$lang[JUMP_TO] </span>
         <SELECT NAME=\"board\" class=\"formboxes\">
       ";

       while ($rows = $dbh -> fetch_array($sth) ) {
         if ($initialcat != "$rows[4]") {
           echo "<option value =\"-CATJUMP-$rows[3]\">*$rows[4]* -----";
           $initialcat = $rows[4];
           $firstpass = 1;
         }
         $selected = "";
         if ($rows[2] == $Board) {
           $selected = "SELECTED";
         }
         echo "<option value=\"$rows[2]\" $selected>&nbsp;&nbsp;&nbsp;$rows[1]";
       }
       $dbh -> finish_sth($sth);
       echo "
         </SELECT>
         <INPUT TYPE=submit name=Jump value=\"$lang[JUMP_TEXT]\" class=\"buttons\">
         </form>

       ";
     }



  // ####################################################################### 
  // Start_page - Logs the user on
  // ####################################################################### 
    function start_page($Username="",$Password="",$Cat="",$Bypass="",$info="") {

      global $theme,$config,$dbh, $lang, $w3t_language, $w3t_myname, $w3t_mypass;
      
    // -----------------------------------------------------
    // Connect to db and get total posts and last logon, etc
      $Username_q = addslashes($Username);
      $query = "
        SELECT U_Username, U_Totalposts, U_Laston, U_Password, U_Sort, U_Display, U_View, U_PostsPer, U_EReplies, U_TextCols, U_TextRows, U_Status, U_StyleSheet, U_Language, U_TempPass, U_TimeOffset, U_Privates, U_FrontPage, U_Groups
        FROM   w3t_Users
        WHERE  U_Username = '$Username_q'
      ";
      $sth = $dbh -> do_query($query);
      $user = $dbh -> fetch_array($sth);
      list($CheckUser,$posts,$laston,$pass,$sort,$display,$view,$postsper,$ereplies,$textcols,$textrows,$status,$stylesheet,$language,$temppass,$offset,$privates,$frontpage,$groups) = $user;
      $dbh -> finish_sth($sth);
 
      if (!$CheckUser) {
        $this -> not_right("$lang[NO_AUTH]",$Cat);
      }

    // -------------------------------------------------------------
    // We allow them to login if they are using the correct password
    // of if they are using the temporary password
      if ( ($Password != $pass) && (crypt($Password,$pass) != $pass) ) {
        $bad = "yes";
      }
      if ($temppass) {
        if (crypt($Password,$temppass) == $temppass) {
          $bad = "no";
        }
      }

      if ($bad == "yes") {
        $this -> send_header("$lang[BAD_PASS]",$Cat,"<META HTTP-EQUIV=\"REFRESH\" CONTENT=\"5;url=$config[phpurl]/logout.php?Cat=$Cat\">",0,0,0);
        $this -> table_header("$lang[BAD_PASS]");
        echo "
          <TABLE BORDER=0 WIDTH=\"$theme[tablewidth]\" align=\"$theme[tablealign]\"><TR><TD>
          $lang[SHORT_RETURN]
          </TD></TR></TABLE>
        ";
        $this -> send_footer();
        exit();
      }

    // --------------------------------------
    // Set a cookie or register a session var
       if ($config[tracking] == "sessions") {
          session_register('w3t_myname');
          session_register('w3t_mypass');
          session_register('w3t_language');
          $w3t_myname = $Username;
          $w3t_mypass = $pass;
          $w3t_language = $language;
       }
       else {
          setcookie("w3t_myname","$Username",time()+31536000);
          setcookie("w3t_mypass","$pass",time()+31536000);
          setcookie("w3t_language","$language",time()+31536000);
       }

    // -----------------------
    // Update last log on time
      $date = $this -> get_date();
      $query = "
        UPDATE w3t_Users
        SET    U_Laston   = $date
        WHERE  U_Username = '$Username_q'
      ";
      $dbh -> do_query($query);

    // ------------------------
    // Now give them their page
      $this -> send_header ("$lang[INTRO_SUB], $Username",$Cat,0,$Username,$pass,0,$user);
      $this -> table_header ("$lang[INTRO_SUB], $Username");

    // ------------------------------------------
    // Get rid of their IP from the online table
      $ip = "-ANON-" . getenv('REMOTE_ADDR');
      $ip_q = addslashes($ip);
      $query = "
        DELETE FROM w3t_Online
        WHERE  O_Username = '$ip_q'
      ";
      $dbh -> do_query($query);

      $lastlogon = $this -> convert_time($laston,$offset);
      $this -> open_table();
      echo "
        <TR CLASS=\"darktable\"><TD>
        <TABLE BORDER=0 WIDTH=100% cellpadding=0 cellspacing=0>
          <TR><TD>
            <a href=\"$config[phpurl]/editprofile.php?Cat=$Cat\"><img src=\"$config[images]/editprofile.gif\" alt=\"$lang[EDIT_PROF]\" border=0></a>
      ";
      if ($config[private]) {
        echo "
            <a href=\"$config[phpurl]/sendprivate.php?Cat=$Cat\"><img src=\"$config[images]/sendprivate.gif\" alt=\"$lang[PRIV_HEAD]\" border=0></a>
        ";
      }
      echo "
        <a href=\"$config[phpurl]/logout.php?Cat=$Cat\"><img src=\"$config[images]/logout.gif\" alt=\"$lang[LOGOUT_TEXT]\" border=0></a>
        <p>
        $lang[LAST_LOGON]: <i>$lastlogon</i><br>
        $lang[YOUR_TOTAL]: <i>$posts</i><br><br>
        <p>$info
      ";

    // ------------------------
    // Set up the proper groups
       $Grouparray = split("-",$groups);
       $gsize = sizeof($Grouparray);
       $groupquery = "AND (";
       $g = 0;
       for ($i=0; $i<=$gsize;$i++) {
          if (!ereg("^[0-9]",$Grouparray[$i])) { continue; };
          $g++;
          if ($g > 1) {
             $groupquery .= " OR ";
          }
          $groupquery .= "Bo_Read_Perm LIKE '%-$Grouparray[$i]-%'";
       }
       $groupquery .= ")";

    // -----------------
    // Give the jump box
       echo "</td><td valign=bottom align=right>";
       $this -> jump_box($Cat,$groupquery);
       echo "</td></tr></table>";

      $this -> close_table();

    // ------------------------
    // Get any private messages
      $query = "
        SELECT M_Status, M_Subject, M_Sender, M_Sent, M_Number
        FROM   w3t_Messages
        WHERE  M_Username = '$Username_q'
        AND    M_Status <> 'X'
        ORDER BY M_Sent DESC
      ";
      $sth = $dbh -> do_query($query);
     
      echo "<p>"; 
      $this -> table_header("$lang[RECEIVED_PM]");
      echo "

        <SCRIPT LANGUAGE=\"JavaScript\">

        <!-- This script and many more are available free online at -->
        <!-- The JavaScript Source!! http://javascript.internet.com -->

        <!-- Begin
          function checkAll(field) {
            for (var j = 0; j <= 100; j++) {
              box = eval(field + j);
              if (box) {
                if (box.checked == false) box.checked = true;
              }
            }
          }
      
          function uncheckAll(field) {
            for (var j = 0; j <= 100; j++) {
              box = eval(field + j);
              if (box) {
                if (box.checked == true) box.checked = false;
               }
            }
          }

          function switchAll(field) {
            for (var j = 0; j <= 100; j++) {
              box = eval(field + j);
              if (box) {
                box.checked = !box.checked;
              }
            }
          }
        //  End -->
        </script>
      ";

      $this -> open_table();
      echo "
        <TR><TD CLASS=\"tdheader\" width=5%>&nbsp;</td>
        <TD CLASS=\"tdheader\" width=\"45%\">$lang[SUBJECT_TEXT]</td>
        <TD CLASS=\"tdheader\" width=\"20%\">$lang[TEXT_FROM]</td>
        <TD CLASS=\"tdheader\" width=\"25%\">$lang[TEXT_REC]</td>
        <TD CLASS=\"tdheader\" width=\"5%\">$lang[TEXT_DELETE]</td></tr>
        <FORM method=post action=\"$config[phpurl]/delete.php\">
        <INPUT TYPE=hidden name=Cat value=\"$Cat\">
      ";

    // -------------------------------------------------------------------
    // We need to keep track of the number of new private messages just in
    // case this number ever gets dorked up (yes, that's a technical term)
      $totalnew = 0;
      $i = 0;
      while ($rows = $dbh -> fetch_array($sth) ) {
        list($read,$subject,$sender,$when,$number) = $rows;
        $senton = $this -> convert_time($when,$offset);
        if ($read == "$lang[TEXT_NEW]") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_NEW]</td>";
        }
        elseif ($read == "$lang[TEXT_REPLIED]") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_REPLIED]</td>";
        }
        elseif ($read == "C") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_NEW]</td>";
        }
        else {
          echo "<tr class=\"lighttable\"><td>&nbsp;</td>";
        }

        $encsender = rawurlencode($sender);
 
    // --------------------------------------------------------------------
    // If this is a new post (N or C) then we need to add this to the value
    // so delete.php knows that this was a new message.
    // Also increment the total number of new private messages by 1
       $formvalue = $number;
       if ( ($read == "N") || ($read == "C") ) {
         $formvalue = $number . "-NEW";
         $totalnew++;
       }

       echo "
         <td><a href=\"$config[phpurl]/viewmessage.php?Cat=$Cat&message=$number&status=$read\">$subject</a></td>
         <td><a href=\"$config[phpurl]/showprofile.php?Cat=$Cat&User=$encsender&what=login\">$sender</a></td>
         <td>$senton</td>
         <td><input type=checkbox name=\"$i\" value=\"$formvalue\" class=\"formboxes\"></td>
       ";
       $i++;
     }
     $dbh -> finish_sth($sth);

     echo "<tr class=\"darktable\"><td colspan=5 align=right>";
     echo "<input type=hidden name=total value = $i>";
     if ($i) {
       echo "
         <input type=submit name=option value=\"$lang[DELETE_CHECK]\" class=\"buttons\">
       ";
     }
     $this -> close_table();
     echo "</form><br>";

    // --------------------------------------
    // Get any private messages (CC Messages)
      $query = "
        SELECT M_Status, M_Subject, M_Sender, M_Sent, M_Number
        FROM   w3t_Messages
        WHERE  M_Username = '$Username_q'
        AND    M_Status = 'X'
        ORDER BY M_Sent DESC
      ";
      $sth = $dbh -> do_query($query);
     
      echo "<p>"; 
      $this -> table_header("$lang[SENT_PM]");
      $this -> open_table();
      echo "
        <TR><TD CLASS=\"tdheader\" width=5%>&nbsp;</td>
        <TD CLASS=\"tdheader\" width=\"45%\">$lang[SUBJECT_TEXT]</td>
        <TD CLASS=\"tdheader\" width=\"20%\">$lang[SENT_TO]</td>
        <TD CLASS=\"tdheader\" width=\"25%\">$lang[SENT]</td>
        <TD CLASS=\"tdheader\" width=\"5%\">$lang[TEXT_DELETE]</td></tr>
        <FORM method=post action=\"$config[phpurl]/delete.php\">
        <INPUT TYPE=hidden name=Cat value=\"$Cat\">
      ";

      $i = 0;
      while ($rows = $dbh -> fetch_array($sth) ) {
        list($read,$subject,$sender,$when,$number) = $rows;
        $senton = $this -> convert_time($when,$offset);
        $encsender = rawurlencode($sender);

        if ($read == "$lang[TEXT_NEW]") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_NEW]</td>";
        }
        elseif ($read == "$lang[TEXT_REPLIED]") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_REPLIED]</td>";
        }
        elseif ($read == "C") {
          echo "<tr class=\"lighttable\"><td>$lang[TEXT_NEW]</td>";
        }
        else {
          echo "<tr class=\"lighttable\"><td>&nbsp;</td>";
        }
 
       $formvalue = $number;
       echo "
         <td><a href=\"$config[phpurl]/viewmessage.php?Cat=$Cat&message=$number&status=$read\">$subject</a></td>
         <td><a href=\"$config[phpurl]/showprofile.php?Cat=$Cat&User=$encsender&what=login\">$sender</a></td>
         <td>$senton</td>
         <td><input type=checkbox name=\"$i\" value=\"$formvalue\" class=\"formboxes\"></td>
       ";
       $i++;
     }
     $dbh -> finish_sth($sth);

     echo "<tr class=\"darktable\"><td colspan=5 align=right>";
     echo "<input type=hidden name=total value = $i>";
     if ($i) {
       echo "
         <input type=submit name=option value=\"$lang[DELETE_CHECK]\" class=\"buttons\">
       ";
     }
     $this -> close_table();
     echo "</form><br><br>";

   // --------------------------------------------------------------------
   // If the total number of new privates in their profile doesn't match
   // the total we just counted, then we update it
     if ($privates != $totalnew) {
       $query = "
         UPDATE w3t_Users
         SET    U_Privates = $totalnew
         WHERE  U_Username = '$Username_q'
       ";
       $dbh -> do_query($query);
     }
  
     $this -> send_footer();
 
    }


  // ####################################################################### 
  //  Send_messages
  // ####################################################################### 
     function send_message($Sender="",$To="",$Subject="",$Mess="") {

       global $lang,$dbh, $config;
       $Sender_q  = addslashes($Sender);
       $To_q      = addslashes($To);
       $Subject_q = addslashes($Subject);
       $Mess_q    = addslashes($Mess);
       $date      = $this -> get_date();
       $Status_q  = $lang[TEXT_NEW];

    // FInd out if we are sending to a group of users
       $admin_q = "Administrator";
       $mod_q   = "Moderator";
       $user_q  = "User";

       if ($To == "ADMIN_GROUP") {
         $selector = "WHERE U_Status = '$admin_q'";
       }
       elseif ($To == "MODERATOR_GROUP") {
         $selector = "WHERE U_Status = '$mod_q'";
       }
       elseif ($To == "A_M_GROUP") {
         $selector = "WHERE U_Status = '$admin_q' OR U_Status = '$mod_q'";
       }
       elseif ($To == "ALL_USERS") {
         $selector = "";
       }
       else {
         $selector = "WHERE U_Username = '$To_q'";
       }

    // ------------------------------------
    // Grab everyone we are sending this to
       $query = "
         SELECT DISTINCT U_Username, U_Status
         FROM w3t_Users
         $selector
       ";
       $sth = $dbh -> do_query($query);
       while (list($To,$Status) = $dbh -> fetch_array($sth)) {
         
       // Increment the recipients total number of unread pms
          $To_q = addslashes($To);
          $query = "
            UPDATE w3t_Users
            SET    U_Privates = U_Privates + 1
            WHERE  U_Username = '$To_q'
          ";
          $dbh -> do_query($query);

       // INSERT DEPENDS ON AUTO_INCREMENT OR SEQUENCE
          if ($config[dbtype] == "mysql") {
             $query = "
                INSERT INTO w3t_Messages(M_Username,M_Status,M_Subject,M_Sender,M_Message,M_Sent)
                VALUES ('$To_q','$Status_q','$Subject_q','$Sender_q','$Mess_q','$date')
             ";
             $dbh -> do_query($query);
          }
          else {
             $seq = "nextval('M_seq')";
             $query = "
                INSERT INTO w3t_Messages(M_Username,M_Status,M_Subject,M_Sender,M_Message,M_Sent)
                VALUES ('$seq','$To_q','$Status_q','$Subject_q','$Sender_q','$Mess_q','$date')
             ";
             $dbh -> do_query($query);
          }
      }
      $dbh -> finish_sth($sth);
    }
    
  }

// ########################################################################
// USER CLASS 
// Define a class for the user object
// ########################################################################
  class user {

  // ###################################################################### 
  // AUTHENTICATE FUNCTION
  // Authenticate the user
  // ######################################################################
    function authenticate($Username="", $Password="", $Query="") {

      global $dbh, $HTTP_COOKIE_VARS;

      if (!$Username) {
        $Username = $w3t_myname;
      }
      if (!$Password) {
        $Password = $w3t_mypass; 
      }
      if (!$Query) {
        $Query = "*";
      }
    // -----------------------------------------------------------------
    // We are automatically adding StyleSheet, Status, Privates and
    // FrontPage to each SQL call because this information is needed by
    // every script that makes a call to authenticate
      else {
        $Query .= ", U_StyleSheet, U_Status, U_Privates, U_FrontPage";
      }
      $Username = addslashes($Username);
      $Password = addslashes($Password);
      $query = $dbh -> do_query("SELECT $Query FROM w3t_Users WHERE U_Username = '$Username' AND U_Password = '$Password'");
      $this->user = $dbh -> fetch_array($query);
      $dbh -> finish_sth($query);
      return $this->user;

    }

  // ####################################################################### 
  // Check_ban 
  // ####################################################################### 
    function check_ban($Username="",$Cat="") {

       global $lang,$dbh;
       $Hostname = getenv('REMOTE_ADDR');
       $Username_q = addslashes($Username);
       $Hostname_q = addslashes($Hostname);

       $query = "
          SELECT B_Hostname,B_Username,B_Reason
          FROM   w3t_Banned
          WHERE  B_Username='$Username_q' OR B_Hostname = '$Hostname_q'
       ";
       $sth = $dbh -> do_query($query);
       list ($Checkuser,$Checkhost,$Reason) = $dbh -> fetch_array($sth);
       $dbh -> finish_sth($sth);
       if ( ($Checkuser) || ($Checkhost) ) {
          $html = new html;
          $html -> not_right("$lang[YOU_BANNED]: $Reason", $Cat);
       }
    }




  }
      
?>
