#!/usr/bin/perl 
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Wired Community Software
#    Rick Baker rbaker@wcsoft.net
#    (c) Copyright 1999-2000
###########################################################################
package w3t;

require Exporter;
@ISA = qw (Exporter);
@EXPORT = qw(@EXPORT_OK);

@EXPORT_OK = qw($dbh $VERSION %lang);

use strict;
use w3tvars qw(%config);
use vars qw($dbh $VERSION %lang);

$w3t::VERSION = "5.1";

# Some versions of perl are barking about the DBI and statement handlers
# For now, we are just turning these off.
# Uncomment this if you are getting DBI and statement handler errors in
# your error log.
#$SIG{'__WARN__'} = sub { };
# Uncomment this if you want to send cgi errors to the browser
$SIG{'__WARN__'} = \&cgi_error;

require "$config{'path'}/languages/$config{'language'}.pl";

###########################################################################
# Start of the main subroutines
###########################################################################

###########################################################################
# get_date: returns a date in seconds
###########################################################################
sub get_date {

  my ($currtime)=time();
  my ($adjust)=$currtime+($config{'adjusttime'}*3600);
  return $adjust;

}


###########################################################################
# convert_time: converts the time to a useable format
# $time = time in seconds : $offset = user's time offset in hours
###########################################################################
sub convert_time {
  my ($time,$offset); 
  ($time,$offset) = @_;
  $time = $time+($offset * 3600);
  $time = localtime($time);
  if($config{'timeformat'} =~/^short/) {

    my @tarray = split(/ +/,$time);
    my %months = (
      "Jan" => 1,
      "Feb" => 2,
      "Mar" => 3,
      "Apr" => 4,
      "May" => 5,
      "Jun" => 6,
      "Jul" => 7,
      "Aug" => 8,
      "Sep" => 9,
      "Oct" => 10,
      "Nov" => 11,
      "Dec" => 12
    );
    my $year = substr($tarray[4],2,2);
    my ($hour,$min,$sec) = split(/:/,$tarray[3]);
    my $AMPM;
    if ($hour >= 12) {
      $AMPM = "PM";
      if ($hour > 12) {
        $hour = $hour-12;
        if ($hour < 10) {
          $hour = "0$hour";
        }
      }
    }
    else {
      $AMPM = "AM";
    }

    if ($tarray[2] < 10) {
      $tarray[2] = "0$tarray[2]";
    }
    if ($months{$tarray[1]} < 10) {
      $months{$tarray[1]} = "0$months{$tarray[1]}";
    }

    if ($config{'timeformat'} eq "short1") {
      $time = "$months{$tarray[1]}/$tarray[2]/$year $hour:$min $AMPM";
    }
    elsif ($config{'timeformat'} eq "short2") {
      $time = "$tarray[2]/$months{$tarray[1]}/$year $hour:$min $AMPM";
    }
    elsif ($config{'timeformat'} eq "short3") {
      $time = "$year/$months{$tarray[1]}/$tarray[2] $hour:$min $AMPM";
    }
    elsif ($config{'timeformat'} eq "short4") {
      my ($hour,$min,$sec) = split(/:/,$tarray[3]);
      $year = $year + 2000;
      $time = "$tarray[2].$months{$tarray[1]}.$year $hour:$min";
    }
  }
  return $time;

}


###########################################################################
# Connects to the database.
###########################################################################
sub db_connect{

  if (!$ENV{'MOD_PERL'}) {
    require DBI;
  }

  if ($config{'dbdriver'} eq "Pg") {
    $dbh = DBI -> connect("DBI:$config{'dbdriver'}:dbname=$config{'dbname'}", "$
config{'dbuser'}", "$config{'dbpass'}")
    or die "Can't connect to sql server.  Reason: $DBI::errstr";
  }
  elsif ($config{'dbdriver'} eq "Oracle") {
    $dbh = DBI -> connect("DBI:$config{'dbdriver'}:$config{'dbname'}","$config{'dbuser'}", "$config{'dbpass'}")
    or die "Can't connect to sql server.  Reason: $DBI::errstr.";
  }
  else {
    $dbh = DBI -> connect("DBI:$config{'dbdriver'}:$config{'dbname'}:$config{'dbserver'}", "$config{'dbuser'}", "$config{'dbpass'}")
    or die "Can't connect to sql server.  Reason: $DBI::errstr";
  }

  if (!$ENV{'MOD_PERL'}) {
    $dbh->{'Warn'} = 0;
  }

}


###########################################################################
# Disconnects from the database
###########################################################################
sub db_disconnect{

   defined $dbh and
    ($dbh->disconnect or die "Can't disconnect from database. Reason: $DBI::errstr" and undef $dbh);

}



1;
