#!/usr/bin/perl 
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Rick Baker scream@screamingweb.com 
#    Copyright 1999 
###########################################################################

  BEGIN {
    unshift(@INC, "/home/httpd/html/wwwthreads.com/php/cron/");
  }
  use w3tvars qw(%config);
  use w3t qw($dbh %lang);

  use strict;
  use Mailer;


# -----------------------
# Connect to the database
  w3t::db_connect();


# ---------------------------------------------- 
# First we grab all boards that have subscribers
  my $query = qq!
    SELECT DISTINCT S_Board
    FROM   w3t_Subscribe
  !;
  my $sth = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
  $sth -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";
  my $rows = $sth -> rows;


# ----------------------------------------------------------------
# Now we have the boards we need to cycle through the subscribers 
  for (my $j = 0;$j < $rows; $j++ ) {
    my ($Board) = $sth -> fetchrow_array;
    my $Board_q       = $dbh -> quote($Board);

    my $query = qq!
      SELECT Bo_Title
      FROM   w3t_Boards
      WHERE  Bo_Keyword = $Board_q
    !;
    my $sta = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
    $sta -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";
    my ($Title) = $sta -> fetchrow_array;


    my $query = qq!
      SELECT S_Username,S_Last
      FROM   w3t_Subscribe
      WHERE  S_Board = $Board_q
    !;
    my $sti = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
    $sti -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";
    my $userrows = $sti -> rows;
 

    # ---------------------------------------------------------
    # Now that we have all the users we need to cycle through 
      for (my $k = 0; $k < $userrows; $k++) {

        # ---------------------------------------
        # Now we need to grab their email address
          my ($Username,$Last)   = $sti -> fetchrow_array;
          my $Username_q = $dbh -> quote($Username);
          my $query = qq!
            SELECT U_Email,U_TimeOffset
            FROM   w3t_Users
            WHERE  U_Username = $Username_q
          !;
          my $stj = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
          $stj -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";
          my ($Email,$TimeOffset) = $stj -> fetchrow_array;

        # ------------------------------
        # Now we grab all the posts info 
          my $Keyword_q = $dbh -> quote($Board);
          my $query = qq!
            SELECT   B_Number,B_Posted,B_Username,B_IP,B_Subject,B_Body
            FROM     w3t_Posts 
            WHERE    B_Number > $Last
            AND      B_Approved = 'yes'
            AND      B_Board = $Keyword_q
            ORDER BY B_Number ASC
          !;
          my $stk = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
          $stk -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";
          my $postrows = $stk -> rows;
          my $seperator = "----------------------------------------------------------------------\n";
          my $message  = "$lang{'SUB_DESC1'} '$Title'.  $lang{'SUB_DESC2'}\n$seperator$seperator\n";  

        # ------------------------------------------------------
        # Only send out an email if there are posts for the day
          if($postrows > 0){


          # --------------------------------------------------------
          # Now we cycle through the posts and append to the message
            my ($Number,$PPosted,$PUsername,$PIP,$PSubject,$PBody);
            for (my $l =0; $l < $postrows; $l++) {
              ($Number,$PPosted,$PUsername,$PIP,$PSubject,$PBody) = $stk -> fetchrow_array;
              $message = $message .   "$lang{'SUBJECT_TEXT'}:   $PSubject\n";
              $message = $message .   "$lang{'POSTER_TEXT'}:    $PUsername\n";
              my $date = w3t::convert_time($PPosted,$TimeOffset);
              $message = $message .   "$lang{'POSTON_TEXT'}: $date\n";
              $PBody =~s /<br>/\n/g;
              if ($config{'stripcodes'} eq "on") {
                $PBody =~ s/<([^>])*>//g;
              }
              $message = $message . "\n$PBody\n\n";
              $message = $message . "$seperator$seperator\n";
    
            }

          # ------------------------------------
          # Now we need to update the last entry
            my $query = qq!
              UPDATE w3t_Subscribe
              SET    S_Last = $Number
              WHERE  S_Board = $Board_q 
              AND    S_Username = $Username_q
            !;
            my $rc = $dbh -> do($query) or die "Can't execute query: $query.  Reason: $DBI::errstr";


             my $mailer = new Mailer ( { smtp => $config{'SMTP'}, sendmail => $config{'sendmail'} } ) or die "Can't init: $Mailer::error";
             my $to   = $Email;
             my $from = $config{'emailaddy'};
             my $subject = "$lang{'SUB_INTRO'} $Title";
             $mailer -> send( {to => $to, from => $from, subject => $subject, msg => $message} ) or die "Can't mail message: $Mailer::error";

          }

      } 

  }

  $sth -> finish;
  w3t::db_disconnect(); 
