#!/usr/bin/perl 
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Rick Baker scream@screamingweb.com 
#    Copyright 1999 
###########################################################################
  BEGIN {
    unshift(@INC, "/home/httpd/perl/modules");
  }
  use w3ttheme qw(%theme);
  use w3tvars qw(%config);
  use w3t qw($dbh %lang);

  use strict;


# -----------------------
# Connect to the database
  w3t::db_connect();


# ----------------------------------------------------
# First we grab the board keywords and the expire time
  my $query = qq!
    SELECT Bo_Keyword,
           Bo_Expire
    FROM   w3t_Boards
    WHERE  Bo_Expire <> 0
  !;
  my $sth = $dbh -> prepare($query) or die "Query syntax error: $query.  Reason: $DBI::errstr";
  $sth -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";


# ----------------------------------------------------------
# Now we cycle through all the boards that have an expire set
  while (my ($Keyword,$Expires) = $sth -> fetchrow_array) {
  # Now we cycle through all the threads and grab all the main posts that 
  # are older than the expiration date
    my $currtime   = w3t::get_date();
    my $expiretime = $currtime - ($Expires * 86400);
    my $Kept_q     = $dbh -> quote("K");
    my $Keyword_q  = $dbh -> quote($Keyword);
    my $query = qq!
      SELECT B_Number,
             B_Main 
      FROM   w3t_Posts 
      WHERE  B_Main      = B_Number
      AND    B_Kept      <> $Kept_q
      AND    B_Last_Post < $expiretime
      AND    B_Board     = $Keyword_q
    !;
    my $sti = $dbh -> prepare($query) or die "Query syntax error: $query.  Reason: $DBI::errstr";
    $sti -> execute() or die "Can't execute query: $query.  Reason: $DBI::errstr";

  # -------------------------------------------------
  # Now we cycle through these threads and purge them
  # and remove them from the keywords table
    my $Keyword_q = $dbh -> quote($Keyword);
    my $totalexpired = 0;
    my $totalthreads = 0;
    my $Approved;
    my $totalna = 0;
    while( my($Mnumber,$Main) = $sti -> fetchrow_array) {

    # ---------------------------------------------------------------------
    # Find out if there are any files to delete and if the post is approved
      my $query = qq!
        SELECT B_Number
        FROM   w3t_Posts 
        WHERE  B_Main  = $Mnumber
        AND    B_Board = $Keyword_q
      !;
      my $sta = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
      $sta -> execute() or die "Can't execute query: $query. Reason: $DBI::errstr.";
      while ( my($checkee) = $sta -> fetchrow_array) {
        my $query = qq!
          SELECT B_File,
                 B_Approved,
                 B_Poll
          FROM   w3t_Posts 
          WHERE  B_Number = $checkee
          AND    B_Board  = $Keyword_q
        !;
        my $stk = $dbh -> prepare($query) or die "Query syntax error: $query. Reason: $DBI::errstr";
        $stk -> execute() or die "Can't execute query: $query. Reason: $DBI::errstr.";
        my($filename,$Approved,$Poll) = $stk -> fetchrow_array;
        if ($filename) {
          unlink("$config{'files'}/$filename");
        }
      # ------------------------------------------
      # If we have a poll for this post, delete it
        if ($Poll) {
          $Poll = $dbh -> quote($Poll);
          my $query = qq!
            DELETE FROM w3t_Polls
            WHERE  P_Name = $Poll
          !;
          $dbh -> do($query) or die "Can't do $query.  Reason: $DBI::errstr.";
        }    
        if ($Approved eq "no") {
          $totalna++;
        }

      }

      my $query = qq!
        DELETE FROM w3t_Posts 
        WHERE B_Main  = $Mnumber  
        AND   B_Board = $Keyword_q
      !;
      my $rc = $dbh -> do($query) or die "Can't execute query: $query.  Reason: $DBI::errstr";
      
      $totalexpired = $totalexpired + ($rc - $totalna);
      $totalthreads++;

    }

  # ---------------------------------------------
  # Now we update the board to set the total posts
    my $Keyword_q = $dbh -> quote($Keyword);

    my $query = qq!
      UPDATE w3t_Boards
      SET Bo_Total = Bo_Total - $totalexpired,
          Bo_Threads = Bo_Threads - $totalthreads
      WHERE Bo_Keyword = $Keyword_q
    !;
    my $rc = $dbh -> do($query) or die "Can't execute query: $query.  Reason: $DBI::errstr";
  

  }
  


  $sth -> finish;
  w3t::db_disconnect(); 
