<?
// ------------------------------------------------------------------------
// WWWThreads - PHP
// Wired Community Software
// Rick Baker (rbaker@wcsoft.net)
// (c) Copyright 1999-2000
// ------------------------------------------------------------------------
// Require the library
   require ("main.inc.php");  

# Postgres handles the INT type differently.  So we need to prepare for this
  $int4  = "INT(4) UNSIGNED";
  $int9  = "INT(9) UNSIGNED";
  $int11 = "INT(11) UNSIGNED";
  $int1  = "INT(1) UNSIGNED";

# Althout Oracle currently isn't supported, this is here for future versions
# Oracle uses VARCHAR2 instead of VARCHAR and does not have TEXT
  $varchar = "varchar";
  $text    = "text";

  if ($config[dbtype] == "postgres") {
    $int4  = "INT4";
    $int9  = "INT4";
    $int11 = "INT4";
    $int1  = "INT4";
  }
  elseif ($config[dbtype] == "Oracle") {
    $int4    = "NUMBER(4)";
    $int9    = "NUMBER(9)";
    $int11   = "NUMBER(11)";
    $int1    = "NUMBER(1)";
    $varchar = "VARCHAR2";
    $text    = "VARCHAR(4000)"; # Oracle8 allows 4000, Oracle 7 allows 2000
  }

#
# Figure out if the SQL server supports AUTO INCREMENT
  $autoincs = "";

  if ($config[dbtype] == 'mysql') {
    $autoincs = "AUTO_INCREMENT";
  }

##################### The Board Table ##############################

echo "Creating the tables...<br>";

# Some versions of mysql don't like INDEXes to be created outside of
# the main table creation.
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ",UNIQUE indx1 (Bo_Keyword), INDEX indx2 (Bo_Number)";
  }

# Create the Board Table
  $query = " 
CREATE TABLE w3t_Boards(
	Bo_Title $text,
	Bo_Description $text,
	Bo_Keyword $varchar(100) NOT NULL,
	Bo_Moderator $varchar(30),
	Bo_Total $int9,
	Bo_Last $int11,
	Bo_HTML $varchar(3) DEFAULT 'On' NOT NULL,
	Bo_Markup $varchar(3) DEFAULT 'On' NOT NULL,
	Bo_Number $int9 DEFAULT '0' $autoincs PRIMARY KEY,
        Bo_Created $int11,
        Bo_Expire $int4,
        Bo_Approve $varchar(3) DEFAULT 'Off' NOT NULL,
        Bo_Moderated $varchar(3) DEFAULT 'no',
        Bo_Cat $int4 DEFAULT '1' NOT NULL,
	Bo_Read_Perm $varchar(250) DEFAULT '-3-4-',
	Bo_Write_Perm $varchar(250) DEFAULT '-3-4-',
        Bo_Threads $int9 unsigned DEFAULT '0',
        Bo_Sorter $int4,
        Bo_CatName $varchar(255)
	$indexes
)";

  $dbh -> do_query($query);
  echo "Board table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE UNIQUE INDEX indx1 ON w3t_Boards (Bo_Keyword)");
  }

  
  if (!$autoincs) {
    $query = "
      CREATE SEQUENCE Bo_seq
    ";
    $dbh -> do_query($query);
  }

############################## The Posts Table    ###################

  $index1 = "w3t_Posts"."index1";
  $index2 = "w3t_Posts"."index2";
  $index3 = "w3t_Posts"."index3";
  $index4 = "w3t_Posts"."index4";
  $index5 = "w3t_Posts"."index5";
  $index6 = "w3t_Posts"."index6";
  $index7 = "w3t_Posts"."index7";
  $index8 = "w3t_Posts"."index8";
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX $index1 (B_Parent,B_Board), INDEX $index2 (B_Number, B_Board), INDEX $index3 (B_Main, B_Board), INDEX $index4 (B_Status,B_Board), INDEX $index5 (B_Kept,B_Board), INDEX $index6 (B_Board), INDEX $index7 (B_Approved,B_Board), INDEX $index8 (B_Posted, B_Board)";
  }
  $query = "
    CREATE TABLE w3t_Posts (
      B_Board $varchar(100) NOT NULL,
      B_Number $int11 $autoincs PRIMARY KEY,
      B_Parent $int11 NOT NULL,
      B_Main $int11 NOT NULL,
      B_Posted $int11 NOT NULL,
      B_Last_Post $int11 DEFAULT '0' NOT NULL,
      B_Username $varchar(30),
      B_IP $varchar(60),
      B_Subject $text,
      B_Body $text,
      B_Mail $int1,
      B_File $varchar(100),
      B_Kept $varchar(1) NOT NULL,
      B_Status $varchar(1) NOT NULL,
      B_Approved $varchar(3) DEFAULT 'yes' NOT NULL,
      B_Picture $varchar(100),
      B_Icon $varchar(30),
      B_Color $varchar(10),
      B_Reged $varchar(1) DEFAULT 'y',
      B_UTitle $varchar(50),
      B_Counter $int9 DEFAULT '0',
      B_Sticky $int11,
      B_Replies $int4 DEFAULT '0',
      B_Poll $varchar(200),
      B_ParentUser $varchar(20),
      B_UStatus $varchar(1)
      $indexes
  )
  ";   
    $dbh -> do_query($query);

  if ($config[dbtype] != "mysql") {
    $dbh ->do_query ("CREATE INDEX $index1 ON w3t_Posts (B_Parent,B_Board)");
    $dbh ->do_query ("CREATE INDEX $index2 ON w3t_Posts (B_Main,B_Board)");
    $dbh ->do_query ("CREATE INDEX $index3 ON w3t_Posts (B_Number,B_Board)");
    $dbh ->do_query ("CREATE INDEX $index4 ON w3t_Posts (B_Status, B_Board)");
    $dbh ->do_query ("CREATE INDEX $index5 ON w3t_Posts (B_Kept ,B_Board)");
    $dbh ->do_query ("CREATE INDEX $index6 ON w3t_Posts (B_Board)");
    $dbh ->do_query ("CREATE INDEX $index7 ON w3t_Posts (B_Approved,B_Board)");
    $dbh ->do_query ("CREATE INDEX $index8 ON w3t_Posts (B_Posted,B_Board)");
  }

# ---------------------------------------------------------------
# If we aren't doing AUTO INCREMENT then we need to do a sequence
  if (!$autoincs) {
    $seq = "w3t_Posts"."_seq";
    $query = "
      CREATE SEQUENCE $seq
    ";
    $dbh -> do_query($query);
  } 

  echo "Posts table created...<br>";

########################## The polls table ################################
  echo "Adding a master poll table...<br>";
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX pollndx (P_Name)";
  }
  $query = "
    CREATE TABLE w3t_Polls (
      P_Name $varchar(200) NOT NULL,
      P_Title $varchar(200),
      P_Option $varchar(200),
      P_Number $int4
      $indexes
    )
  ";
    $dbh -> do_query($query);
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query("CREATE INDEX pollndx ON w3t_Polls (P_Name)");
  } 

  echo "Adding the poll results table...<br>";
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX pollndx2(P_Name)";
  }
  $query = "
    CREATE TABLE w3t_PollData (
      P_Name $varchar(200) NOT NULL,
      P_Number $int4,
      P_IP $varchar(25)
      $indexes
    )
  ";
    $dbh -> do_query($query);
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query("CREATE INDEX pollndx2 ON w3t_PollData (P_Name)");
  } 

########################## Last viewed table ##############################
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX Last_indx (L_Board,L_Username)";
  }

  $query = "
    CREATE TABLE w3t_Last(
      L_Board $varchar(100) NOT NULL,
      L_Username $varchar(30) NOT NULL,
      L_Last $int11
      $indexes
    )
  ";
    $dbh -> do_query($query);

  if ($config[dbtype] != "mysql") {
    $dbh -> do_query("CREATE INDEX Last_indx ON w3t_Last (L_Board,L_Username)");
  }
  echo "Last viewed table created...<br>"; 

############################## The Category Table ###################

  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ",INDEX indx1 (Cat_Title), INDEX indx2 (Cat_Number)";
  }
  $query = "
    CREATE TABLE w3t_Category(
      Cat_Title $varchar(120) DEFAULT 'General Discussion' NOT NULL,
      Cat_Number $int9 DEFAULT '0' NOT NULL,
      Cat_Description $text
      $indexes
    )
  ";
    $dbh -> do_query($query);
  echo "Category table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX catindx1 ON w3t_Category (Cat_Title)");
    $dbh -> do_query ("CREATE INDEX catindx2 ON w3t_Category (Cat_Number)");
  }

  $query = "
    INSERT INTO w3t_Category VALUES ('General Discussion',1,'Forums for general discussion')
  ";
  $dbh -> do_query ($query);


############################## The User Table ########################
$indexes = "";
if ($config[dbtype] == "mysql") {
  $indexes = ",INDEX indx1 (U_Username, U_Password), INDEX indx2 (U_Status), INDEX indx3 (U_Number)";
}

# Create the User Table
  $query = "
CREATE TABLE w3t_Users(
	U_Username $varchar(30) NOT NULL,
	U_Password $varchar(30) NOT NULL,
	U_Email $varchar(50),
	U_Fakeemail $varchar(50),
        U_Name $varchar(100),
	U_Totalposts $int9,
	U_Laston $int11,
	U_Signature $text,
	U_Homepage $varchar(150),
	U_Occupation $varchar(150),
	U_Hobbies $varchar(200),
	U_Location $varchar(200),
	U_Bio $text,
	U_Status $varchar(15) DEFAULT 'User' NOT NULL,
        U_Sort $int4,
        U_Display $varchar(10) NOT NULL,
        U_View $varchar(10) NOT NULL,
        U_PostsPer $int11,
        U_Number $int9 $autoincs PRIMARY KEY,
        U_EReplies $varchar(3) NOT NULL,
        U_Notify $varchar(3) NOT NULL,
        U_TextCols $varchar(3),
        U_TextRows $varchar(3),
        U_Extra1 $varchar(200),
        U_Extra2 $varchar(200),
        U_Extra3 $varchar(200),
        U_Extra4 $varchar(200),
        U_Extra5 $varchar(200),
        U_Post_Format $varchar(5) NOT NULL,
        U_Registered $int11,
        U_Preview $varchar(5),
        U_Picture $varchar(150),
        U_PictureView $varchar(3),
	U_Visible $varchar(3) DEFAULT 'yes',
        U_PicturePosts $varchar(3),
	U_AcceptPriv $varchar(3) DEFAULT 'yes',
    	U_RegEmail char(50),
    	U_RegIP char(15),
	U_Groups $varchar(250) DEFAULT '-1-',
        U_Language $varchar(20),
        U_Title $varchar(100),
        U_FlatPosts $varchar(2),
        U_TempPass $varchar(30),
        U_Color $varchar(15),
        U_TempRead $text,
        U_StyleSheet $varchar(50),
        U_TimeOffset $varchar(10),
        U_Privates $int4 DEFAULT '0',
        U_FrontPage $varchar(20)
	$indexes
)";

  $dbh -> do_query ($query);
  echo "Users table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX Uindx1 ON w3t_Users (U_Username,U_Password)");
    $dbh -> do_query ("CREATE INDEX Uindx2 ON w3t_Users (U_Status)");
  }

  if (!$autoincs) {
    $query = "
      CREATE SEQUENCE U_seq
    ";
    $dbh -> do_query($query);
  }

######################## BoModerators table #############################
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ",INDEX Modindx1 (Mod_Username,Mod_Board)";
  }
  $query = "
    CREATE TABLE w3t_Moderators (
	Mod_Username $varchar(30) NOT NULL,
	Mod_Board $varchar(100) NOT NULL
	$indexes
    )
  ";
  $dbh -> do_query($query);
  echo "Moderator table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX Modindx1 ON w3t_Moderators (Mod_Username,Mod_Board)");
  }

######################## Private Message Table ##########################

# Create the Private Messages Table
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ",INDEX Messindx1 (M_Username, M_Status)";
  }
  $query = "
CREATE TABLE w3t_Messages(
	M_Username $varchar(30) NOT NULL,
	M_Status $varchar(1) DEFAULT 'N' NOT NULL,
	M_Subject $varchar(60),
	M_Sender $varchar(30),
	M_Message $text,
	M_Sent $int11,
	M_Number $int9 $autoincs PRIMARY KEY
	$indexes
)";

  $dbh -> do_query ($query);
  echo "Messages table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX Messindx1 ON w3t_Messages (M_Username,M_Status)");
  }

  if (!$autoincs) {
    $query = "
      CREATE SEQUENCE M_seq
    ";
    $dbh -> do_query($query);
  }


############################ The Banned Table ###########################

  $query = "
CREATE TABLE w3t_Banned(
	B_Username $varchar(60) NOT NULL,
	B_Hostname $varchar(60) NOT NULL,
	B_Reason $text
)";

  $dbh -> do_query ($query);
  echo "Banned table created...<br>";


################################### The Groups Table ##################
  $query = "
    CREATE TABLE w3t_Groups (
      G_Name $varchar(250),
      G_Id $int4 $autoincs PRIMARY KEY
    )
  ";
  $dbh -> do_query ($query);
  echo "Groups table created";

  if (!$autoincs) {
    $query = "
      CREATE SEQUENCE group_seq
    ";
    $dbh -> do_query ($query);
  }

  $extra;
  $cols = "(G_Name)";
  if ($config[dbtype] == 'Oracle') {
    $extra = ",Group_seq.nextval";
    $cols = "(G_Name,G_Id)";
  }
  elseif ($config[dbtype] == 'postgres') {
    $extra = ",nextval('Group_seq')";
    $cols = "(G_Name,G_Id)";
  }
  $query = "
    INSERT INTO w3t_Groups $cols VALUES ('Administrators'$extra)
  ";
  $dbh -> do_query ($query);
  $query = "
    INSERT INTO w3t_Groups $cols VALUES ('Moderators'$extra)
  ";
  $dbh -> do_query ($query);
  $query = "
    INSERT INTO w3t_Groups $cols VALUES ('Users'$extra)
  ";
  $dbh -> do_query ($query);
  $query = "
    INSERT INTO w3t_Groups $cols VALUES ('Guests'$extra)
  ";
  $dbh -> do_query ($query);
  echo "Basic groups created...<br>"; 

################################### The Online Table ##################
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ",UNIQUE Oindx1 (O_Username), INDEX Oindx2 (O_Last)";
  }

  $query = "
  CREATE TABLE w3t_Online(
    O_Username $varchar(64) NOT NULL,
    O_Last $int9 DEFAULT '0' NOT NULL,
    O_What $varchar(64)
    $indexes
  )
  ";
  $dbh -> do_query ($query);
  echo "Online table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE UNIQUE INDEX Oindx1 ON w3t_Online (O_Username)");
    $dbh -> do_query ("CREATE INDEX Oindx2 ON w3t_Online (O_Last)");
  }

################################### The Subscribe Table ##################
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX Subindx1 (S_Board,S_Username)";
  }
  $query = "
    CREATE TABLE w3t_Subscribe(
	S_Username $varchar(60) NOT NULL,
	S_Board $varchar(100) NOT NULL,
        S_Last $int9
        $indexes
  )";

  $dbh -> do_query ($query);
  echo "Subscribe table created...<br>";

# ------------------
# Create the indexes
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX Subindx1 ON w3t_Subscribe (S_Board,S_Username)");
  }

# -----------------------
# Create the address book
  echo "Creating table for the address book...<br>";
  $indexes = "";
  if ($config[dbtype] == "mysql") {
    $indexes = ", INDEX address_ndx1 (Add_Owner)";
  }
  $query = "
    CREATE TABLE w3t_AddressBook (
      Add_Owner $varchar(30) NOT NULL,
      Add_Member $varchar(30)
      $indexes
    )
  ";
  $dbh -> do_query($query);
  if ($config[dbtype] != "mysql") {
    $dbh -> do_query ("CREATE INDEX address_ndx1 ON w3t_AddressBook (Add_Owner)");
  } 


echo " 
<br>
All tables created.
<br>
<br>

Don't forget to visit <a href=\"http://www.wwwthreads.com/resourcecenter/InUse
\">the WWWThreads In Use section</a> to add your site to the list of sites running WWWThreads.

<br>
<br>
You are required to keep all Powered By links intact when running this demo version.  You may purchase the full version and keep any forums/users/posts/messages created intact when upgrading from the demo version.
<br>
<br>

Visit <a href=\"newuser.php\">the newuser script</a> to create your main admin user.  Be sure to choose this name and email carefully as this will be your permanent main administrator.
<br>
<br>

Thanks,
<br>
Scream (Rick Baker scream@wwwthreads.com)
<br>

";

