<?
// ------------------------------------------------------------------------
// WWWThreads - PHP
// Wired Community Software
// Rick Baker (rbaker@wcsoft.net)
// (c) Copyright 1999-2000
// ------------------------------------------------------------------------

// Require the library
   require ("main.inc.php");
   require ("languages/$lang[THIS_FILE]/categories.php");

// -----------------
// Get the user info
   $Username = $w3t_myname;
   $Password = $w3t_mypass;

   $userob = new user;
   $user = $userob -> authenticate("$Username","$Password","U_Username, U_Password, U_Groups, U_TimeOffset, U_FrontPage"); 

// ---------------
// send the header
   $html = new html;
   $html -> send_header("$config[title]",$Cat,0,$Username,$Password,0,$user);

// ------------------------------------------------------------------------
// If they are logged in then we check their groups, otherwise they
// get set to the guest group 
   $Groups = $user['U_Groups'];
   if (!$Groups) {
     $Groups = "-4-";
   }  
  
// ------------------------------------
// Are we just looking at one category?
   $catsonly = $user['U_FrontPage'];
   $main     = "wwwthreads";
   if ($config['catsonly']) {
      $main = "categories";
   }
   if (!$catsonly) {
      $catsonly = $main;
   }
 
// -----------------------------------------------------------------
// If we have a Cat variable then we need to set it up for the query
   if ($Cat) {
     $pattern = ",";
     $replace = " OR Cat_Number = ";
     $catonly = ereg_replace($pattern,$replace,$Cat);
     $catonly = "WHERE Cat_Number = " . $catonly;
   }

// ------------------------------------
// Links for posts of the last few days
   if ($catsonly == "categories") {
      echo "<p>";
      $html -> open_table();
      echo "
         <tr class=\"cleartable\">
           <td width=55%>
             <b>$lang[VIEW_PAST]</b>
           </td>
           <td class=\"cleartable\" width=15% align=\"center\"><a href=\"$config[phpurl]/dosearch.php?Cat=$Cat&Forum=All_Forums&Words=&Match=Entire+Phrase&Old=1day&Limit=25\">$lang[PAST24]</a></td>
           <td class=\"cleartable\" width=15% align=\"center\"><a href=\"$config[phpurl]/dosearch.php?Cat=$Cat&Forum=All_Forums&Words=&Match=Entire+Phrase&Old=2days&Limit=25\">$lang[PAST48]</a></td>
           <td class=\"cleartable\" align=\"center\"><a href=\"$config[phpurl]/dosearch.php?Cat=$Cat&Forum=All_Forums&Words=&Match=Entire+Phrase&Old=1week&Limit=25\">$lang[PAST7]</a>
      ";
      $html -> close_table();
      echo "<p>";
  }                                                                 

// ----------------------------------------------------------------------
// Lets see how many total registered users there are but only if we want
// to display this information
   if ($config['showreg']) {
      $sth = $dbh->do_query("SELECT COUNT(*) FROM w3t_Users");
      $registered = $dbh -> fetch_array($sth);
      $showreg = "$registered[0] $lang[REGED_USERS]";
      $dbh -> finish_sth($sth);
   }  

// -----------------------------------------------------------------------
// Print the html for the number of registered users but only display if we
// want to 
   echo "
     <TABLE BORDER=0 WIDTH=\"$theme[tablewidth]\" align=\"$theme[tablealign]\" cellpadding=0 cellspacing=0>
       <TR>
         <TD ALIGN=LEFT class=\"welcome\">
           $showreg
         </TD><TD ALIGN=RIGHT class=\"welcome\">
   ";

   if ($user['U_Username']) {
      echo "$lang[INTRO_SUB], $user[U_Username]";
   }
   else {
      echo $lang['WEL_PRIV_NO'];
   }

   echo "</TD></TR></TABLE>"; 

// --------------------------
// Get the list of categories
   $query = "
     SELECT DISTINCT Cat_Title,Cat_Number,Cat_Description
     FROM   w3t_Category
     $catonly
     ORDER BY Cat_Number
   ";
   $categories = $dbh -> do_query($query);
   $j = 0; 

// -------------------------------------------------
// Open up a table to surround all of the categories
   $html -> open_table();
   echo "
     <tr>
      <td class=\"tdheader\">
        $lang[CAT_TEXT] 
      </td><td width=12% align=center class=\"tdheader\">
        $lang[CAT_FORUMS] 
      </td><td width=12% align=center class=\"tdheader\">
        $lang[THREAD_TEXT] 
      </td><td width=12% align=center class=\"tdheader\">
        $lang[POSTS_TEXT] 
      </td></tr>
  ";

// ----------------------------
// Cycle through the categories
   $forumtotal=0;
   $threadtotal=0;
   $posttotal=0;
   $shownew=0;
   while (list ($CatTitle,$CatNumber,$CatDescription) = $dbh -> fetch_array($categories)) {

  // ------------------------------------------------------------
  // This variable let's us know if there were any boards in this
  // category that were visible to the user.  As soon as we come
  // across a board that they can see, it gets set to "yes"
     $table_done = "no";
     $k=0;

  // --------------------------------------------------------------
  // We need to format a SQL query to see what boards this user can
  // view
      $Grouparray = split("-",$Groups);
      $gsize = sizeof($Grouparray);
      $groupquery = "AND (";
      $g = 0;
      for ($i=0; $i<=$gsize;$i++) {
         if (!ereg("^[0-9]",$Grouparray[$i])) { continue; };
         $g++;
         if ($g > 1) {
            $groupquery .= " OR ";
         }
         $groupquery .= "Bo_Read_Perm LIKE '%-$Grouparray[$i]-%'";
      }
      $groupquery .= ")";


  // ---------------------------------------
  // Grab all of the boards in this category
     $query = "
      SELECT Bo_Keyword,Bo_Total,Bo_Last,Bo_Threads,Bo_Moderated
      FROM   w3t_Boards
      WHERE  Bo_Cat     = '$CatNumber'
      $groupquery
     ";
     $boards = $dbh -> do_query($query);

  // ---------------------------------------------
  // Now cycle through the boards in this category
     $firstpass = 0;
     while (list($Keyword,$Total,$Last,$Threads,$Moderated) = $dbh -> fetch_array($boards)) {
    
    // --------------------------------------------
    // On the first pass through we open up a table
       if (!$firstpass) {
          echo "
            <tr>
              <td class=\"lighttable\">
                <span class=\"forumtitle\">
                  <a href=\"$config[phpurl]/wwwthreads.php?Cat=$Cat&C=$CatNumber\">$CatTitle</a>
                </span>
              <br>
              <table cellpadding=0 cellspacing=0>
                <tr>
                  <td>
                    &nbsp;&nbsp;&nbsp;
                  </td>
                  <td class=\"forumdescript\">
                    $CatDescription
                  </td>
                </tr>
              </table> 
              </td>
            ";
            $firstpass = 1;
         }

      // ---------------------------------------------------------------
      // If they are a normal user then they can only see approved posts
         $Viewable = "And B_Approved = 'yes'";
         if ($user[Status] == "Administrator") {
            $Viewable = "";
         }
         if ($user[Status] == "Moderator") {
         // ---------------------------------
         // Check if they moderate this board
            $Username_q = addslashes($Username);
            $Board_q    = addslashes($Keyword);
            $query = "
              SELECT Mod_Board
              FROM   w3t_Moderators
              WHERE  Mod_Username = '$Username_q'
              AND    Mod_Board    = '$Board_q'
            ";
            $sti = $dbh -> do_query($query);
            list($check) = $dbh -> fetch_array($sti);
            $dbh -> finish_sth($sti);
            if ($check) {
               $Viewable = "";
            }
         }

      // --------------------------------------------------
      // Check if the are new posts since they last visited
         if ($Username) {
            $Username_q  = addslashes($Username);
            $Board_q     = addslashes($Keyword);
            $query = "
              SELECT L_Last 
              FROM   w3t_Last  
              WHERE  L_Username = '$Username_q'
              AND    L_Board    = '$Board_q'
            ";
            $sti = $dbh -> do_query($query);
            list($checker) = $dbh -> fetch_array($sti);
            $dbh -> finish_sth($sti);
            if (!$checker) {
               $checker = 0;
            }

         // --------------------------------------------------------------
         // Let's see how many new posts there are.  We have to do some
         // tricky AND/OR operations because we don't want sticky posts to
         // be counted as new if they aren't.
            $newposts;
            $newthreads;
            $query = "
              SELECT COUNT(*)
              FROM   w3t_Posts 
              WHERE  ( (B_Posted > $checker AND B_Posted <> 4294967295 )
              OR       (B_Posted = 4294967295 AND B_Sticky > $checker) )
              $Viewable 
              AND    B_Board = '$Board_q'
            ";
            $newp = $dbh -> do_query($query);
            list($newposts) = $dbh -> fetch_array($newp);
            $dbh -> finish_sth($newp);
            if ( ($checker < $Last) && ($Username) ) {
               $shownew = $shownew + $newposts;
            }

         // -----------------------------------------------------------
         // If we have new posts let's see how many new threads we have
            if ($newposts) {
               $query = "
                 SELECT COUNT(*)
                 FROM   w3t_Posts 
                 WHERE  ( (B_Posted > $checker AND B_Posted <> 4294967295)
                 OR       (B_Posted = 4294967295 AND B_Sticky > $checker) )
                 $Viewable 
                 AND    B_Board = '$Board_q'
                 AND    B_Main  = B_Number
               ";
               $newt = $dbh -> do_query($query);
               list($newthreads) = $dbh -> fetch_array($newt); 
               $dbh -> finish_sth($newt);
            }
            if ( ($checker < $Last) && ($Username) ) {
               $shownewt = $shownewt + $newthreads;
            }

         // --------------------------------------
         // Let's see how many NA posts there are
            if ( ($Moderated == "yes") && ($Viewable == "") ) {
               $query = "
                 SELECT COUNT(*)
                 FROM   w3t_Posts 
                 WHERE  B_Approved = 'no' 
                 AND    B_Board    = '$Board_q'
               ";
               $notapp = $dbh -> do_query($query);
               $notapproved = $dbh -> fetch_array($notapp); 
               $dbh -> finish_sth($notapp);
            }
            $showna = $showna + $notapproved;
         }
         $threadtotal = $threadtotal+$Threads;
         $forumtotal++;
         $posttotal = $posttotal + $Total;

      }
      $dbh -> finish_sth($boards);

      if ($shownew) {
         $shownew = "<br><font class=\"new\">($shownew $lang[NEW_TEXT])</font>";
      } else {
         $shownew = "";
      }
      if ($shownewt) {
         $shownewt = "<br><font class=\"new\">($shownewt $lang[NEW_TEXT])</font>";
      } else {
         $shownewt = "";
      }

      echo "
        <td class=\"darktable\" align=center>
          $forumtotal
        </td><td class=\"lighttable\" align=center>
          $threadtotal
          $shownewt
        </td><td class=\"darktable\" align=center>
          $posttotal
          $shownew
      ";

      if ($showna) {
         echo " <font class=\"new\">($showna $lang[NOT_APPROVED])</font>";
      }
      echo "
         </td></tr> 
      ";
      $forumtotal = 0;
      $threadtotal = 0;
      $posttotal = 0;
      $shownew = "";
      $shownewt = "";
      $showna = "";
    }

   $dbh -> finish_sth($categories);

  echo "</table></td></tr></table>";
  $html -> send_footer();
