<?
// ------------------------------------------------------------------------
// WWWThreads - PHP
// Wired Community Software
// Rick Baker (rbaker@wcsoft.net)
// (c) Copyright 1999-2000
// ------------------------------------------------------------------------


// Require the library
   require ("main.inc.php");
   require ("languages/$lang[THIS_FILE]/adduser.php");   
   $html = new html;

   $Username = $Loginname;
   $Password = $Loginpass; 

// --------------------------------------------------------
// If we are checking age, we make sure they are old enough
   if ( ($config[checkage] == 'on') && ($age == "no")) {
      $html -> not_right("$lang[TOOYOUNG]",$Cat);
   }

// ----------------------------------
// No special characters
   if ($config[specialc] == "off") { 
      if (!preg_match("/^\w+$/",$Username)) {
         $html -> not_right("$lang[BAD_UNAME]",$Cat);
      } 
   }
   else {
   // ----------------------------------
   // No html characters in the username
      if ( (ereg("&nbsp;",$Username)) || ( ereg("<",$Username)) || (ereg(">",$Username)) || (ereg("^ ",$Username)) || (ereg(" $",$Username)) ) {
         $html -> not_right("$lang[BAD_UNAME]",$Cat);
      }  
   }

// ------------------------------------------------------------
// If all required info is not filled in, then we can't proceed 
   if((!$Username)||(!$Email)){
      $html -> not_right("$lang[ALL_FIELDS]",$Cat);
   }

// -------------------------------------------------------------
// If the Username isn't the proper length then we can't proceed  
   if((strlen($Username) >16) || (strlen($Username) < 3)) {
      $html -> not_right("$lang[LONG_NAME]",$Cat);
   }

// --------------------------------------
// Let's see if the email domain is valid
   $bademails = file ("$config[path]/filters/bademail");
   while (list($linenum,$line) = each($bademails)) {
      chop;
      if ( (ereg("^\n",$line)) || (ereg("^\r",$line)) || (ereg("^#/",$line)) ) {
         continue; 
      }
      if (ereg($Email,$line)) {
         $html -> not_right("$lang[BAD_EMAIL] $_.",$Cat);
      }
   } 

// --------------------------------------------
// Check to make sure the Username is available
   $Username_q = addslashes($Username);
   $query = " 
     SELECT U_Username
     FROM   w3t_Users
     WHERE  U_Username = '$Username_q'
   ";
   $sth = $dbh -> do_query($query);
   list ($check) = $dbh -> fetch_array($sth);
   $dbh -> finish_sth($sth);
 
// ----------------------------------------------------------
// If sql returned a row then that username is already in use.
   if( $check ) {
      $html -> not_right("$lang[USER_EXISTS]",$Cat);
   }

// -------------------------------------
// Lets see if it is a reserved Username
   $badnames = file ("$config[path]/filters/badnames");
   while (list($linenum,$line) = each($badnames)) {
      if (ereg("^#",$line)) {
         continue;
      }
      chop ($line);
      if (strtolower($Username) == strtolower($line)) {
         $html -> not_right("$lang[USER_EXISTS]",$Cat);
      }
   }

// ---------------------------------------------------------------------
// If we do not allow multiple usernames for the same email address then
// we need to see if this email address is in the database
   if ($config[multiuser] == "off" ) {
      $Email_q = addslashes($Email);
      $query = " 
        SELECT U_Email
        FROM   w3t_Users
        WHERE U_Email = '$Email_q'
        OR U_RegEmail = '$Email_q'
      "; 
      $sth = $dbh -> do_query($query);
      list($emailcheck) = $dbh -> fetch_array($sth);
      $dbh -> finish_sth($sth);
      if($emailcheck){
         $html -> not_right("$lang[NO_MULTI]",$Cat);
      }
   } 


// --------------------------------------
// Check to see if this is the first user
   $query = " 
    SELECT U_Username
    FROM   w3t_Users
   ";
   $sth = $dbh -> do_query($query);
   list ($firstuser) = $dbh -> fetch_array($sth);
   $dbh -> finish_sth($sth);
   $Groups = "-3-";

// -------------------------------------------------------
// If this is the first user, then status is Administrator
// otherwise they are just get normal user status.
   $Color = " ";
   if (!$firstuser){
      $Status = "Administrator";
      $Groups .= "1-";
      $Color  = $theme[admincolor];
   } else {
      $Status = "User";
   } 

// ---------------------
// Set the default title
   $titles = file ("$config[path]/filters/usertitles");
   list($post,$utitle) = split("\t",$titles[0]);
   chop($utitle);
   $Title_q = addslashes($utitle);

// ------------
// Get the date
   $date = $html -> get_date();

// ------------------------------
// Put the user into the database
   $Groups_q   = addslashes($Groups);
   $Status_q   = addslashes($Status);
   $Username_q    = addslashes($Username);
   $Email_q    = addslashes($Email);
   $Display_q  = addslashes($theme[postlist]);
   $View_q     = addslashes($theme[threaded]); 
   $EReplies_q = addslashes("Off");
   $PFormat    = addslashes($theme[post_format]);
   $Color_q    = addslashes($Color);

// -------------------------------
// Grab the registering IP address
   $ip = getenv('REMOTE_ADDR');
   $ip_q = addslashes($ip);

// ----------------------------------------------------------------------
// Patch to WWWThreads by Steve Linberg (slinberg@crocker.com), 11/3/1999 
// Allow a password to be specified directly.  Tweak the algorithms as you like. 
   if ($Password) {	
      if ($Password != $Verify) {
         $html -> not_right("$lang[PASS_MATCH]", $Cat);
      }
      if((strlen($Password) > 21) || (strlen($Password) < 4)) {
         $html -> not_right("$lang[PASS_TOO_LONG]", $Cat);
      }
      if (ereg("^\W+$",$Password)) {
         $html -> not_right("$lang[ILL_PASS]", $Cat);
      }
      $pass = $Password;  
   }
// xxx pw SFL  Done.


// --------------------------------------------------------------------
// Now we need to generate a random password if they didn't specify one
   $passset = array('a','b','c','d','e','f','g','h','i','j','k','m','n','o','p','q','r','s','t','u','v','x','y','z','A','B','C','D','E','F','G','H','I','J','K','M','N','P','Q','R','S','T','U','V','W','X','Y','Z','2','3','4','5','6','7','8','9');
   $chars = sizeof($passset);

   if (!$pass) {
      $a = time();
      mt_srand($a);
      for ($i=0; $i < 6; $i++) {
         $randnum = intval(mt_rand(0,$chars))    ;
         $pass .= $passset[$randnum];
      }                                            
   }

// ----------------------------
// Now let's crypt the password
   $a = time();
   mt_srand($a);
   $one = intval(mt_rand(0,$chars));
   $two = intval(mt_rand(0,$chars));
   $salt = "$passset[$one]$passset[$two]";
   $crypt = crypt($pass,$salt); 

// ----------------------------------
// Insert this user into the database
// QUERY DEPENDS ON AUTO_INCREMENT OR SEQUENCE
   if ($config[dbtype] == "mysql") {
      $query = "
         INSERT INTO w3t_Users (U_Username,U_Password,U_Email,U_Totalposts,U_Laston,U_Status,U_Sort,U_Display,U_View,U_PostsPer,U_EReplies,U_Post_Format,U_Registered,U_RegEmail,U_RegIP,U_Groups,U_Title,U_Color,U_Privates)
         VALUES ('$Username_q','$crypt','$Email_q','0','$date','$Status_q','$theme[sort]','$Display_q','$View_q','$theme[postsperpage]','$EReplies_q','$PFormat','$date','$Email_q','$ip_q','$Groups_q','$Title_q','$Color_q','1')
      "; 
      $dbh -> do_query($query);
   }
   else {
      $seq = "nextval('U_seq')";
      $query = " 
      INSERT INTO w3t_Users (U_Number,U_Password,U_Username,U_Email,U_Totalposts,U_Laston,U_Status,U_Sort,U_Display,U_View,U_PostsPer,U_EReplies,U_Post_Format,U_Registered,U_RegEmail,U_RegIP,U_Groups,U_Title,U_Color,U_Privates)
      VALUES ('$seq','$crypt','$Username_q','$Email_q','0','$date','$Status_q','$theme[sort]','$Display_q','$View_q','$theme[postsperpage]','$EReplies_q','$PFormat','$date','$Email_q','$ip_q','$Groups_q','$Title_q','$Color_q','1')
      "; 
      $dbh -> do_query($query);
   }

// --------------------------------
// Get the Administrator's Username
   $query = " 
      SELECT U_Username
      FROM   w3t_Users
      WHERE  U_Number = 1 
   "; 
   $sth = $dbh -> do_query($query);

// ---------------------------------
// Set up some stuff for the message
   list($Sender)   = $dbh -> fetch_array($sth); 
   $dbh -> finish_sth($sth);
   $Sender_q   = addslashes ($Sender);
   $Messstat_q = "N";
   $Subject    = "$lang[INTRO_SUB]";
   $Subject_q  = addslashes($Subject);
   $Message_q  = addslashes($lang[WEL_MSG]);

// --------------------------------------
// Put the message into the Messages table
// DEPENDS ON AUTO_INCREMENT OR SEQUENCE
   if ($config[dbtype] == "mysql") {
      $query = " 
         INSERT INTO w3t_Messages (M_Username,M_Status,M_Subject,M_Sender,M_Message,M_Sent)
         VALUES ('$Username_q','$Messstat_q','$Subject_q','$Sender_q','$Message_q','$date')
      "; 
      $dbh -> do_query($query);
   }
   else {
      $seq = "nextval('M_seq')";
      $query = " 
         INSERT INTO w3t_Messages (M_Number,M_Username,M_Status,M_Subject,M_Sender,M_Message,M_Sent)
         VALUES ('$seq','$Username_q','$Messstat_q','$Subject_q','$Sender_q','$Message_q','$date')
      ";
      $dbh -> do_query($query); 
   }
    

// -------------------------------------
// Now we need to mail them the password
   if ( ($Username) && ($Email) ) {

      $to      = $Email;
      $from    = $config[emailaddy];
      $subject = "$lang[PASS_SUB] $config[title]";
      $msg     = "$lang[PASS_BODY1] '$ip' $lang[PASS_BODY2] '$Username'.  $lang[PASS_BODY3] '$pass'.";
      $mailsend = mail("$to","$subject","$msg","From: $from");

  }

// ------------------------
// Send them a confirmation
   $html -> send_header("$lang[NEW_CONFIRM]",$Cat,0,0,0,0);
   $html -> table_header("$lang[NEW_CONFIRM]");
   $html -> open_table();
   echo " 
     <TR><TD class=\"lighttable\">
     $lang[NEW_BODY]
   "; 
   $html -> close_table();
   $html -> send_footer();

