# THIS FILE DISPLAYS GUTS OF: Control Panel, Polling Options

%vars_wordlets_local = (
	user_group_administrators => "Administrators",
	user_group_moderators => "Moderators",
	user_group_senior_members => "Members",
	user_group_junior_members => "Jr. Members",
	user_group_COPPA_members => "COPPA Members",
	user_group_all => "All registered members",
	user_group_none => "No members",
	no_forums_in_this_group => "No forums are assigned to this group.",
);

my @group_order = qw(administrators moderators senior_members junior_members COPPA_members);

&CheckUndonePolls;

&FormStart("$vars_config{CGIURL}/cp.cgi", "$Hiddens");

&TBT;    #Table Border Top in cp_common.pl

&HeaderRow(qq%Optional fields are in <FONT COLOR="#5d7790">blue</FONT>.%, "2", "#FFFFFF", "#000000", "left", "1");

&HeaderRow("$vars_config{BBName} $CurrentTab", "2", "#5d7790", "#FFFFFF", "center", "2");

&HeaderRow("Poll Options", "2", "#c9c9c9", "#000000", "left", "2");

&RadioField("Enable Polls", "Enabled", "yes", "You may enable or disable polling globally using this option.", $vars_poll{Enabled}, "on|Polling Enabled%%off|Polling Disabled");

# Not implemented in this version
#&HeaderRow("&nbsp;", "2", "#ffffff", "#000000", "left", "2");
#
#&RadioField("Result Viewing", "ViewResults", "yes", "This controls who may view the record of votes in polls, meaning which users voted for which options.  This is not retroactive - changing this option will not change any polls currently open.", $vars_poll{ViewResults}, "off|No one may view voter details%%all|Everyone may view voter details.%%starter|Only Administrators and the poll author may view voter details.%%admins|Only Administrators may view voter details");

&HeaderRow("Poll Groups", "2", "#c9c9c9", "#000000", "left", "2");

print <<CUSTOM_HTML;
<tr>
<td colspan="2" bgcolor="white">
<font face="Verdana, Arial, sans-serif" size="2">
CUSTOM_HTML

&RequireCode("ubb_lib_dumper.cgi");
import Data::ThatWhichDumps;

&GetForumRecord(0); # load up vars_forums
my %forum_groups;

foreach my $f (keys %vars_forums) {
	if($vars_forums{$f}->[17] =~ m/^(\d+)$/) {
		push(@{ $forum_groups{$1} }, $vars_forums{$f}->[8]);
	} # end if
} # end foreach

my @grouplist = sort grep(/pollgroup_\d+/, $vars_groups->_get_raw_group_list("poll"));
foreach my $groupref (@grouplist) {
	my($name, $number) = split(/_/, $groupref);
	my $data = $vars_groups->_get_raw_group($groupref);
#	print "<pre><big>$groupref: \n" . Dumper($data, \%forum_groups) . "</big></pre>";
	print qq(<b>$data->{name}</b> [<a href="$vars_config{CGIURL}/cp.cgi?ubb=group_edit&g=$groupref">Edit Group Settings</a>]);

	print qq(<small><br />);

	print qq(<b>Create polls: </b>);
	my @ct;
	# Create
	if($data->{perms}->{create} eq "all") {
		push(@ct, $vars_wordlets_local{user_group_all});
	} elsif($data->{perms}->{create} eq "restrict") {
		foreach my $one (@group_order) {
			foreach my $two (@{ $data->{authlists}->{create}->{l} }) {
				if($two eq $one) {
					push(@ct, $vars_wordlets_local{"user_group_$one"});
				} # end if
			} # end foreach
		} # end foreach
	} elsif($data->{perms}->{create} eq "none") {
		push(@ct, $vars_wordlets_local{user_group_none});
	} # end if
	print join(", ", @ct) . qq(<br />);

	print qq(<b>Vote in polls: </b>);
	# Vote
	my(@vt);
	if($data->{perms}->{vote} eq "all") {
		push(@vt, $vars_wordlets_local{user_group_all});
	} elsif($data->{perms}->{vote} eq "restrict") {
		foreach my $one (@group_order) {
			foreach my $two (@{ $data->{authlists}->{vote}->{l} }) {
				if($two eq $one) {
					push(@vt, $vars_wordlets_local{"user_group_$one"});
				} # end if
			} # end foreach
		} # end foreach
	} elsif($data->{perms}->{vote} eq "none") {
		push(@vt, $vars_wordlets_local{user_group_none});
	} # end if
	print join(", ", @vt) . qq(<br />);

	print qq(<b>Applies to forums: </b>);
	# Forums
	my @fl = sort @{ $forum_groups{$number} };
	my @lf;
	if(@fl) {
		foreach my $num (@fl) {
			push(@lf, "(#<b>$num</b>) " . (&GetForumRecord($num))[1]);
		} # end foreach
	} else {
		@lf = ($vars_wordlets_local{no_forums_in_this_group}, );
	} # end if
	print join(", ", @lf) . qq(<br />);
	print qq(</small><br /><hr /><br />);
} # end foreach


print <<CUSTOM_HTML;
[<a href="$vars_config{CGIURL}/cp.cgi?ubb=add_group&g=pollgroup">Add New Permission Group</a>]
</font>
</td>
</tr>
CUSTOM_HTML

&TBB;    #Table Border Bottom in cp_common.pl

&Submit("Update $CurrentTab");

# Nothing below this line should be changed.. and there is no more code!

# This entire program is copyright Infopop Corporation.
# For more info on UBB.classic and other Infopop
# Products/Services, visit: http://www.infopop.com

# You may not distribute this program in any manner, modified or otherwise.

#You make modifications, but only for your own use and within the confines of the UBB.classic License Agreement.

# DANGER: Do not remove the following line!
1;
# $Id: cp_vars_poll.pl,v 1.4 2002/04/18 22:59:29 cvscapps Exp $
