# THIS FILE DISPLAYS GUTS OF: Control Panel, User Groups

sub addedit_group {

my $group = shift;
my $act = shift;

$group =~ m/group_(\d+)$/;
my $currentgroup = $1;
$currentgroup ||= 0;

%vars_wordlets_local = (
	user_group_administrators => "Administrators",
	user_group_moderators => "Moderators",
	user_group_senior_members => "Members",
	user_group_junior_members => "Jr. Members",
	user_group_COPPA_members => "COPPA Members",
	user_group_all => "All registered members",
	user_group_none => "No members",
	no_forums_in_this_group => "No forums are assigned to this group.",
);

my @group_order = qw(administrators moderators senior_members junior_members COPPA_members);

&GetForumRecord(0); # load up vars_forums
my %forum_groups;

foreach my $f (keys %vars_forums) {
	if($vars_forums{$f}->[17] =~ m/^(\d+)$/) {
		push(@{ $forum_groups{$1} }, $vars_forums{$f}->[8]);
	} # end if
} # end foreach

my @grouplist = sort grep(/pollgroup_\d+/, $vars_groups->_get_raw_group_list("poll"));
my $this_group;
foreach my $groupref (@grouplist) {
	my($name, $number) = split(/_/, $groupref);
	if($groupref eq $group) {
		$this_group = $vars_groups->_get_raw_group($groupref);
	} # end if
} # end foreach

if((!$this_group) && ($act ne 'add_group')) {
	# Oops, too far in to call &StandardHTML
	&StandardHTML("I can't find that group.  Did you mean to add rather than edit?");
} elsif($act eq 'add_group') {
	if($group =~ m//) {
		$this_group = {
			'authlists' => { 'create' => { 'u' => [], 'l' => [] }, 'vote' => { 'u' => [], 'l' => [] } },
			'perms' => { 'create' => 'all', 'vote' => 'all' }, 'defaultaction' => 'allow', 'name' => 'New Group'
		};
	#} else { # ah, for the day we'll have forum groups....
	} # end if
} # end this_group


&CPHeader;
&CPFooter;
&CPTop;

&FormStart("$vars_config{CGIURL}/cp.cgi", qq[<input type="hidden" name="ubb" value="do_group" /><input type="hidden" name="group" value="$group" /><input type="hidden" name="act" value="$act" />]);

&TBT;    #Table Border Top in cp_common.pl

&HeaderRow(qq%Optional fields are in <FONT COLOR="#5d7790">blue</FONT>.%, "2", "#FFFFFF", "#000000", "left", "1");

&HeaderRow("$vars_config{BBName} $CurrentTab", "2", "#5d7790", "#FFFFFF", "center", "2");

if($in{ubb} ne "add_group") {
print <<CUSTOM_HTML;
<tr><td bgcolor="#eeeeee" colspan="2"><font face="Verdana, Arial" size="1">
<script language="JavaScript" type="text/javascript">
	function go_nuts () {
		if(document.THISFORM.deleter.checked == true) {
			if(confirm("Are you sure you want to delete this group?") == false) {
				document.THISFORM.deleter.checked = false;
			}
		}
	}
</script>
<b><input type="checkbox" name="deleter" value="true" onclick="go_nuts();" /> Delete this group</b>
</font></td></tr>
CUSTOM_HTML
} # end if

=pod
print <<CUSTOM_HTML;
<tr>
<td colspan="2" bgcolor="white">
<font face="Verdana, Arial, sans-serif" size="2">
CUSTOM_HTML

&RequireCode("ubb_lib_dumper.cgi");
import Data::ThatWhichDumps;
my $z = Dumper($this_group);

print <<CUSTOM_HTML;
<pre><big>$z</big></pre>
</font>
</td>
</tr>
CUSTOM_HTML
=cut

&RegField("Group Name", "group_name", "yes", "40", "150", "", $this_group->{name});

&HeaderRow("Permissions", "2", "#c9c9c9", "#000000", "left", "2");

my @create_select = ('','','');
my $create_p = $this_group->{perms}->{create};
if($create_p eq "all") {
	$create_select[0] = 'checked="checked"';
} elsif($create_p eq "restrict") {
	$create_select[1] = 'checked="checked"';
} elsif($create_p eq "none") {
	$create_select[2] = 'checked="checked"';
} # end if

print<<MORECUSTOM;
<tr>
<td bgcolor="white" valign="top"><font face="Verdana, Arial" size="2"><b>
Create Poll
</b></font></td>
<td bgcolor="white" valign="top"><font face="Verdana, Arial" size="2">
<input type="radio" name="create_perm" value="all" $create_select[0] /> All registered users<br />
<input type="radio" name="create_perm" value="none" $create_select[2] /> No users<br />
<input type="radio" name="create_perm" value="restrict" $create_select[1] /> Only selected groups:<br />
MORECUSTOM

my $cgl = join("|", @{ $this_group->{authlists}->{create}->{l} });
foreach my $one (@group_order) {
	my $checker = ($cgl =~ m/$one/ ? 'checked="checked"' : "" );
	print qq(&nbsp; &nbsp; &nbsp; &nbsp; <input type="checkbox" name="create_group_$one" value="1" $checker /> $vars_wordlets_local{"user_group_$one"}<br />);
} # end foreach

print qq~
</font></td>
</tr>
<tr><td colspan="2" bgcolor="#c9c9c9">
</td></tr>
~;




my @vote_select = ('','','');
my $vote_p = $this_group->{perms}->{vote};
if($vote_p eq "all") {
	$vote_select[0] = 'checked="checked"';
} elsif($vote_p eq "restrict") {
	$vote_select[1] = 'checked="checked"';
} elsif($vote_p eq "none") {
	$vote_select[2] = 'checked="checked"';
} # end if

print<<MORECUSTOM;
<tr>
<td bgcolor="white" valign="top"><font face="Verdana, Arial" size="2"><b>
Vote in Poll
</b></font></td>
<td bgcolor="white" valign="top"><font face="Verdana, Arial" size="2">
<input type="radio" name="vote_perm" value="all" $vote_select[0] /> All registered users<br />
<input type="radio" name="vote_perm" value="none" $vote_select[2] /> No users<br />
<input type="radio" name="vote_perm" value="restrict" $vote_select[1] /> Only selected groups:<br />
MORECUSTOM

my $vgl = join("|", @{ $this_group->{authlists}->{vote}->{l} });
foreach my $one (@group_order) {
	my $checker = ($vgl =~ m/$one/ ? 'checked="checked"' : "" );
	print qq(&nbsp; &nbsp; &nbsp; &nbsp; <input type="checkbox" name="vote_group_$one" value="1" $checker /> $vars_wordlets_local{"user_group_$one"}<br />);
} # end foreach

print qq~
</font></td>
</tr>
~;

&GetForumRecord(0); # load up vars_forums
my %forum_groups;
my $optionlist;

my $nof = scalar(keys %vars_forums);
if($nof > 20) { $nof = 20; }
my @fl = ();
my @flis;

my $l = 0;
FORUM: foreach my $f (sort {$a <=> $b} keys %vars_forums) {
	my $fn = $vars_forums{$f}->[8];
	if($vars_forums{$f}->[17] =~ m/^(\d+)$/) {
		#push(@{ $forum_groups{$1} }, $vars_forums{$f}->[8]);
		my $whichgroup = $1;
		if($whichgroup == $currentgroup) {
			push(@flis, "(#<b>$fn</b>) $vars_forums{$f}->[1]");
			push(@fl, $l);
			$optionlist .= qq(<option value="$fn" selected="selected">(#$fn) $vars_forums{$f}->[1]</option>);
		} else {
			$optionlist .= qq(<option value="$fn">(#$fn) $vars_forums{$f}->[1]</option>);
		}
	} else {
		$optionlist .= qq(<option value="$fn">(#$fn) $vars_forums{$f}->[1]</option>);
	} # end if
	$l++;
} # end foreach

my $forumlist = join("', '", @fl);
my $flist = join(",<br />", @flis);
$flist ||= "None";

&HeaderRow("Forums", "2", "#c9c9c9", "#000000", "left", "2");

print <<THEEND;
<script language="JavaScript" type="text/javascript">
	function select_all () {
		var l = document.THISFORM.forumlist.length;
		for(i = 0; i < l; i++) {
			document.THISFORM.forumlist[i].selected = true;
		}
	}

	function select_none () {
		var l = document.THISFORM.forumlist.length;
		for(i = 0; i < l; i++) {
			document.THISFORM.forumlist[i].selected = false;
		}
	}

	function reset_forums () {
		select_none();
		var trues = new Array('$forumlist');
		for(i = 0; i < trues.length; i++) {
			var x = trues[i];
			if(x > 1) {
				document.THISFORM.forumlist[x].selected = true;
			}
		}
	}

	// CGI.pm doesn't handle multiselect lists very well...
	function assemble_hidden () {
		var l = document.THISFORM.forumlist.length;
		for(i = 0; i < l; i++) {
			if(document.THISFORM.forumlist[i].selected == true) {
				document.THISFORM.forumselection.value =
				document.THISFORM.forumselection.value +
				document.THISFORM.forumlist[i].value + ",";
			}
		}
	}
</script>
<input type="hidden" name="forumselection" value="" />
<tr>
<td bgcolor="white" valign="top" align="left"><font face="Verdana, Arial" size="2">
<p>This is a list of your forums.  To apply this permission group
to a forum, select it.</p>
<p>You may select as many forums as you wish.</p>
<p>To select or un-select an item in the list:
<br /><b>Windows</b>: Press and hold the "Control" key on your keyboard, and click an item
<br /><b>Macintosh</b>: Press and hold the "Command" key on your keyboard, and click an item.</p>
<br />
<br />
<div align="right">
<input type="button" onclick="select_all();" value="   Select All    " />
<br />
<input type="button" onclick="select_none();" value="Select None " />
<br />
<br />
<input type="button" onclick="reset_forums();" value="Reset Forums" />
</div>
</font></td>
<td bgcolor="white" valign="top" align="left">
<table><tr><td>
<font face="Verdana, Arial" size="2">
<select name="forumlist" size="$nof" multiple="true">
$optionlist
</select>
</font></td><td valign="top"><font face="Verdana, Arial" size="2">
<b style="white-space: nowrap">Currently Selected:</b>
<br /><small>$flist
</small></font>
</td></tr></table>
</td></tr>
THEEND

&TBB;    #Table Border Bottom in cp_common.pl

print <<EEEEEEHHHHH;
<table width="95%"><tr><td align="center">
<input type="submit" onclick="assemble_hidden();" value="Update Group Settings" />
</td></tr></table>
EEEEEEHHHHH
#&Submit("Update Group Settings");

&CPBottom;

} # end sub

# Nothing below this line should be changed.. and there is no more code!

# This entire program is copyright Infopop Corporation.
# For more info on UBB.classic and other Infopop
# Products/Services, visit: http://www.infopop.com

# You may not distribute this program in any manner, modified or otherwise.

#You make modifications, but only for your own use and within the confines of the UBB.classic License Agreement.

# DANGER: Do not remove the following line!
1;
# $Id: cp_user_groups.pl,v 1.4 2002/04/18 22:59:29 cvscapps Exp $

