# HTML bits for post preview.

sub dont_do_it_quite_yet {

# Right - IE cuts off the query string at ~1024x2 characters, which is sane... but that means
# that I can't send in the message via the query string.  Solution: open this hidden form,
# which will, upon loading, submit a new form with the message, bypassing the qstring

print <<THEEND;
<html>
<head><title>$vars_config{BBName}</title>
<script language="JavaScript" type="text/javascript">
<!--

function again () {
	document.thisform.message.value = window.opener.document.replier.message.value;
	document.thisform.submit();
	return true;
} // end func

// -->
</script>
</head>
<body onload="again();">
<form name="thisform" id="thisform" action="$vars_config{CGIURL}/ultimatebb.cgi" method="POST">
<input type="hidden" name="ubb" value="preview_post" />
<input type="hidden" name="f" value="$in{f}" />
<input type="hidden" name="pm" value="$in{pm}" />
<input type="hidden" name="Signature" value="$in{Signature}" />
<input type="hidden" name="disable_smilies" value="$in{disable_smilies}" />
<input type="hidden" name="type" value="$in{type}" />
<input type="hidden" name="itial" value="false" />
<input type="hidden" name="message" value="" />
</form>
</body>
</html>
THEEND

exit;
} # end dont_do_it_quite_yet

sub just_do_it {
	# Payoffs from Nike?  Naaaa.

	if($in{itial} ne "false") { &dont_do_it_quite_yet; }

	my $message = $in{message};

	if($message) {

		my @this_forum = &GetForumRecord($in{f}) if $in{f};

		$message = &CensorCheck("$message");

		my @codes;
		($message, @codes) = &UndoCodeTag($message);

		## IF HTML is not allowed, render HTML useless
		if($in{pm} ne "true") {
			if ($this_forum[4] eq 'is not') {
				$message =~ s/</&lt;/g;
				$message =~ s/>/&gt;/g;
			} else {
				$message =~ s/\<\?/\&lt\;\?/g;
			} # end if
		} else {
			if($vars_pntf{html} ne "on") {
				$message =~ s/</&lt;/g;
				$message =~ s/>/&gt;/g;
			} # end if
		} # end if

		$message = &Truncate("$message");

		# do graemlins--
		$in{disable_smilies} = "no" unless $in{disable_smilies};
		if ($in{disable_smilies} ne "yes") {
			$message = &Smilies("$message");
		}

		my $is_ubbcode = "is not";
		# UBB.classic Code-ify (if allowed)
		if($in{pm} ne "true") {
			if ($this_forum[5] eq 'is') {
				$is_ubbcode = "is";
				$message = &UBBCode("$message", "$this_forum[10]");
			}    #end if UBB Code allowed
		} else {
			if($vars_pm{ubb_code} eq "on") {
				$is_ubbcode = "is";
				$message = &UBBCode("$message", "OFF");
			} # end if
		} # end if

		# don't allow HTML SCRIPT TAGS
		&check_html($message);

		#convert newlines/carriage returns to <br> and <p> html tags
		$message = &ConvertReturns(&LimitReturns($message));
		$message = &PipeCleaner("$message");

		# check for excess images-
		&excess_smilies_check($message);

		$message = &RedoCodeTag($message, $is_ubbcode, @codes);

		# append edit note to the message
		if(($vars_misc{EditWording} eq 'yes') && ($in{type} eq "edit")) {
			&GetDateTime;
			$edit_date = &DateFormat($GotTime{HyphenDate});
			$message .= qq(<br /> <br /> <small>[ $edit_date: $vars_wordlets{edit_wording} $pubname ]</small>);
		}    # end "edited by" message

		# new format! - signature is not included in message
		if(($username) && ($user_number =~ m/^\d{8}$/)) {
			my @user_profile = &OpenProfile($user_number);
			if (($vars_display{AllowSignature} eq 'YES') && ($user_profile[12] ne '') && ($in{Signature} eq 'yes')) {

				if ($vars_display{AllowSignatureImage} eq 'YES') {
					$allow_images = 'ON';
				} else {
					$allow_images = 'OFF';
				}

				$user_profile[12] = &UBBCode($user_profile[12], $allow_images);
				# Buggage: No more Graemlin interpretation at runtime
				# $user_profile[12] = &Smilies($user_profile[12]) if $allow_images eq "ON";

				$message .= ("<br /><br />$vars_wordlets{signature_break}<br />$user_profile[12]<br />");
			} # end if
		} # end if
	} else {
		$message = $vars_wordlets{preview_post_no_message};
	} # end if message
	%vars_style = &LoadStyleTemplate(( $in{pm} eq "true" ? "private_message" : "forum_$in{f}" ));
	$vars_style{HeaderInsert} .= qq(<base href="$vars_config{NonCGIURL}/" />);
	&set_page_elements;

	print<<THEEND;
$Header_Popup
<br />
$TBT_Popup
<tr>
<td bgcolor="$vars_style{TableColorStrip}" class="normal-font1">$vars_wordlets{preview_post_head}</td>
</tr>
<tr>
<td bgcolor="$vars_style{AltColumnColor1}" class="normal-font">$message</td>
</tr>
$TBB_Popup
<center>
<table width="95%"><tr><td align="right" class="small-font"><a href="javascript:void(0);" onclick="window.close()">$vars_wordlets{close_window}</a></td></tr></table>
</center>
$Footer_Popup
THEEND

} # end just_do_it

# Nothing below this line should be changed.. and there is no more code!

# This entire program is copyright Infopop Corporation.
# For more info on UBB.classic and other Infopop
# Products/Services, visit: http://www.infopop.com

# You may not distribute this program in any manner, modified or otherwise.

#You make modifications, but only for your own use and within the confines of the UBB.classic License Agreement.

# DANGER: Do not remove the following line!
1;
# $Id: public_post_preview.pl,v 1.3 2002/02/22 01:37:11 cvscapps Exp $
