#!/usr/bin/perl

# Whoops!  If you see this message in your browser, your web hosting provider
# has not properly mapped the .cgi file extension to Perl.
#
# Please contact them for more information.  Mapping .cgi is easy for both
# Unix and NT servers, and usually only takes a few seconds.






# UBB.classic 6.x
# Official Release Date for UBB.classic 6.0: March 15, 2001
#
# First version of UBB created May 7, 1996 (by Ted O'Neill).
# This entire program is copyright Infopop Corporation, 2002.
# For more info on UBB.classic and other Infopop
# Products and Services, visit: http://www.infopop.com
#
# Program Author: Ted O'Neill, with assistance from Michael Farris, Dave Dreezer
#
# Special Thanks to: Rosemary O'Neill, Mark Badolato, Charles Capps,
# Graeme, Jesus de la Garza, Joe Siegler, Hal, Brett Harris, Kristi Miller,
# Celeste Combs, everyone who beta-tested, and all of our support moderators!
#
# UBB.classic 6.x is dedicated to Edward Kriz.
#
# You may not distribute this program in any manner, modified or otherwise,
# without the express, written written consent from Infopop Corporation.
#
# You may make modifications, but only for your own use and within the confines
# of the UBB.classic License Agreement (see our website for the full license).
#
# You may not distribute "hacks" for UBB.classic without approval from Infopop.
#
# Note: If you modify ANY code within your UBB.classic, we at Infopop Corporation
# cannot offer you support -- thus modify at your own peril :)

BEGIN {	# get our modules directory set up
	($0 =~ m!(.*)(\\|/)[^/\\]+!) && unshift(@INC, $1, "$1$2Modules");
	$| = 1;
}

use lib("./Modules", ".");	# if there's no $0, or it's not sane...

use strict;
use Fcntl ':flock';
use UBBCGI qw(:cgi);	# CGIPath/Modules/UBBCGI.pm
use UBBCGI::Carp qw(fatalsToBrowser set_message carpout);	# CGIPath/Modules/UBBCGI/Carp.pm

use constant SEVENSEVENSEVEN => 0777;
use constant SIXSIXSIX => 0666;

use vars qw(%template_html %vars_poll %vars_wordlets_poll $poll $vars_groups $user_permissions $Header_Popup $Footer_Popup $TBB_Popup $TBT_Popup %vars_wordlets_criterr $HeaderClean $FooterClean $PNTF $pntf_cookie_data $ULTIMATEBB $filehandle %vars_pntf %vars_style_reference $trademark $trade $InfopopCopyright %weights $version $version_number $masterCharset $release_j %GotTime $template $vars_graemlins %template %vars_config %vars_misc %vars_registration %vars_forums %vars_styles %vars_display %vars_style %vars_email %vars_time %vars_search %vars_pm %vars_wordlets %vars_wordlets_err %vars_wordlets_email %vars_wordlets_img %vars_wordlets_date %template_match $username $password $last_login_dt $session_login_dt $last_login_j $session_login_j $days_prune $LastLoginTime $pubname $user_topic_view $user_number @ubber @login @session $ThisHTML $exact_path @memberslist %in $memlistopen $cache_cookie $forum_threads $summary @alltheforums @allthecategories @memberslist_array %forum_thread_data %ProfileNumber %member_profile $CurrentTab $Hiddens $direct_to $Legend $LoginWording $MainButtonsLine $TableWidth2 $ContactLine $TBT $TBB $Header $Footer $EmailHeader $show_logout $show_logout_noreg $instant_jscript $title_wording);

##################################################################################
# NOTE TO USERS WHO ARE RUNNING UBB.classic IN THE NON-WRITABLE CGI-BIN SITUATION:
# Modify the path in the following 'do' line to reflect the VariablesPath!
# There is NO NEED to modify this line unless you are using a different
# VariablesPath.  PLEASE use the UBB's CGI directory as the VariablesPath
# if at all possible.  Thanks.
##################################################################################

eval {
	do "vars_config.cgi";
};

&CheckDollarAt($@);


# No need to touch this now that we have the VariablesPath!
foreach my $file (qw(display misc email time search pm registration pntf poll template_match wordlets wordlets_err wordlets_img wordlets_date wordlets_pntf wordlets_poll)) {
	eval { do "$vars_config{VariablesPath}/vars_$file.cgi"; };
	&CheckDollarAt($@);
} # end foreach

eval {	require "$vars_config{CGIPath}/ubb_lib.cgi";	}; &CheckDollarAt($@);

	&InitImportantStuff;	#ubb_lib

	&RequireCode("$vars_config{CGIPath}/ubb_lib_files.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_time.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_filehandler.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_filehandle.cgi");

	# init our FileHandler object
	$filehandle = new UBB::FileHandler(\%vars_config, "global");

	# load our template routines
	&LoadTemplate("public_common");

#out in the middle of nowhere, we have a subroutine!
sub CheckDollarAt {
	my $error = shift;
	return unless $error;

	$masterCharset = "ISO-8859-1" unless $masterCharset;
	print header(
		-charset => "$masterCharset",
		-type    => "text/html",
	);

	print "<p><br />There was a compilation error while loading the UBB.classic"
	. " libraries and data files: <pre>\n$error</pre><br />"
	. " Please make sure that you uploaded the CGI and Variables files"
	. " to the proper directory, permissions are set properly on the files,"
	. " and that paths in the control panel are set correctly.</p>";
	exit;
}


# We want to do this now rather than continue to make
# up to 1000 calls to UBBCGI routines per instance...
%in = map{$_ => param($_)} param();	#map is your friend!

my $templatefile = &DetermineDefaultTemplates($in{ubb});

#print header;

if(defined $templatefile) {
#	print "TEMPLATEFILE: $templatefile<br />";
	$template_html{"CURRENT"} = $template_html{$templatefile};
	%vars_style = &LoadStyleTemplate($templatefile);
} else {
	%vars_style = &LoadStyleTemplate("summary_page");
} # end if
&LoadTemplate("public_common");
&InitImportantStuff;

# If we grabed a template file, reassign the character set
# Otherwise, $masterCharset is called in from ubb_lib
$masterCharset = $vars_style{thisCharset} if $vars_style{thisCharset};

$cache_cookie = $vars_config{cache_pw};

$template = \%template;


# set main buttons options
$MainButtonsLine = &MainButtonOptions; # moved to public_common

# set date/time
&GetDateTime;

# counter
&hit_me;

# for misc actions --
my %deadhash = &LoadStyleTemplate("transition") if(($summary == 1) && ($template_match{"transition"} ne $template_match{"summary_page"}));
# intentional - just want to load it up

# now that we have our both our style template and
# public_common loaded, we can do nice errors again
set_message(\&StandardHTML2);

# check our Perl version
die &Template($vars_wordlets_criterr{old_perl}, {VERSION => $]}) if $] < 5.004;

# special case

#my $shutdownmessage = q{
#<p>Sorry, this bulletin board is unavailable.</p>
#<p>The server is currently overloaded with requests.  The bulletin board has
#automatically turned itself off to help bring the server load back down.</p>
#<p>Please retry your request in a few minutes.  Thank you for your paitence!</p>
#};
#
#if($^O =~ m/^linux$/i) {	# if we're on a Linux box, we can enable basic load protection
#	if(-e "$vars_config{NonCGIPath}/forceclosed.cgi") {
#		my $untiltime = &OpenFileAsString("$vars_config{NonCGIPath}/forceclosed.cgi");
#		if(time() > $untiltime) {
#			unlink("$vars_config{NonCGIPath}/forceclosed.cgi");
#		} else {
#			&StandardHTML($shutdownmessage);
#			exit;
#		} # end if
#	} else {
#		if(-r "/proc/loadavg") {
#			open(LOADAVERAGE, "</proc/loadavg");
#			my @data = split(/ /, <LOADAVERAGE>);
#			close(LOADAVERAGE);
#			if(($data[0] > 12.5) && ($data[2] > 7)) {
#				my $value = int(time() + 120 + rand(120));
#				&WriteFileAsString("$vars_config{NonCGIPath}/forceclosed.cgi", $value);
#				&StandardHTML($shutdownmessage);
#				exit;
#			} # end if
#		} # end if
#	} # end if
#} # end if


# standard argument
my $ubb = $in{ubb};
my $skip_cookie_check;
my $logoff;

# perform user logoff?
if ($ubb eq 'logoff') {
	$skip_cookie_check = 'true';
	my $cookieA = cookie(
		-name    => "ubber$vars_config{Cookie_Number}",
		-value   => ['', ''],
		-path    => '/',
		-expires => '-2y'
	);
	my $cookieB = cookie(
		-name    => "session$vars_config{Cookie_Number}",
		-value   => ['', ''],
		-path    => '/',
		-expires => '-2y'
	);
	my $cookieC = cookie(
		-name    => "forumpw$vars_config{Cookie_Number}",
		-value   => ['', ''],
		-path    => '/',
		-expires => '-2y'
	);

	#print header(-cookie=>[$cookieA, $cookieB, $cookieC]);
	print header(
		-cookie  => [$cookieA, $cookieB, $cookieC, $pntf_cookie_data],
		-charset => "$masterCharset",
	);



	# confirm logoff
	&set_page_elements;
	&StandardHTML($vars_wordlets{logged_off});
	exit(0);

}    # end logoff

if ($ubb eq 'clearcookies') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&clear_cookies;
	exit(0);
}    #end clearcookies

if ($ubb eq 'dumpcookies') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&dump_cookies;
	exit(0);
}    #end clearcookies


&RequireCode("$vars_config{CGIPath}/ubb_lib_secgroups.cgi");
&GetForumRecord(0);
$vars_groups = new UBB::SecurityGroups({
		'CONFIG' => \%vars_config,
		'FILEHANDLER' => $filehandle,
		'VARSFORUMS' => \%vars_forums,
		'IN' => \%in});
$vars_groups->load_groups();

if($vars_pntf{Enabled} eq "yes") { # if we have PNTF enabled
	&RequireCode("ubb_lib_pntf.cgi");
	&RequireCode("ubb_lib_dumper.cgi");
	import Data::ThatWhichDumps;
	#UBB::FileHandler->new(\%vars_config, "pntf")
	$PNTF = UBB::PNTF->new(\%vars_config, $filehandle, \%vars_pntf, \%vars_forums);
	$PNTF->load();

	my @pntf_cookie = cookie("PnTf_$vars_config{Cookie_Number}");
	my @ubber_cookie = cookie("ubber$vars_config{Cookie_Number}");

	if($ubber_cookie[0] && $ubber_cookie[4]) {
		my @up = &OpenProfile2($ubber_cookie[4]);
		if(!@up) {
			&StandardHTML($vars_wordlets_err{member_gone2});
		} # end if
		$user_permissions = new UBB::SecurityToken($vars_groups, $ubber_cookie[4], \@up, \%vars_forums, \%in);
	} # end if

	my @pntf_cookie_append = $PNTF->append(&GetIPAddress, \@pntf_cookie, \@ubber_cookie, \%in, undef, undef, $user_permissions);

	if(($pntf_cookie_append[0] ne '') && 	# Cookie has something and
	(($pntf_cookie_append[0] ne $pntf_cookie[0]) ||  # UNIQID differs
	($pntf_cookie_append[5] != $pntf_cookie[5]) ||	 # or hidden value differs
	($pntf_cookie_append[1] ne $pntf_cookie[1]) || 	 # or IP differs
	($pntf_cookie_append[3] ne $pntf_cookie[3])) ) { # or usernumber differs
		# then set the new cookie
		$pntf_cookie_data = cookie(
			-name    => "PnTf_$vars_config{Cookie_Number}",
			-value   => \@pntf_cookie_append,
			-path    => '/',
			-expires => '+12h'
		);
	} # end if
	$PNTF->write();	# closes the file
} # end if



# is forum closed?
if(($vars_misc{BBStatus} !~ /^ON/) && ((($ubb ne "avatar_select") || ($ubb ne "find_lost")) && ($in{cp} ne "cp"))) {
	&set_page_elements;

	#print qq%Content-type: text/html\n\n%;
	print header(
		-charset => "$masterCharset",
		-type    => "text/html",
	);


	&StandardHTML("$vars_misc{BBClosedMessage}");
	exit(0);
} # end off check

if ($ubb eq 'markallread') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&mark_all_read;
	exit(0);
}    #end clearcookies


if ($ubb eq 'forum_pw_check') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_forum.cgi");
	&forum_pw_check;
	exit(0);
}    #end forum_pw_check

# perform user login?
if ($ubb eq 'do_login') {
	&GetOrPost("POST");
	my $ip_number = &GetIPAddress;
	&check_ip_bans($ip_number);

	$skip_cookie_check = 'true';

	&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

	my @user_info = &verify_id("$in{username}", "$in{password}");
	my $pubname   = $user_info[0];
	my $dp        = $user_info[1];
	my $profile_number = $user_info[2];
	my $mod_q          = $user_info[3];
	my $hidden	   = $user_info[4];
	my $noav	   = $user_info[5];
	chomp(my $writeadmin     = (&OpenProfile($profile_number))[4]);
	chomp(my $this_un     = (&OpenProfile($profile_number))[0]);
	chomp(my $this_pw     = (&OpenProfile($profile_number))[1]);

	chomp($mod_q);

	#6.1.0 - now forbidding login without queue approval
	if ($mod_q eq 'Q') {

		# user is registered but not approved!
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);
		&StandardHTML("$vars_wordlets_err{awaiting_approval}");
		exit(0);
	}

	if ($writeadmin !~ /Write/) {

		#user has no write permissions -> can't login
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);
		&StandardHTML("$vars_wordlets_err{user_not_approved}");
		exit(0);
	}

	if ($dp eq '') { $dp = "$vars_display{DaysPruneDefault}"; }

	my $cookie = cookie(
		-name    => "ubber$vars_config{Cookie_Number}",
		-value   => [$this_un, $this_pw, $pubname, $dp, $profile_number, $hidden, $noav],
		-path    => '/',
		-expires => '+2y'
	);
	$username = $in{username};

	#print header(-cookie=>[$cookie]);
	print header(
		-cookie  => [$cookie, $pntf_cookie_data],
		-charset => "$masterCharset"
	);

	# display refer page
	my $clean_cgi = quotemeta($vars_config{CGIURL});
	if (($in{refer} ne '') && ($in{refer} !~ m/register|age|coppa/i) && ($in{refer} !~ /(logoff|cookies|find_lost|password)$/) && ($in{refer} =~ /^$clean_cgi/)) {

		# take viewer back to topic
		&set_page_elements;
		&Transition("$in{refer}", "$vars_wordlets{thanks_for_login}", "$in{refer}");
		exit(0);
	} else {
		$ubb = '';
	}
}    # end do login

# retrieve cookies!
@ubber = cookie("ubber$vars_config{Cookie_Number}");
if ($ubber[0] ne '') { $username        = $ubber[0]; }
if ($ubber[1] ne '') { $password        = $ubber[1]; }
if ($ubber[2] ne '') { $pubname         = $ubber[2]; }
if ($ubber[3] ne '') { $user_topic_view = $ubber[3]; }
if ($ubber[4] ne '') { $user_number     = $ubber[4]; }


#make sure the user is not forging his cookie to get into a protected area
#if (($vars_display{MembersOnlyAccess} eq 'YES') && (@ubber)) {
if (@ubber) {
	my @checkTheProfile = &verify_id_num_2($username, $password, $user_number);
	unless ($checkTheProfile[4] =~ /Write/) {
		print header(
			-charset => "$masterCharset",
		);
		&StandardHTML($vars_wordlets_err{user_not_approved});
	}
}

@login = cookie("login$vars_config{Cookie_Number}");
if ($login[0] ne '') { $last_login_dt = $login[0]; }
if ($login[1] ne '') { $last_login_j  = $login[1]; }

@session = cookie("session$vars_config{Cookie_Number}");
if ($session[0] ne '') { $session_login_dt = $session[0]; }
if ($session[1] ne '') { $session_login_j  = $session[1]; }

# in case this is a new visitor!
if ($last_login_dt eq '') { $last_login_dt = 'NEW'; }

# set login cookie, if necessary

if ($skip_cookie_check ne 'true') {

	if ($session_login_dt eq '') {

		# set session cookie:
		# this is a temp cookie that stores previous last login

		my $cookie1 = cookie(
			-name  => "session$vars_config{Cookie_Number}",
			-value => [$last_login_dt, $last_login_j],
			-path  => '/'
		);

		# set new last login
		my $cookie2 = cookie(
			-name    => "login$vars_config{Cookie_Number}",
			-value   => [$GotTime{LastLoginDT}, $GotTime{LastLoginJulian}],
			-path    => '/',
			-expires => '+1y'
		);

		my $cookie3;

		# reconfirm user data- in case profile details were changed
		if ($username ne '') {
			my @this_profile = &verify_id_num_2($username, $password, $user_number);
			chomp($this_profile[1]);
			chomp($this_profile[0]);
			chomp($this_profile[21]);
			chomp($this_profile[15]);
			chomp($this_profile[34]);
			if ($this_profile[15] eq '') { $this_profile[15] = "$this_profile[0]"; }
			$cookie3 = cookie(
				-name    => "ubber$vars_config{Cookie_Number}",
				-value   => [$this_profile[0], $this_profile[1], $this_profile[15], $this_profile[21], $user_number, $this_profile[34], (split(/\|/, $this_profile[38]))[2]],
				-path    => '/',
				-expires => '+2y'
			);
		}

		#print header(-cookie=>[$cookie1, $cookie2, $cookie3]);
		print header(
			-cookie  => [$cookie1, $cookie2, $cookie3, $pntf_cookie_data],
			-charset => "$masterCharset"
		);

	} else {

		unless ($ubb =~ m/^(check_age|submit_new_reply|submit_new_topic|submit_registration|edit_profile)$/) {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-cookie  => [$pntf_cookie_data,],
				-charset => "$masterCharset",
				-type    => "text/html",
			);
		} # end unless
	} # end if
}    #if not do_login

# members only acess check
if ($vars_display{MembersOnlyAccess} eq 'YES') {
	if (($username eq '') || ($logoff eq 'true')) {
		unless ($ubb =~ m/^(avatar_select|check_age|agree|coppa_agree|show_coppa_form|register_page|underage_register_page|submit_registration|lost_password|find_lost)$/) {
			&set_page_elements;
			&LoadTemplate("public_login");
			exit(0);
		}
	}
}

# all ubb options:
$ubb = "" unless $ubb;

if(($username && $user_number) && (!$user_permissions)) {
	# Yay, security groups!
	my @ur = &OpenProfile($user_number);
	$user_permissions = new UBB::SecurityToken($vars_groups, $user_number, \@ur);
} # end if


# forum summary
if ($ubb eq '') {
	&RequireCode("$vars_config{CGIPath}/ubb_forum_summary.cgi");
	&forum_summary;
	exit(0);
}

if ($ubb eq 'login') {
	&set_page_elements;
	&LoadTemplate("public_login");
	exit(0);
}

if ($ubb eq 'agree') {
	&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
	&do_agree;
	exit(0);
}    #end agree

if ($ubb eq 'coppa_agree') {
	&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
	&coppa_agree;
	exit(0);
}    #end coppa_agree


if ($ubb eq 'check_age') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
	&check_age;
	exit(0);
}    #end coppa_agree

if ($ubb eq 'register_page') {
#	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
	&register_page;
	exit(0);
}    #end register_page

if ($ubb eq 'underage_register_page') {
	&GetOrPost("POST");
	if ($vars_registration{COPPAType} eq 'COPPADenied') {
		&StandardHTML("$vars_wordlets_err{age_deny}");
	} elsif ($vars_registration{COPPACheck} ne 'ON') {
		&StandardHTML("$vars_wordlets_err{coppa_turned_off}");
	} else {
		&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
		&underage_register_page;
	}
	exit(0);
}    #end underage_register_page

if ($ubb eq 'show_coppa_form') {
	if ($vars_registration{COPPAType} eq 'COPPADenied') {
		&StandardHTML("$vars_wordlets_err{age_deny}");
	} elsif ($vars_registration{COPPACheck} ne 'ON') {
		&StandardHTML("$vars_wordlets_err{coppa_turned_off}");
	} else {
		&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
		$vars_registration{'COPPAType'} = 'COPPAFormOnly';
		%vars_style = &LoadStyleTemplate("registration");

		&set_page_elements;

		my $COPPAInstructions = &ConvertReturns($vars_registration{COPPAInstructions});
		&LoadTemplate("public_reg_confirm_kid");
	}

	exit(0);
}    #end show_coppa_form

if ($ubb eq 'submit_registration') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_registration.cgi");
	&submit_registration;
	exit(0);
}    #end submit_reg

if ($ubb eq 'forum') {

	if ($in{f} =~ /CAT:/) {

		my ($j, $cat_number);
		($j, $cat_number) = split (/:/, $in{f});
		$in{category} = $cat_number;
		&RequireCode("$vars_config{CGIPath}/ubb_forum_summary.cgi");
		&forum_summary;
	} else {
		&RequireCode("$vars_config{CGIPath}/ubb_forum.cgi");
		&get_forum;
	}
	exit(0);
}    # end forum

if ($ubb eq 'rate_member') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&rate_member;
	exit(0);
}    #end rate_member

if ($ubb eq 'email') {
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&email_user;
	exit(0);
}    #end email

if ($ubb eq 'edit_my_profile') {
	&RequireCode( "$vars_config{CGIPath}/ubb_profile.cgi");
	&edit_my_profile;
	exit(0);
}    #end edit_my_profile

if ($ubb eq 'my_profile') {
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&my_profile;
	exit(0);
}    #end my_profile

if ($ubb eq 'my_rating_list') {
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&my_rating_list;
	exit(0);
}    #end my_rating_list

if ($ubb eq "recent_user_posts") {
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&recent_user_posts;
	exit(0);
}    #end recent_user_posts

if ($ubb eq 'get_profile') {
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&get_profile;
	exit(0);
}    #end get_profile

if ($ubb eq 'edit_profile') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_profile.cgi");
	&edit_profile;
	exit(0);
}    #end edit_profile

if ($ubb eq 'avatar_select') {
	&GetOrPost("GET");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&avatar_select_menu;
	exit(0);
}    #end avatar_select



if ($ubb eq 'preview_post') {
	#&GetOrPost("GET");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&preview_post;
	exit(0);
}    #end submit_new_topic

if($ubb eq "poll") {
	&RequireCode("$vars_config{CGIPath}/ubb_poll.cgi");
	&poll_dispatch;
	exit(0);
} # end poll

if ($ubb eq 'newtopic') {
	&RequireCode("$vars_config{CGIPath}/ubb_new_topic.cgi");
	&new_topic_page;
	exit(0);
}    #end newtopic

if ($ubb eq 'submit_new_topic') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_new_topic.cgi");
	&submit_new_topic;
	exit(0);
}    #end submit_new_topic

if ($ubb eq 'get_topic') {
	&RequireCode("$vars_config{CGIPath}/ubb_get_topic.cgi");
	&get_topic($in{f}, $in{t});
	exit(0);
}    #end get_topic

if ($ubb eq 'print_topic') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&this_is_not_print_preview($in{f}, $in{t});
	exit(0);
}    #end get_topic

if ($ubb eq 'reply') {
	&RequireCode("$vars_config{CGIPath}/ubb_new_reply.cgi");
	&reply_page;
	exit(0);
}    #end reply

if ($ubb eq 'submit_new_reply') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_new_reply.cgi");
	&submit_new_reply;
	exit(0);
}    #end submit_new_reply

if ($ubb eq 'get_pm') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&get_pm;
	exit(0);
}    #end get_pm

if ($ubb eq 'sent_pms') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&sent_pm_box;
	exit(0);
}    #end get_pm


if ($ubb eq 'private_message') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&private_message;
	exit(0);
}    #end private_message

if ($ubb eq 'submit_private_message') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&submit_pm;
	exit(0);
}    #end submit_pm

if ($ubb eq 'pm_prune') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_prune;
	exit(0);
}    #end pm_prune

if ($ubb eq 'pm_delete') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_delete;
	exit(0);
}    #end pm_delete

if ($ubb eq 'pm_reply') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_reply;
	exit(0);
}    # end pm_reply

if ($ubb eq 'submit_pm_reply') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&submit_pm_reply;
	exit(0);
}    #end submit_pm_reply

if ($ubb eq 'ignore_list') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_list('ignore');
	exit(0);
}    #end ignore_list

if ($ubb eq 'buddy_list') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_list('buddy');
	exit(0);
}    #end buddy_list

if ($ubb eq 'do_ignore') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_do_list('ignore');
	exit(0);
}    #end do_ignore

if ($ubb eq 'do_buddy') {
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_do_list('buddy');
	exit(0);
}    #end do_buddy

if ($ubb eq 'update_ignore') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_update_list('ignore');
	exit(0);
}    #end update_ignore

if ($ubb eq 'update_buddy') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_pm.cgi");
	&pm_update_list('buddy');
	exit(0);
}    #end update_buddy

if ($ubb eq 'get_ip') {
	&RequireCode("$vars_config{CGIPath}/ubb_get_topic.cgi");
	&get_ip;
	exit(0);
}    #end get_ip

if ($ubb eq 'delete_topic') {
	&RequireCode("$vars_config{CGIPath}/ubb_topic_maint.cgi");
	&delete_topic;
	exit(0);
}    #end delete_topic

if (($ubb eq 'close_topic') || ($ubb eq 'open_topic')) {
	&RequireCode("$vars_config{CGIPath}/ubb_topic_maint.cgi");
	&topic_open_close;
	exit(0);
}    #end close_topic/open_topic

if ($ubb eq 'next_topic') {
	&RequireCode("$vars_config{CGIPath}/ubb_get_topic.cgi");
	&next_topic;
	exit(0);
}    #end next_topic

if (($ubb eq 'transfer') || ($ubb eq 'transfer_topic')) {
	&RequireCode("$vars_config{CGIPath}/ubb_topic_maint.cgi");
	&transfer_topic;
	exit(0);
}    #end transfer

if ($ubb eq 'edit_post') {
	&RequireCode("$vars_config{CGIPath}/ubb_edit_post.cgi");
	&edit_post;
	exit(0);
}    #end edit_post

if ($ubb eq 'submit_edit') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/ubb_edit_post.cgi");
	&submit_edit;
	exit(0);
}    #end submit_edit

if ($ubb eq 'get_daily') {
	&RequireCode("$vars_config{CGIPath}/ubb_search.cgi");
	&get_daily;
	exit(0);
}    #end get_daily

unless($vars_search{AllowSearch} ne "TRUE") {
	if ($ubb eq 'search') {
		&RequireCode("$vars_config{CGIPath}/ubb_search.cgi");
		&search;
		exit(0);
	} elsif($ubb eq 'search_tng') {
		&RequireCode("$vars_config{CGIPath}/ubb_search.cgi");
		&search_tng_dispatch;
		exit(0);
	}    #end search
} #end check for search disabled

if ($ubb eq 'send_topic') {
	&GetOrPost("POST") if $in{send_it};
	&RequireCode("$vars_config{CGIPath}/ubb_friend.cgi");
	&send_topic;
	exit(0);
}    #end send_topic

if ($ubb eq 'faq') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&faq;
	exit(0);
}    #end faq

if ($ubb eq 'ubb_code_page') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&ubb_code_page;
	exit(0);
}    #end ubb_code_page

if ($ubb eq 'lost_password') {
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&lost_password;
	exit(0);
}    #end lost_password

if ($ubb eq 'find_lost') {
	&GetOrPost("POST") unless(($in{cp} eq "cp") && ($ENV{HTTP_REFERER} =~ m/cp\.cgi/));
	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");
	&find_lost;
	exit(0);
}    #end find_lost

if($vars_pntf{Enabled} eq "yes") {
	# Standard display
	if($ubb eq "pntf") {
		&RequireCode("$vars_config{CGIPath}/ubb_pntf.cgi");
		&pntf_html;
	} # end pntf

	# Javascript version of the QuickSummary bits for inclusion on websites
	#
	# Disabled due to server load - perhaps in the future...
	# For now, a direct link to the cached copy will have to do.
	if($ubb eq "pntf_js") {
		&RequireCode("$vars_config{CGIPath}/ubb_pntf.cgi");
		&pntf_js;
	} # end pntf

	# The *GOOD* stuff!
	if($ubb eq "pntf_admin") {
		&RequireCode("$vars_config{CGIPath}/ubb_pntf.cgi");
		&pntf_admin;
	} # end pntf
} # end if

%vars_style = &LoadStyleTemplate("transition");
# default error-- obviously they do not know where they are going
&StandardHTML("$vars_wordlets_err{dead_end}");

exit(0);    # comply with SafePerl

# $Id: ultimatebb.cgi,v 1.24 2002/05/07 22:13:04 cvscapps Exp $
