# UBB.classic Topic Maintenance : Perl Code

# get assigned style template!

unless ($in{f}) {
	&StandardHTML($vars_wordlets_err{no_forum_selected});
	exit(0);
}

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");

# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

&set_page_elements;

sub delete_topic {
	local (@user_profile, @topic_file);

	# make sure we have someone logged in
	if ($username eq "") {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# user must be an admin or mod
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	my $is_one = &is_admin_or_mod($in{f}, @user_profile);

	if ($is_one ne "true") {
		&StandardHTML($vars_wordlets_err{not_admin_or_mod});
	}

	if ($in{confirm} ne "yes") {
		&LoadTemplate("public_confirm_delete");
	} else {
		&do_delete_topic;
	}

}    #end delete_topic

sub do_delete_topic {

	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

	#get topic file
	my @topic_file = &OpenTopic("$in{t}", "$in{f}");

	# this also sets $exact_path!

	# get forum info
	my @this_forum = &GetForumRecord($in{f});

	# get stat line
	my @stat_line = split (/\|\|/, $topic_file[0]);
	my $replies = $stat_line[2];
	chomp($replies);

	my $subtract_posts = $replies + 1;

	my $pollid = $stat_line[10];
	chomp($pollid);

	# If this is a poll, nuke the datafile
	if($pollid =~ m/^\w{12}$/) {
		&Unlink("$vars_config{NonCGIPath}/Polls/$pollid.cgi");
	} # end if

	# delete topic file
	&Unlink("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

	# delete HTML file
	#unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");
	my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
	&DoThatClearCacheThing($thispath, $in{t});

	# unlink threads file
	# also nukes $forum_thread_data{forum}->{lefty}->{righty}
	&RequireCode("ubb_lib_2.cgi");
	&RequireCode("ubb_lib_posting.cgi");
	&unlink_topic_from_forum_summary($in{f}, $in{t});


	&CreateLastTimeFiles($in{f});    #booom!

	# clear cache
	&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
	&ClearSingleForumPageCache($exact_path, $in{f});

	# transition
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum;f=$in{f}", "$vars_wordlets{thanks_for_topic_delete}", "$this_forum[1]");

}    # end do_delete_topic

sub topic_open_close {
	local (@user_profile, @topic_file, $notify, $notify_wording);
	local (*FILE);

	# make sure we have someone logged in
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# user must be an admin or mod
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	my $is_one = &is_admin_or_mod($in{f}, @user_profile);
	if ($is_one ne 'true') {
		&StandardHTML($vars_wordlets_err{not_admin_or_mod});
	}

	#get topic file
	my @topic_file = &OpenTopic("$in{t}", "$in{f}");

	# this also sets $exact_path!

	# get stat line
	my @stat_line = split (/\|\|/, $topic_file[0]);
	my $note_field = $stat_line[1];
	chomp($note_line);

	if ($note_field =~ /N/) {
		$notify = 'N';
	} else {
		$notify = '';
	}

	# adjust note field
	if ($in{ubb} eq 'open_topic') {
		$stat_line[1] = "$notify";

		# is topic already open?
		if ($note_field !~ /X/i) { &StandardHTML("$vars_wordlets_err{topic_already_open}"); }

		$notify_wording = "$vars_wordlets{topic_opened_notify}";

	} else {
		$stat_line[1] = "X$notify";

		# is topic already closed?
		if ($note_field =~ /X/i) {
			&StandardHTML("$vars_wordlets_err{topic_already_closed}");
		}

		$notify_wording = "$vars_wordlets{topic_closed_notify}";

	}

	# adjust @topic_file
	$topic_file[0] = join ("||", @stat_line);

	# update topic file
	&WriteTopic($in{f}, $in{t}, @topic_file);
	&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $in{t}, \@topic_file);

	# delete current HTML page
	#unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");
	my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
	&DoThatClearCacheThing($thispath, $in{t});

	# clear forum page cache
	&ClearSingleForumPageCache($exact_path, $in{f});

	# transition
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}", "$notify_wording", "$stat_line[4]");


}    # end topic_open_close

sub transfer_topic {
	local (@user_profile, $hop_to_options, $subject, @old_forum, @new_forum, @topic_file, @new_topic_file, @forumcounter, $last_topic_number, $total_post_count, $total_topic_count, $topic_replies, $topic_posts, @newforumcount, $last_topic_number_n, $total_post_count_n, $total_topic_count_n, $hyphen_date, $post_time);

	# make sure we have someone logged in
	if ($username eq "") {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# user must be an admin or mod
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	my $is_one = &is_admin_or_mod($in{f}, @user_profile);

	if ($is_one ne 'true') {
		&StandardHTML($vars_wordlets_err{not_admin_or_mod});
	}

	if ($in{ubb} eq 'transfer_topic') {
		&GetOrPost("POST");

		#validate
		my @ValidateArray = ("f", "t", "transfer_to", "move_type");
		&Validate(@ValidateArray);
	}

	#get topic file
	@topic_file = &OpenTopic("$in{t}", "$in{f}");

	chomp($topic_file[0]);
	my @stat_line = split (/\|\|/, $topic_file[0]);
	$subject = $stat_line[4];

	# JIC: Make sure our reply count is accurate
	$stat_line[2] = scalar(@topic_file) - 2;

	# *NOW* clone it...
	$topic_file[0] = join("||", @stat_line);
	@new_topic_file = @topic_file;

	# make sure topic has not already been transferred before:
	if ($stat_line[7] ne '') {

		#&StandardHTML("$vars_wordlets_err{already_transferred}");
		#exit(0);
	}

	if ($in{ubb} eq 'transfer') {
		$hop_to_options = &hop_to_list("nosel");
		&LoadTemplate("public_move_topic");
		exit(0);
	} else {

		# do the transfer--

		# can't transfer to categories or to the same forum
		unless ($in{transfer_to} > 0) { &StandardHTML($vars_wordlets_err{cant_move_to_category}); }
		if ($in{transfer_to} == $in{f}) { &StandardHTML($vars_wordlets_err{cant_move_to_same_forum}); }

		# get info on old forum
		@old_forum     = &GetForumRecord($in{f});
		$topic_replies = $stat_line[2];
		chomp($topic_replies);
		$topic_posts = $topic_replies + 1;

		# get info on new forum
		@new_forum = &GetForumRecord($in{transfer_to});

		# update stats for old forum

		# get forum post count
		@forumcounter      = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
		$last_topic_number = $forumcounter[0];
		chomp($last_topic_number);
		$total_topic_count = $forumcounter[1];
		chomp($total_topic_count);
		$total_post_count = $forumcounter[2];
		chomp($total_post_count);


		# determine exact path for new forum
		if ($new_forum[6] =~ /private/) {
			$exact_path = "Forum$in{transfer_to}/private-$new_forum[7]";
		} else {
			$exact_path = "Forum$in{transfer_to}";
		}

		# get forum post count
		local ($last_topic_number_n, $total_topic_count_n, $total_post_count_n, $new_topic_number);

		if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
			@newforumcount       = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
			$last_topic_number_n = $newforumcount[0];
			chomp($last_topic_number_n);
			$total_topic_count_n = $newforumcount[1];
			chomp($total_topic_count_n);
			$total_post_count_n = $newforumcount[2];
			chomp($total_post_count_n);

		} else {
			$total_post_count_n  = 0;
			$last_topic_number_n = 0;
			$total_topic_count_n = 0;
		}

		($hyphen_date, $post_time) = (split(/\|\|/, $topic_file[-1]))[3,4];

		#my @rev_topic_file = reverse(@topic_file);
		#my $last_post      = $rev_topic_file[0];
		#my @get_dt         = split (/\|\|/, $last_post);
		#$hyphen_date = $get_dt[3];
		#$post_time   = $get_dt[4];

		# see if we need to create lasttime file
		unless (&FileExists("$vars_config{NonCGIPath}/$exact_path/lasttime.file")) {

			&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lasttime.file", "$hyphen_date\n$post_time\n");

		}    # if we need to create lasttime file

		# add transferred topic posts to forum totals
		$total_post_count_n  = $total_post_count_n + $topic_posts;
		$total_topic_count_n = $total_topic_count_n + 1;

		if ($last_topic_number_n > 0) {
			$last_topic_number_n++;
			$new_topic_number = sprintf("%6d", $last_topic_number_n);
			$new_topic_number =~ tr/ /0/;
		} else {
			$new_topic_number = "000001";
		}

		# Now that we know the new topic number, we can update the original..
		if ($in{move_type} eq 'delete') {

			# update .threads file
			&RequireCode("ubb_lib_2.cgi");
			&RequireCode("ubb_lib_posting.cgi");
			&unlink_topic_from_forum_summary($in{f}, $in{t});

			# regen the last*.files
			&CreateLastTimeFiles($in{f});

			# delete old topic
			&Unlink("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

		} else {

			# update topic file in old forum

			if ($stat_line[1] =~ /N/) {
				$stat_line[1] = 'NX';
			} else {
				$stat_line[1] = 'X';
			}

			$stat_line[7] = &Template(qq!<a href="$ULTIMATEBB?ubb=get_topic;f=$in{transfer_to};t=$new_topic_number">$vars_wordlets{topic_moved}</a>!,
						{ FORUM => $new_forum[1] });

			# adjust @topic_file
			$topic_file[0] = join ("||", @stat_line);
			$topic_file[0] .= "\n";

			&WriteTopic($in{f}, $in{t}, @topic_file);
			&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $in{t}, \@topic_file);

		}    # if/else deleting old topic

		# delete old forum cache file
		&ClearSingleForumPageCache($exact_path, $in{f});

		# delete old topic HTML
		#unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");
		my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
		&DoThatClearCacheThing($thispath, $in{t});

		# If this is a poll, update the poll data
		chomp($stat_line[10]);
		if($stat_line[10] =~ m/^\w{12}$/) {
			&RequireCode("ubb_poll.cgi");
			&poll_move($stat_line[10], $in{transfer_to}, $new_topic_number);
		} # end if

		#get new %forum_topics
		my $topicref = &GetForumTopics($in{transfer_to});
		%forum_topics = %$topicref;

		#load up the proper forum_thread_data file for this forum
		&SafeGetThreadData2($in{transfer_to}, $new_topic_number);

		#update the forum_thread_data file
		&UpdateForumThreadDataForSingleThreadAndWrite($in{transfer_to}, $new_topic_number, \@new_topic_file);

		&RequireCode("ubb_lib_2.cgi");
		&RequireCode("ubb_lib_posting.cgi");

		#update the .threads file
		&update_forum_summary_for_topic_move($in{transfer_to}, $new_topic_number, $subject, &ConvertPostTimetoJulian($hyphen_date, $post_time));

		#update the last*.file files
		&CreateLastTimeFiles($in{transfer_to});

		#write the new topic
		&WriteTopic($in{transfer_to}, $new_topic_number, @new_topic_file);

		# clear cache
		&ClearSummaryCacheCarefully((&GetForumRecord($in{transfer_to}))[0]);
		&ClearSingleForumPageCache($exact_path, $in{transfer_to});

		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;

		if ($in{move_type} eq 'keep') {

			&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}", "$vars_wordlets{topic_transferred}", "$subject");

		} else {

			&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum;f=$in{f}", "$vars_wordlets{topic_transferred}", "$old_forum[1]");
		}

	}    # if/else transfer/transfer_topic

}    # end transfer_topic

# DANGER: Do not remove the next line!
1;
# $Id: ubb_topic_maint.cgi,v 1.9 2002/04/30 18:19:05 cvscapps Exp $
