# UBB.classic Search Routines : Perl Code

# get assigned style template!
%vars_style = &LoadStyleTemplate("search");

&set_page_elements;

sub get_daily {
	local (%daily_date_time, %subject_subset, @topic_file, @stat_file, @last_post, $the_last_post, @reverse_topic, $key, @topics, $total_topics, $more, $previous, %ExactPath, $current, @get_path, %forum_names);

	# get from cache? - doesn't use ServeFromCache due to extra reqs
	if (
		(($in{start_point} eq '') ||
		($in{start_point} == 0)) &&
		($vars_misc{use_cache} ne 'no') &&
		((-s "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi") &&
		(-s "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi"))
		) {

		$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi");

		print "$ThisHTML";
		exit(0);

	}


	if (-s "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi") {

		# the sole, lone require() in the entire UBB code... :)
		eval { require "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi"; };

		if ($@) {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi");
			&StandardHTML("$vars_wordlets_err{no_daily_topics}*");
		}

	} else {

		&StandardHTML("$vars_wordlets_err{no_daily_topics}");

	}

	#need promo sr:
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

	# sort by date/time-> newest to oldest
	@topics = sort { $daily_date_time{$b} <=> $daily_date_time{$a} } keys %daily_date_time;

	# set page limit
	my $page_limit  = 50;
	my $array_limit = $page_limit - 1;
	$current = "$vars_wordlets{additional_topics}";

	# total topics in list:
	$total_topics = @topics;

	# truncate array, if necessary

	if (($in{start_point} eq '') || ($in{start_point} == 0)) {

		if ($total_topics <= $page_limit) {
			$current  = '';
			$more     = '';
			$previous = '';
		} else {
			@topics   = @topics[0 .. $array_limit];
			$more     = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_daily;start_point=$page_limit">&#187;&#187;</a>!;
			$previous = '';
		}

	} else {

		# make sure startpoint input is a number!
		unless ($in{start_point} >= 0) {
			&StandardHTML("$vars_wordlets_err{start_point_number}");
		}

		my $end_point = $in{start_point} + $array_limit;
		my $back      = $in{start_point} - $page_limit;

		if ($total_topics <= ($end_point + 1)) {
			$end_point = $total_topics - 1;
			$more      = '';
			$previous  = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_daily;start_point=$back">&#171;&#171;</a>!;


		} else {

			my $next = $in{start_point} + $page_limit;
			$more     = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_daily;start_point=$next">&#187;&#187;</a>!;
			$previous = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_daily;start_point=$back">&#171;&#171;</a>!;

		}

		@topics  = @topics[$in{start_point} .. $end_point];
		$current = "$vars_wordlets{additional_topics}";
	}


	# get HTML bits for this page
	&LoadTemplate("public_daily_topics");

	# get top of page from public_common.pl
	$ThisHTML = $Header;
	$ThisHTML .= &page_top;


	$ThisHTML .= &todays_topics_body;


	$ThisHTML .= &page_bottom;

	# get bottom of page from public_common.pl
	$ThisHTML .= $Footer;

	print "$ThisHTML";

	# print to cache if start point = 0
	if ((($in{start_point} eq '') || ($in{start_point} == 0)) && ($vars_misc{use_cache} ne 'no')) {

		# is ubb_files/misc directory created?
		unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc")) {
			mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
			chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
		}

		unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi") {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi");
		}

		&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi", $ThisHTML);

	}
	exit(0);
}    # end get_daily sr


sub prune_temps {
	my ($temp, $j, $JDate, $CompareDate, $JTime, $diff);

	opendir(DIR, "$vars_config{NonCGIPath}/searchlogs");
	my @temps = grep(/^temp-\d{7}-\d{6}-\w{4}\.cgi$/, readdir(DIR));
	closedir(DIR);

	foreach $temp (@temps) {
		($j, $JDate, $JTime, $j) = split (/-/, $temp);
		$CompareDate = ($JDate + ($JTime * 0.000001));
		$diff        = $GotTime{LastLoginJulian} - $CompareDate;
		if ($diff > 0.010) {	# about 40 minutes....
			&Unlink("$vars_config{NonCGIPath}/searchlogs/$temp");
		}
	}
}    # end prune_temps


sub CreateTempSearchName {
	return $GotTime{SearchJulian} . "-" . &GeneratePasswordCore(4);
} # end CreateTempSearchName


sub search {

	#check for search directory
	unless (&DirExists("$vars_config{NonCGIPath}/searchlogs")) {
		mkdir("$vars_config{NonCGIPath}/searchlogs", 0777);
		chmod(0777, "$vars_config{NonCGIPath}/searchlogs");
	}

	&prune_temps;

	@forums = ();
	%forum_selected = ();
	$forum_list = "";

	# generate forum list, based on user's permissions
	&GetForumRecord(0);
	LOOPER: foreach my $number (sort {$a <=> $b} keys %vars_forums) {

		# is forum open?
		if ($vars_forums{$number}->[3] eq 'Off') { next LOOPER; }

		# is forum private? If so, check permission!
		if ($vars_forums{$number}->[6] =~ m/private/) {

			# must be logged in!
			if ($username eq '') { next LOOPER; }

			# check user permissions
			my @user_profile = &verify_id_num($username, $password, $user_number);
			chomp($user_profile[8]);

			if($user_permissions->has_permission('forum', 'view', $vars_forums{$number}->[8])) {
				push (@forums, $vars_forums{$number}->[8]);
				next LOOPER;
			} elsif(&user_access($vars_forums{$number}->[8], @user_profile) eq "true") {
				push (@forums, $vars_forums{$number}->[8]);
				next LOOPER;
			} else {
				next LOOPER;
			} # end if
		} else {

			# not a private forum, so:
			push (@forums, $vars_forums{$number}->[8]);
		}


	}    # end forum loop


	# set forum?
	if ($in{search_forum} ne '') {
		my $fn = $in{search_forum};
		$forum_selected{$fn} = 'selected="selected"';
	}

	# @forums contains all forum numbers user is permitted to search
	if ($vars_search{AllowTotalSearch} eq 'TRUE') {
		$forum_list = qq!<option value="ALL"> $vars_wordlets{search_all_forums}</option>!;
	}

	foreach my $number (@forums) {
		$forum_list .= qq~<option value="$number" $forum_selected{$number}>&raquo; $vars_forums{$number}->[1]</option>
~;
	}

	# display profile info
	&LoadTemplate("public_search");

}


sub search_tng_dispatch {
	$| = 1;

	print header;

	if(!exists $in{d}) {
		# If this is the first submit...
		if(exists $in{search_forum}) {
			# filter out common words
			$in{search_words_original} = &strip_lead_trail_space($in{search_words});
			$vars_search{removelist} ||= $vars_search{removelist_stock};
			foreach my $word (split(/\|/, $vars_search{removelist})) {
#				print "->$in{search_words}<br />";
				$in{search_words} =~ s/\b$word\b//isg;
#				print "=!$in{search_words}<br />";
			} # end foreach

			$in{search_words} = &strip_lead_trail_space($in{search_words});
			if($in{search_words_original} ne $in{search_words}) {
				$in{original_terms_modified}++;
			} # end if

#			die $in{search_words_original};

			if($in{search_forum}) { $in{search_forum} =~ m/^(ALL|\d+)$/ or &PostHackDetails($vars_wordlets_err{invalid_input}); }

			my %r = %in;
			if(($vars_search{IndexMethod} eq 'PERFORUM') && ($in{search_forum} eq 'ALL')){
				# Ack!  Worst case scenerio - a search in all
				# forums with multiple indexes.  Refresh time!
				$in{d} = 'multiple';
				$in{dex} = '0';
				&search_tng_dispatch;
			} elsif(($vars_search{IndexMethod} eq 'PERFORUM') && ($in{search_forum} =~ m/^\d+$/)) {
				# Multiple indexes and searching just one
				$r{filename_extra} = $in{search_forum};
			} else {
				# single index, so it doesn't matter...
				$r{filename_extra} = "";
			} # end if

			# disallow private forum searching unless user has access
			if(($in{search_forum} =~ m/^\d+$/) && ($vars_forums{$in{search_forum}}->[6] =~ m/private/) &&
			    (!$username || !$user_permissions || !$user_permissions->has_permission('forum', 'view', $in{search_forum}) )) {
				&StandardHTML($vars_wordlets_err{no_access});
			} # end if

			my $resline = &search_tng_core_onefile(\%r);
			if(scalar(@{$resline}) < 1) {
				&StandardHTML($vars_wordlets_err{search_no_results});
			} else {
				&search_tng_prepare_results($resline);
			} # end if
			exit(0);

		} else {
			&StandardHTML($vars_wordlets_err{search_nowhere});
		} # end if
	} else {
		if($in{d} eq 'multiple') {
			# search_limit_2, unflatten_hash
			#die "I can't handle that type of search yet.";
			my ($results, $inner) = ([], {});

			if($in{record} =~ m/^\d{7}-\d{6}-\w{4}$/) {
				($results, $inner) = &search_tng_retrieve_results("$vars_config{NonCGIPath}/searchlogs/temp-$in{record}.cgi");
				# update %in with the data from the file...
				my %innah = %{&unflatten_hash($inner)};
				%in = (%innah, %in);
			} else {
				$in{record} = &CreateTempSearchName;
			} # end if

			&GetForumRecord(0);

			my $last_number = (sort {$a <=> $b} keys %vars_forums)[-1];

			# figure out the next forum we should search in
			while(1) {
				$in{dex}++;
				my $number = $vars_forums{$in{dex}}->[8];
				if($in{dex} > $last_number) {
					$in{dex} = undef; last;
				} # end if
				next unless $number;
				next if $vars_forums{$number}->[4] eq 'Off';
				if($vars_forums{$number}->[6] =~ m/private/) {
					# Don't let unregs search private forums
					next unless $username && $user_permissions;
					# And make sure this user has permission to do so...
					next unless $user_permissions->has_permission("forum", "view", $number);
				} # end if
				$in{dex} = $number;
				$in{search_forum} = $number;
				last;
			} # end while

			if(defined $in{dex}) {
				my %r = %in;
				$r{filename_extra} = $in{dex};
				my $resline2 = &search_tng_core_onefile(\%r);
				foreach(@{$resline2}) {
					$in{results_found}++;
					push(@{$results}, $_);
				} # end foreach
			} # end if

			my $doneness = &search_tng_prepare_results($results, 1);

			my $url =  qq($vars_config{CGIURL}/ultimatebb.cgi?ubb=search_tng;d=results;record=$in{record});
			my $url2 = qq($vars_config{CGIURL}/ultimatebb.cgi?ubb=search_tng;d=multiple;record=$in{record};dex=$in{dex});
			my $wrd = &Template($vars_wordlets{search_limit_2}, {NUMBER => "$vars_search{soft_limit} - $vars_search{hard_limit}"});
			my $frm = &Template($vars_wordlets{search_looking_in_forum}, { FORUM => "$vars_forums{$in{dex}}->[1] (# $in{dex})"});
			my $sofar = &Template($vars_wordlets{search_found_so_far}, {NUMBER => $in{results_found} + 0});

			if($doneness == 1) {	# manually write results
				&search_tng_record_results($in{record}, $results)
			} # end if
			my $url =  qq($vars_config{CGIURL}/ultimatebb.cgi?ubb=search_tng;d=results;record=$in{record});
			my $url2 = qq($vars_config{CGIURL}/ultimatebb.cgi?ubb=search_tng;d=multiple;record=$in{record};dex=$in{dex});
			my $wrd = &Template($vars_wordlets{search_limit_2}, {NUMBER => "$vars_search{soft_limit} - $vars_search{hard_limit}"});
			my $frm = &Template($vars_wordlets{search_looking_in_forum}, { FORUM => "$vars_forums{$in{dex}}->[1] (# $in{dex})"});
			my $sofar = &Template($vars_wordlets{search_found_so_far}, {NUMBER => $in{results_found} + 0});
			if($doneness == 2) {
				&Transition2($url, "$vars_wordlets{search_wait} $frm <br /> <br /> $sofar  <br /><small>$wrd</small>", $vars_wordlets{search_continuing}, "");
			} elsif(scalar(@{$results}) > $vars_search{'soft_limit'}) {
				&search_tng_prepare_results($results);
			} elsif(!defined $in{dex}) {
				&Transition2($url, "$vars_wordlets{search_wait} $frm <br /> <br /> $sofar <br /><small>$wrd</small>", $vars_wordlets{search_continuing}, "");
			} else {	# let's keep going
				&Transition2($url2, "$vars_wordlets{search_wait} $frm <br /> <br /> $sofar  <br /><small>$wrd</small>", $vars_wordlets{search_continuing}, "");
			} # end if

			exit(0);

		} elsif($in{d} eq 'results') {
			unless($in{record} =~ m/^\d{7}-\d{6}-\w{4}$/) {
				&PostHackDetails($vars_wordlets_err{invalid_input});
			} # end unless
			my($results, $inner) = &search_tng_retrieve_results("$vars_config{NonCGIPath}/searchlogs/temp-$in{record}.cgi");
			# update %in with the data from the file...
			my %innah = %{&unflatten_hash($inner)};
			%in = (%innah, %in);

			if(scalar(@{$results}) < 1) {
				&StandardHTML($vars_wordlets_err{search_no_results});
			} else {
				&search_tng_display_results($results);
			} # end if
			exit(0);
		} else {
			# Otherwise we have a dispatchable item, so do it...
			die "I don't know how to dispatch a '$in{d}'.";
		} # end if
	} # end if

	die "Fellthough.";
} # end search_tng_dispatch


sub search_tng_core_onefile {	# Caution: Deep magic follows.  Well, compared to what used to be done.  :)

	my $args = shift;
	my $path = "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index/forumindex";
	my $handle = $filehandle->open('index', 'readonly', "$path$args->{filename_extra}.cgi");
	$user_post_index = undef;

	if(($args->{search_user}) && ($args->{search_user} =~ m/^\d+$/)) {
		my $user_sub = q!
sub search_tng_user_sub {
	my $forum = ! . ((($args->{search_forum} ne 'ALL') && ($args->{search_forum} ne '')) ? $args->{search_forum} : 'undef') . q!;
	my @line = split(/\|/, $_[0]);
	next unless $line[3] =~ m/^\d{6}$/; # modern index
	if($forum) {
		return undef unless $forum == $line[1];
	} # end if
	return(join('|', @line[1,2,3]), 1);
} # end search_tng_user_sub
!;

		{ # start local
			local $SIG{'__DIE__'} = sub { return; };
			local $SIG{'__WARN__'} = sub { return; };
			eval $user_sub;
		} # end local

		if(!defined &search_tng_user_sub) {
			&StandardHTML($vars_wordlets_err{search_filtersub_failure});
#			die "Couldn't create user filter: $@";
		} # end if

		my $f = "$vars_config{MembersPath}/user_posts/" . sprintf("%.8d", $in{search_user}) . ".cgi";
		if(&FileExists($f)) {
			my $user_handle = $filehandle->open('file', 'readonly', $f);
			$user_post_index = $user_handle->readfile_filtered_ashashref(\&search_tng_user_sub);
			$filehandle->close($user_handle);
		} else {
			&StandardHTML($vars_wordlets_err{search_user_no_posts});
		} # end if
	} # end if

	my $andor = ($args->{match_all} eq "no" ? '||' : '&&');
	my $andorq = quotemeta($andor);

	my @words = split(/\s+/, &strip_lead_trail_space($args->{search_words}));

	my $title_search = "";
	my $body_search = "";
	my $word_search = "";
	if(scalar(@words) > 0) {
		foreach my $w (@words) {
			my $wor = quotemeta($w);
			$title_search .= qq!(\$items[4] =~ m/$wor/i) $andor !;
			$body_search .= qq!(\$items[5] =~ m/$wor/i) $andor !;
		} # end foreach
		$title_search =~ s/ $andorq $//;
		$body_search =~ s/ $andorq $//;

		$word_search = qq~($title_search)~;
		$word_search = qq~($word_search || ($body_search))~ if $args->{search_in} ne "SUBJECT";
		$word_search = qq~($word_search && (\$items[2] eq '000000'))~ if $args->{search_in} eq "SUBJECT";
#	} else {
#		$word_search = qq~ (1701) ~; #("$args->{search_words}" =\~ m/./) ~;
	} # end if

	my $datestring = ( ((exists $args->{search_date}) && ($args->{search_date} ne 'ALL')) ? q~my $date = join("", (split(/\-/, $items[3]))[2,0,1]);~ : "");

	my($thend, $thent) = &ConvertJulianToPostTime(($GotTime{LastLoginJulianDATE} - $args->{search_date}));
	my $this_date = join("", (split(/\-/, $thend))[2,0,1]);
	my $date_search = ($datestring ? qq~ (\$date > $this_date)~ : "");

	$user_search = ($user_post_index ? qq~ (exists \$main::user_post_index->{join('|', \@items[0,1,2])})~ : '');

	my($forumif_open, $forumif_close);
	if($args->{search_forum} ne 'ALL') {
		$forumif_open = q~
	if($items[0] == ~ . $args->{search_forum} . q~) {
~;
		$forumif_close = q~
	} else {
		return undef;
	} # end if
~;
	} # end if

	# Make sure that we're actually going to do a search for something...
	unless($user_search || $date_search || $word_search) {
		my $error = ( $args->{original_terms_modified} ? 'search_for_nothing2' : 'search_for_nothing' );
		&StandardHTML($vars_wordlets{$error});
	} # end unless

	my %workaround;	# really, really, really stupid workaround
	$workaround{$word_search}++ if $word_search;
	$workaround{$date_search}++ if $date_search;
	$workaround{$user_search}++ if $user_search;
	my $searchline = join("\n\t\t && ", keys %workaround);

	my $substring = q~
sub search_tng_filter_sub {
	my @items = split(/\|/, $_[0]);
	~ . $datestring . $forumif_open .q~
		if(
		~ . $searchline . q~
		) {
			$items[5] = undef;
			return \@items;
		} else {
			return undef;
		} # end if
	~ . $forumif_close . q~
} # end sub
	~;

#	die $substring;

	{ # start local
		local $SIG{'__DIE__'} = sub { return; };
		local $SIG{'__WARN__'} = sub { return; };
		eval $substring;
	} # end local

	if(!defined &search_tng_filter_sub) {
		&StandardHTML($vars_wordlets_err{search_filtersub_failure});
#		die "Couldn't create search filter: $@";
	} # end if

	my $resline = $handle->readfile_filtered_asarrayref(\&search_tng_filter_sub);
	$filehandle->close($handle);

	return $resline;

} # end search_tng_core_onefile



sub search_tng_sortbydate {
	my $one = $a;
	my $two = $b;

	my $ay = join("", (split(/\-/, $one->[3]))[2,0,1] );
	my $bee = join("", (split(/\-/, $two->[3]))[2,0,1] );
	return $ay <=> $bee;
} # end search_tng_sortbydate

sub search_tng_prepare_results {
	my $resline = shift;
	my $justreturn = shift;

	my $c = scalar(@{$resline});
	my @sorted = reverse sort search_tng_sortbydate @{$resline};
	if($c > $vars_search{page_limit}) {
		# need to write this thing to a tempfile...
		if($c > $vars_search{soft_limit}) {
			if($c > $vars_search{hard_limit}) {
				# Gotta truncate it to the max results limit...
				@sorted = @sorted[0 .. ($vars_search{hard_limit} - 1)];
			} # end if
		} # end if
		$in{record} = &CreateTempSearchName unless $in{record};
		&search_tng_record_results($in{record}, \@sorted)
	} # end if

	if($justreturn > 0) {
		return $justreturn;
	} elsif(scalar(@sorted) > 0) {
		&search_tng_display_results(\@sorted);
	} else {
		&StandardHTML($vars_wordlets_err{search_no_results});
	} # end if
} # end search_tng_prepare_results

sub search_tng_display_results {
	my $resline = shift;

	# Globals: StartPoint, EndPoint, MatchTotal, NextWording

	# resline is always < hard_limit

	$StartPoint = ($in{result_start} ? $in{result_start} : 0 );
	$EndPoint = $StartPoint + $vars_search{page_limit};
	$MatchTotal = scalar(@{$resline});

	my @rl;
	if($MatchTotal > $vars_search{page_limit}) {
		my $w = $StartPoint + $vars_search{page_limit};
		if($w > $MatchTotal) {
			$w = $MatchTotal;
		} elsif($MatchTotal > $EndPoint) {
			$NextWording = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=search_tng;d=results;record=$in{record};result_start=$w">[$vars_wordlets{search_next}]</a>);
		} # end if
		$w--;
		@rl = @{$resline}[$StartPoint .. $w];
	} # end if
	$resline = \@rl if @rl;

	if($EndPoint > $MatchTotal) { $EndPoint = $MatchTotal; }

	$NextWording .= " &nbsp; &nbsp; $vars_wordlets{search_ed_for} '<i>$in{search_words_original}</i>' ";
	$NextWording .= " $vars_wordlets{search_original_modified}" if $in{original_terms_modified};

	$StartPoint += 1 unless $StartPoint;

	&LoadTemplate("public_search_results");

	my $ThisHTML = "";

	&GetForumRecord(0);

	my $leng = 0;

	my $counter = 0;
	for $eachone (reverse sort search_tng_sortbydate @{$resline}) {
		my @goodline = @{ $eachone };
		$leng += length(join("", @goodline));

		$TheURL	= "$ULTIMATEBB?ubb=get_topic;f=$goodline[0];t=$goodline[1]";

		# redirect to the right page
		if($vars_display{HTMLDisplayMax} > 0) {
			my $post_number = $goodline[2] + 0;
			my $page = int($post_number / $vars_display{HTMLDisplayMax}) + ( int($post_number % $vars_display{HTMLDisplayMax}) > 0 ? 1 : 0 );
			if($page > 1) {
				$TheURL .= ";p=$page";
			} # end if
			$TheURL .= "#$goodline[2]";
		} # end if

		# Row HTML
		$ThisHTML .= &MatchRow($goodline[2], $TheURL, $goodline[4], &DateFormat($goodline[3]), $vars_forums{$goodline[0]}->[1], $counter);
		$counter++;
	}    # loop thru each match

	print &PageTop . $ThisHTML . &PageBottom;
} # end search_tng_display_results


sub search_tng_record_results {
	my $name = shift;
	my $resline = shift;
	my $string;
	foreach my $line (@{$resline}) {
		$string .= join("|", @{$line}) . "\n";
	} # end foreach
	&WriteFileAsString("$vars_config{NonCGIPath}/searchlogs/temp-$name.cgi", &flatten_hash(\%in) . "\n" . $string);
} # end search_tng_record_results

sub search_tng_retrieve_results {
	my @res = &OpenFileAsArray(shift);
	my $innah = shift @res;
	my $ults = [];
	foreach(@res) { chomp; push(@{$ults}, [split(/\|/)]); }
	return($ults, $innah);
} # end search_tng_retrieve_results

# DANGER: Do not remove the next line!
1;
# $Id: ubb_search.cgi,v 1.14 2002/04/18 22:27:18 cvscapps Exp $
