# UBB.classic Registration Routines : Perl Code

# get assigned style template!
%vars_style = &LoadStyleTemplate("registration");

&set_page_elements;

# are registrations being accepted?
if ($vars_registration{SuspendRegister} eq "true") {
	&StandardHTML("$vars_wordlets_err{registrations_suspended}");
}

sub check_age {

	# if user is logged in, no need to register
	if ($username ne '') {
		&StandardHTML("$vars_wordlets_err{already_registered}");
	}

	my $head = "";

	if((!cookie("age$vars_config{Cookie_Number}")) && (!exists $in{check_cookie})) {

		# step one, figure out if the date is sane
		my $valid = &IsValidDate($in{year}, $in{month}, $in{day});
		if($valid > 0) {
			&StandardHTML($vars_wordlets_err{bad_date});
			exit;
		} # end if

		# now that we know it's a good date, set the date cookie
		my $cookie = cookie(
			-name    => "age$vars_config{Cookie_Number}",
			-value   => [sprintf("%04d", $in{year}), sprintf("%02d", $in{month}), sprintf("%02d", $in{day})],
			-path    => '/',
			-expires => '+1h'
		);

		$head = header(
			-cookie  => [$cookie],
			-charset => "$masterCharset"
		);

	} else {

		($in{year}, $in{month}, $in{day}) = cookie("age$vars_config{Cookie_Number}");
		my $valid = &IsValidDate($in{year}, $in{month}, $in{day});
		if($valid > 0) {
			&StandardHTML($vars_wordlets_err{bad_date});
			exit;
		} # end if

		$head = header(
			-charset => "$masterCharset"
		);

	} # end if

	print $head;

	my $diff = $GotTime{JSYear} - $in{year};

	# Right, if we're this far then we know for a fact that
	# the date is valid.  Let's figure out how long ago it was.
	if($diff == 13) {
		# There are exactly 13 years between now and then, so let's
		# do more comparisons to figure it all out

		# Adjust the number of days between now and then
		my @years = ($in{year} .. $GotTime{JSYear});
		my $addleap; foreach my $year (@years) { $addleap += &YearIsLeap($year) }
		my $adjusted = 4744 + $addleap; # it's really 4745, but we subtract
						# one to allow today to be their birthday

		# now actually do the math
		my $bday = &jday($in{month}, $in{day}, $in{year});
		my $daysold = ($GotTime{LastLoginJulianDATE} - $bday) - $adjusted;

		if($daysold < 0) {
			&reg_under_13;# under 13
		} else {
			&reg_over_13;# over 13
		}
	} elsif($diff > 13) {
		# more than 13 years ago, obviously OK
		&reg_over_13;# over 13
	} else {
		# less than 13 years ago, definately not OK
		&reg_under_13;# under 13
	} # end if
} # end sub

sub reg_over_13 {
	# display rules
	$BBRules = &ConvertReturns($vars_registration{BBRules});
	&LoadTemplate("public_display_rules");
	exit;
} # end sub


sub reg_under_13 {
	local ($COPPAWording, %select_list);

	if ($vars_registration{COPPAType} eq 'COPPADenied') {
		&StandardHTML("$vars_wordlets_err{age_deny}");
	} # end if

	if ($vars_registration{COPPAType} eq 'COPPAFormOnly') {
		&LoadTemplate("public_reg_confirm_kid");
		exit;
	} else {
		$COPPAWording = &ConvertReturns($vars_registration{COPPAWording});
		&LoadTemplate("public_rules_for_minors");
		exit;
	} # end if
	exit;
} # end sub


sub do_agree {
	local ($BBRules);

	# if user is logged in, no need to register
	if ($username ne '') {
		&StandardHTML("$vars_wordlets_err{already_registered}");
	}

	# do age check?
	if (($vars_registration{COPPACheck} eq "ON") && ($in{age} ne "OK")) {
		&age_check;
		exit;
	}

	# display rules
	$BBRules = &ConvertReturns($vars_registration{BBRules});
	&LoadTemplate("public_display_rules");
}    # do_agree

sub age_check {
	local ($NextCOPPALink, $PrivacyStatement, $PrivacyStatementVerbose);

	# if user is logged in, no need to register
	if ($username ne '') {
		&StandardHTML("$vars_wordlets_err{already_registered}");
	}

	&GetDateTime;    # sets %GotTime vars

	my @months = ("blank", "$vars_wordlets_date{month_1}", "$vars_wordlets_date{month_2}", "$vars_wordlets_date{month_3}", "$vars_wordlets_date{month_4}", "$vars_wordlets_date{month_5}", "$vars_wordlets_date{month_6}", "$vars_wordlets_date{month_7}", "$vars_wordlets_date{month_8}", "$vars_wordlets_date{month_9}", "$vars_wordlets_date{month_10}", "$vars_wordlets_date{month_11}", "$vars_wordlets_date{month_12}");

	$COPPADate = "$GotTime{mday} $months[$GotTime{JSMonth}] " . ($GotTime{JSYear} - 13);

	if ($vars_registration{COPPAFormOnly} eq 'YES') {
		$NextCOPPALink = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=show_coppa_form";
	} else {
		$NextCOPPALink = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=coppa_agree";
	}


	if ($vars_display{ShowPrivacyLink} eq 'ON') {
		$PrivacyStatement        = qq!| <a href="$vars_display{PrivacyURL}">$vars_wordlets{privacy_statement}</a>!;
		$PrivacyStatementVerbose = qq!<p><a href="$vars_display{PrivacyURL}">$vars_config{BBName} $vars_wordlets{privacy_statement}</a>.</p>!;
	}

	&LoadTemplate("public_age_check");

}    # end age_check

sub register_page {
	local ($B1, $B2, $ImagesWording, $days, %select_list);

	my @age_cookie = cookie("age$vars_config{Cookie_Number}");
	if($vars_registration{COPPACheck} eq "ON") {
		if(!@age_cookie) {
			&StandardHTML($vars_wordlets_err{reg_no_cookie});
			exit;
		} #end if
	} # end if

	# if user is logged in, no need to register
	if ($username ne '') {
		&StandardHTML("$vars_wordlets_err{already_registered}");
	}

	$days = $vars_display{DaysPruneDefault};
	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$select_list{$_} = '';
	}
	$select_list{$days} = 'selected="selected"';

	&LoadTemplate("public_register_form");
	&register_form_core("no"); #kid
}    # end register_page


sub coppa_agree {
	&StandardHTML("$vars_wordlets_criterr{coppa_agree_called} <br /><big><pre>" . $filehandle->tracer() . "</pre></big>");
#	local ($COPPAWording, %select_list);
#
#	# if user is logged in, no need to register
#	if ($username ne '') {
#		&StandardHTML("$vars_wordlets_err{already_registered}");
#	}
#
#	# check to see if admin wants to deny outright
#	if ($vars_registration{COPPAType} eq 'COPPADenied') {
#		&StandardHTML("$vars_wordlets_err{age_deny}");
#	}
#
#	# accepting reg?
#	if ($vars_registration{SuspendRegister} eq "true") {
#		&StandardHTML("$vars_wordlets_err{registrations_suspended}");
#	}
#
#	# display rules
#	$COPPAWording = &ConvertReturns($vars_registration{COPPAWording});
#	&LoadTemplate("public_rules_for_minors");
}    # end coppa_agree


sub underage_register_page {
	local (@email_verify_html, $pw_wording_1, $pw_wording_2);

	my @age_cookie = cookie("age$vars_config{Cookie_Number}");
	if($vars_registration{COPPACheck} eq "ON") {
		if(!@age_cookie) {
			&StandardHTML($vars_wordlets_err{reg_no_cookie});
			exit;
		} #end if
	} # end if

	# if user is logged in, no need to register
	if ($username ne '') {
		&StandardHTML("$vars_wordlets_err{already_registered}");
	}

	if ($vars_registration{SuspendRegister} eq 'true') {
		&StandardHTML("$vars_wordlets_err{registrations_suspended}");
	}

	my $days = $vars_display{DaysPruneDefault};
	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$select_list{$_} = '';
	}
	$select_list{$days} = 'selected="selected"';

	#&LoadTemplate("public_register_page_kid");
	&LoadTemplate("public_register_form");
	&register_form_core("yes"); #kid
}    # end underage_register_page

sub submit_registration {
	local (@age_cookie, $lc_it, $the_email, $j, $lc_the_email, $ubb_code_images, $permission, $sendto, $from, $subject, $message, $message_text, $message_html, $reg_wording_1, $reg_wording_2, $public_name, $pub_warning, $lc_public_name, $cc, $bcc, $COPPAInstructions, $password, $user_name, $email, %select_list, $sig, $sig_html, $this_status, $html_body, $ModWording, $HTMLMessage, $mod_q, $user_ratings, $AllowMassMail, $EmailView, $private_message, $private_message_notify);
	local (*MEMBERSHIP);
	local (*FILE);

	&GetOrPost('POST');

	@age_cookie = cookie("age$vars_config{Cookie_Number}");
	if($vars_registration{COPPACheck} eq "ON") {
		if(!@age_cookie) {
			&StandardHTML($vars_wordlets_err{reg_no_cookie});
			exit;
		} #end if
	} # end if


	foreach $key (keys %in) {
		# rem HTML and unclosed tags
		$in{$key} =~ s/(__)(\w+)(__)/_ $2 _ /g;    # silly IIS, always allowing insecure things to happen when you aren't paying attention....

		unless (($key eq 'username') || ($key eq 'password') || ($key eq 'password_confirm')) {
			$in{$key} =~ s/<.*?>//sg;
			$in{$key} =~ s/</&lt;/sg;
			$in{$key} =~ s/>/&gt;/g;

			unless ($key eq 'signature') {
				$in{$key} =~ s/\s+/ /sg;
				$in{$key} =~ s/"/&quot\;/sg;
			}
		}
	}


	if ($vars_registration{allowHighBit} ne "YES") {

		# now make sure that the user isn't forging input
		my %checkthese = (
			"location"     => 80,
			"occupation"   => 80,
			"interests"    => 80,
			"url"          => 80,
			"picture"      => 80,
			"icq"          => 25,
			"aim"          => 32,
			"customfield1" => 80,
			"customfield2" => 80,
			"customfield3" => 80,
			"customfield4" => 80,
		);

		foreach (keys %checkthese) {
			&CheckLength($_, $checkthese{$_});
		}
	}    #end if highbit

	#let's assign a few
	$user_name = &name_clean($in{username});
	$email     = $in{email};
	$password  = $in{password};


	# login name has to be clean

	#check for illegal (non alphanumeric characters)
	&illegal_name_check($user_name);
	if ($in{public_name} ne '') { &illegal_name_check($in{public_name}); }

	# make sure size is ok
	if ((length($in{username}) > 25) || (length($in{public_name}) > 35) || (length($in{password}) > 13)) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{name_too_long}");
	}

	# make sure email is in valid format!
	if (&email_test($email)) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{email_invalid}");
	}

	# check password --
	if ($password =~ m/__\w+__/) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{password_error}");
	}

	# does email match confirmation?
	if ($email ne "$in{email_confirm}") {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{email_confirm_err}");
	}

	# does pw match confirmation?
	if ($vars_registration{EmailVerify} eq 'OFF') {
		if ($password ne "$in{password_confirm}") {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

			&StandardHTML("$vars_wordlets_err{password_confirm_err}");
		}
	}

	# Okay, now that we've gotten this far, we can
	# throw an error if they're doing a flood
	if ($vars_misc{FloodCheck} eq 'ON') {
		&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
		&floodcheck;
	} # end if

	# validate
	my @VA = ("username");

	if ($vars_registration{EmailVerify} eq 'ON') {
		push (@VA, 'email');
		push (@VA, "email_confirm");
	}

	if ($in{kid} eq 'yes') {

		push (@VA, "parent_email");

		unless ($in{parent_email} ne $email) {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

			&StandardHTML("$vars_wordlets_err{parent_email_not_unique}");
		} else {
			if(&email_test($in{parent_email})) {
				&StandardHTML("$vars_wordlets_err{email_invalid}");
			}
		}

	} else {

		if ($vars_registration{location_field_use} eq 'REQ')   { push (@VA, "location"); }
		if ($vars_registration{occupation_field_use} eq "REQ") { push (@VA, "occupation"); }
		if ($vars_registration{picture_field_use} eq "REQ")    { push (@VA, "picture"); }
		if ($vars_registration{homepage_field_use} eq "REQ")   { push (@VA, "homepage"); }
		if ($vars_registration{interests_field_use} eq "REQ")  { push (@VA, "interests"); }
		if ($vars_registration{signature_field_use} eq "REQ")  { push (@VA, "signature"); }
		if ($vars_registration{icq_field_use} eq "REQ")        { push (@VA, "icq"); }
		if ($vars_registration{aim_field_use} eq "REQ")        { push (@VA, "aim"); }
		if (($vars_registration{bdate_field_use} eq "REQ") && (!@age_cookie)) { push(@VA, "bday_year", "bday_month", "bday_day"); }

		if ($vars_registration{EmailVerify} eq 'OFF') { push (@VA, "password"); push (@VA, "password_confirm"); }

		if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push (@VA, "customfield1"); }
		if (($vars_registration{custom2_field_use} eq "REQ") && ($vars_registration{customfield2} ne '')) { push (@VA, "customfield2"); }
		if (($vars_registration{custom3_field_use} eq "REQ") && ($vars_registration{customfield3} ne '')) { push (@VA, "customfield3"); }
		if (($vars_registration{custom4_field_use} eq "REQ") && ($vars_registration{customfield4} ne '')) { push (@VA, "customfield4"); }

	}    # if/else a child

	&Validate(@VA);

	$user_name =~ s/\s+/ /g;
	$email     =~ s/\s+//g;

	# is user banned?
	&check_email_bans($email);
	&check_ip_bans;

	if ($in{public_name} eq '') {
		$public_name = "$user_name";
	} else {
		$public_name = &name_clean($in{public_name});
	}

	#lc pub name for check later...
	$lc_public_name = lc($public_name);

	# check to make sure login name is unique
	my @members    = &GetMemberListArray;
	my @email_list = &GetEmails;

	my $lc_username = lc($user_name);

	&CheckForExistingNames($lc_username,    1);    # 1 tells the routine to print out the HTTP header
	&CheckForExistingNames($lc_public_name, 1);    # 1 tells the routine to print out the HTTP header


	# make sure email isn't a duplicate, if this is a requirement

	if ($vars_registration{EmailCheck} eq 'true') {
		my $lc_email = lc($email);    #lowercase to check for dupe
		CHECKEMAIL: for (@email_list) {
			($the_email, $j) = split (/\?\?/, $_);
			$lc_the_email = lc($the_email);
			if ($lc_email eq "$lc_the_email") {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);

				&StandardHTML("$vars_wordlets_err{dupe_email}");
				last CHECKEMAIL;
			}
		}
	}    #END if we need to do dupe email check


	# generate password, if necessary
	if ($vars_registration{EmailVerify} eq 'ON') {

		# make sure email is activated!
		if ($vars_email{UseEmail} ne 'ON') {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

			&StandardHTML("$vars_wordlets_err{email_not_on_for_reg}");
		}

		#generate password
		$password = &GeneratePassword;
	}

	# prep sig - prevent HTML, strip returns, do UBB Code

	$sig_html = $in{signature};
	if ($vars_display{AllowSignatureImage} eq 'no') {
		$ubb_code_images = 'no';
	} else {
		$ubb_code_images = 'yes';
	}

	$sig_html =~ s/(<IMG +SRC)(.*?)(>)//isg;

	# do graemlins--
	if ($ubb_code_images eq "yes") {
		$sig_html = &Smilies($sig_html);
	}

	# UBB Code-ify (if allowed)
	$sig_html = &UBBCode($sig_html, $ubb_code_images);

	#convert newlines/carriage returns to <br> and <p> html tags
	$sig_html = &PipeCleaner($sig_html);
	$sig_html = &CheckLength2(&ConvertReturns(&LimitReturns($sig_html)), 2500);

	# don't allow HTML SCRIPT TAGS
	&check_html($sig_html);

	#check for excess images-
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&excess_smilies_check($sig_html);

	$in{icq} =~ s/\D//sg;    # rem non numbers

	# assign member number
	my $last_number      = &GetLastMemberNumber;
	my $orig_last_number = $last_number + 0;

#	die $orig_last_number;

	$last_number++;
	$next_number = sprintf("%08d", $last_number);

	if (&FileExists("$vars_config{MembersPath}/$next_number.cgi")) {
		print UBBCGI::header;
		&StandardHTML("$vars_wordlets_err{wont_overwrite_profile} ($next_number)");
		exit;
	}



	# permissions?
	if ($in{kid} eq 'yes') {
		if ($vars_registration{ModerateRegs} eq 'ON') {
			$mod_q = 'Q';
			&add_to_registration_mod_list($next_number);
		}
		$permission = '&COPPA';
		$in{AllowMassMail}          = 'no';
		$in{private_message}        = 'no';
		$in{private_message_notify} = 'no';
	} elsif ($vars_registration{ModerateRegs} eq 'ON') {
		$permission = '&';
		$mod_q      = 'Q';
		&add_to_registration_mod_list($next_number);
	} else {
		$permission = 'Write&';
	}

	# set wordlets for options (new 6.01):
	if ($in{AllowMassMail} eq 'yes') {
		$AllowMassMail = "$vars_wordlets{yes_option}";
	} else {
		$AllowMassMail = "$vars_wordlets{no_option}";
	}

	if ($in{EmailView} eq 'yes') {
		$EmailView = "$vars_wordlets{yes_option}";
	} else {
		$EmailView = "$vars_wordlets{no_option}";
	}

	if ($in{user_ratings} eq 'yes') {
		$user_ratings = "$vars_wordlets{yes_option}";
	} else {
		$user_ratings = "$vars_wordlets{no_option}";
	}

	if ($in{private_message} eq 'yes') {
		$private_message = "$vars_wordlets{yes_option}";
	} else {
		$private_message = "$vars_wordlets{no_option}";
	}

	if ($in{private_message_notify} eq 'yes') {
		$private_message_notify = "$vars_wordlets{yes_option}";
	} else {
		$private_message_notify = "$vars_wordlets{no_option}";
	}

	# PNTF bits
	my $pntf_hide = $in{pntf_hide} || 0;

	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");

	# Avatar bits
	my $groupname = ( $in{kid} eq "yes" ? "COPPA_members" : "junior_members" );
	my $avatar_url;
	if(($vars_display{UseAvatars} eq "yes") && &UBB::SecurityToken::_is_in($groupname, @{$vars_groups->raw_group_access("avatars")->{"perms"}->{"use"}})) {
		my $url = strip_lead_trail_whitespace($in{avurl});
		my $nc = quotemeta($vars_config{NonCGIURL});
		$url =~ s!^$nc/+?!!;
		$url =~ s!^/+!/!;
		if($url && !check_html_boolean($url)) {
			if($url !~ m!https?://!) {
				$avatar_url = $url if -e "$vars_config{NonCGIPath}/$url";
			} elsif(($url =~ m!https?://!) && (&UBB::SecurityToken::_is_in($groupname, @{$vars_groups->raw_group_access("avatars")->{"perms"}->{"custom"}}))) {
				if((&auto_url($url) ne $url) && (&ImageChecker($url) ne '')) {
					$avatar_url = $url if &avatar_remote_url_filter($url);
				} # end if
			} # end if
		} # end if
	} # end if

	my $avhide = $in{avatar_hidden};  if(!defined $in{avatar_hidden}) { $avhide = 0; }
	my $avline = "0|0|$avhide";

	# set cookie
	if ($vars_registration{EmailVerify} eq 'OFF') {
		my $cookie = cookie(
			-name    => "ubber$vars_config{Cookie_Number}",
			-value   => [$user_name, $password, $public_name, $in{DaysPrune}, $next_number, $pntf_hide],
			-path    => '/',
			-expires => '+2y'
		);
		$username = $user_name;

		print header(
			-cookie  => [$cookie],
			-charset => "$masterCharset",
			-type    => "text/html",
		);

	} else {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

	}

	$this_status = 'Junior Member';

	# is this first member? if so, make admin
	if (!$orig_last_number) {
		unless (&FileExists("$vars_config{MembersPath}/memberslist.cgi") && (-s "$vars_config{MembersPath}/memberslist.cgi")) {
			$permission  = 'WriteAdmin&';
			$this_status = 'Administrator';
			&Unlink("$vars_config{MembersPath}/member_test.cgi");
		}
	}

	my $homepage;
	if ($in{homepage} !~ m/^http\:\/\//) { $homepage = "http://$in{homepage}"; }
	else { $homepage = $in{homepage}; }

	my $picture;
	if ($in{picture} !~ m/^http\:\/\//) { $picture = "http://$in{picture}"; }
	else { $picture = $in{picture}; }

	$picture = &ImageChecker($picture);

	# create registration file

	local($birthdate) = "";
	if(@age_cookie) {
		$birthdate = join("", @age_cookie);
		$birthdate .= "|" . ($in{bday_public} or "no");
	} else {
		if($vars_registration{bdate_field_use} eq "REQ") {
			# Require a valid date
			if(&IsValidDate($in{bday_year}, $in{bday_month}, $in{bday_day}) < 1) {
				$birthdate = sprintf("%04d", $in{bday_year}) . sprintf("%02d", $in{bday_month}) . sprintf("%02d", $in{bday_day}) . "|" . ($in{bday_public} or "no");
			} else {
				&StandardHTML($vars_wordlets_err{bad_date});
				exit;
			} # end if
		} else {
				# No requirement, so let's check
			if(&IsValidDate($in{bday_year}, $in{bday_month}, $in{bday_day}) < 1) {
				$birthdate = sprintf("%04d", $in{bday_year}) . sprintf("%02d", $in{bday_month}) . sprintf("%02d", $in{bday_day}) . "|" . ($in{bday_public} or "no");
			} else {
				# Okay, the check failed, so make it "|no"
				$birthdate = "|no";
			} # end if
		} # end if
	} # end if

	my $ipaddy = &GetIPAddress;

	my $poll_ban = 0;

	my @thismemarray = (
		$user_name, $password, $email, $homepage, $permission,    #0

		&CensorCheck($in{occupation}), &CensorCheck($in{location}), '0', $this_status, &CensorCheck($in{interests}),    #5

		$GotTime{HyphenDate}, $in{EmailView}, $sig_html, $in{icq}, $in{AllowMassMail},    #10

		$public_name, &CensorCheck($in{customfield1}), &CensorCheck($in{customfield2}), &CensorCheck($in{customfield3}),            #15

		&CensorCheck($in{customfield4}), $picture, $in{DaysPrune}, $in{aim}, '', '', $in{user_ratings}, #19

		$mod_q, $in{private_message}, $in{private_message_notify}, 'yes', '', '',	#26

		$birthdate, $ipaddy, $in{parent_email}, $pntf_hide, $poll_ban, $avatar_url, 	# 32

		$avline,	#38
	);

	&WriteMemberProfile($next_number, @thismemarray);

	$total_members = (@members + 1);    #the total number of registered users

	# update associated files
	&WriteNewMemberToMetaData($total_members, $user_name, $email, $next_number, $public_name);

	# clear forum summ cache if necessary
	if (($vars_display{DisplayMemberTotal} eq 'true') || ($vars_display{NewestMemberWelcome} eq 'yes')) {
		&ClearSummaryCache;
	}

	# now do email functions--
	if ($in{kid} ne 'yes') { $in{kid} = 'no'; }

	if ($vars_email{UseEmail} eq 'ON') {
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

		my $s = &EmailWordletFixer;
		eval($s);
		if(defined &EmailWordletFiller) {
			%vars_wordlets_email = &EmailWordletFiller();
		} else {
			&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
		} # end if

		# set email template
		%vars_style = &LoadStyleTemplate("email");

		&set_page_elements;

		$sendto = "$email";
		$from   = "$vars_registration{RegsAdminEmail}";

		# standard email verification -> send new user a password

		if ($vars_registration{EmailVerify} eq 'ON') {
			&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");



			$subject = "$vars_wordlets_email{registration_subject}";

			if ($in{kid} eq 'yes') {

				#convert coppa instructions
				$coppa_instructions = $vars_registration{COPPAInstructions};
				$subject            = "$vars_wordlets_email{reg_subject_kid}";
				$sendto             = "$in{parent_email}";
				$cc                 = "$email";

				$message   = "$vars_wordlets_email{reg_text_kid}";
				$html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_kid}" . qq!</font>!;
			}

			elsif ($vars_registration{ModerateRegs} eq "ON") {
				$message   = "$vars_wordlets_email{reg_text_mod}";
				$html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_mod}" . qq!</font>!;

			} else {
				$message   = "$vars_wordlets_email{reg_text_normal}";
				$html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_normal}" . qq!</font>!;
			}

			# is HTML format to be sent?
			if ($vars_email{email_format} ne "ascii") {
				$HTMLMessage = "$EmailHeader $html_body $Footer";
			} else {
				$HTMLMessage = '';
			}

			# in case only HTML format is to be sent:
			if ($vars_email{email_format} eq 'html') { $message = ''; }

			&ubb_mail_tng({
				'EmailTo' => $sendto,
				'EmailFrom' => $from,
				'EmailReplyTo' => $from,
				'BCCList' => undef,
				'Subject' => $subject,
				'TextMessage' => $message,
				'HTMLMessage' => $HTMLMessage,
				'CCList' => $cc,
			});


		}

		# notify registration admin?
		if ($vars_registration{OnRegsNotifyAdmin} ne 'OFF') {

			unless (($vars_registration{OnRegsNotifyAdmin} eq 'COPPA') && ($in{kid} eq 'no')) {

				$subject   = "$vars_wordlets_email{reg_notify_admin_subject}: $public_name";
				$message   = "$vars_wordlets_email{reg_notify_admin}";
				$html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_notify_admin_html}" . qq!</font>!;

				# is HTML format to be sent?
				if ($vars_email{email_format} ne 'ascii') {
					$HTMLMessage = "$EmailHeader $html_body $Footer";
				} else {
					$HTMLMessage = '';
				}

				# in case only HTML format is to be sent:
				if ($vars_email{email_format} eq 'html') { $message = ''; }
				&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");
				&ubb_mail_tng({
					'EmailTo' => $from,
					'EmailFrom' => $from,
					'EmailReplyTo' => $from,
					'BCCList' => undef,
					'Subject' => $subject,
					'TextMessage' => $message,
					'HTMLMessage' => $HTMLMessage,
					'CCList' => undef,
				});
			}

		}


	}    # if email is activated

	# get assigned style template!
	%vars_style = &LoadStyleTemplate("registration");
	&set_page_elements;

	# on screen confirmation

	my $days = $in{DaysPrune};
	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$select_list{$_} = '';
	}
	$select_list{$days} = 'selected="selected"';

	if ($in{kid} eq 'yes') {
		$COPPAInstructions = &ConvertReturns($vars_registration{COPPAInstructions});
		&LoadTemplate("public_reg_confirm_kid");
	} else {
		if ($vars_registration{ModerateRegs} eq "ON") {
			$ModWording = "$vars_wordlets{moderated_reg}";
		}
		&LoadTemplate("public_reg_confirm");
	}

}    # end submit_reg

sub add_to_registration_mod_list {
	local (*FILE);

	# parameter:
	# $_[0] : member number

	&AppendFileAsString("$vars_config{MembersPath}/moderation_q.cgi", "$_[0]\n");

}    # end add to registration_mod_list



# DANGER: Do not remove the next line!
1;
# $Id: ubb_registration.cgi,v 1.15 2002/04/18 22:27:18 cvscapps Exp $
