# UBB.classic Profile Routines : Perl Code

# get assigned style template!
%vars_style = &LoadStyleTemplate("profile");

$direct_to = qq~

<script language="javascript" type="text/javascript">
<!--
function ignore()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_ignore&u=$in{u}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=$vars_display{PopupWidth},height=$vars_display{PopupHeight}');
}
function buddy()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_buddy&u=$in{u}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=$vars_display{PopupWidth},height=$vars_display{PopupHeight}');
}
//-->
</script>

~;


&set_page_elements;

sub my_rating_list {
	local (%user, $key, $star_level, @level_1, @level_2, @level_3, @level_4, @level_5, $profiler, $level_1, $level_2, $level_3, $level_4, $level_5, $this_rating_list, $this_name, $sent_box_wording, $sent_pm_count);

	# user must be logged in!
	unless ($username ne '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
	}

	# grab user_rater hash
	if (&FileExists("$vars_config{MembersPath}/user_raters/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/user_raters/$user_number.cgi");
	}

	# sort by level:
	foreach $key (sort keys %user) {
		if (&FileExists("$vars_config{MembersPath}/$key.cgi")) {
			$this_name = &get_public_name($key);
			$profiler  = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$key" target=_blank>$this_name</a>!;


			if ($user{$key} == 1) {
				push (@level_1, $profiler);
			} elsif ($user{$key} == 2) {
				push (@level_2, $profiler);
			} elsif ($user{$key} == 3) {
				push (@level_3, $profiler);
			} elsif ($user{$key} == 4) {
				push (@level_4, $profiler);
			} else {
				push (@level_5, $profiler);
			}
		}    # unless profile exists!
	}

	# assemble var lines
	$level_1 = join (", ", @level_1);
	$level_2 = join (", ", @level_2);
	$level_3 = join (", ", @level_3);
	$level_4 = join (", ", @level_4);
	$level_5 = join (", ", @level_5);

	# display my profile page
	&LoadTemplate("public_rating_list");

}    # end my_rating_list

sub my_profile {
	local ($pm_count_sent, @pm_topics_sent, @user_profile, $chompee, $count, $overall_rating, $rating_wording, %votes, %totals, %avg, %weighted_avg, %pm_user_index, @pm_topics, $pm_dir, $pm_topic, %pm_topic, %pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_signature, %pm_to, %pm_from, %user, $user_public_name, $key, $star, $read_marker_1, $read_marker_2, $pm_count);

	# retrieve profile

	# user must be logged in!
	unless ($username ne '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
	}

	# verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);
	$count = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# get rating:
	if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {

		if (&FileExists("$vars_config{MembersPath}/user_ratings/$user_number.cgi")) {
			&RequireVars("$vars_config{MembersPath}/user_ratings/$user_number.cgi");
			$overall_rating = &round_up($weighted_avg{total});
			# patch code to prevent forgery
			if($overall_rating > 5){ $overall_rating = 5; }
			if($overall_rating < 1){ $overall_rating = 1 unless $overall_rating == 0 }
		} else {
			$overall_rating = '';
		}
	}

	if ($overall_rating ne '') {
		$overall_rating = ("user_ratings_" . "$overall_rating");
		$overall_rating = qq!<img src="$vars_config{NonCGIURL}/$vars_style{$overall_rating}" border="0">!;
	} else {
		$overall_rating = "$vars_wordlets{not_rated}";
	}


	if ($vars_display{user_ratings} ne 'off') {
		$rating_wording = "$vars_wordlets{ratings_featured_only}";
	}

	# grab user_rater hash
	if (&FileExists("$vars_config{MembersPath}/user_raters/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/user_raters/$user_number.cgi");
	}

	# get pm topics for user
	if (&FileExists("$vars_config{MembersPath}/pm_users/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/pm_users/$user_number.cgi");
	}

	if (0) {
		foreach my $this (keys %pm_user_index_sent) {
			next if (exists $pm_user_index{$this});
			$pm_user_index{$this} = $pm_user_index_sent{$this};
		}
	} else {
		$sent_pm_count    = scalar keys %pm_user_index_sent;
		$sent_box_wording = "View your sent Private Messages";

		#$sent_box_wording = $vars_wordlets{"pm_sent_box_link"}
	}    #endif

	# sort %pm_user_index
	@pm_topics      = sort { $pm_user_index{$b} <=> $pm_user_index{$a} } keys %pm_user_index;
	@pm_topics_sent = sort { $pm_user_index_sent{$b} <=> $pm_user_index_sent{$a} } keys %pm_user_index_sent;


	# pm max warning
	$pm_count = $pm_count_sent = 0;
	foreach $key ((keys %pm_user_index)) {
		$pm_count++;
	}

	foreach $key (keys %pm_user_index_sent) {
		$pm_count_sent++;
	}

	# display my profile page
	&LoadTemplate("public_my_profile");

}    # end my_profile

sub rate_member {
	local ($update, %user, %votes, %totals, %avg, %weighted_avg, $key, $rater_rating);
	local (*FILE);

	# are ratings permitted?
	if ($vars_display{user_ratings} eq 'off') {
		&StandardHTML("$vars_wordlets_err{ratings_off}");
	}

	# validate
	my @ValidateArray = ("u", "rating");
	&Validate(@ValidateArray);

	# extra test
	unless (($in{u} > 0) && ($in{rating} > 0) && ($in{rating} =~ m/^\d+?$/) && ($in{rating} > 0) && ($in{rating} < 6)) {
		&StandardHTML("$vars_wordlets_err{bad_input}");
	}

	# format ratee number
	my $ratee = &Do8Digit($in{u});

	# make sure this user is allowing ratings
	my $allowsratings = (&OpenProfile($ratee))[25];
	if($allowsratings eq "no") {
		&StandardHTML($vars_wordlets{user_turned_off_ratings});
	}

	# make sure rater is logged in!
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
	}

	my $writeadmin = (&OpenProfile($user_number))[4];
	my $modq       = (&OpenProfile($user_number))[26];
	if (($writeadmin !~ /Write/) || ($modq =~ /Q/)) {

		#user has no permissions -> can't rate
		&StandardHTML("$vars_wordlets_err{user_not_approved}");
	}

	# you can't rate yourself!
	if ($ratee eq "$user_number") {
		&StandardHTML("$vars_wordlets_err{cant_rate_self}");
	}

	# make sure profile is still there
	unless ((&FileExists("$vars_config{MembersPath}/$ratee.cgi")) && ($ratee ne '')) {
		&StandardHTML("$vars_wordlets_err{member_gone}");
	}

	# get raters history or ratings
	if (&FileExists("$vars_config{MembersPath}/user_raters/$user_number.cgi")) {

		&RequireVars("$vars_config{MembersPath}/user_raters/$user_number.cgi");
		if (exists($user{"$ratee"})) {

			# rater has already rated this person!
			&StandardHTML("$vars_wordlets_err{rated_previously}");
		}
	}

	$user{$ratee} = $in{rating};

	# update user_raters file:
	&WriteHashToFile("$vars_config{MembersPath}/user_raters/$user_number.cgi", "user", \%user);

	# get rater's rating:
	if (&FileExists("$vars_config{MembersPath}/user_ratings/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/user_ratings/$user_number.cgi");
		$rater_rating = &round_up($weighted_avg{total});
	} else {
		$rater_rating = '0';
	}

	undef(%votes);
	undef(%totals);
	undef(%avg);
	undef(%weighted_avg);

	# update ratee ratings
	if (&FileExists("$vars_config{MembersPath}/user_ratings/$ratee.cgi")) {
		&RequireVars("$vars_config{MembersPath}/user_ratings/$ratee.cgi");
	}

	# update values for this rating group
	if (exists($votes{$rater_rating})) {
		$votes{$rater_rating}++;
		$totals{$rater_rating}       = $totals{$rater_rating} + $in{rating};
		$avg{$rater_rating}          = $totals{$rater_rating} / $votes{$rater_rating};
		$avg{$rater_rating}          = &Do2Decimal($avg{$rater_rating});
		$weighted_avg{$rater_rating} = $avg{$rater_rating} * $weights{$rater_rating};

	} else {
		$votes{$rater_rating}        = '1';
		$totals{$rater_rating}       = $in{rating};
		$avg{$rater_rating}          = $in{rating};
		$weighted_avg{$rater_rating} = $avg{$rater_rating} * $weights{$rater_rating};
	}

	$weighted_avg{$rater_rating} = &Do2Decimal($weighted_avg{$rater_rating});

	# calculate unweighted average
	$votes{total} = $votes{0} + $votes{1} + $votes{2} + $votes{3} + $votes{4} + $votes{5};

	$totals{total} = $totals{0} + $totals{1} + $totals{2} + $totals{3} + $totals{4} + $totals{5};

	# Fixes illegal division by zero - thanks for the patch, LK!
	$avg{total} = $votes{total} ? ($totals{total} / $votes{total} ) : $totals{total};

	# calculate new total weighted average
	# fill in blanks...
	for (0 .. 5) {
		unless (exists($votes{$_})) {
			$votes{$_}        = '0';
			$totals{$_}       = '0';
			$avg{$_}          = 'N/A';
			$weighted_avg{$_} = $avg{total} * $weights{$_};
			$weighted_avg{$_} = &Do2Decimal($weighted_avg{$_});
		}
	}

	$weighted_avg{total} = $weighted_avg{0} + $weighted_avg{1} + $weighted_avg{2} + $weighted_avg{3} + $weighted_avg{4} + $weighted_avg{5};

	# format it
	$weighted_avg{total} = &Do2Decimal($weighted_avg{total});

	# print to ratings file!
	my $thishashstring;

	$thishashstring .= qq!\%votes = (\n!;
	foreach $key (keys %votes) {
		$thishashstring .= qq!"$key" => "$votes{$key}",\n!;
	}
	$thishashstring .= qq!);\n\n!;

	$thishashstring .= qq!\%totals = (\n!;
	foreach $key (keys %totals) {
		$thishashstring .= qq!"$key" => "$totals{$key}",\n!;
	}
	$thishashstring .= qq!);\n\n!;

	$thishashstring .= qq!\%avg = (\n!;
	foreach $key (keys %avg) {
		$thishashstring .= qq!"$key" => "$avg{$key}",\n!;
	}
	$thishashstring .= qq!);\n\n!;

	$thishashstring .= qq!\%weighted_avg = (\n!;
	foreach $key (keys %weighted_avg) {
		$thishashstring .= qq!"$key" => "$weighted_avg{$key}",\n!;
	}
	$thishashstring .= qq!);\n!;
	$thishashstring .= qq!1;\n!;

	&WriteFileAsString("$vars_config{MembersPath}/user_ratings/$ratee.cgi", $thishashstring);

	$thishashstring = "";


	# get member name
	my @user_profile = &OpenProfile($ratee);
	chomp($user_profile[15]);
	my $member_name = $user_profile[15];
	if ($member_name eq '') { $member_name = $user_profile[0]; }
	chomp($member_name);

	# if we didn't come from the UBB, redirect to the user profile
	if(($in{refer} !~ m/^($vars_config{NonCGIURL}|$vars_config{CGIURL})/)
		|| ($in{refer} !~ m/\/ultimatebb\.(cgi|php)/)) {
		$in{refer} = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$ratee";
	}

	# on screen confirmation
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$in{refer}", "$vars_wordlets{thanks_for_rating}", "$in{refer}");
	exit(0);

}    # end rate_member

sub edit_my_profile {
	local (@user_profile, $logged_in_status, $days, %select_list, $chompee, $mm_yes, $mm_no, $ev_yes, $ev_no, $count, $email_verify_requirement, $Signature, $user_public_name, $update_wording, $update_name, $update_un, $user_status, $update_date, $pm_yes, $pm_no, $pm_notify_yes, $pm_notify_no);


	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

	# lib required for reverse_ubb_code

	# user must be logged in!
	unless ($username ne '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a>!);
	}

	# verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);
	$count = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# is profile locked?
	if ($user_profile[24] eq 'yes') {
		&StandardHTML(qq!$vars_wordlets_err{profile_locked}!);
	}

	my $writeadmin = $user_profile[4];
	my $modq       = $user_profile[26];
	if (($writeadmin !~ /Write/) || ($modq =~ /Q/)) {

		#user has no permissions -> can't edit profile
		&StandardHTML("$vars_wordlets_err{user_not_approved}");
	}

	# custom status
	unless ($user_profile[31] ne '') {
		$user_status = &CustomTitle($user_profile[8], $user_profile[7]);
	}
	else { $user_status = $user_profile[31]; }

	# request for user's own profile
	$in{u} = $user_number;

	# calibrate topic view
	$days = $user_profile[21];
	if ($days eq '') { $days = $vars_display{DaysPruneDefault}; }
	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$select_list{$_} = '';
	}
	$select_list{$days} = qq(selected="selected");

	# calibrate mass mail
	if ($user_profile[14] eq 'yes') { $mm_yes = 'checked="checked"'; $mm_no = ''; }
	else { $mm_no = 'checked="checked"'; $mm_yes = ''; }

	# calibrate email view mail
	if ($user_profile[11] eq 'yes') { $ev_yes = 'checked="checked"'; $ev_no = ''; }
	else { $ev_no = 'checked="checked"'; $ev_yes = ''; }

	# calibrate user ratings option
	if ($user_profile[25] eq 'no') { $ratings_no = 'checked="checked"'; $ratings_yes = ''; }
	else { $ratings_yes = 'checked="checked"'; $ratings_no = ''; }

	# calibrate pm option
	if ($user_profile[27] eq 'no') { $pm_no = 'checked="checked"'; $pm_yes = ''; }
	else { $pm_yes = 'checked="checked"'; $pm_no = ''; }

	# calibrate pm notify option
	if ($user_profile[28] eq 'no') { $pm_notify_no = 'checked="checked"'; $pm_notify_yes = ''; }
	else { $pm_notify_yes = 'checked="checked"'; $pm_notify_no = ''; }

	# convert signature
	$Signature = &prep_for_edit($user_profile[12], 'is', $vars_display{AllowSignatureImage});

	# check for last update
	if ($user_profile[23] ne '') {
		($update_name, $update_un, $update_date) = split (/\|\^\|/, $user_profile[23]);

		#format date
		$update_date = &DateFormat($update_date);

		$update_wording = qq!$vars_wordlets{profile_update_stamp} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$update_un">$update_name</a> ($update_date)!;

	}    # last update check

	if ($user_profile[15] eq '') { $user_profile[15] = $user_profile[0]; }

	# display profile info
	&LoadTemplate("public_edit_profile");


	exit(0);

}    # end edit_my_profile


sub get_profile {
	local (@user_profile, $user_public_name, $user_status, $count, $chompee, $date_registered, $reg_month, $reg_day, $reg_year, @themonths, @viewer_profile, $is_admin_mod, $u, $rating_line, $overall_rating, $admin_view_rating, %user, $personal_line, $personal_rating, $user_ratings_off, %votes, %totals, %avg, %weighted_avg, $pm_line, %pm_ignore, %pm_buddy, $total_votes, $add_2_list);

	# get requested profile
	@user_profile = &OpenProfile($in{u});
	$count        = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# set rating line
	if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {
		$rating_line = qq!
<select name="rating">
	<option value=''>$vars_wordlets{rate_member}</option>
	<option value='5'>$vars_wordlets{member_rating_5}</option>
	<option value='4'>$vars_wordlets{member_rating_4}</option>
	<option value='3'>$vars_wordlets{member_rating_3}</option>
	<option value='2'>$vars_wordlets{member_rating_2}</option>
	<option value='1'>$vars_wordlets{member_rating_1}</option>
</select> <input type="SUBMIT" name="Submit" id="Submit" value="$vars_wordlets{rate}">
!;
	} else {
		$rating_line = '';
	}

	$u = $in{u} + 0;    # get rid of extra zeros
	my $u_formatted = &Do8Digit($u);

	# custom status
	unless ($user_profile[31] ne '') {
		$user_status = &CustomTitle($user_profile[8], $user_profile[7]);
	}
	else { $user_status = $user_profile[31]; }

	# set public_name
	if ($user_profile[15] eq '') {
		$user_public_name = $user_profile[0];
	} else {
		$user_public_name = $user_profile[15];
	}

	# set registration date (in proper format)
	($reg_month, $reg_day, $reg_year) = split (/-/, $user_profile[10]);


	# get user rating?
	if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {
		($overall_rating, $total_votes) = &get_rating($u);
		$admin_view_rating = $overall_rating;
		# prevent forgery
		if($overall_rating > 5){ $overall_rating = 5; }
		if($overall_rating < 1){ $overall_rating = 1 unless $overall_rating == 0 }

		if (($vars_display{user_ratings} eq 'feature_top') && ($overall_rating < 4)) {
			$overall_rating = '';
		}
	}

	# is this an admin or mod that is viewing?
	if ($username ne '') {

		# verify cookie id
		@viewer_profile = &verify_id_num($username, $password, $user_number);
		chomp($viewer_profile[8]);
		if (($viewer_profile[8] eq 'Administrator') || ($viewer_profile[8] eq 'Moderator')) {
			$is_admin_mod = 'true';
		} else {
			$is_admin_mod = 'false';
		}

		# viewing your own record.. if so, can't rate yourself
		if ($user_number eq "$u_formatted") { $rating_line = ''; }

		# has viewer rated this person?
		if (&FileExists("$vars_config{MembersPath}/user_raters/$user_number.cgi")) {

			&RequireVars("$vars_config{MembersPath}/user_raters/$user_number.cgi");

			if (exists($user{$u_formatted})) {
				$personal_rating = $user{$u_formatted};
				$rating_line     = '';
			} else {
				$personal_rating = '';
			}

			# in case user has disabled ratings...
			if ($user_profile[25] eq 'no') { $personal_rating = ''; }

		}    # if viewer has user rater file



	} else {
		$is_admin_mod    = 'false';
		$rating_line     = '';
		$personal_rating = '';
	}    # end admin/mod check

	if ($user_profile[10] eq '') {

		$date_registered = "$vars_wordlets{pre_reg_date_wording}";

	} else {

		$date_registered = &DateFormat($user_profile[10]);

	}

	#make personal_line?
	if (($personal_rating ne '') && ($vars_display{user_ratings} ne 'off')) {
		my $stars = ("user_ratings_" . "$personal_rating");
		$personal_line = qq!
$vars_wordlets{personal_rating} <img src="$vars_config{NonCGIURL}/$vars_style{$stars}" border="0">
	!;
	}

	if ($admin_view_rating ne '') {
		$admin_view_rating = ("user_ratings_" . "$admin_view_rating");
		$admin_view_rating = qq!<img src="$vars_config{NonCGIURL}/$vars_style{$admin_view_rating}" border="0">!;
	} else {
		$admin_view_rating = $vars_wordlets{not_rated};
	}

	if ($overall_rating ne '') {
		$overall_rating = ("user_ratings_" . "$overall_rating");
	}

	if (($user_profile[25] eq 'no') && ($vars_display{user_ratings} ne 'off')) {
		$user_ratings_off = $vars_wordlets{user_turned_off_ratings};
	} elsif ($vars_display{user_ratings} eq 'off') {
		$user_ratings_off = $vars_wordlets{admin_turned_off_ratings};
	} else {
		$user_ratings_off = '';
	}

	# pm?
	if (($user_profile[27] ne 'no') && ($vars_pm{feature} ne 'off')) {
		unless (($vars_pm{feature} eq 'leaders_only') && (($user_profile[8] ne 'Administrator') && ($user_profile[8] ne 'Moderator'))) {
			$pm_line = qq! | <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=private_message&u=$in{u}">$vars_wordlets{send_private_message}</a>!;
		}

		# list check
		if ($user_number > 0) {
			$add_2_list = &list_check("$in{u}");
			$add_2_list = "$user_public_name: $add_2_list";
		} else {
			$add_2_list = '';
		}


	}    # end pm check


	if ($rating_line eq '') { $rating_line = '&nbsp;'; }

	local($pntf_show, %pntf_info);

	$pntf_show = 0;
	if($vars_pntf{Enabled} eq "yes") {
		if($viewer_profile[8] eq 'Administrator') {
			%pntf_info = %{ $PNTF->examine3_user4admin($in{u}) };
			$pntf_show++ if %pntf_info;
		} elsif(($vars_pntf{LastSeen} eq "yes") && ($viewer_profile[8] ne 'Administrator')) {
			%pntf_info = %{ $PNTF->examine3_user($in{u}) };
			$pntf_show++ if %pntf_info;
		} # end if
	} # end if

	# display limited profile info
	&LoadTemplate("public_display_profile");

	exit(0);

}    # end get_profile

sub edit_profile {
	local ($count, @user_profile, $user_status, $chompee, $old_public_name);

	# user must be logged in!
	unless ($username ne '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	$count = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# set current public name (so we can compare later)
	$old_public_name = $user_profile[15];

	if (($user_profile[8] eq 'Administrator') || ($in{u} == $user_number)) {

		# authorized editor
		&update_profile;

	} else {

		# unauthorized editor
		&StandardHTML("$vars_wordlets_err{cant_edit_profile}");

	}


}    # end edit_profile

sub update_profile {
	local ($pub_warning, $email, $new_password, $sig_html, $public_name, $ubb_code_images, $sig, $subject, $text_message, $html_message, $modify_warning, $lc_old_email, $lc_email, $j, $this_email, $theemail, $checkemail, $html_message, $lc_it, $old_email, $dos, $thisnum, @amend, $checker, $NewLine, $logoff, $lc_un, $lc_old_public_name, $lc_new_public_name);

	# make sure user is approved (mod reg)
	if ($user_profile[4] !~ /Write/i) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{user_not_approved}");
	}


	# clean up, validate, & ensure that this profile can be updated
	foreach $key (keys %in) {

		# rem HTML and unclosed tags
		$in{$key} =~ s/(__)(\w+)(__)/_ $2 _ /g;    #rem IIS exploit
		unless (($key eq 'password')) {
			$in{$key} =~ s/<.*?>//sg;
			$in{$key} =~ s/</&lt;/sg;
			$in{$key} =~ s/>/&gt;/g;

			unless ($key eq 'signature') {
				$in{$key} =~ s/\s+/ /sg;
				$in{$key} =~ s/"/&quot\;/sg;
			}
		}
	}    # foreach key


	if ($vars_registration{allowHighBit} ne "YES") {

		# now make sure that the user isn't forging input
		my %checkthese = (
			"location"     => 80,
			"occupation"   => 80,
			"interests"    => 80,
			"url"          => 80,
			"picture"      => 80,
			"icq"          => 25,
			"aim"          => 32,
			"customfield1" => 80,
			"customfield2" => 80,
			"customfield3" => 80,
			"customfield4" => 80,
		);

		foreach (keys %checkthese) {
			&CheckLength($_, $checkthese{$_});
		}
	}    #end if highbit


	# make sure size is ok
	if ((length($in{public_name}) > 35) || (length($in{password}) > 13)) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{name_too_long}");
	}

	# check email
	if (&email_test($in{email})) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{email_invalid}");
	}

	# clean email
	$email = $in{email};
	$email =~ s/\s+//g;

	# check password --
	if ($in{password} =~ m/__\w+__/) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{password_error}");
	}

	# lc email for dupe checks later
	$lc_email     = lc($email);
	$old_email    = $user_profile[2];
	$lc_old_email = lc($old_email);

	# validate
	my @VA = ("email", "password", "u");

	if ($vars_registration{location_field_use} eq 'REQ')   { push (@VA, "location"); }
	if ($vars_registration{occupation_field_use} eq 'REQ') { push (@VA, "occupation"); }
	if ($vars_registration{picture_field_use} eq 'REQ')    { push (@VA, "picture"); }
	if ($vars_registration{homepage_field_use} eq 'REQ')   { push (@VA, "homepage"); }
	if ($vars_registration{interests_field_use} eq 'REQ')  { push (@VA, "interests"); }
	if ($vars_registration{signature_field_use} eq 'REQ')  { push (@VA, "signature"); }
	if ($vars_registration{icq_field_use} eq 'REQ')        { push (@VA, "icq"); }
	if ($vars_registration{aim_field_use} eq 'REQ')        { push (@VA, "aim"); }
	if ($vars_registration{bdate_field_use} eq "REQ")     { push (@VA, "bday_year", "bday_month", "bday_day"); }

	if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push (@VA, "customfield1"); }
	if (($vars_registration{custom2_field_use} eq 'REQ') && ($vars_registration{customfield2} ne '')) { push (@VA, "customfield2"); }
	if (($vars_registration{custom3_field_use} eq 'REQ') && ($vars_registration{customfield3} ne '')) { push (@VA, "customfield3"); }
	if (($vars_registration{custom4_field_use} eq 'REQ') && ($vars_registration{customfield4} ne '')) { push (@VA, "customfield4"); }

	&Validate(@VA);

	my $birthdate;
	if(&IsValidDate($in{bday_year}, $in{bday_month}, $in{bday_day}) < 1) {
		$birthdate = sprintf("%04d", $in{bday_year}) . sprintf("%02d", $in{bday_month}) . sprintf("%02d", $in{bday_day}) . "|" . ($in{bday_public} or "no");
	} else {
		&StandardHTML($vars_wordlets_err{bad_date}) if ($vars_registration{bdate_field_use} eq 'REQ');

	}

	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");

	my $avatar_url = "";
	my($avlock, $avban, $oldavhide) = split(/\|/, $user_profile[38]);
	$avlock ||= 0;
	$avban ||= 0;
	my $avhide = $in{avatar_hidden};  if(!defined $in{avatar_hidden}) { $avhide = $oldavhide; }
	unless($avban && !$user_permissions->has_permission("avatar", "use") ) {
		my $url = strip_lead_trail_whitespace($in{avurl});
		my $nc = quotemeta($vars_config{NonCGIURL});
		$url =~ s!^$nc/+?!!;
		$url =~ s!^/+!/!;
		if($url && !check_html_boolean($url)) {
			if($url !~ m!https?://!) {
				$avatar_url = $url if -e "$vars_config{NonCGIPath}/$url";
			} elsif(($url =~ m!https?://!) && ($user_permissions->has_permission("avatar", "custom"))) {
				if((&auto_url($url) ne $url) && (&ImageChecker($url) ne '')) {
					$avatar_url = $url if &avatar_remote_url_filter($url);
				} # end if
			} # end if
		} # end if
	} # end if

	my $ipaddy = &GetIPAddress;

	# if displayed name is changing, need to make sure it is unique
	# clean up public name input:
	if (((exists($in{public_name})) || ($in{public_name} ne $old_public_name)) && ($vars_misc{edit_public_names} eq "YES")) {


		&illegal_name_check($in{public_name});
		$public_name = &name_clean($in{public_name});

		# lc checks
		$lc_un           = lc($user_profile[0]);
		$lc_un           = &name_clean($lc_un);
		$old_public_name = &name_clean($old_public_name);

		$lc_old_public_name = lc($old_public_name);
		$lc_new_public_name = lc($public_name);

		# are we changing the public name? if so, need to check it!
		if (($lc_new_public_name ne $lc_old_public_name) && ($lc_new_public_name ne $lc_un)) {

			&CheckForExistingNames($lc_new_public_name, 1);

		}    # end if need to check public_names

	} else {
		$public_name = $user_profile[15];
		my $lc_old_public_name = lc($old_public_name);
		my $lc_new_public_name = lc($public_name);
		my $lc_un              = lc($user_profile[0]);
		$lc_un = &name_clean($lc_un);
	}

	$pub_warning = "" unless $pub_warning;

	# is email banned?
	&check_email_bans($lc_email) if ($lc_email ne $lc_old_email);

	# dupicate email check
	if (($lc_email ne $lc_old_email) && ($vars_registration{EmailCheck} eq 'true')) {

		my @EmailList = &GetEmails;

		CHECKEMAIL: for $this_email (@EmailList) {
			($theemail, $j) = split (/\?\?/, $this_email);
			$checkemail = lc($theemail);
			if ($lc_email eq $checkemail) {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);

				&StandardHTML("$vars_wordlets_err{dupe_email}");
				last CHECKEMAIL;
			}    #end if regemail
		}    # end foreach


	}    # end dupe email check

	# generate password & send by email, if necessary
	if (($vars_registration{EmailVerify} eq 'ON') && ($lc_email ne "$lc_old_email")) {
		$new_password = &GeneratePassword;

		# need to log this user off, since PW is changing!
		$logoff = qq~?ubb=logoff~;

		# make sure email is activated!
		if ($vars_email{UseEmail} ne 'ON') {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

			&StandardHTML("$vars_wordlets_err{email_not_on_for_reg}");
		}

		# generate password
		$new_password = &GeneratePassword;

		# send email!
		# set email template
		%vars_style = &LoadStyleTemplate("email");
		&set_page_elements;

		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
		&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

		my $s = &EmailWordletFixer;
		eval($s);
		if(defined &EmailWordletFiller) {
			%vars_wordlets_email = &EmailWordletFiller();
		} else {
			&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
		} # end if

		$subject = "$vars_config{BBName}: $vars_wordlets_email{new_password_subject}";

		if ($vars_email{email_format} ne 'html') {
			$text_message = "$vars_wordlets_email{new_password_text}";
		} else {
			$text_message = '';
		}

		if ($vars_email{email_format} ne 'ascii') {
			my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{new_password_html}" . qq!</font>!;
			$html_message = "$EmailHeader $html_body $Footer";
		} else {
			$html_message = '';
		}

		&ubb_mail_tng({
			'EmailTo' => $email,
			'EmailFrom' => $vars_registration{RegsAdminEmail},
			'EmailReplyTo' => $vars_registration{RegsAdminEmail},
			'BCCList' => undef,
			'Subject' => $subject,
			'TextMessage' => $text_message,
			'HTMLMessage' => $html_message,
			'CCList' => undef,
		});


		$modify_warning = $vars_wordlets{change_email_warning};
		$modify_warning =~ s/\$email/$email/;


	}    # end automatic pw change due to email verify...
	else {
		$logoff         = "";
		$modify_warning = "";
	}

	# assuming pw has not been generated...
	if (!$logoff) { $new_password = $in{password}; }

	# set PNTF hide value
	my $pntf_hidden = ($in{pntf_hidden} =~ m/^(0|1)$/ ? $in{pntf_hidden} : 0 );
	chomp($user_profile[34]);

	# set new cookie, if necessary
	if (($user_profile[34] != $pntf_hidden) || ($lc_email ne $lc_old_email) || ($new_password ne $user_profile[1]) || ($public_name ne $old_public_name) || ($avhide != $oldavhide)) {
		my $cookie2;
		if ($new_password ne "$user_profile[1]") {
			$cookie2 = cookie(
				-name  => "ubber$vars_config{Cookie_Number}",
				-value => "",
				-path  => '/'
			);
		} else {
			$cookie2 = cookie(
				-name    => "ubber$vars_config{Cookie_Number}",
				-value   => [$user_profile[0], $new_password, $public_name, $in{DaysPrune}, $in{u}, $pntf_hidden, $avhide],
				-path    => '/',
				-expires => '+2y'
			);
		}
		print header(
			-cookie  => [$cookie2],
			-charset => "$masterCharset",
			-type    => "text/html",
		);

	} else {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

	}


	$username = $user_profile[0];

	# get assigned style template for profiles!
	%vars_style = &LoadStyleTemplate("profile");

	&set_page_elements;

	# add new public name to list, assuming we can
	if (($lc_new_public_name ne "$lc_old_public_name") && ($lc_new_public_name ne "$lc_un") && ($pub_warning eq '')) {
		&AppendPubNames($public_name);
	}


	# if email is changing, update emailfile.cgi
	undef(@amend);
	if ($lc_email ne "$lc_old_email") {

		my @emailsfile = &GetEmailFileAsArray;

		$lc_old_email =~ s/([\.|\@])/\\$1/isg;

		foreach $checker (@emailsfile) {
			chomp($checker);

			if ($checker =~ m/^$lc_old_email\|\|/i) {
				($j, $thisnum) = split (/\|\|/, $checker);
				$NewLine = "$lc_email||$thisnum";
				push (@amend, $NewLine);
			} else {
				push (@amend, $checker);
			}
		}

		&UpdateEmailfile(\@amend);

	}

	# prep sig - prevent HTML, strip returns, do UBB Code

	$sig_html = $in{signature};
	if ($vars_display{AllowSignatureImage} eq 'no') {
		$ubb_code_images = 'no';
	} else {
		$ubb_code_images = 'yes';
	}

	$sig_html =~ s/(<IMG +SRC)(.*?)(>)//isg;

	# do graemlins--
	if ($ubb_code_images eq "yes") {
		$sig_html = &Smilies($sig_html);
	}

	# UBB Code-ify (if allowed)
	$sig_html = &UBBCode($sig_html, $ubb_code_images);

	#convert newlines/carriage returns to <br> and <p> html tags
	$sig_html = &PipeCleaner($sig_html);
	$sig_html = &CheckLength2(&ConvertReturns(&LimitReturns($sig_html)), 2500);

	# don't allow HTML SCRIPT TAGS
	&check_html($sig_html);

	#check for excess images-
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&excess_smilies_check($sig_html);

	# update registration file
	my $homepage;
	if ($in{homepage} !~ m/^http\:\/\//) { $homepage = "http://$in{homepage}"; }
	else { $homepage = $in{homepage}; }

	my $picture;
	if ($in{picture} !~ m/^http\:\/\//) { $picture = "http://$in{picture}"; }
	else { $picture = $in{picture}; }

	$picture = &ImageChecker($picture);

	# Yes, there are better ways to do this, but we don't want to
	# overwrite any future profile fields in the process.
	$user_profile[1]  = $new_password;
	$user_profile[2]  = $email;
	$user_profile[3]  = $homepage;
	$user_profile[5]  = &CensorCheck($in{occupation});
	$user_profile[6]  = &CensorCheck($in{location});
	$user_profile[9]  = &CensorCheck($in{interests});
	$user_profile[11] = $in{EmailView};
	$user_profile[12] = $sig_html;
	$user_profile[13] = $in{icq};
	$user_profile[14] = $in{AllowMassMail};
	$user_profile[15] = $public_name;
	$user_profile[16] = &CensorCheck($in{customfield1});
	$user_profile[17] = &CensorCheck($in{customfield2});
	$user_profile[18] = &CensorCheck($in{customfield3});
	$user_profile[19] = &CensorCheck($in{customfield4});
	$user_profile[20] = $picture;
	$user_profile[21] = $in{DaysPrune};
	$user_profile[22] = $in{aim};
	$user_profile[23] = "$pubname|^|$user_number|^|$GotTime{HyphenDate}";
	$user_profile[25] = $in{user_ratings};
	$user_profile[27] = $in{private_message};
	$user_profile[28] = $in{private_message_notify};
	$user_profile[32] = $birthdate;
	$user_profile[33] = $ipaddy;
	$user_profile[34] = $pntf_hidden;
	$user_profile[37] = $avatar_url;
	$user_profile[38] = join("|", $avlock, $avban, $avhide);
	&WriteMemberProfile($in{u}, @user_profile);

	# take viewer back to forum
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	$pub_warning = ($pub_warning? qq!<p>$pub_warning</p>! : "");
	$modify_warning = ($modify_warning? qq!<p>$modify_warning</p>! : "");
	&Transition("$vars_config{CGIURL}/ultimatebb.cgi$logoff", "$vars_wordlets{profile_updated} ", "$vars_config{BBName}");
	exit(0);
}    # end update_profile sr

sub email_user {
	local (@user_profile, $user_email, $pub_name, $un);

	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&floodcheck;

	@user_profile = &OpenProfile("$in{ToWhom}");
	my $email_address = $user_profile[2];
	my $email_view    = $user_profile[11];
	$pub_name   = $user_profile[15];
	$un         = $user_profile[0];
	$user_email = $user_profile[2];

	chomp($email_address);
	chomp($email_view);
	chomp($un);
	chomp($pub_name);
	chomp($user_email);

	if ($pub_name eq '') { $pub_name = $un; }

	if (($vars_display{EmailBlock} ne 'ON') && ($email_view ne 'no')) {
		&LoadTemplate("public_show_email");
	} else {
		&StandardHTML("$vars_wordlets_err{email_blocked}");
	}

}    # end email_user

sub recent_user_posts {
	local (@user_profile, $chompee, $count, $user_public_name, @posts, @rev_posts, $total, $f, $t, $r, @this_topic, @stat_line, @this_forum, $counter, %ExactPath);

	# get user profile
	# get requested profile
	@user_profile = &OpenProfile($in{u});
	$count        = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# set public_name
	if ($user_profile[15] eq '') {
		$user_public_name = $user_profile[0];
	} else {
		$user_public_name = $user_profile[15];
	}

	# grab user posts record
	if (&FileExists("$vars_config{MembersPath}/user_posts/$in{u}.cgi")) {
		@posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{u}.cgi");
	}

	# sort newest to oldest
	@rev_posts = reverse sort (@posts);

	# limit to last 50 posts
#	$total = @rev_posts;
#	if ($total > 50) {
#		@rev_posts = @rev_posts[0 .. 49];
#	}
#
#	$counter = 0;
	&LoadTemplate("public_user_posts");


}    # end recent user posts


# DANGER: Do not remove the next line!
1;
# $Id: ubb_profile.cgi,v 1.20 2002/04/30 18:19:05 cvscapps Exp $
