# Polling bits

# We can not run under strict in the control panel for some odd reason...

#use strict;

sub poll_dispatch {

	# a brief moment of elegance....

	my $pollid = $in{pollid};

	my %actions = (
		create => \&poll_create,
		view => \&poll_view,
		vote => \&poll_vote,
	);

	&LoadTemplate("public_polls");
	&RequireCode("ubb_lib_posting.cgi");

	my $success = &poll_load($pollid);
	# Code to check success cut - have to be able to
	# come up with random pollids BEFORE the file is created.

	if(!$in{d}) {
		&StandardHTML($vars_wordlets_err{invalid_input});
	} elsif(!exists $actions{$in{d}}) {
		&StandardHTML($vars_wordlets_err{invalid_input});
	} else {
		no strict("subs");
		&{$actions{$in{d}}};
	} # end if

	# Write any changes made to the poll automagically
	if($pollid) {
		&poll_write($pollid);
	} # end if

	exit;
} # end poll_dispatch

sub poll_create {

	&StandardHTML($vars_wordlets_err{no_forum_selected}) unless $in{f} =~ m/^\d+$/;

	&StandardHTML($vars_wordlets_poll{no_polling_here}) if $vars_poll{Enabled} ne "on";

	if((&OpenProfile($user_number))[36] == 1) {
		&StandardHTML($vars_wordlets_poll{no_permission_whatsoever});
	} # end if

	my $this_forum = ("forum_" . "$in{f}");
	%vars_style = &LoadStyleTemplate($this_forum);

	&set_page_elements;

	my @this_forum = &GetForumRecord($in{f});

	unless(@this_forum) {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	} # end unless

	unless($user_permissions) {
		&StandardHTML($vars_wordlets_poll{no_polling_here});
	} # end unless

	my $permission = $this_forum[6];
	&SetExactPath($in{f});
	if ($permission =~ m/private/) {
#		$exact_path .= "/private-$this_forum[7]";
		# does user have permission to enter?
		# Checked before polling access...
		&check_private_access($in{f}, $this_forum[12]);
	} # end if

	my $p = 0;

	# Make sure that this forum can have polls...
	if($this_forum[17] =~ m/^(\d+)$/) {
		my $num = $1;	# Polling group number
		if($num > 0) {
			my $g = $vars_groups->_get_raw_group("pollgroup_$num");
			# If creation is allowed by the group itself...
			if($g->{perms}->{create} ne "none") {
				# ...and that the user has permissions...
				$p = $user_permissions->has_permission('polling', 'create', $num);
			} # end if
		} # end if
	} # end if polling field

	if($p > 0) {	# ... then $p is > 0.  And so the kludge begins.
		if(!$in{step}) {
			&poll_start;
		} elsif($in{step} eq "questions") {
			&poll_qs;
		} elsif($in{step} eq "extras") {
			&poll_extras;
		} elsif($in{step} eq "postme") {
			if($in{post}) {
				&poll_write_topic;
			} elsif($in{edit}) {
				&poll_qs_question_bootstrap_form;
			} elsif($in{preview}) {
				&StandardHTML($vars_wordlets_criterr{browser_lacks_understanding});
			} # end if
		} else {
			&StandardHTML($vars_wordlets_criterr{browser_lacks_understanding});
		} # end if
	} else {
		&StandardHTML($vars_wordlets_poll{no_polling_here});
	} # end if
} # end poll_create

sub poll_start {

	# Generates a new topic form, with the polling extras
	# (Rather than tack onto the already ugly topic form.)
	my $pollid = $in{pollid};
	while(!$pollid) {
		my $r = &UBB::CommonElements::_random(0, 12);
		if(!&FileExists("$vars_config{NonCGIPath}/Polls/$r.cgi")) {
			$pollid = $r;
			$in{pollid} = $pollid;
		} # end if
	} # end if

	my @pass;
	push(@pass, $pollid);

	my @this_forum = &GetForumRecord($in{f});

	# Lexicals GOOD.  Napster^H^H^H^H^H^H^HGLOBALS BAD.
	my($is_html, $is_ubb, $ubb_images_wording, $ubb_code_buttons, $email_notify, $disable_smilies, $close_option, $show_sig);

	# email notify on?
	if (($vars_email{UseEmail} eq 'ON') && (($username ne '') || ($vars_display{RequireLoginPosts} eq "NO"))) {
		$email_notify = qq(<input type="checkbox" id="email_notification" name="email_notification" value="yes" /> $vars_wordlets{email_notify});
	}

	# show signature?
	if (($vars_display{AllowSignature} eq 'YES') && (($username ne '') || ($vars_display{RequireLoginPosts} eq "NO"))) {
		$show_sig = qq(<br /><input type="checkbox" name="Signature" id="Signature" value="yes" checked="checked" /> $vars_wordlets{show_signature});
	}

	# disable smilies?
	$disable_smilies = qq(<br /><input type="checkbox" id="disable_smilies" name="disable_smilies" value="yes" /> $vars_wordlets{disable_smilies});


	(my($html_allowed, $ubb_allowed), $is_ubb, $is_html, $ubb_images_wording) = &CheckCoding($this_forum[4], $this_forum[5], $this_forum[10]);

	if ($this_forum[5] eq 'is') {
		$ubb_code_buttons = &instant_ubb_code;
	} else {
		$ubb_code_buttons = "$is_ubb";
	}

	$direct_to = $instant_jscript;
	&set_page_elements;

	push(@pass, ($is_html, $is_ubb, $ubb_images_wording, $ubb_code_buttons, $email_notify, $disable_smilies, $close_option, $show_sig));

	print $Header . &PageTop($this_forum[1]) .
		&PollStart(@pass) . &PageBottom . $Footer;

	return;
} # end poll_start

sub poll_qs {

	if((!$in{pollid}) || ($in{pollid} !~ m/^[a-zA-Z0-9]{12}$/)) {
		die $vars_wordlets_poll{no_pollid};
	} # end if

	&GetOrPost("POST");

	if($in{qspart} eq "questions") {
		# The initial question form
		&poll_qs_question_form;
	} # end if

	if($in{qspart} eq "options") {
		# The options form
		&poll_qs_options_form;
	} # end if

	if($in{qspart} eq "finish") {
		&poll_qs_finish_form;
	} # end if

	if($in{qstart} eq "extradone") {
		&poll_extras_done;
	} # end if

	return;
} # end poll_qs

sub poll_qs_question_form {

	# The initial questions form (after the new topic form)

	my $pollid = $in{pollid};

	my @this_forum = &GetForumRecord($in{f});

	my($intro, $message);

	my @i_hate_validate = ("intro", "message");
	&Validate(@i_hate_validate);

	if (($in{intro} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq 'ON')) {
		&StandardHTML("$vars_wordlets_err{subject_deficient}");
	}
	&CheckLength("intro", 85);
	if (($in{intro} =~ /<.+>/) || ($in{intro} =~ /</)) {
		&StandardHTML("$vars_wordlets_err{subject_with_html}");
	}
	$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};
	if ($in{intro} =~ /\S{$vars_misc{runOnLimit}}/) {
		&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{intro}");
	}    #test before trying to expand special characters
	$in{intro} = FixSubjectEncoding($in{intro});
	$intro = &CensorCheck($in{intro});

	$message = &cook_post($in{message}, $in{f}, $in{disable_smilies});

	$in{noq} =~ s/\D//g;

	if((!$in{noq}) || ($in{noq} < 1) || ($in{noq} > 99) || ($in{noq} =~ m/\D/)) {
		&StandardHTML($vars_wordlets_poll{invalid_number})
	} # end if

	$poll->{$pollid} = {
		questions => [],
		author => $user_number,
		answers => {},
		noq => $in{noq},

		title => $intro,
		message => $message,
		signature => $in{Signature},
		msg_icon => $in{msg_icon},
		email_notification => $in{email_notification},
		disable_smilies => $in{disable_smilies},
		forum => $in{f},
		topic => undef,

		set_options => $in{set_options},
		start_time => undef,
		stop_time => undef,
		view_restrict => undef,
	};

	print $Header . &PageTop($this_forum[1]) .
		&PollQuestionForm($poll->{$pollid}) .
		&PageBottom . $Footer;

} # end poll_qs_question_form

sub poll_qs_question_bootstrap_form {

	# Skips right to the form
	my $pollid = $in{pollid};
	my @this_forum = &GetForumRecord($in{f});
	print $Header . &PageTop($this_forum[1]) .
		&PollQuestionForm($poll->{$pollid}) .
		&PageBottom . $Footer;
} # end poll_qs_question_bootstrap_form

sub poll_qs_options_form {

	# Options form

	my $pollid = $in{pollid};

	my @this_forum = &GetForumRecord($in{f});

	my @forgots;

	foreach my $questi (1 .. $poll->{$pollid}->{noq}) {

		$in{"noo$questi"} = ($in{"noo$questi"} =~ m/^\d+$/ ? $in{"noo$questi"} : 1 );

		if(($in{"noo$questi"} < 1) || ($in{"noo$questi"} > 99)) {
			&StandardHTML($vars_wordlets_poll{invalid_number})
		} # end if

		$in{"name$questi"} = &strip_lead_trail_whitespace($in{"name$questi"});

		my($limiter, $type);
		if($in{"ptype$questi"} eq "lchecks") {
			$type = "checks";
			$limiter = ($in{"limval$questi"} > $in{"noo$questi"} ? $in{"noo$questi"} : $in{"limval$questi"} );
		} elsif($in{"ptype$questi"} eq "uchecks") {
			$type = "checks";
			$limiter = $in{"noo$questi"};
		} elsif($in{"ptype$questi"} eq "radio") {
			$type = "radios";
			$limiter = 1;
		} else {
			push(@forgots, "$questi-ptype");
		} # end if

		if(!$in{"name$questi"} && ($poll->{$pollid}->{noq} != 1)) {
			push(@forgots, "$questi-name");
		} # end if

		my $title = &cook_post($in{"name$questi"}, $in{f}, $poll->{$pollid}->{disable_smilies});

		my $opts = $poll->{$pollid}->{questions}->[$questi - 1]->{options};
		$poll->{$pollid}->{questions}->[$questi - 1] = {
			title => $title,
			limit => $limiter,
			type => $type,
			opts => $in{"noo$questi"},
			options => $opts,
		};

	} # end foreach

	if(@forgots) {
	print $Header . &PageTop($this_forum[1]) .
		&PollQuestionForm($poll->{$pollid}, \@forgots) .
		&PageBottom . $Footer;
	} else {
		print $Header . &PageTop($this_forum[1]) .
			&PollOptionsForm($poll->{$pollid}) .
			&PageBottom . $Footer;
	} # end if

} # end poll_qs_options_form

sub poll_qs_finish_form {

	# Checks the options, makes sure they're finished, then moves on...

	my $pollid = $in{pollid};

	my @this_forum = &GetForumRecord($in{f});

	my @forgots;

	foreach my $quest (1 .. $poll->{$pollid}->{noq}) {
		my $sc = $poll->{$pollid}->{questions}->[$quest - 1];
		$sc->{options} = undef;
		foreach my $n (1 .. $sc->{opts}) {
			$in{"q$n" . "name$quest"} = &strip_lead_trail_whitespace($in{"q$n" . "name$quest"});

			my $this = &cook_post($in{"q$n" . "name$quest"}, $in{f}, $poll->{$pollid}->{disable_smilies});

			$sc->{options}->[$n - 1] = $this;

			if($in{"q$n" . "name$quest"} eq '') {
				push(@forgots, "$quest-q$n");
			} # end if

		} # end foreach
		$poll->{$pollid}->{questions}->[$quest - 1] = $sc;
	} # end foreach

	if(@forgots) {
		print $Header . &PageTop($this_forum[1]) .
			&PollOptionsForm($poll->{$pollid}, \@forgots) .
			&PageBottom . $Footer;
	} else {
		if($poll->{$pollid}->{set_options}) {
			&poll_extras;
		} else {
			$poll->{$pollid}->{view_restrict} .= "votebefore";
			&poll_done;
		} # end if
	} # end if
} # end poll_qs_finish_form

sub poll_extras {

	my @this_forum = &GetForumRecord($in{f});

	my $pollid = $in{pollid};
	print $Header . &PageTop($this_forum[1]) .
		&PollExtrasForm($poll->{$pollid}, $pollid) .
		&PageBottom . $Footer;
	return;
} # end poll_extras

sub poll_extras_done {

	my @this_forum = &GetForumRecord($in{f});

	my $pollid = $in{pollid};

	my @forgots;

	if($in{start_time}) {
		# Only process the dates if we're told to
		my($year, $month, $day, $hour, $min, $ampm) =
			($in{"start_year"}, $in{"start_month"}, $in{"start_day"}, $in{"start_hour"}, $in{"start_minute"}, $in{"start_ampm"});
		if(&IsValidFutureDate($year, $month, $day)) {
			push(@forgots, "start_time-date: $year, $month, $day");
		} elsif(&IsInvalidTime($hour, $min, $ampm)) {
			push(@forgots, "start_time-time: $hour, $min, $ampm");
		} else {
			# We're good!
			my $post_date = sprintf("%.2d-%.2d-%.4d", $month, $day, $year);
			my $post_time = sprintf("%.2d:%.2d %s", $hour, $min, $ampm);
#			print("$post_date, $post_time<br />");
			$poll->{$pollid}->{start_time} = &ConvertPostTimeToPNTF($post_date, $post_time);
		} # end if
	} else {
		$poll->{$pollid}->{start_time} = undef;
	} # end if

	if($in{stop_time}) {
		my($year, $month, $day, $hour, $min, $ampm) =
			($in{"stop_year"}, $in{"stop_month"}, $in{"stop_day"}, $in{"stop_hour"}, $in{"stop_minute"}, $in{"stop_ampm"});
		if(&IsValidFutureDate($year, $month, $day)) {
			push(@forgots, "stop_time-date: $year, $month, $day");
		} elsif(&IsInvalidTime($hour, $min, $ampm)) {
			push(@forgots, "stop_time-time: $hour, $min, $ampm");
		} else {
			# We're good!
			my $post_date = sprintf("%.2d-%.2d-%.4d", $month, $day, $year);
			my $post_time = sprintf("%.2d:%.2d %s", $hour, $min, $ampm);
#			print("$post_date, $post_time<br />");
			$poll->{$pollid}->{stop_time} = &ConvertPostTimeToPNTF($post_date, $post_time);
		} # end if
	} else {
		$poll->{$pollid}->{stop_time} = undef;
	} # end if

	if(($poll->{$pollid}->{stop_time} > 0)
	    && ($poll->{$pollid}->{stop_time} <= $poll->{$pollid}->{start_time})) {
		push(@forgots, "stop-before-start");
	} # end if

	if(($poll->{$pollid}->{stop_time} > 0)
	    && ($poll->{$pollid}->{stop_time} < $GotTime{CurrentPNTF})) {
		my $t = scalar(localtime($poll->{$pollid}->{stop_time} * 60));
		my $a = scalar(localtime($GotTime{CurrentPNTF} *  60));
		push(@forgots, "stop-in-past : $t $a ($poll->{$pollid}->{stop_time} < $GotTime{CurrentPNTF})");
	} else {
		delete $in{closefirst};
	} # end if

	$poll->{$pollid}->{view_restrict} =~ s/closefirst//g;
	if($in{"closefirst1"}) {
		$poll->{$pollid}->{view_restrict} .= "closefirst";
	} # end if

	$poll->{$pollid}->{view_restrict} =~ s/votebefore(forced){0,1}//g;
	if($in{"votebefore"}) {
		$poll->{$pollid}->{view_restrict} .= "votebefore";
	} # end if

	if(@forgots) {
		print $Header . &PageTop($this_forum[1]) .
			&PollExtrasForm($poll->{$pollid}, $pollid, \@forgots) .
			&PageBottom . $Footer;
		return;
	} else {
		&poll_done;
	} # end if
} # end poll_extras_done

sub poll_done {

	my @this_forum = &GetForumRecord($in{f});

	my $pollid = $in{pollid};

	print $Header . &PageTop($this_forum[1]) . &PollExtendedForm($poll->{$pollid}, $pollid) .
		&PageBottom . $Footer;
	return;
} # end poll_done



sub poll_write_topic {

	my @this_forum = &GetForumRecord($in{f});

	my $pollid = $in{pollid};

	my @user_profile = &OpenProfile($user_number);

	if ($vars_misc{FloodCheck} eq 'ON') {
		chomp($user_profile[8]);
		&floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
	} # end if

	my($last_topic_number, $total_topic_count, $total_post_count);
	my($Notes);

	# determine last topic number and increment by 1
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
		my @forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
		$last_topic_number = 0 + $forumcounter[0];
		chomp($last_topic_number);
		$total_topic_count = 0 + $forumcounter[1];
		chomp($total_topic_count);
		$total_post_count = 0 + $forumcounter[2];
		chomp($total_post_count);
	} else {
		$last_topic_number = 0;
		$total_topic_count = 0;
		$total_post_count  = 0;
	} # end else

	if (($poll->{$pollid}->{email_notification}) && ($poll->{$pollid}->{email_notification} eq 'yes')) {
		$Notes = 'N';
	} else {
		$Notes = '';
	} # end if

	my($new_topic_number, $post_email);
	my $ip_number = &GetIPAddress;

	if ($last_topic_number > 0) {
		$last_topic_number++;
		$new_topic_number = sprintf("%6d", $last_topic_number);
		$new_topic_number =~ tr/ /0/;
	} else {
		$new_topic_number = '000001';
	} # end if

	my $mess = $poll->{$pollid}->{message}; # already filtered
	my $message = $mess;
	my $message_ascii = &prep_for_edit($mess, $this_forum[5], $this_forum[10]);
	my $topic_subject = $poll->{$pollid}->{title}; #already filtered

	chomp($user_profile[11]);
	chomp($user_profile[2]);
	if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no') || ($in{your_name})) {
		$post_email = '';
	} else {
		$post_email = "$user_profile[2]";
	} # end if

	if ($vars_misc{IP} eq 'OFF') {
		$ip_number = '';
	} # end if

#$poll->{$in{pollid}}->{}

#	print header;
#	print "MSGICON: $poll->{$pollid}->{msg_icon}<br />";

	unless ($poll->{$pollid}->{msg_icon} =~ m/^\d+?$/) { $poll->{$pollid}->{msg_icon} = '1'; }
	if(!&FileExists("$vars_config{NonCGIPath}/icons/icon$poll->{$pollid}->{msg_icon}.gif")) {
#		print "MSGICON: $poll->{$pollid}->{msg_icon}<br />";
		$poll->{$pollid}->{msg_icon} = '1';
	} # end if
#	print "MSGICON: $poll->{$pollid}->{msg_icon}<br />";

	my $stat_line = join("||", "A", $Notes, 0, $username, $topic_subject, "",
		$poll->{$pollid}->{msg_icon}, "", $pubname, $user_number, $pollid);

	if (!$poll->{$pollid}->{signature}) { $poll->{$pollid}->{signature} = 'no'; }

	my $topic_line = join("||", "Z", "000000", $username,
		$GotTime{HyphenDate}, $GotTime{Time}, $post_email,
		$message, $ip_number, "reg", $poll->{$pollid}->{msg_icon},
		$pubname, $user_number, $poll->{$pollid}->{signature});

	unless (-w "$vars_config{MembersPath}/$user_number.cgi") {
		chmod(0777, "$vars_config{MembersPath}/$user_number.cgi") or die &Template($vars_wordlets_criterr{cant_reset_perms_on_profile}, {NUMBER => $user_number, OSERR => $!});
	}

	my @topic_file = ($stat_line, $topic_line);
	&WriteTopic($in{f}, $new_topic_number, @topic_file);

	$user_profile[7]++;

	# bump user up to Member if total posts reaches MemberMinimum
	if ($user_profile[8] !~ m/^(Administrator|Moderator)$/) {
		if ($user_profile[7] < $vars_misc{MemberMinimum}) {
			$user_profile[8] = 'Junior Member';
		} else {
			$user_profile[8] = 'Member';
		}
	}

	#last post in profile
	my $ipaddy = &GetIPAddress;
	$user_profile[30] = qq%$GotTime{YMDRunonDate}|$in{f}|$new_topic_number|000000|$ipaddy%;

	&WriteMemberProfile($user_number, @user_profile);

	my $reg_status = "reg";

	# update last time file
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lasttime.file", "$GotTime{HyphenDate}\n$GotTime{Time}\n");

	#update last number file for forum
	$total_topic_count++;
	$total_post_count++;
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", "$new_topic_number\n$total_topic_count\n$total_post_count\n$topic_subject\n$pubname\n$poll->{$pollid}->{msg_icon}\n$new_topic_number\n");

	# update user_posts file
	if (($reg_status eq 'reg') && ($this_forum[6] !~ m/private/)) {
		&AppendFileAsString("$vars_config{MembersPath}/user_posts/$user_number.cgi", "$GotTime{YMDRunonDate}|$in{f}|$new_topic_number|000000|$ipaddy\n");
	}    # if user is registered & forum is not private



	{ # no strict block
		no strict("vars");

		my $pollid = $in{pollid};
		my $topic_subject = $poll->{$pollid}->{title}; #already filtered

		# update threads summary file
		if (&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads")) {
			&update_forum_summary($in{f}, $new_topic_number, $topic_subject);
		} else {
			my $thistopics = &NiceForumThreadsRebuild($in{f});
			&UpdateForumTopics($in{f}, $thistopics, 1);	#1 == nowrite
			&update_forum_summary($in{f}, $new_topic_number, $topic_subject);	#writes
			%forum_topics = %{$thistopics};
		}

		&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $new_topic_number, \@topic_file);

		# index:
		# create promo edition of message
		#$mess_truncated = &promo($message);
		&append_index($in{f}, $new_topic_number, $this_forum[6], "000000");

		# take viewer back to forum
		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;
		&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$new_topic_number", "$vars_wordlets{thanks_for_posting}", "$topic_subject");

		$in{t} = $new_topic_number;
		#$this_subject = $topic_subject;

		#strip UBBCode for moderator notification email
		$message_ascii =~ s/\[\/?(b|i|url|img|email|quote|code|list|\*)\]//gi;
		$message_ascii =~ s/\[\/?url=(.+)\]/($1) /;

		# notify moderator?
		if (($this_forum[11] eq 'yes') && ($vars_email{UseEmail} eq 'ON')) {

			# set email template
			%vars_style = &LoadStyleTemplate("email");
			&set_page_elements;

			&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

			local ($Moderator); # NOOOOOOOOOOOOOOO!!!

			# $Moderator contains list of email addresses for modderators, separated by commas
			$Moderator = &build_mod_emails($in{f});

			my $this_subject = $topic_subject;

			if ($Moderator ne '') {

				if ($vars_email{email_format} ne 'html') {
					&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
					my $s = &EmailWordletFixer;
					eval($s);
					if(defined &EmailWordletFiller) {
						%vars_wordlets_email = &EmailWordletFiller();
					} else {
						&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
					} # end if
					$email_message = qq!$vars_wordlets_email{mod_notify_post}!;
				} else {
					$email_message = '';
				}

				if ($vars_email{email_format} ne 'ascii') {
					$message = &ConvertReturns($message_ascii);

					&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
					my $s = &EmailWordletFixer;
					eval($s);
					if(defined &EmailWordletFiller) {
						%vars_wordlets_email = &EmailWordletFiller();
					} else {
						&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
					} # end if
					my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_notify_post_html}" . qq!</font>!;
					$html_message = "$EmailHeader $html_body $Footer";
				} else {
					$html_message = '';
				}

				&ubb_mail_tng({
					'EmailTo' => $Moderator,
					'EmailFrom' => $vars_display{BBEmail},
					'EmailReplyTo' => $vars_display{BBEmail},
					'BCCList' => undef,
					'Subject' => "$vars_wordlets_email{mod_notify_subject}: $this_forum[1]",
					'TextMessage' => $email_message,
					'HTMLMessage' => $html_message,
					'CCList' => undef,
				});
			}


		}    #end mod notify block

		# clear cache- we have new data!
		&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
		&ClearSingleForumPageCache($exact_path, $in{f});


	} # end no strict block

	$poll->{$pollid}->{topic} = $new_topic_number;
	# Now nuke all the extra data
#	delete $poll->{$pollid}->{message};
	delete $poll->{$pollid}->{signature};
	delete $poll->{$pollid}->{msg_icon};
	delete $poll->{$pollid}->{email_notification};
	delete $poll->{$pollid}->{disable_smilies};
	if(!$poll->{$pollid}->{set_options}) {
		$poll->{$pollid}->{start_time} = 0;
		$poll->{$pollid}->{stop_time} = 0;
		$poll->{$pollid}->{view_restrict} =~ s/votebefore//gi;
		$poll->{$pollid}->{view_restrict} .= 'votebeforeforced';
	} # end if
#	delete $poll->{$pollid}->{set_options}

} # end poll_write_topic





sub poll_view {

	my $pollid = $in{pollid};

	if(&poll_load($pollid)) {

		my $f = $poll->{$pollid}->{forum};
		my $t = $poll->{$pollid}->{topic};

		%vars_style = &LoadStyleTemplate("forum_$f");

		&set_page_elements;

		my @this_forum = &GetForumRecord($f);

		unless(@this_forum) {
			&StandardHTMLPopup($vars_wordlets_err{no_such_forum} . " ($f)");
		} # end unless

		my $p = 0;
		# If the poll creator decided to allow unregs to view
		# the poll....
		if($poll->{$pollid}->{view_restrict} =~ m/OPTIONDELETED/) {
			# We were going to allow unregs to view poll
			# results, but then we remembered people can log out. :)
			# This remains here so that it can be hacked in later.
			$p++;
		} else {
			if($user_permissions) {
				# Make sure that this forum can have polls...
				if($this_forum[17] =~ m/^(\d+)$/) {
					my $num = $1;	# Polling group number
					if($num > 0) {
						my $g = $vars_groups->_get_raw_group("pollgroup_$num");
						# If creation is allowed by the group itself...
						if($g->{perms}->{create} ne "none") {
							# ...and that the user has permissions...
							$p += $user_permissions->has_permission('polling', 'vote', $num);
						} # end if
					} # end if
				} # end if polling field
			} else {
				&StandardHTMLPopup($vars_wordlets_poll{no_viewing_here});
			} # end if
		} # end if

		my $permission = $this_forum[6];
		&SetExactPath($f);
		if ($permission =~ m/private/) {
			$exact_path .= "/private-$this_forum[7]";
			# does user have permission to enter?
			# Checked before polling access...
			&check_private_access($f, $this_forum[12]);
		} # end if

		if(($poll->{$pollid}->{stop_time} > $GotTime{CurrentPNTF}) && ($poll->{$pollid}->{view_restrict} =~ m/closefirst/)) {
			&StandardHTMLPopup($vars_wordlets_poll{no_view_results_until_closed});
		} # end if

		if($p > 0) {
			# If the topic is *OPEN*, check the viewrestrict.
			# If the topic is *CLOSED*, and the user has permission,
			# make sure that they can view results anyway.
			if(($f && $t) && (&GetThreadData($f, $t))[1] !~ m/X/) {
				# if topic is open
				if(($poll->{$pollid}->{view_restrict} =~ m/votebefore/) &&
				    ($poll->{$pollid}->{view_restrict} !~ m/closefirst/) &&
		    		    (!exists $poll->{$pollid}->{answers}->{$user_number})) {
					# if votebefore and no closefirst and user has not voted
					&StandardHTMLPopup($vars_wordlets_poll{no_view_until_vote} . "....");
				} elsif(($poll->{$pollid}->{view_restrict} =~~ m/closefirst/)
		    		    && ($poll->{$pollid}->{stop_time} > $GotTime{CurrentPNTF})) {
					# if closefirst and stoptime is yet to come
					&StandardHTMLPopup($vars_wordlets_poll{no_view_results_until_closed} . "....");
				} # end if
#					&StandardHTMLPopup($vars_wordlets_poll{no_view_until_vote} . "...");
#				} # end if
			} # end if

			# Bits to allow viewing of individual votes
			# stripped out - too many privacy issues to
			# worry about.  6.3?  6.4?
			&PollViewResults($poll->{$pollid}, $pollid);
		} else {
			&StandardHTMLPopup($vars_wordlets_poll{no_viewing_here});
		} # end if

	} else {
		&StandardHTMLPopup($vars_wordlets_poll{no_pollid});
	} # end if
} # end poll_view






sub poll_vote {


	my $pollid = $in{pollid};

	if((&OpenProfile($user_number))[36] == 1) {
		&StandardHTMLPopup($vars_wordlets_poll{no_permission_whatsoever});
	} # end if

	if(&poll_load($pollid)) {

		my $f = $poll->{$pollid}->{forum};
		my $t = $poll->{$pollid}->{topic};

		%vars_style = &LoadStyleTemplate("forum_$f");

		&set_page_elements;

		my @this_forum = &GetForumRecord($f);

		unless(@this_forum) {
			&StandardHTMLPopup($vars_wordlets_err{no_such_forum} . " ($f)");
		} # end unless

		unless($user_permissions) {
			&StandardHTMLPopup($vars_wordlets_poll{no_voting_here});
		} # end unless

		my $permission = $this_forum[6];
		&SetExactPath($f);
		if ($permission =~ m/private/) {
			$exact_path .= "/private-$this_forum[7]";
			# does user have permission to enter?
			# Checked before polling access...
			&check_private_access($f, $this_forum[12]);
		} # end if

		my $p = 0;

		# Make sure that this forum can have polls...
		if($this_forum[17] =~ m/^(\d+)$/) {
			my $num = $1;	# Polling group number
			if($num > 0) {
				my $g = $vars_groups->_get_raw_group("pollgroup_$num");
				# If creation is allowed by the group itself...
				if($g->{perms}->{create} ne "none") {
					# ...and that the user has permissions...
					$p = $user_permissions->has_permission('polling', 'vote', $num);
				} # end if
			} # end if
		} # end if polling field

		if(exists $poll->{$pollid}->{answers}->{$user_number}) {
			&StandardHTMLPopup($vars_wordlets_poll{already_voted});
		} # end if

		&GetDateTime;

		if(($in{preview} ne "true") && ($poll->{$pollid}->{start_time}) && ($poll->{$pollid}->{start_time} > $GotTime{CurrentPNTF})) {
			&StandardHTMLPopup($vars_wordlets_poll{poll_not_open});
		} elsif(($poll->{$pollid}->{stop_time}) && ($poll->{$pollid}->{stop_time} < $GotTime{CurrentPNTF})) {
			&StandardHTMLPopup($vars_wordlets_poll{poll_closed});
		} # end if

		# Check to see if the topic is closed
		if(($f && $t) && (&GetThreadData($f, $t))[1] =~ m/X/) {
			&StandardHTMLPopup($vars_wordlets_poll{poll_topic_closed});
		} # end if

		if($p > 0) {
			my $preview = ($in{preview} eq "true" ? 1 : 0);
			if($in{answers} eq "true") {
				if($in{preview_workaround} != 1) {
					my @list = &poll_vote_summup();
					my @forgots = keys %{$list[3]};
					if(scalar(@forgots) > 0) {
						&LoadTemplate("public_polls");
						&PollVoteForm($poll->{$pollid}, $pollid, $preview, @forgots);
						exit;
					} else {
						&poll_write($pollid);
						# Clear the cached version of the topic
						# if it was modified more than 5 minutes
						# ago (to update the vote count
						my $topic = $poll->{$pollid}->{topic};
						my $forum = $poll->{$pollid}->{forum};
						my $extra = ($this_forum[6] =~ m/private/ ? "/private-$this_forum[7]" : "" );
						my $fn = "$vars_config{NonCGIPath}/cache-$vars_config{cache_cookie}/ubb_files/Forums/Forum$forum$extra";
						my @stats = stat("$fn/$topic.cgi");
						if(@stats) {
							if($stats[9] + (60 * 5) > time()) {
								&DoThatClearCacheThing($fn, $topic);
							} # end if
						} # end if

						&PollThankForVote($pollid);
					} # end if
				} else {
					# Ignore the submit if it was a preview
					&StandardHTMLPopup($vars_wordlets_poll{browser_didnt_close_window});
				} # end if
			} else {
				&LoadTemplate("public_polls");
				&PollVoteForm($poll->{$pollid}, $pollid, $preview);
				exit;
			} # end if
		} else {
			&StandardHTMLPopup($vars_wordlets_poll{no_voting_here});
		} # end if

	} else {
		&StandardHTMLPopup($vars_wordlets_poll{no_pollid});
	} # end if

} # end poll_vote

sub poll_vote_summup {


	my $pollid = $in{pollid};
	my %vals;
	my $quick = $poll->{$pollid}->{questions};

	my %as;
	foreach my $one (grep(/^(chk|rad)X\d+/, keys %in)) {
		next unless $one =~ m/^(chk|rad)X(\d+)X?/;
		$as{$2}++;
	} # end foreach

	my %qs;
	foreach my $q (0 .. ($poll->{$pollid}->{noq} - 1)) { $qs{$q}++ }

	my @fs;
	foreach my $a (keys %as) {
		delete $qs{$a + 0};
	} # end foreach

	foreach my $element (sort grep(/^chk/, keys %in)) {
		my($type, $dex, $sel) = split(/X/, $element);
		my $index = $dex + 0;
		my $selection = $sel + 0;
		$poll->{$pollid}->{answers}->{$user_number}->{$index}->{$selection}++;
#		print qq!For question $dex ('$quick->[$index]->{title}'), you selected option $sel ('$quick->[$index]->{options}->[$selection]')<br />!;
		last if(
			(ref($poll->{$pollid}->{answers}->{$user_number}->{$index}) =~ m/ARRAY/)
			&& (scalar(@{ $poll->{$pollid}->{answers}->{$user_number}->{$index} })
				>= $quick->[$index]->limit));
		$vals{$dex}->{$sel}++;
	} # end foreach
	foreach my $element (sort grep(/^rad/, keys %in)) {
		my($type, $dex, $sel) = (split(/X/, $element), $in{$element});
		my $index = $dex + 0;
		my $selection = $sel + 0;
		$poll->{$pollid}->{answers}->{$user_number}->{$index}->{$selection}++;
#		print qq!FOR question $dex ('$quick->[$index]->{title}'), you selected option $sel ('$quick->[$index]->{options}->[$selection]')<br />!;
		$vals{$dex}->{$sel}++;
	} # end foreach

	my($results, $totals, $maxes) = &poll_vote_tabulate($poll->{$in{pollid}}->{answers});

	return($results, $totals, $maxes, \%qs)

} # end poll_vote_summup

sub poll_vote_tabulate {

	my $answers = shift;
	my $questions = {};
	my $totals = {};
	my $maxes = {};
	foreach my $user (keys %{ $answers }) {
		foreach my $quest (keys %{ $answers->{$user} }) {
			foreach my $vote (keys %{ $answers->{$user}->{$quest} }) {
				$questions->{$quest}->{$vote}++;
				$totals->{$quest}++;
				if($maxes->{$quest} < $questions->{$quest}->{$vote}) {
					$maxes->{$quest} = $questions->{$quest}->{$vote};
				} # end if
			} # end foreach
		} # end foreach
	} # end foreach
	return($questions, $totals, $maxes);
} # end poll_vote_tabulate





sub poll_load {

	my $pollid = shift;

	if(&FileExists("$vars_config{NonCGIPath}/Polls/$pollid.cgi")) {
		my $string = &OpenFileAsString("$vars_config{NonCGIPath}/Polls/$pollid.cgi");
		{    # start local block
			local $SIG{'__DIE__'}  = sub { return; };
			local $SIG{'__WARN__'} = sub { return; };
			eval $string;
		}    # end local block
	} # end if

	my $subcall = \&{ "poll_load_" . $pollid };

	if(defined(&$subcall)) {
		&$subcall;
		return 1;
	} else {
		return 0;
	} # end if
} # end poll_load

sub poll_write {

	my $pollid = shift;

	return unless $poll->{$pollid};

	if(!defined &Data::ThatWhichDumps::Dumper) {
		&RequireCode("$vars_config{CGIPath}/ubb_lib_dumper.cgi");
	} # end if

	my $obj = Data::ThatWhichDumps->new([$poll->{$pollid}], ['$REPLACEMEPLEASE']);

	my $string = "sub poll_load_$pollid { \n" . $obj->Dump;
	$string =~ s/REPLACEMEPLEASE/poll->{$pollid}/;
	$string .= "};\n1;\n";

	&WriteFileAsString("$vars_config{NonCGIPath}/Polls/$pollid.cgi", $string);

	return;
} # end write_poll


sub poll_move {

	my($pollid, $forum, $topic) = @_;

	if(&poll_load($pollid)) {
		$poll->{$pollid}->{forum} = $forum;
		$poll->{$pollid}->{topic} = $topic;
	} # end if

	&poll_write($pollid);

	return;
} # end poll_move

sub poll_random_color_set {

	my $perc = shift;
	my $num = (255 * ($perc / 100));
	$num += 64 if($num < 128);
	my $n2 = 64;
	$n2 = 32 if $num < 96;
	my @random;
	if($n2 > $num) { @random = ($num .. $n2); } else { @random = ($n2 .. $num) }
	return(int(rand(@random)), int(rand(@random)), int(rand(@random)));
} # end poll_random_color_set


1;
# $Id: ubb_poll.cgi,v 1.12 2002/03/22 20:33:40 cvscapps Exp $