sub pntf_init {
	my $match = ($in{f} =~ m/^\d+$/ ? "forum_$in{f}" : "summary_page" );
	%vars_style = &LoadStyleTemplate($match);
	&set_page_elements;
} # end pntf_init

sub pntf_js {

	&pntf_init;

	print UBBCGI::header(-type => "text/javascript");

	print qq[document.writeln("Sorry, pntf_js is not implemented in this version.")];

} # end pntf_js

sub pntf_html {

	&pntf_init;

	#print UBBCGI::header(-type => "text/html");
	if(($in{f} =~ m/^\d+$/) && (!exists $in{t})) {
		if( (&GetForumRecord($in{f}))[6] =~ m/private/ ) {
			#&StandardHTML($vars_wordlets_pntf{pntf_no_private});
			&check_private_access($in{f}, $vars_forums{$in{f}}->[12]);
		}# else {
			my $z = &OpenTimedCachedFile("/pntf/html-forum_$in{f}.cgi", ($vars_pntf{Prune} * 60));
			if($z) { print $z; exit; }
			else {
				my %results = $PNTF->examine;
				&LoadTemplate("public_pntf_summary");
				my $r = $PNTF->examine_forum($in{f});
				my @f = &GetForumRecord($in{f});

				my $q = "";
				$q .= $Header;
				$q .= &PageTop(" &#187; $f[1]");
				$q .= &ForumBody($r, \@f);
				$q .= &PageBottom;
				$q .= $Footer;
				print $q;
				&WriteFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/html-forum_$in{f}.cgi", $q)
			#} # end if
		} # end if
	} elsif(($in{f} =~ m/^\d+$/) && ($in{t} =~ m/^\d{6}$/)) {
		if( (&GetForumRecord($in{f}))[6] =~ m/private/ ) {
			#&StandardHTML($vars_wordlets_pntf{pntf_no_private});
			&check_private_access($in{f}, $vars_forums{$in{f}}->[12]);
		} #else {
			my $z = &OpenTimedCachedFile("/pntf/html-topic_$in{f}_$in{t}.cgi", ($vars_pntf{Prune} * 60));
			if($z) { print $z; exit; }
			else {
				my %results = $PNTF->examine;
				&LoadTemplate("public_pntf_summary");
				my $r = $PNTF->examine_topic($in{f}, $in{t});
				my @i = &GetThreadData($in{f}, $in{t});

				my $q = "";
				$q .= $Header;
				$q .= &PageTop(" &#187; $i[3]");
				$q .= &TopicBody($r, \@i);
				$q .= &PageBottom2;
				$q .= $Footer;
				print $q;
				&WriteFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/html-topic_$in{f}_$in{t}.cgi", $q)
			} # end if
			#&StandardHTML("(Details for forum $in{f}, topic $in{t} will be available shortly.)");
		#} # end if
	} else {
		my $sortor = $in{sort};
		$sortor =~ m/^(cats|forums|visitors)$/;
		my $sortorder = $1 || "visitors";
		my $z = &OpenTimedCachedFile("/pntf/html-summary-$sortorder.cgi", ($vars_pntf{Prune} * 60));
		if($z) { print $z; exit; }
		else {
			my %results = $PNTF->examine;
			&LoadTemplate("public_pntf_summary");
			my $q = "";
			$q .= $Header;
			$q .= &PageTop;
			$q .= &SummaryIntro($results{'012_active_UNIQs'}, @{$results{"013_record"}}, $results{"011_forum_summary_visitors"});
			$q .= &SummaryForumTable($PNTF->examine_forums, $in{sort}, ($vars_display{CategoryView} ne "no" ? 1 : 0));
			$q .= &SummaryThreadTable($PNTF->examine_topics, ($vars_display{CategoryView} ne "no" ? 1 : 0));
			$q .= &SummaryTableBottom;
			$q .= &PageBottom;
			$q .= $Footer;
			print $q;
			&WriteFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/html-summary.cgi", $q)
		} # end if
	} # end if
	exit;
} # end pntf_html


sub pntf_admin {
	&pntf_init;

	if($user_number !~ m/^\d{8}$/) {
		&StandardHTML("$vars_wordlets_err{no_access}");
	} else {
		chomp(my($writeline, $statusline) = (&OpenProfile($user_number))[4,8]);
		&StandardHTML("$vars_wordlets_err{no_access}") unless(($writeline =~ m/Admin/) && ($statusline eq "Administrator"))
	} # end elsif

	# If we've managed to get this far, then we know user is an admin.

	&LoadTemplate("public_pntf_summary");
	&LoadTemplate("public_pntf_admin");
	if(!defined &Data::ThatWhichDumps::Dumper) {
		&RequireCode("$vars_config{CGIPath}/ubb_lib_dumper.cgi");
	} # end if


	my $w = $vars_wordlets_pntf{pntf_admin_view};
	my $wl = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=pntf_admin">$w</a>);

	# Let's figure out what we're doing
	if((exists $in{f}) && ($in{f} =~ m/^\d+$/) && (!exists $in{t})) {
		# Ops for forums
		&GetForumRecord($in{f});
		my $r = $PNTF->examine5_forum($in{f});
		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $wl &#187; $vars_forums{$in{f}}->[1]");
		$q .= &LocBody($r, $vars_forums{$in{f}}->[1], 1, "?ubb=forum;f=$in{f}");
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;

	} elsif((exists $in{f}) && ($in{f} =~ m/^\d+$/) && (exists $in{t}) && ($in{t} =~ m/^\d{6}$/)){
		# Ops for topics
		&GetForumRecord($in{f});
		my @d = &GetThreadData($in{f}, $in{t});
		my $r = $PNTF->examine5_topic($in{f}, $in{t});
		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $wl &#187; $d[3]");
		$q .= &LocBody($r, $d[3], 2, "?ubb=get_topic;f=$in{f};t=$in{t}");
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;
	} elsif((exists $in{a}) && ($in{a} eq "i")) {
		# Ops for the forum summary page
		my $r = $PNTF->examine5_fsum();
		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $wl &#187; $vars_wordlets_pntf{pntf_forum_summary}");
		$q .= &LocBody($r, $vars_wordlets_pntf{pntf_forum_summary}, 1, ($in{category} ? "?category=$in{category}" : "?"));
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;
	} elsif((exists $in{uniq}) && ($in{uniq} =~ m/^\w{16}$/)) {
		# Ops for UNIQIDs
		my $table = $PNTF->examine5_uniq($in{uniq});

		my ($s, $un) = &UniqBody($table, $in{uniq});

		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $wl &#187; $un");
		$q .= $s;
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;
	} elsif((exists $in{ip}) && ($in{ip} =~ m/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/)) {
		# Ops for IPs
		my %table = $PNTF->examine5_ip($in{ip});

		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $wl &#187; $in{ip}");
		$q .= &IPBody(\%table);
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;
	} else {
		#&StandardHTML("$vars_wordlets_err{dead_end}..");
		my %results = $PNTF->examine;
		my %table = $PNTF->examine5_overview;

		my $q = "";
		$q .= $Header;
		$q .= &PageTop(" &#187; $w");
		$q .= &SummaryBody(\%table);
		$q .= &PageBottom3;
		$q .= $Footer;
		print $q;
	} # end if

	exit;

} # end pntf_admin

sub MakeNumberFromUNIQID {
	my @chars = split(//, shift);

	my $number = 0;
	foreach my $one (@chars) { $number += ord($one); }

	return $number;
} # MakeNumberFromUNIQID

1701;
# $Id: ubb_pntf.cgi,v 1.11 2002/04/16 18:31:04 cvscapps Exp $
